/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.controls;

import com.sobey.bsp.framework.controls.HtmlElement;
import com.sobey.bsp.framework.controls.HtmlTR;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlTable
extends HtmlElement {
    public static final Pattern PTable = Pattern.compile("^\\s*<table(.*?)>(.*)</table>\\s*$", 34);
    public static final Pattern PInnerTable = Pattern.compile("<table(.*?)>(.*?)</table>", 34);
    public static final Pattern PTR = Pattern.compile("^\\s*<tr(.*?)>(.*)</tr>\\s*$", 34);
    public static final Pattern PTRPre = Pattern.compile("<tr.*?>.*?</tr>", 34);
    public static final Pattern PTD = Pattern.compile("^\\s*<(td|th)(.*?)>(.*)</(td|th)>\\s*$", 34);
    public static final Pattern PTDPre = Pattern.compile("<(td|th).*?>.*?</(td|th)>", 34);
    public static final String ProtectedTableStart = "<!--_ZVING_INNERTABLE_PROTECTED_";
    private ArrayList pList = null;

    public HtmlTable() {
        this.ElementType = "TABLE";
        this.TagName = "table";
    }

    public void addTR(HtmlTR tr) {
        this.addChild((HtmlElement)tr);
    }

    public HtmlTR getTR(int index) {
        return (HtmlTR)this.Children.get(index);
    }

    public void removeTR(int index) {
        if (index < 0 || index > this.Children.size()) {
            throw new RuntimeException("\u9519\u8bef\u7684\u7d22\u5f15");
        }
        this.Children.remove(index);
    }

    public void removeColumn(int index) {
        for (int i = 0; i < this.Children.size(); ++i) {
            HtmlTR tr = this.getTR(i);
            if (index >= tr.Children.size()) continue;
            tr.removeTD(index);
        }
    }

    public void setWidth(int width) {
        this.Attributes.put((Object)"width", (Object)new Integer(width));
    }

    public int getWidth() {
        return (Integer)this.Attributes.get((Object)"width");
    }

    public void setHeight(int height) {
        this.Attributes.put((Object)"height", (Object)new Integer(height));
    }

    public int getHeight() {
        return (Integer)this.Attributes.get((Object)"height");
    }

    public void setAlign(String align) {
        this.Attributes.put((Object)"align", (Object)align);
    }

    public String getAlign() {
        return (String)this.Attributes.get((Object)"align");
    }

    public void setBgColor(String bgColor) {
        this.Attributes.put((Object)"bgColor", (Object)bgColor);
    }

    public String getBgColor() {
        return (String)this.Attributes.get((Object)"bgColor");
    }

    public void setBackgroud(String backgroud) {
        this.Attributes.put((Object)"backgroud", (Object)backgroud);
    }

    public String getBackgroud() {
        return (String)this.Attributes.get((Object)"backgroud");
    }

    public void setCellSpacing(String cellSpacing) {
        this.setAttribute("cellSpacing", cellSpacing);
    }

    public String getCellSpacing() {
        return this.getAttribute("cellSpacing");
    }

    public void setCellPadding(String cellPadding) {
        this.setAttribute("cellPadding", cellPadding);
    }

    public String getCellPadding() {
        return this.getAttribute("cellPadding");
    }

    public void parseHtml(String html) throws Exception {
        Matcher m = PTable.matcher(html);
        if (!m.find()) {
            throw new Exception("Table\u89e3\u6790html\u65f6\u53d1\u751f\u9519\u8bef");
        }
        String attrs = m.group(1);
        String trs = m.group(2).trim();
        this.Attributes.clear();
        this.Children.clear();
        this.Attributes = HtmlTable.parseAttr((String)attrs);
        m = PInnerTable.matcher(trs);
        int lastEndIndex = 0;
        while (m.find(lastEndIndex)) {
            if (this.pList == null) {
                this.pList = new ArrayList();
            }
            this.pList.add(m.group(0));
            lastEndIndex = m.end();
        }
        if (this.pList != null) {
            for (int i = 0; i < this.pList.size(); ++i) {
                trs = StringUtil.replaceEx((String)trs, (String)this.pList.get(i).toString(), (String)("<!--_ZVING_INNERTABLE_PROTECTED_" + i + "-->"));
            }
        }
        m = PTRPre.matcher(trs);
        lastEndIndex = 0;
        while (m.find(lastEndIndex)) {
            String t = trs.substring(m.start(), m.end());
            HtmlTR tr = new HtmlTR(this);
            tr.parseHtml(t);
            this.addTR(tr);
            lastEndIndex = m.end();
        }
    }

    public String restoreInnerTable(String html) {
        if (this.pList == null || this.pList.size() == 0) {
            return html;
        }
        String[] arr = StringUtil.splitEx((String)html, (String)"<!--_ZVING_INNERTABLE_PROTECTED_");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (!StringUtil.isNotEmpty((String)arr[i])) continue;
            if (i != 0) {
                int index = Integer.parseInt(arr[i].substring(0, arr[i].indexOf("-")));
                sb.append(this.pList.get(index).toString());
                arr[i] = arr[i].substring(arr[i].indexOf(">") + 1);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public String getOuterHtml() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.TagName);
        Object[] ks = this.Attributes.keyArray();
        Object[] vs = this.Attributes.valueArray();
        for (i = 0; i < this.Attributes.size(); ++i) {
            if (vs[i] == null) continue;
            sb.append(" ");
            sb.append(ks[i]);
            sb.append("=\"");
            sb.append(vs[i]);
            sb.append("\"");
        }
        sb.append(">\n");
        if (this.getTR(0).getTD(0).isHead()) {
            sb.append("<thead>\n");
        }
        sb.append(this.getTR(0).getOuterHtml());
        if (this.getTR(0).getTD(0).isHead()) {
            sb.append("</thead>\n");
            if (this.Children.size() > 1) {
                sb.append("<tbody>\n");
            }
        }
        for (i = 1; i < this.Children.size(); ++i) {
            sb.append(((HtmlElement)this.Children.get(i)).getOuterHtml());
        }
        if (this.getTR(0).getTD(0).isHead() && this.Children.size() > 1) {
            sb.append("</tbody>\n");
        }
        sb.append("</");
        sb.append(this.TagName);
        sb.append(">");
        return sb.toString();
    }

    public static void test() {
        HtmlTable table = new HtmlTable();
        try {
            String html = FileUtil.readText((String)"G:/Test.txt");
            table.parseHtml(html);
            System.out.println(table.getOuterHtml());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Pattern PTR = Pattern.compile("^\\s*<(tr|th)(.*?)>(.*)</(tr|th)>\\s*$", 34);
        Matcher m = PTR.matcher("<th>dsfsd</th>");
        if (m.find()) {
            System.out.println(m.group(3));
        }
    }
}

