/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.collection.Executor;
import com.sobey.bsp.framework.data.DBConn;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingTransaction
extends Transaction {
    private static final Logger log = LoggerFactory.getLogger(BlockingTransaction.class);
    private boolean isExistsOpeningOperate = false;
    private static ThreadLocal<Object> current = new ThreadLocal();
    private DBConn conn;

    public void setDataAccess(DataAccess dAccess) {
        if (this.dataAccess != null && !this.outerConnFlag) {
            throw new RuntimeException("setDataAccess() must before any add()");
        }
        super.setDataAccess(dAccess);
    }

    public void add(QueryBuilder qb) {
        this.executeWithBlockedConnection((Object)qb, 7, true);
    }

    public void add(Schema schema, int type) {
        this.executeWithBlockedConnection((Object)schema, type, true);
    }

    public void add(SchemaSet set, int type) {
        this.executeWithBlockedConnection((Object)set, type, true);
    }

    private void executeWithBlockedConnection(Object obj, int type, boolean rollBackFlag) {
        try {
            this.executeObject(obj, type);
            this.isExistsOpeningOperate = true;
        }
        catch (SQLException e) {
            log.error("\u6267\u884csql\u9047\u5230\u5f02\u5e38", (Throwable)e);
            if (!this.outerConnFlag && rollBackFlag) {
                try {
                    this.dataAccess.rollback();
                    this.conn.isBlockingTransactionStarted = false;
                }
                catch (SQLException e1) {
                    log.error("\u56de\u6eda\u6570\u636e\u5e93\u9047\u5230\u5f02\u5e38", (Throwable)e);
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.dataAccess.close();
            }
            catch (SQLException e) {
                log.error("\u5173\u95ed\u8fde\u63a5\uff08\u5f52\u8fd8\uff09\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public boolean commit() {
        return this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(boolean setAutoCommitStatus) {
        if (this.dataAccess != null) {
            try {
                this.dataAccess.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.ExceptionMessage = e.getMessage();
                if (!this.outerConnFlag) {
                    try {
                        this.dataAccess.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
                boolean e1 = false;
                return e1;
            }
            finally {
                try {
                    if (!this.outerConnFlag || setAutoCommitStatus) {
                        this.dataAccess.setAutoCommit(true);
                    }
                    if (!this.outerConnFlag) {
                        this.conn.isBlockingTransactionStarted = false;
                        this.dataAccess.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                this.isExistsOpeningOperate = false;
                current.set(null);
            }
            for (int i = 0; i < this.executorList.size(); ++i) {
                Executor executor = (Executor)this.executorList.get(i);
                executor.execute();
            }
        }
        return true;
    }
}

