/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.chinamcloud.vms.datasource.util.PrintSqlUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConn;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.LobUtil;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.SelectSQLParser;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.LogUtil;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataAccess {
    private static final Logger log = LoggerFactory.getLogger(DataAccess.class);
    protected DBConn dbConn;
    protected boolean allowActiveCloseConnection = true;

    public void setAllowActiveCloseConnection(boolean allowActiveCloseConnection) {
        this.allowActiveCloseConnection = allowActiveCloseConnection;
    }

    public DataAccess() {
    }

    public DataAccess(DBConn conn) {
        this.dbConn = conn;
    }

    public DBConn getConnection() {
        if (this.dbConn == null) {
            this.dbConn = DBConnPool.getConnection();
        }
        return this.dbConn;
    }

    public void setAutoCommit(boolean bCommit) throws SQLException {
        if (this.dbConn == null) {
            this.dbConn = DBConnPool.getConnection();
        }
        this.dbConn.setAutoCommit(bCommit);
    }

    public void commit() throws SQLException {
        if (this.dbConn == null) {
            return;
        }
        this.dbConn.commit();
    }

    public void rollback() throws SQLException {
        if (this.dbConn == null) {
            return;
        }
        this.dbConn.rollback();
    }

    public void close() throws SQLException {
        if (this.dbConn == null) {
            return;
        }
        this.dbConn.close();
    }

    public static void setParams(PreparedStatement stmt, QueryBuilder qb, DBConn conn) throws SQLException {
        ArrayList batches = null;
        if (qb.isBatchMode()) {
            batches = qb.getBatches();
            for (int k = 0; k < batches.size(); ++k) {
                ArrayList list = (ArrayList)batches.get(k);
                for (int i = 1; i <= list.size(); ++i) {
                    Object o = list.get(i - 1);
                    if (o == null) {
                        stmt.setNull(i, 12);
                        continue;
                    }
                    if (o instanceof Byte) {
                        stmt.setByte(i, (Byte)o);
                        continue;
                    }
                    if (o instanceof Short) {
                        stmt.setShort(i, (Short)o);
                        continue;
                    }
                    if (o instanceof Integer) {
                        stmt.setInt(i, (Integer)o);
                        continue;
                    }
                    if (o instanceof Long) {
                        stmt.setLong(i, (Long)o);
                        continue;
                    }
                    if (o instanceof Float) {
                        stmt.setFloat(i, ((Float)o).floatValue());
                        continue;
                    }
                    if (o instanceof Double) {
                        stmt.setDouble(i, (Double)o);
                        continue;
                    }
                    if (o instanceof Date) {
                        stmt.setTimestamp(i, new Timestamp(((Date)o).getTime()));
                        continue;
                    }
                    if (o instanceof String) {
                        stmt.setString(i, (String)o);
                        continue;
                    }
                    if (o instanceof Clob) {
                        LobUtil.setClob((DBConn)conn, (PreparedStatement)stmt, (int)i, o);
                        continue;
                    }
                    if (o instanceof byte[]) {
                        LobUtil.setBlob((DBConn)conn, (PreparedStatement)stmt, (int)i, (byte[])((byte[])o));
                        continue;
                    }
                    stmt.setObject(i, o);
                }
                stmt.addBatch();
            }
        } else {
            ArrayList list = qb.getParams();
            for (int i = 1; i <= list.size(); ++i) {
                Object o = list.get(i - 1);
                if (o == null) {
                    stmt.setNull(i, 12);
                    continue;
                }
                if (o instanceof Byte) {
                    stmt.setByte(i, (Byte)o);
                    continue;
                }
                if (o instanceof Short) {
                    stmt.setShort(i, (Short)o);
                    continue;
                }
                if (o instanceof Integer) {
                    stmt.setInt(i, (Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    stmt.setLong(i, (Long)o);
                    continue;
                }
                if (o instanceof Float) {
                    stmt.setFloat(i, ((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Double) {
                    stmt.setDouble(i, (Double)o);
                    continue;
                }
                if (o instanceof Date) {
                    stmt.setTimestamp(i, new Timestamp(((Date)o).getTime()));
                    continue;
                }
                if (o instanceof String) {
                    stmt.setString(i, (String)o);
                    continue;
                }
                if (o instanceof Clob) {
                    LobUtil.setClob((DBConn)conn, (PreparedStatement)stmt, (int)i, o);
                    continue;
                }
                if (o instanceof byte[]) {
                    LobUtil.setBlob((DBConn)conn, (PreparedStatement)stmt, (int)i, (byte[])((byte[])o));
                    continue;
                }
                stmt.setObject(i, o);
            }
        }
    }

    public DataTable executeDataTable(QueryBuilder queryBuilder) {
        Statement stmt = null;
        ResultSet rs = null;
        DataTable dt = null;
        try {
            if (this.dbConn == null) {
                this.dbConn = DBConnPool.getConnection();
            }
            if (Config.isDebugLoglevel()) {
                LogUtil.info((Object)queryBuilder.toString());
            }
            stmt = this.dbConn.prepareStatement(queryBuilder.getSQL(), 1003, 1007);
            DataAccess.setParams((PreparedStatement)stmt, (QueryBuilder)queryBuilder, (DBConn)this.dbConn);
            rs = stmt.executeQuery();
            dt = new DataTable(rs);
        }
        catch (Exception e) {
            log.error("\u6267\u884csql:" + PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder) + ",\u8fd0\u884c\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (this.dbConn != null) {
                    this.dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error("\u6267\u884csql:" + PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder) + ",\u5173\u95ed\u8d44\u6e90\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable executePagedDataTable(QueryBuilder queryBuilder, int pageSize, int pageIndex) throws SQLException {
        String pageSQL;
        if (this.dbConn == null) {
            this.dbConn = DBConnPool.getConnection();
        }
        if (pageSize < 1) {
            pageSize = Integer.MAX_VALUE;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        if ((pageSQL = DataAccess.getPagedSQL((DBConn)this.dbConn, (QueryBuilder)queryBuilder, (int)pageSize, (int)pageIndex)).contains("SCMS_Article") && pageSQL.contains("and id in")) {
            pageSQL = pageSQL.substring(0, pageSQL.indexOf("limit"));
            queryBuilder.getParams().remove(queryBuilder.getParams().size() - 1);
            queryBuilder.getParams().remove(queryBuilder.getParams().size() - 1);
        }
        if (Config.isDebugLoglevel()) {
            LogUtil.info((Object)(pageSQL + " " + pageIndex + "," + pageSize));
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DataTable dt = null;
        try {
            stmt = this.dbConn.prepareStatement(pageSQL, 1003, 1007);
            DataAccess.setParams((PreparedStatement)stmt, (QueryBuilder)queryBuilder, (DBConn)this.dbConn);
            rs = stmt.executeQuery();
            dt = this.dbConn.getDBConfig().DBType.equals("MSSQL2000") ? new DataTable(rs, pageSize, pageIndex) : new DataTable(rs);
        }
        finally {
            try {
                if (!this.dbConn.getDBConfig().DBType.equals("MSSQL2000") && !queryBuilder.getParams().isEmpty()) {
                    queryBuilder.getParams().remove(queryBuilder.getParams().size() - 1);
                    queryBuilder.getParams().remove(queryBuilder.getParams().size() - 1);
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (this.dbConn != null) {
                    this.dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error("\u6267\u884csql:" + PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder, (int)pageIndex, (int)pageSize) + ",\u5173\u95ed\u8d44\u6e90\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
        }
        return dt;
    }

    public static String getPagedSQL(DBConn conn, QueryBuilder queryBuilder, int pageSize, int pageIndex) {
        StringBuffer sb = new StringBuffer();
        String DBType = conn.getDBConfig().DBType.toUpperCase();
        int start = pageIndex * pageSize;
        int end = (pageIndex + 1) * pageSize;
        if (DBType.equals("ORACLE")) {
            sb.append("select * from (select rs.*,rownum rnm from (");
            sb.append(queryBuilder.getSQL());
            sb.append(") rs where rownum <= ?) rss where rnm > ?");
            queryBuilder.add(end);
            queryBuilder.add(start);
        } else if (DBType.equals("DB2")) {
            sb.append("select * from (select rs.*,rownumber() OVER () rnm from (");
            sb.append(queryBuilder.getSQL());
            sb.append(") rs) rss WHERE rnm BETWEEN ? and ?");
            queryBuilder.add(start + 1);
            queryBuilder.add(end);
        } else if (DBType.equals("MSSQL")) {
            String sql = queryBuilder.getSQL();
            SelectSQLParser sp = new SelectSQLParser();
            try {
                sp.setSQL(sql);
                sp.parse();
            }
            catch (Exception e) {
                log.error("\u6267\u884csql:" + PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder, (int)pageIndex, (int)pageSize) + ",\u5173\u95ed\u8d44\u6e90\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
            sb.append(sp.getMSSQLPagedSQL());
            queryBuilder.add(start + 1);
            queryBuilder.add(end);
        } else if (DBType.equals("MSSQL2000")) {
            sb.append(queryBuilder.getSQL());
        } else if (DBType.equals("MYSQL")) {
            sb.append(queryBuilder.getSQL());
            sb.append(" limit ?,?");
            queryBuilder.add(start);
            queryBuilder.add(pageSize);
        }
        return sb.toString();
    }

    public static int getCount(String dbType, QueryBuilder qb) {
        QueryBuilder cqb = new QueryBuilder();
        cqb.setParams((ArrayList)qb.getParams().clone());
        String sql = qb.getSQL().toLowerCase();
        int index1 = sql.lastIndexOf(")");
        int index2 = sql.lastIndexOf("order by");
        if (index2 > index1) {
            sql = sql.substring(0, index2);
        }
        cqb.setSQL("select count(1) from (" + sql + ") t1");
        return cqb.executeInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeOneValue(QueryBuilder queryBuilder) throws SQLException {
        if (this.dbConn == null) {
            this.dbConn = DBConnPool.getConnection();
        }
        if (Config.isDebugLoglevel()) {
            LogUtil.info((Object)queryBuilder.toString());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object t = null;
        try {
            stmt = this.dbConn.prepareStatement(queryBuilder.getSQL(), 1003, 1007);
            DataAccess.setParams((PreparedStatement)stmt, (QueryBuilder)queryBuilder, (DBConn)this.dbConn);
            rs = stmt.executeQuery();
            if (rs.next()) {
                t = rs.getObject(1);
                if (t instanceof Clob) {
                    t = LobUtil.clobToString((Clob)((Clob)t));
                }
                if (t instanceof Blob) {
                    t = LobUtil.blobToBytes((Blob)((Blob)t));
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (this.dbConn != null) {
                    this.dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error("\u6267\u884csql:" + PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder) + ",\u5173\u95ed\u8d44\u6e90\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNoQuery(QueryBuilder queryBuilder) throws SQLException {
        if (this.dbConn == null) {
            this.dbConn = DBConnPool.getConnection();
        }
        if (Config.isDebugLoglevel()) {
            LogUtil.info((Object)queryBuilder.toString());
        }
        Statement stmt = null;
        int t = -1;
        try {
            stmt = this.dbConn.prepareStatement(queryBuilder.getSQL(), 1003, 1007);
            DataAccess.setParams((PreparedStatement)stmt, (QueryBuilder)queryBuilder, (DBConn)this.dbConn);
            if (queryBuilder.isBatchMode()) {
                stmt.executeBatch();
            } else {
                t = stmt.executeUpdate();
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (this.allowActiveCloseConnection) {
                    this.dbConn.close();
                }
            }
            catch (SQLException e) {
                log.error("\u6267\u884csql:" + PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder) + ",\u5173\u95ed\u8d44\u6e90\u65f6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
        }
        return t;
    }

    public void insert(Schema schema) {
        schema.setDataAccess(this);
        schema.insert();
    }

    public void update(Schema schema) {
        schema.setDataAccess(this);
        schema.update();
    }

    public void delete(Schema schema) {
        schema.setDataAccess(this);
        schema.delete();
    }

    public void deleteAndBackup(Schema schema) {
        schema.setDataAccess(this);
        schema.deleteAndBackup();
    }

    public void deleteAndInsert(Schema schema) {
        schema.setDataAccess(this);
        schema.deleteAndInsert();
    }

    public void insert(SchemaSet set) {
        set.setDataAccess(this);
        set.insert();
    }

    public void update(SchemaSet set) {
        set.setDataAccess(this);
        set.update();
    }

    public void delete(SchemaSet set) {
        set.setDataAccess(this);
        set.delete();
    }

    public void deleteAndBackup(SchemaSet set) {
        set.setDataAccess(this);
        set.deleteAndBackup();
    }

    public void deleteAndInsert(SchemaSet set) {
        set.setDataAccess(this);
        set.deleteAndInsert();
    }
}

