/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.orm.SchemaUtil;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class DataCollection
extends Mapx {
    private static final long serialVersionUID = 1L;

    public void put(String id, int number) {
        this.put((Object)id, (Object)new Integer(number));
    }

    public void put(String id, long number) {
        this.put((Object)id, (Object)new Long(number));
    }

    public void put(String id, double number) {
        this.put((Object)id, (Object)new Double(number));
    }

    public void put(String id, float number) {
        this.put((Object)id, (Object)new Float(number));
    }

    public Object get(String id) {
        return super.get((Object)id);
    }

    public String[] getStringArray(String id) {
        Object o = super.get((Object)id);
        if (o != null && o instanceof String[]) {
            try {
                return (String[])o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int[] getIntArray(String id) {
        Object o = super.get((Object)id);
        if (o != null && o instanceof int[]) {
            try {
                return (int[])o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public long[] getLongArray(String id) {
        Object o = super.get((Object)id);
        if (o != null && o instanceof long[]) {
            try {
                return (long[])o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public float[] getFloatArray(String id) {
        Object o = super.get((Object)id);
        if (o != null && o instanceof float[]) {
            try {
                return (float[])o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public double[] getDoubleArray(String id) {
        Object o = super.get((Object)id);
        if (o != null && o instanceof double[]) {
            try {
                return (double[])o;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getInt(String id) {
        Object o = super.get((Object)id);
        if (Integer.class.isInstance(o)) {
            return (Integer)o;
        }
        throw new RuntimeException("DataSource:getInt\u8fd4\u56de\u7684\u4e0d\u662fint\uff0cid=" + id);
    }

    public long getLong(String id) {
        Object o = super.get((Object)id);
        if (Long.class.isInstance(o)) {
            return (Long)o;
        }
        throw new RuntimeException("DataSource:getLong\u8fd4\u56de\u7684\u4e0d\u662flong\uff0cid=" + id);
    }

    public double getDouble(String id) {
        Object o = super.get((Object)id);
        if (Double.class.isInstance(o)) {
            return (Double)o;
        }
        throw new RuntimeException("DataSource:getDouble\u8fd4\u56de\u7684\u4e0d\u662fdouble\uff0cid=" + id);
    }

    public float getFloat(String id) {
        Object o = super.get((Object)id);
        if (Float.class.isInstance(o)) {
            return ((Float)o).floatValue();
        }
        throw new RuntimeException("DataSource:getFloat\u8fd4\u56de\u7684\u4e0d\u662ffloat\uff0cid=" + id);
    }

    public String getString(String id) {
        Object o = super.get((Object)id);
        if (String.class.isInstance(o)) {
            return (String)o;
        }
        return null;
    }

    public DataTable getDataTable(String id) {
        Object o = super.get((Object)id);
        if (DataTable.class.isInstance(o)) {
            return (DataTable)o;
        }
        return null;
    }

    public Schema getSchema(String id) {
        Object o = super.get((Object)id);
        if (Schema.class.isInstance(o)) {
            return (Schema)o;
        }
        return null;
    }

    public SchemaSet getSchemaSet(String id) {
        Object o = super.get((Object)id);
        if (SchemaSet.class.isInstance(o)) {
            return (SchemaSet)o;
        }
        return null;
    }

    public String toXML() {
        Document doc = DocumentHelper.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("collection");
        Object[] ks = this.keyArray();
        Object[] vs = this.valueArray();
        for (int i = 0; i < this.size(); ++i) {
            int j;
            StringBuffer sb;
            Object[] t;
            String id = (String)ks[i];
            Object value = vs[i];
            Element ele = root.addElement("element");
            ele.addAttribute("ID", id);
            if (value == null || value.equals("")) {
                ele.addAttribute("Type", "String");
                ele.addCDATA("_ZVING_NULL");
                continue;
            }
            if (value instanceof String) {
                ele.addAttribute("Type", "String");
                ele.addCDATA((String)value);
                continue;
            }
            if (value instanceof Integer) {
                ele.addAttribute("Type", "Int");
                ele.addAttribute("Value", String.valueOf(value));
                continue;
            }
            if (value instanceof Long) {
                ele.addAttribute("Type", "Long");
                ele.addAttribute("Value", String.valueOf(value));
                continue;
            }
            if (value instanceof Float) {
                ele.addAttribute("Type", "Float");
                ele.addAttribute("Value", String.valueOf(value));
                continue;
            }
            if (value instanceof Double) {
                ele.addAttribute("Type", "Double");
                ele.addAttribute("Value", String.valueOf(value));
                continue;
            }
            if (value instanceof int[]) {
                t = (int[])value;
                sb = new StringBuffer();
                sb.append(t[0]);
                for (j = 1; j < t.length; ++j) {
                    sb.append(",");
                    sb.append(t[j]);
                }
                ele.addAttribute("Type", "IntArray");
                ele.addAttribute("Value", sb.toString());
                continue;
            }
            if (value instanceof long[]) {
                t = (long[])value;
                sb = new StringBuffer();
                sb.append((long)t[0]);
                for (j = 1; j < t.length; ++j) {
                    sb.append(",");
                    sb.append((long)t[j]);
                }
                ele.addAttribute("Type", "LongArray");
                ele.addAttribute("Value", sb.toString());
                continue;
            }
            if (value instanceof float[]) {
                t = (float[])value;
                sb = new StringBuffer();
                sb.append((float)t[0]);
                for (j = 1; j < t.length; ++j) {
                    sb.append(",");
                    sb.append((float)t[j]);
                }
                ele.addAttribute("Type", "FloatArray");
                ele.addAttribute("Value", sb.toString());
                continue;
            }
            if (value instanceof double[]) {
                t = (double[])value;
                sb = new StringBuffer();
                sb.append((double)t[0]);
                for (j = 1; j < t.length; ++j) {
                    sb.append(",");
                    sb.append((double)t[j]);
                }
                ele.addAttribute("Type", "DoubleArray");
                ele.addAttribute("Value", sb.toString());
                continue;
            }
            if (value instanceof String[]) {
                t = (String[])value;
                sb = new StringBuffer();
                for (j = 0; j < t.length; ++j) {
                    if (j != 0) {
                        sb.append(",");
                    }
                    sb.append("\"");
                    if (t[j] == null) {
                        t[j] = (int)"_ZVING_NULL";
                    }
                    sb.append(StringUtil.javaEncode((String)t[j]));
                    sb.append("\"");
                }
                ele.addAttribute("Type", "StringArray");
                ele.addCDATA(sb.toString());
                continue;
            }
            if (value instanceof DataTable) {
                this.dataTableToXML((DataTable)value, ele);
                continue;
            }
            if (value instanceof Schema) {
                this.schemaToXML((Schema)value, ele);
                continue;
            }
            if (value instanceof SchemaSet) {
                this.schemaSetToXML((SchemaSet)value, ele);
                continue;
            }
            if (!(value instanceof Mapx)) continue;
            this.mapToXML((Mapx)value, ele);
        }
        return doc.asXML();
    }

    private void dataTableToXML(DataTable dt, Element ele) {
        this.translatDataTableToXML(dt, ele, "DataTable");
    }

    private void translatDataTableToXML(DataTable dt, Element ele, String type) {
        int i;
        if (dt == null) {
            throw new RuntimeException("DataCollection:\u751f\u6210XML\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u4f20\u5165\u7684DataTable\u4e3a\u7a7a!");
        }
        ele.addAttribute("Type", type);
        DataColumn[] dcs = dt.getDataColumns();
        Element cols = ele.addElement("columns");
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (i = 0; i < dcs.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("[\"");
            sb.append(dcs[i].getColumnName());
            sb.append("\"");
            sb.append(",");
            sb.append(dcs[i].getColumnType());
            sb.append("]");
        }
        sb.append("]");
        cols.addCDATA(sb.toString());
        sb = new StringBuffer();
        sb.append("[");
        for (i = 0; i < dt.getRowCount(); ++i) {
            sb.append("[");
            for (int j = 0; j < dcs.length; ++j) {
                String v = dt.getString(i, j);
                if (j == 0) {
                    if (v == null) continue;
                    sb.append("\"" + StringUtil.javaEncode((String)v) + "\"");
                    continue;
                }
                if (v == null) {
                    sb.append(",");
                    continue;
                }
                sb.append(",\"" + StringUtil.javaEncode((String)v) + "\"");
            }
            if (i == dt.getRowCount() - 1) {
                sb.append("]");
                continue;
            }
            sb.append("],\n");
        }
        sb.append("]");
        Element value = ele.addElement("values");
        value.addCDATA(sb.toString());
    }

    public static String dataTableToJS(DataTable dt) {
        int i;
        if (dt == null) {
            throw new RuntimeException("DataCollection:\u751f\u6210JS\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u4f20\u5165\u7684DataTable\u4e3a\u7a7a!");
        }
        boolean webModeFlag = dt.isWebMode();
        dt.setWebMode(false);
        DataColumn[] dcs = dt.getDataColumns();
        StringBuffer sb = new StringBuffer();
        sb.append("var _Zving_Cols = [");
        for (i = 0; i < dcs.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("[\"");
            sb.append(dcs[i].getColumnName());
            sb.append("\"");
            sb.append(",");
            sb.append(dcs[i].getColumnType());
            sb.append("]");
        }
        sb.append("]\n");
        sb.append("var _Zving_Values = [");
        for (i = 0; i < dt.getRowCount(); ++i) {
            sb.append("[");
            for (int j = 0; j < dcs.length; ++j) {
                String v = dt.getString(i, j);
                int ct = dcs[j].ColumnType;
                if (j != 0) {
                    sb.append(",");
                }
                if (v == null) {
                    sb.append("null");
                    continue;
                }
                if (ct == 1 || ct == 10) {
                    String txt = StringUtil.javaEncode((String)v);
                    txt = StringUtil.replaceEx((String)txt, (String)"<", (String)"\\<");
                    txt = StringUtil.replaceEx((String)txt, (String)">", (String)"\\>");
                    sb.append("\"" + txt + "\"");
                    continue;
                }
                if (ct == 0) {
                    sb.append("\"" + v + "\"");
                    continue;
                }
                sb.append("" + v);
            }
            if (i == dt.getRowCount() - 1) {
                sb.append("]");
                continue;
            }
            sb.append("],\n");
        }
        dt.setWebMode(webModeFlag);
        sb.append("];\n");
        return sb.toString();
    }

    private void schemaToXML(Schema schema, Element ele) {
        try {
            Class<?> c = Class.forName(SchemaUtil.getNameSpace((Schema)schema) + "." + SchemaUtil.getTableCode((Schema)schema) + "Set");
            SchemaSet set = (SchemaSet)c.newInstance();
            set.add(schema);
            DataTable dt = set.toDataTable();
            ele.addAttribute("TableCode", SchemaUtil.getTableCode((Schema)schema));
            ele.addAttribute("NameSpace", SchemaUtil.getNameSpace((Schema)schema));
            this.translatDataTableToXML(dt, ele, "Schema");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void schemaSetToXML(SchemaSet set, Element ele) {
        if (set != null && set.size() != 0) {
            DataTable dt = set.toDataTable();
            ele.addAttribute("TableCode", SchemaUtil.getTableCode((SchemaSet)set));
            ele.addAttribute("NameSpace", SchemaUtil.getNameSpace((SchemaSet)set));
            this.translatDataTableToXML(dt, ele, "SchemaSet");
        }
    }

    public void parseXML(String xml) {
        if (xml == null || xml.length() == 0) {
            throw new RuntimeException("DataCollection:\u89e3\u6790XML\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u4f20\u5165\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a!");
        }
        xml = StringUtil.replaceEx((String)xml, (String)StringUtil.urlDecode((String)"%C2%A0", (String)"UTF-8"), (String)" ");
        xml = StringUtil.clearForXML((String)xml);
        SAXReader reader = new SAXReader(false);
        reader.setEncoding("UTF-8");
        try {
            Document doc = reader.read(new InputSource(new StringReader(xml)));
            Element root = doc.getRootElement();
            List elements = root.elements();
            for (int i = 0; i < elements.size(); ++i) {
                String[] t;
                String str;
                Element ele = (Element)elements.get(i);
                String id = ele.attributeValue("ID");
                String type = ele.attributeValue("Type");
                if (type.equals("String")) {
                    str = ele.getText();
                    if ("_ZVING_NULL".equals(str)) {
                        str = null;
                    }
                    this.put((Object)id, (Object)str);
                    continue;
                }
                if (type.equals("Int")) {
                    str = ele.attributeValue("Value");
                    if (StringUtil.isEmpty((String)str)) {
                        str = ele.getText();
                    }
                    this.put(id, Integer.parseInt(str));
                    continue;
                }
                if (type.equals("Long")) {
                    str = ele.attributeValue("Value");
                    if (StringUtil.isEmpty((String)str)) {
                        str = ele.getText();
                    }
                    this.put(id, Long.parseLong(str));
                    continue;
                }
                if (type.equals("Float")) {
                    str = ele.attributeValue("Value");
                    if (StringUtil.isEmpty((String)str)) {
                        str = ele.getText();
                    }
                    this.put(id, Float.parseFloat(str));
                    continue;
                }
                if (type.equals("Double")) {
                    str = ele.attributeValue("Value");
                    if (StringUtil.isEmpty((String)str)) {
                        str = ele.getText();
                    }
                    this.put(id, Double.parseDouble(str));
                    continue;
                }
                if (type.equals("StringArray")) {
                    str = ele.getText();
                    t = str.split("\",\"");
                    for (int j = 0; j < t.length; ++j) {
                        t[j] = StringUtil.javaDecode((String)t[j]);
                    }
                    t[0] = t[0].substring(1);
                    t[t.length - 1] = t[t.length - 1].substring(0, t[t.length - 1].length() - 2);
                    this.put((Object)id, (Object)t);
                    continue;
                }
                if (type.equals("IntArray")) {
                    str = ele.attributeValue("Value");
                    t = str.split(",");
                    int[] a = new int[t.length];
                    for (int j = 0; j < t.length; ++j) {
                        a[j] = Integer.parseInt(t[j]);
                    }
                    this.put((Object)id, (Object)a);
                    continue;
                }
                if (type.equals("LongArray")) {
                    str = ele.attributeValue("Value");
                    t = str.split(",");
                    long[] a = new long[t.length];
                    for (int j = 0; j < t.length; ++j) {
                        a[j] = Long.parseLong(t[j]);
                    }
                    this.put((Object)id, (Object)a);
                    continue;
                }
                if (type.equals("FloatArray")) {
                    str = ele.attributeValue("Value");
                    t = str.split(",");
                    float[] a = new float[t.length];
                    for (int j = 0; j < t.length; ++j) {
                        a[j] = Float.parseFloat(t[j]);
                    }
                    this.put((Object)id, (Object)a);
                    continue;
                }
                if (type.equals("DoubleArray")) {
                    str = ele.attributeValue("Value");
                    t = str.split(",");
                    double[] a = new double[t.length];
                    for (int j = 0; j < t.length; ++j) {
                        a[j] = Double.parseDouble(t[j]);
                    }
                    this.put((Object)id, (Object)a);
                    continue;
                }
                if (type.equals("DataTable")) {
                    DataTable dt = this.parseDataTable(ele);
                    this.put((Object)id, (Object)dt);
                    continue;
                }
                if (type.equals("Map")) {
                    Mapx map = this.parseMap(ele);
                    this.put((Object)id, (Object)map);
                    continue;
                }
                if (type.equals("Schema")) {
                    Class<?> c = Class.forName(ele.attributeValue("NameSpace") + "." + ele.attributeValue("TableCode"));
                    Schema schema = (Schema)c.newInstance();
                    DataTable dt = this.parseDataTable(ele);
                    for (int j = 0; j < SchemaUtil.getColumns((Schema)schema).length; ++j) {
                        schema.setV(i, dt.get(0, j));
                    }
                    this.put((Object)id, (Object)schema);
                    continue;
                }
                if (!type.equals("SchemaSet")) continue;
                Class<?> cSchema = Class.forName(ele.attributeValue("NameSpace") + "." + ele.attributeValue("TableCode") + "Schema");
                Class<?> cSet = Class.forName(ele.attributeValue("NameSpace") + "." + ele.attributeValue("TableCode") + "Set");
                DataTable dt = this.parseDataTable(ele);
                SchemaSet set = (SchemaSet)cSet.newInstance();
                for (int j = 0; j < dt.getRowCount(); ++j) {
                    Schema schema = (Schema)cSchema.newInstance();
                    for (int k = 0; k < SchemaUtil.getColumns((Schema)schema).length; ++k) {
                        schema.setV(i, dt.get(j, k));
                    }
                    set.add(schema);
                }
                this.put((Object)id, (Object)set);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Mapx parseMap(Element ele) {
        Mapx map = new Mapx();
        String str = ele.element("columns").getText();
        str = str.trim().substring(0, str.length() - 1);
        String[] arr = StringUtil.splitEx((String)str, (String)",\"");
        for (int i = 0; i < arr.length; ++i) {
            String[] arr2 = StringUtil.splitEx((String)str, (String)"\":");
            if (arr2.length != 2) continue;
            String k = arr2[0];
            String v = arr2[1];
            if (k.startsWith("\"")) {
                k = k.substring(1);
            }
            if (k.endsWith("\"")) {
                k = k.substring(0, k.length() - 1);
            }
            if (v.startsWith("\"")) {
                v = v.substring(1);
            }
            if (v.endsWith("\"")) {
                v = v.substring(0, v.length() - 1);
            }
            map.put((Object)k, (Object)v);
        }
        return map;
    }

    private void mapToXML(Mapx map, Element ele) {
        ele.addAttribute("Type", "Map");
        StringBuffer sb = new StringBuffer();
        Object[] ks = map.keyArray();
        sb.append("{");
        for (int i = 0; i < ks.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(ks[i]);
            sb.append(":\"");
            sb.append(StringUtil.javaEncode((String)map.getString(ks[i])));
            sb.append("\"");
        }
        sb.append("}");
        ele.addCDATA(sb.toString());
    }

    private DataTable parseDataTable(Element ele) {
        String str = ele.element("columns").getText();
        String[] t = StringUtil.splitEx((String)str, (String)"],[");
        DataColumn[] dcs = new DataColumn[t.length];
        t[0] = t[0].substring(2);
        int length = t.length;
        t[length - 1] = t[length - 1].substring(0, t[length - 1].length() - 2);
        for (int i = 0; i < t.length; ++i) {
            dcs[i] = new DataColumn();
            int index = t[i].lastIndexOf(",");
            dcs[i].setColumnName(t[i].substring(1, index - 1));
            dcs[i].setColumnType(Integer.parseInt(t[i].substring(index + 1)));
        }
        String value = ele.element("values").getText();
        t = value.split("\\\"\\]\\,\\s*?\\[\\\"");
        if (t[0].equals("[]")) {
            return new DataTable(dcs, (Object[][])null);
        }
        t[0] = t[0].substring(3);
        length = t.length;
        t[length - 1] = t[length - 1].substring(0, t[length - 1].length() - 3);
        Object[][] values = new Object[length][dcs.length];
        for (int i = 0; i < t.length; ++i) {
            String[] r = t[i].split("\",\"");
            for (int j = 0; j < r.length; ++j) {
                if (dcs[j].getColumnType() == 1) {
                    values[i][j] = StringUtil.javaDecode((String)r[j]);
                    continue;
                }
                if (r[j].equals("_ZVING_NULL") || StringUtil.isEmpty((String)r[j])) {
                    values[i][j] = null;
                    continue;
                }
                if (dcs[j].getColumnType() == 3) {
                    values[i][j] = new Double(Double.parseDouble(r[j]));
                    continue;
                }
                if (dcs[j].getColumnType() == 0) {
                    values[i][j] = DateUtil.parse((String)r[j]);
                    continue;
                }
                if (dcs[j].getColumnType() == 4) {
                    values[i][j] = new Double(Double.parseDouble(r[j]));
                    continue;
                }
                if (dcs[j].getColumnType() == 6) {
                    values[i][j] = new Double(Double.parseDouble(r[j]));
                    continue;
                }
                if (dcs[j].getColumnType() == 5) {
                    values[i][j] = new Float(Float.parseFloat(r[j]));
                    continue;
                }
                if (dcs[j].getColumnType() == 8) {
                    values[i][j] = new Integer(Integer.parseInt(r[j]));
                    continue;
                }
                if (dcs[j].getColumnType() == 7) {
                    values[i][j] = new Long(Long.parseLong(r[j]));
                    continue;
                }
                if (dcs[j].getColumnType() != 9) continue;
                values[i][j] = new Integer(Integer.parseInt(r[j]));
            }
        }
        return new DataTable(dcs, values);
    }
}

