/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.utility.CaseIgnoreMapx;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;

public class DataRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isWebMode;
    protected DataColumn[] columns;
    protected Object[] values;

    public DataRow(DataColumn[] types, Object[] values) {
        this.columns = types;
        this.values = values;
    }

    public Object get(int index) {
        if (this.values == null) {
            return null;
        }
        if (index < 0 || index >= this.columns.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + index);
        }
        return this.values[index];
    }

    public Object get(String columnName) {
        if ("addtime".equals(columnName)) {
            columnName = "PublishDate";
        }
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.values[i];
        }
        LogUtil.warn((Object)("\u6307\u5b9a\u7684\u5217\u540d\u6ca1\u6709\u627e\u5230:" + columnName));
        throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u540d\u6ca1\u6709\u627e\u5230:" + columnName);
    }

    public String getString(int index) {
        if (this.values[index] != null) {
            if (!"".equals(this.values[index]) && this.columns[index].getColumnType() == 0) {
                if (StringUtil.isNotEmpty((String)this.columns[index].getDateFormat())) {
                    return DateUtil.toString((Date)((Date)this.values[index]), (String)this.columns[index].getDateFormat());
                }
                return DateUtil.toString((Date)((Date)this.values[index]), (String)"yyyy-MM-dd HH:mm:ss");
            }
            String t = String.valueOf(this.values[index]).trim();
            if (this.isWebMode && (t == null || t.equals(""))) {
                return "&nbsp;";
            }
            return t;
        }
        if (this.isWebMode) {
            return "&nbsp;";
        }
        return "";
    }

    public String getString(String columnName) {
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getString(i);
        }
        return "";
    }

    public Date getDate(int index) {
        Object obj = this.get(index);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        return DateUtil.parseDateTime((String)obj.toString());
    }

    public Date getDate(String columnName) {
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getDate(i);
        }
        return null;
    }

    public double getDouble(int index) {
        Object obj = this.get(index);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        String str = obj.toString();
        if (StringUtil.isEmpty((String)str)) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public double getDouble(String columnName) {
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getDouble(i);
        }
        return 0.0;
    }

    public long getLong(int index) {
        Object obj = this.get(index);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        String str = obj.toString();
        if (StringUtil.isEmpty((String)str)) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    public long getLong(String columnName) {
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getLong(i);
        }
        return 0L;
    }

    public int getInt(int index) {
        Object obj = this.get(index);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String str = obj.toString();
        if (StringUtil.isEmpty((String)str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public int getInt(String columnName) {
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getInt(i);
        }
        return 0;
    }

    public boolean isNull(int index) {
        return this.get(index) == null;
    }

    public boolean isNull(String columnName) {
        return this.get(columnName) == null;
    }

    public void set(int index, Object value) {
        if (this.values == null) {
            return;
        }
        if (index < 0 || index >= this.values.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + index);
        }
        this.values[index] = value;
    }

    public void set(String columnName, Object value) {
        if (columnName == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            this.values[i] = value;
            return;
        }
        throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u540d\u6ca1\u6709\u627e\u5230\uff1a" + columnName);
    }

    public void set(int index, int value) {
        this.set(index, (Object)new Integer(value));
    }

    public void set(String columnName, int value) {
        this.set(columnName, (Object)new Integer(value));
    }

    public void set(String columnName, long value) {
        this.set(columnName, (Object)new Long(value));
    }

    public void set(int index, long value) {
        this.set(index, (Object)new Long(value));
    }

    public void set(String columnName, double value) {
        this.set(columnName, (Object)new Double(value));
    }

    public void set(int index, double value) {
        this.set(index, (Object)new Double(value));
    }

    public DataColumn getDataColumn(int index) {
        if (index < 0 || index >= this.columns.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + index);
        }
        return this.columns[index];
    }

    public DataColumn getDataColumn(String columnName) {
        if ("addtime".equals(columnName)) {
            columnName = "PublishDate";
        }
        if ((columnName = columnName.trim()) == null || columnName.equals("")) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.columns[i];
        }
        throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u540d\u6ca1\u6709\u627e\u5230");
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object[] getDataValues() {
        return this.values;
    }

    public DataColumn[] getDataColumns() {
        return this.columns;
    }

    public void insertColumn(String columnName, Object columnValue) {
        this.insertColumn(new DataColumn(columnName, 1), columnValue);
    }

    public void insertColumn(String columnName, Object columnValue, int index) {
        this.insertColumn(new DataColumn(columnName, 1), columnValue, index);
    }

    public void insertColumn(DataColumn dc, Object columnValue) {
        this.insertColumn(dc, columnValue, this.values.length);
    }

    public void insertColumn(DataColumn dc, Object columnValue, int index) {
        if (index < 0 || index > this.columns.length) {
            throw new RuntimeException(index + "\u8d85\u51fa\u8303\u56f4\uff0c\u6700\u5927\u5141\u8bb8\u503c\u4e3a" + this.columns.length + "!");
        }
        this.columns = (DataColumn[])ArrayUtils.add((Object[])this.columns, (int)index, (Object)dc);
        this.values = ArrayUtils.add((Object[])this.values, (int)index, (Object)columnValue);
    }

    public boolean isWebMode() {
        return this.isWebMode;
    }

    public void setWebMode(boolean isWebMode) {
        this.isWebMode = isWebMode;
    }

    public Mapx toMapx() {
        Mapx map = new Mapx();
        for (int i = 0; i < this.columns.length; ++i) {
            map.put((Object)this.columns[i].getColumnName(), this.values[i]);
        }
        return map;
    }

    public CaseIgnoreMapx toCaseIgnoreMapx() {
        CaseIgnoreMapx map = new CaseIgnoreMapx(new HashMap());
        for (int i = 0; i < this.columns.length; ++i) {
            map.put((Object)this.columns[i].getColumnName(), this.values[i]);
        }
        return map;
    }

    public void fill(Mapx map) {
        if (map == null) {
            return;
        }
        Object[] ks = map.keyArray();
        Object[] vs = map.valueArray();
        for (int i = 0; i < map.size(); ++i) {
            Object key = ks[i];
            if (key == null) continue;
            for (int j = 0; j < this.columns.length; ++j) {
                if (!key.toString().equalsIgnoreCase(this.columns[j].getColumnName())) continue;
                Object v = vs[i];
                if (this.columns[j].ColumnType == 0 && !Date.class.isInstance(v)) {
                    throw new RuntimeException("\u6570\u7ec4\u7684\u7b2c" + j + "\u4e2a\u5143\u7d20\u5fc5\u987b\u662fDate\u5bf9\u8c61!");
                }
                this.set(j, v);
            }
        }
    }

    public void fill(Object[] values) {
        if (values == null) {
            return;
        }
        if (values.length != this.getColumnCount()) {
            throw new RuntimeException("\u6267\u884cfill\u64cd\u4f5c\u6570\u7ec4\u957f\u5ea6\u4e3a" + values.length + "\uff0c\u8981\u6c42\u7684\u957f\u5ea6\u4e3a" + this.getColumnCount() + "\uff01");
        }
        for (int i = 0; i < values.length; ++i) {
            if (this.columns[i].ColumnType == 0 && !Date.class.isInstance(values[i])) {
                throw new RuntimeException("\u7b2c" + i + "\u5217\u5fc5\u987b\u662fDate\u5bf9\u8c61!");
            }
            this.set(i, values[i]);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.columns.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.columns[i].getColumnName());
            sb.append(":");
            sb.append(this.values[i]);
        }
        return sb.toString();
    }
}

