/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.LobUtil;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.Filter;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class DataTable
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean isWebMode;
    private DataRow[] rows;
    private DataColumn[] columns;

    public DataTable() {
        this.rows = new DataRow[0];
        this.columns = new DataColumn[0];
    }

    public DataTable(DataColumn[] types, Object[][] values) {
        if (types == null) {
            types = new DataColumn[]{};
        }
        this.columns = null;
        this.rows = null;
        if (this.checkColumns(types)) {
            this.columns = types;
        }
        if (values != null) {
            this.rows = new DataRow[values.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new DataRow(this.columns, values[i]);
            }
        } else {
            this.rows = new DataRow[0];
        }
    }

    public boolean checkColumns(DataColumn[] types) {
        if (types == null) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            String columnName = types[i].getColumnName();
            for (int j = 0; j < i; ++j) {
                if (columnName == null) {
                    throw new RuntimeException("DataTable\u4e2d\u7b2c" + i + "\u5217\u5217\u540d\u4e3anull!");
                }
                if (!columnName.equals(types[j].getColumnName())) continue;
                throw new RuntimeException("\u4e00\u4e2aDataTable\u4e2d\u4e0d\u5145\u8bb8\u6709\u91cd\u540d\u7684\u5217:" + columnName);
            }
        }
        return true;
    }

    public DataTable(ResultSet rs) {
        this(rs, Integer.MAX_VALUE, 0);
    }

    public DataTable(ResultSet rs, int pageSize, int pageIndex) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            DataColumn[] types = new DataColumn[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                String name = rsmd.getColumnLabel(i);
                boolean b = rsmd.isNullable(i) == 1;
                DataColumn dc = new DataColumn();
                dc.setAllowNull(b);
                dc.setColumnName(name);
                int dataType = rsmd.getColumnType(i);
                if (dataType == 1 || dataType == 12 || dataType == -1) {
                    dc.ColumnType = 1;
                } else if (dataType == 93 || dataType == 91) {
                    dc.ColumnType = 0;
                } else if (dataType == 3) {
                    dc.ColumnType = 4;
                } else if (dataType == 6) {
                    dc.ColumnType = 5;
                } else if (dataType == 4) {
                    dc.ColumnType = 8;
                } else if (dataType == 5) {
                    dc.ColumnType = 9;
                } else if (dataType == -5) {
                    dc.ColumnType = 7;
                } else if (dataType == 2004) {
                    dc.ColumnType = 2;
                } else if (dataType == 2005) {
                    dc.ColumnType = 10;
                } else if (dataType == 2) {
                    int dataScale = rsmd.getScale(i);
                    int dataPrecision = rsmd.getPrecision(i);
                    dc.ColumnType = dataScale == 0 ? (dataPrecision == 0 ? 3 : 7) : 3;
                } else {
                    dc.ColumnType = 1;
                }
                types[i - 1] = dc;
            }
            if (this.checkColumns(types)) {
                this.columns = types;
            }
            ArrayList<DataRow> list = new ArrayList<DataRow>();
            int begin = pageIndex * pageSize;
            int end = (pageIndex + 1) * pageSize;
            for (int index = 0; rs.next() && index < end; ++index) {
                if (index < begin) continue;
                Object[] t = new Object[columnCount];
                for (int j = 1; j <= columnCount; ++j) {
                    t[j - 1] = this.columns[j - 1].getColumnType() == 10 ? LobUtil.clobToString((Clob)rs.getClob(j)) : (this.columns[j - 1].getColumnType() == 2 ? (Object)LobUtil.blobToBytes((Blob)rs.getBlob(j)) : rs.getObject(j));
                }
                DataRow tmpRow = new DataRow(this.columns, t);
                list.add(tmpRow);
            }
            this.rows = new DataRow[list.size()];
            list.toArray(this.rows);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteColumn(int columnIndex) {
        if (this.columns.length == 0) {
            return;
        }
        if (columnIndex < 0 || this.columns != null && columnIndex >= this.columns.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + columnIndex);
        }
        this.columns = (DataColumn[])ArrayUtils.remove((Object[])this.columns, (int)columnIndex);
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].columns = null;
            this.rows[i].columns = this.columns;
            this.rows[i].values = ArrayUtils.remove((Object[])this.rows[i].values, (int)columnIndex);
        }
    }

    public void deleteColumn(String columnName) {
        if (this.columns.length == 0) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            this.deleteColumn(i);
            break;
        }
    }

    public void insertColumn(String columnName) {
        this.insertColumn(new DataColumn(columnName, 1), null, this.columns.length);
    }

    public void insertColumn(String columnName, Object columnValue) {
        Object[] cv = new Object[this.rows.length];
        for (int i = 0; i < cv.length; ++i) {
            cv[i] = columnValue;
        }
        this.insertColumn(new DataColumn(columnName, 1), cv, this.columns.length);
    }

    public void insertColumns(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.insertColumn(new DataColumn(columnNames[i], 1), null, this.columns.length);
        }
    }

    public void insertColumn(String columnName, Object[] columnValue) {
        this.insertColumn(new DataColumn(columnName, 1), columnValue, this.columns.length);
    }

    public void insertColumn(DataColumn dc) {
        this.insertColumn(dc, null, this.columns.length);
    }

    public void insertColumn(DataColumn dc, Object[] columnValue) {
        this.insertColumn(dc, columnValue, this.columns.length);
    }

    public void insertColumn(String columnName, Object[] columnValue, int index) {
        this.insertColumn(new DataColumn(columnName, 1), columnValue, index);
    }

    public void insertColumn(DataColumn dc, Object[] columnValue, int index) {
        int i;
        if (index > this.columns.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + index);
        }
        for (i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(dc.getColumnName())) continue;
            throw new RuntimeException("DataTable\u4e2d\u5df2\u7ecf\u5b58\u5728\u5217\uff1a" + dc.getColumnName());
        }
        this.columns = (DataColumn[])ArrayUtils.add((Object[])this.columns, (int)index, (Object)dc);
        if (columnValue == null) {
            columnValue = new Object[this.rows.length];
        }
        if (this.rows.length == 0) {
            this.rows = new DataRow[columnValue.length];
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new DataRow(this.columns, new Object[]{columnValue[i]});
            }
        } else {
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i].columns = null;
                this.rows[i].columns = this.columns;
                this.rows[i].values = ArrayUtils.add((Object[])this.rows[i].values, (int)index, (Object)columnValue[i]);
            }
        }
    }

    public void insertRow(DataRow dr) {
        this.insertRow(dr, 0);
    }

    public void insertRow(DataRow dr, int index) {
        if (this.columns.length == 0) {
            this.columns = dr.columns;
        }
        this.insertRow(dr.getDataValues(), index);
    }

    public void insertRow(Object[] rowValue) {
        this.insertRow(rowValue, this.rows.length);
    }

    public void insertRow(Object[] rowValue, int index) {
        if (index > this.rows.length) {
            throw new RuntimeException(index + "\u8d85\u51fa\u8303\u56f4\uff0c\u6700\u5927\u5141\u8bb8\u503c\u4e3a" + this.rows.length + "!");
        }
        if (rowValue != null) {
            int i;
            if (this.columns.length == 0) {
                this.columns = new DataColumn[rowValue.length];
                for (i = 0; i < this.columns.length; ++i) {
                    this.columns[i] = new DataColumn("_Columns_" + i, 1);
                }
            }
            for (i = 0; i < this.columns.length; ++i) {
                if (this.columns[i].ColumnType != 0 || rowValue[i] == null || Date.class.isInstance(rowValue[i])) continue;
                throw new RuntimeException("\u7b2c" + i + "\u5217\u5fc5\u987b\u662fDate\u5bf9\u8c61!");
            }
        } else {
            rowValue = new Object[this.columns.length];
        }
        DataRow[] newRows = new DataRow[this.rows.length + 1];
        System.arraycopy(this.rows, 0, newRows, 0, index);
        if (index < this.rows.length) {
            System.arraycopy(this.rows, index, newRows, index + 1, this.rows.length - index);
        }
        newRows[index] = new DataRow(this.columns, rowValue);
        this.rows = newRows;
    }

    public void deleteRow(int index) {
        if (index >= this.rows.length) {
            throw new RuntimeException(index + "\u8d85\u51fa\u8303\u56f4\uff0c\u6700\u5927\u5141\u8bb8\u503c\u4e3a" + (this.rows.length - 1) + "!");
        }
        this.rows = (DataRow[])ArrayUtils.remove((Object[])this.rows, (int)index);
    }

    public void deleteRow(DataRow dr) {
        for (int i = 0; i < this.rows.length; ++i) {
            if (dr != this.rows[i]) continue;
            this.deleteRow(i);
            return;
        }
        throw new RuntimeException("\u6307\u5b9a\u7684DataRow\u5bf9\u8c61\u4e0d\u5c5e\u4e8e\u6b64DataTable!");
    }

    public DataRow get(int rowIndex) {
        if (rowIndex >= this.rows.length || rowIndex < 0) {
            throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u7d22\u5f15\u503c\u8d85\u51fa\u8303\u56f4");
        }
        return this.rows[rowIndex];
    }

    public void set(int rowIndex, int colIndex, Object value) {
        this.getDataRow(rowIndex).set(colIndex, value);
    }

    public void set(int rowIndex, String columnName, Object value) {
        this.getDataRow(rowIndex).set(columnName, value);
    }

    public void set(int rowIndex, int colIndex, int value) {
        this.getDataRow(rowIndex).set(colIndex, value);
    }

    public void set(int rowIndex, String columnName, int value) {
        this.getDataRow(rowIndex).set(columnName, value);
    }

    public void set(int rowIndex, int colIndex, long value) {
        this.getDataRow(rowIndex).set(colIndex, value);
    }

    public void set(int rowIndex, String columnName, long value) {
        this.getDataRow(rowIndex).set(columnName, value);
    }

    public void set(int rowIndex, int colIndex, double value) {
        this.getDataRow(rowIndex).set(colIndex, value);
    }

    public void set(int rowIndex, String columnName, double value) {
        this.getDataRow(rowIndex).set(columnName, value);
    }

    public Object get(int rowIndex, int colIndex) {
        return this.getDataRow(rowIndex).get(colIndex);
    }

    public Object get(int rowIndex, String columnName) {
        return this.getDataRow(rowIndex).get(columnName);
    }

    public String getString(int rowIndex, int colIndex) {
        return this.getDataRow(rowIndex).getString(colIndex);
    }

    public String getString(int rowIndex, String columnName) {
        return this.getDataRow(rowIndex).getString(columnName);
    }

    public int getInt(int rowIndex, int colIndex) {
        return this.getDataRow(rowIndex).getInt(colIndex);
    }

    public int getInt(int rowIndex, String columnName) {
        return this.getDataRow(rowIndex).getInt(columnName);
    }

    public long getLong(int rowIndex, int colIndex) {
        return this.getDataRow(rowIndex).getLong(colIndex);
    }

    public long getLong(int rowIndex, String columnName) {
        return this.getDataRow(rowIndex).getLong(columnName);
    }

    public double getDouble(int rowIndex, int colIndex) {
        return this.getDataRow(rowIndex).getDouble(colIndex);
    }

    public double getDouble(int rowIndex, String columnName) {
        return this.getDataRow(rowIndex).getDouble(columnName);
    }

    public Date getDate(int rowIndex, int colIndex) {
        return this.getDataRow(rowIndex).getDate(colIndex);
    }

    public Date getDate(int rowIndex, String columnName) {
        return this.getDataRow(rowIndex).getDate(columnName);
    }

    public DataRow getDataRow(int rowIndex) {
        if (rowIndex == this.rows.length) {
            rowIndex = this.rows.length - 1;
        }
        if (rowIndex >= this.rows.length || rowIndex < 0) {
            throw new RuntimeException("\u6307\u5b9a\u7684\u884c\u7d22\u5f15\u503c\u8d85\u51fa\u8303\u56f4");
        }
        return this.rows[rowIndex];
    }

    public DataColumn getDataColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.length) {
            throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u7d22\u5f15\u503c\u8d85\u51fa\u8303\u56f4");
        }
        return this.columns[columnIndex];
    }

    public DataColumn getDataColumn(String columnName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getDataColumn(i);
        }
        return null;
    }

    public Object[] getColumnValues(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.length) {
            throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u7d22\u5f15\u503c\u8d85\u51fa\u8303\u56f4");
        }
        Object[] arr = new Object[this.getRowCount()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.rows[i].values[columnIndex];
        }
        return arr;
    }

    public Object[] getColumnValues(String columnName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(columnName)) continue;
            return this.getColumnValues(i);
        }
        return null;
    }

    public void sort(Comparator c) {
        Arrays.sort(this.rows, c);
    }

    public void sort(String columnName) {
        this.sort(columnName, "desc", false);
    }

    public void sort(String columnName, String order) {
        this.sort(columnName, order, false);
    }

    public void sort(String columnName, String order, boolean isNumber) {
        String cn = columnName;
        String od = order;
        this.sort((Comparator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public DataTable filter(Filter filter) {
        ArrayList<DataRow> valueList = new ArrayList<DataRow>();
        for (int i = 0; i < this.rows.length; ++i) {
            if (!filter.filter((Object)this.rows[i])) continue;
            valueList.add(this.rows[i]);
        }
        DataTable dt = new DataTable();
        dt.columns = this.columns;
        dt.rows = new DataRow[valueList.size()];
        valueList.toArray(dt.rows);
        dt.setWebMode(this.isWebMode);
        return dt;
    }

    public Object clone() {
        DataColumn[] dcs = new DataColumn[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            dcs[i] = (DataColumn)this.columns[i].clone();
        }
        DataTable dt = new DataTable();
        dt.columns = dcs;
        dt.rows = (DataRow[])this.rows.clone();
        dt.setWebMode(this.isWebMode);
        return dt;
    }

    public Mapx toMapx(String keyColumnName, String valueColumnName) {
        if (StringUtil.isEmpty((String)keyColumnName)) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        if (StringUtil.isEmpty((String)valueColumnName)) {
            throw new RuntimeException("\u4e0d\u80fd\u5b58\u53d6\u5217\u540d\u4e3a\u7a7a\u7684\u5217");
        }
        int keyIndex = 0;
        int valueIndex = 0;
        boolean keyFlag = false;
        boolean valueFlag = false;
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].getColumnName().equalsIgnoreCase(keyColumnName)) {
                keyIndex = i;
                keyFlag = true;
                if (valueFlag) break;
            }
            if (!this.columns[i].getColumnName().equalsIgnoreCase(valueColumnName)) continue;
            valueIndex = i;
            valueFlag = true;
            if (keyFlag) break;
        }
        return this.toMapx(keyIndex, valueIndex);
    }

    public Mapx toMapx(int keyColumnIndex, int valueColumnIndex) {
        if (keyColumnIndex < 0 || keyColumnIndex >= this.columns.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + keyColumnIndex);
        }
        if (valueColumnIndex < 0 || valueColumnIndex >= this.columns.length) {
            throw new RuntimeException("DataRow\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u5217\uff1a" + valueColumnIndex);
        }
        Mapx map = new Mapx();
        for (int i = 0; i < this.rows.length; ++i) {
            Object key = this.rows[i].values[keyColumnIndex];
            if (key == null) {
                map.put(key, this.rows[i].values[valueColumnIndex]);
                continue;
            }
            map.put((Object)key.toString(), this.rows[i].values[valueColumnIndex]);
        }
        return map;
    }

    public void decodeColumn(String colName, Map map) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(colName)) continue;
            this.decodeColumn(i, map);
            return;
        }
    }

    public void decodeColumn(int colIndex, Map map) {
        String newName = this.columns[colIndex].ColumnName + "Name";
        this.insertColumn(newName);
        for (int i = 0; i < this.getRowCount(); ++i) {
            String v = this.getString(i, colIndex);
            this.set(i, newName, map.get(v));
        }
    }

    public void decodeDateColumn(String colName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].getColumnName().equalsIgnoreCase(colName)) continue;
            this.decodeDateColumn(i);
            return;
        }
    }

    public void decodeDateColumn(int colIndex) {
        String newName = this.columns[colIndex].ColumnName + "Name";
        this.insertColumn(newName);
        for (int i = 0; i < this.getRowCount(); ++i) {
            String v = this.getString(i, colIndex);
            this.set(i, newName, (Object)DateUtil.toDisplayDateTime((String)v));
        }
    }

    public void union(DataTable anotherDT) {
        if (anotherDT.getRowCount() == 0) {
            return;
        }
        if (this.getRowCount() == 0) {
            this.rows = anotherDT.rows;
            return;
        }
        if (this.getColCount() != anotherDT.getColCount()) {
            throw new RuntimeException("\u4e24\u4e2aDataTable\u7684\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u5217\u65701\uff1a" + this.getColCount() + " ,\u5217\u65702\uff1a" + anotherDT.getColCount());
        }
        int srcPos = this.rows.length;
        DataRow[] newRows = new DataRow[this.rows.length + anotherDT.getRowCount()];
        System.arraycopy(this.rows, 0, newRows, 0, srcPos);
        System.arraycopy(anotherDT.rows, 0, newRows, srcPos, anotherDT.getRowCount());
        this.rows = null;
        this.rows = newRows;
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public int getColCount() {
        return this.columns.length;
    }

    public DataColumn[] getDataColumns() {
        return this.columns;
    }

    public boolean isWebMode() {
        return this.isWebMode;
    }

    public void setWebMode(boolean isWebMode) {
        this.isWebMode = isWebMode;
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].setWebMode(isWebMode);
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.columns.length; ++i) {
            if (i != 0) {
                sb.append("\t");
            }
            sb.append(this.columns[i].getColumnName());
        }
        sb.append("\n");
        for (i = 0; i < this.rows.length; ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            for (int j = 0; j < this.columns.length; ++j) {
                if (j != 0) {
                    sb.append("\t");
                }
                sb.append(this.get(i, j));
            }
        }
        return sb.toString();
    }
}

