/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.Constant;
import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataTableUtil {
    public static DataTable txtToDataTable(String fileName) {
        return DataTableUtil.txtToDataTable((String)fileName, (String[])null, (String)",");
    }

    public static DataTable txtToDataTable(String fileName, String filedspliter) {
        return DataTableUtil.txtToDataTable((String)fileName, (String[])null, (String)Constant.GlobalCharset, (String)filedspliter, (String)"\\n");
    }

    public static DataTable txtToDataTable(String fileName, String filedspliter, String rowspliter) {
        return DataTableUtil.txtToDataTable((String)fileName, (String[])null, (String)Constant.GlobalCharset, (String)filedspliter, (String)rowspliter);
    }

    public static DataTable txtToDataTable(String fileName, String encoding, String filedspliter, String rowspliter) {
        return DataTableUtil.txtToDataTable((String)fileName, (String[])null, (String)encoding, (String)filedspliter, (String)rowspliter);
    }

    public static DataTable txtToDataTable(String fileName, String[] columnNames) {
        return DataTableUtil.txtToDataTable((String)fileName, (String[])columnNames, (String)",");
    }

    public static DataTable txtToDataTable(String fileName, String[] columnNames, String filedspliter) {
        return DataTableUtil.txtToDataTable((String)fileName, (String[])columnNames, (String)Constant.GlobalCharset, (String)filedspliter, (String)"\\n");
    }

    public static DataTable txtToDataTable(String fileName, String[] columnNames, String encoding, String filedspliter, String rowspliter) {
        int i;
        String file = FileUtil.readText((String)fileName, (String)encoding);
        if (file == null || file.trim().equals("")) {
            return null;
        }
        String[] rows = file.split(rowspliter);
        int startIndex = 0;
        if (columnNames == null) {
            columnNames = rows[0].split(filedspliter);
            Mapx map = new Mapx();
            for (i = 0; i < columnNames.length; ++i) {
                String name;
                String tmp = name = columnNames[i];
                int k = 2;
                while (map.containsKey((Object)tmp)) {
                    tmp = name + k++;
                }
                map.put((Object)tmp, (Object)tmp);
                columnNames[i] = tmp;
            }
            startIndex = 1;
        }
        if (columnNames == null || columnNames.length == 0) {
            return null;
        }
        DataColumn[] dcs = new DataColumn[columnNames.length];
        for (i = 0; i < columnNames.length; ++i) {
            DataColumn dc = new DataColumn();
            dc.setColumnName(columnNames[i]);
            dc.setColumnType(1);
            dcs[i] = dc;
        }
        Object[][] values = new Object[rows.length - startIndex][columnNames.length];
        for (int i2 = startIndex; i2 < rows.length; ++i2) {
            String[] cols;
            if (rows[i2] == null || (cols = rows[i2].trim().split(filedspliter)) == null) continue;
            for (int j = 0; j < cols.length && j < columnNames.length; ++j) {
                values[i2 - startIndex][j] = cols[j];
            }
        }
        return new DataTable(dcs, values);
    }

    public static void dataTableToTxt(DataTable dt, String fileName) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (String)fileName, (String[])null, (String)",");
    }

    public static void dataTableToTxt(DataTable dt, String fileName, String filedspliter) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (String)fileName, (String[])null, (String)filedspliter, (String)"\n");
    }

    public static void dataTableToTxt(DataTable dt, String fileName, String filedspliter, String rowspliter) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (String)fileName, (String[])null, (String)filedspliter, (String)rowspliter);
    }

    public static void dataTableToTxt(DataTable dt, String fileName, String[] columnNames) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (String)fileName, (String[])columnNames, (String)",");
    }

    public static void dataTableToTxt(DataTable dt, String fileName, String[] columnNames, String filedspliter) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (String)fileName, (String[])columnNames, (String)filedspliter, (String)"\n");
    }

    public static void dataTableToTxt(DataTable dt, String fileName, String[] columnNames, String filedspliter, String rowspliter) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            DataTableUtil.dataTableToTxt((DataTable)dt, (OutputStream)fos, (String[])columnNames, (String)filedspliter, (String)rowspliter);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dataTableToTxt(DataTable dt, OutputStream os) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (OutputStream)os, (String[])null, (String)",");
    }

    public static void dataTableToTxt(DataTable dt, OutputStream os, String filedspliter) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (OutputStream)os, (String[])null, (String)filedspliter, (String)"\n");
    }

    public static void dataTableToTxt(DataTable dt, OutputStream os, String filedspliter, String rowspliter) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (OutputStream)os, (String[])null, (String)filedspliter, (String)rowspliter);
    }

    public static void dataTableToTxt(DataTable dt, OutputStream os, String[] columnNames) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (OutputStream)os, (String[])columnNames, (String)",");
    }

    public static void dataTableToTxt(DataTable dt, OutputStream os, String[] columnNames, String filedspliter) {
        DataTableUtil.dataTableToTxt((DataTable)dt, (OutputStream)os, (String[])columnNames, (String)filedspliter, (String)"\r\n");
    }

    public static void dataTableToTxt(DataTable dt, OutputStream os, String[] columnNames, String filedspliter, String rowspliter) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (columnNames == null) {
            columnNames = new String[dt.getColCount()];
            for (i = 0; i < columnNames.length; ++i) {
                columnNames[i] = dt.getDataColumn(i).getColumnName();
            }
        }
        for (i = 0; i < columnNames.length; ++i) {
            if (i != 0) {
                sb.append(filedspliter);
            }
            sb.append(columnNames[i]);
        }
        sb.append(rowspliter);
        for (i = 0; i < dt.getRowCount(); ++i) {
            for (int j = 0; j < dt.getColCount(); ++j) {
                if (j != 0) {
                    sb.append(filedspliter);
                }
                sb.append(dt.getString(i, j));
            }
            sb.append(rowspliter);
        }
        try {
            IOUtils.write((String)sb.toString(), (OutputStream)os, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dataTableToExcel(DataTable dt, String fileName) {
        DataTableUtil.dataTableToExcel((DataTable)dt, (String)fileName, null, null);
    }

    public static void dataTableToExcel(DataTable dt, String fileName, String[] columnNames, String[] widths) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            DataTableUtil.dataTableToExcel((DataTable)dt, (OutputStream)fos, (String[])columnNames, (String[])widths);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dataTableToExcel(DataTable dt, OutputStream os) {
        DataTableUtil.dataTableToExcel((DataTable)dt, (OutputStream)os, null, null);
    }

    public static void dataTableToExcel(DataTable dt, OutputStream os, String[] columnNames, String[] widths) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("First");
        try {
            int i;
            HSSFFont fontBold = wb.createFont();
            fontBold.setFontHeightInPoints((short)10);
            fontBold.setFontName("\u5b8b\u4f53");
            fontBold.setBoldweight((short)700);
            HSSFFont fontNormal = wb.createFont();
            fontNormal.setFontHeightInPoints((short)10);
            fontNormal.setFontName("\u5b8b\u4f53");
            fontNormal.setBoldweight((short)400);
            HSSFCellStyle styleBorderBold = wb.createCellStyle();
            styleBorderBold.setBorderBottom((short)1);
            styleBorderBold.setBorderLeft((short)1);
            styleBorderBold.setBorderRight((short)1);
            styleBorderBold.setBorderTop((short)1);
            styleBorderBold.setVerticalAlignment((short)1);
            styleBorderBold.setAlignment((short)2);
            styleBorderBold.setWrapText(true);
            styleBorderBold.setFont(fontBold);
            HSSFCellStyle styleBorderNormal = wb.createCellStyle();
            styleBorderNormal.setBorderBottom((short)1);
            styleBorderNormal.setBorderLeft((short)1);
            styleBorderNormal.setBorderRight((short)1);
            styleBorderNormal.setBorderTop((short)1);
            styleBorderBold.setVerticalAlignment((short)1);
            styleBorderNormal.setFont(fontNormal);
            HSSFCellStyle styleBold = wb.createCellStyle();
            styleBold.setFont(fontBold);
            HSSFCellStyle styleNormal = wb.createCellStyle();
            styleNormal.setFont(fontNormal);
            HSSFRow row = sheet.getRow(0);
            if (row == null) {
                row = sheet.createRow(0);
            }
            for (i = 0; i < dt.getColCount(); ++i) {
                HSSFCell cell = row.getCell((short)i);
                if (cell == null) {
                    cell = row.createCell((short)i);
                }
                cell.setCellType(1);
                cell.setCellStyle(styleBorderBold);
                cell.setEncoding((short)1);
                if (columnNames != null && columnNames.length > i) {
                    cell.setCellValue(columnNames[i]);
                } else {
                    cell.setCellValue(dt.getDataColumn(i).getColumnName());
                }
                row.setHeightInPoints(30.0f);
                if (widths == null || widths.length <= i) continue;
                sheet.setColumnWidth((short)i, (short)((double)Short.parseShort(widths[i]) * 37.5));
            }
            for (i = 0; i < dt.getRowCount(); ++i) {
                row = sheet.getRow(i + 1);
                if (row == null) {
                    row = sheet.createRow(i + 1);
                }
                row.setHeight((short)356);
                for (int j = 0; j < dt.getColCount(); ++j) {
                    HSSFCell cell = row.getCell((short)j);
                    if (cell == null) {
                        cell = row.createCell((short)j);
                    }
                    cell.setCellType(1);
                    cell.setCellStyle(styleBorderNormal);
                    cell.setEncoding((short)1);
                    if (dt.get(i, j) == null) {
                        cell.setCellValue("");
                        continue;
                    }
                    if (dt.getDataColumn(j).getColumnType() == 0) {
                        cell.setCellValue(DateUtil.toString((Date)((Date)dt.get(i, j)), (String)"yyyy-MM-dd"));
                        continue;
                    }
                    cell.setCellValue(dt.getString(i, j));
                }
            }
            wb.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dataTableToExcel(DataTable dt, OutputStream os, String[] columnNames, String[] widths, String[] columnIndexes) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("First");
        try {
            int i;
            HSSFFont fontBold = wb.createFont();
            fontBold.setFontHeightInPoints((short)10);
            fontBold.setFontName("\u5b8b\u4f53");
            fontBold.setBoldweight((short)700);
            HSSFFont fontNormal = wb.createFont();
            fontNormal.setFontHeightInPoints((short)10);
            fontNormal.setFontName("\u5b8b\u4f53");
            fontNormal.setBoldweight((short)400);
            HSSFCellStyle styleBorderBold = wb.createCellStyle();
            styleBorderBold.setBorderBottom((short)1);
            styleBorderBold.setBorderLeft((short)1);
            styleBorderBold.setBorderRight((short)1);
            styleBorderBold.setBorderTop((short)1);
            styleBorderBold.setVerticalAlignment((short)1);
            styleBorderBold.setAlignment((short)2);
            styleBorderBold.setWrapText(true);
            styleBorderBold.setFont(fontBold);
            HSSFCellStyle styleBorderNormal = wb.createCellStyle();
            styleBorderNormal.setBorderBottom((short)1);
            styleBorderNormal.setBorderLeft((short)1);
            styleBorderNormal.setBorderRight((short)1);
            styleBorderNormal.setBorderTop((short)1);
            styleBorderBold.setVerticalAlignment((short)1);
            styleBorderNormal.setFont(fontNormal);
            HSSFCellStyle styleBold = wb.createCellStyle();
            styleBold.setFont(fontBold);
            HSSFCellStyle styleNormal = wb.createCellStyle();
            styleNormal.setFont(fontNormal);
            HSSFRow row = sheet.getRow(0);
            if (row == null) {
                row = sheet.createRow(0);
            }
            for (i = 0; i < columnNames.length; ++i) {
                HSSFCell cell = row.getCell((short)i);
                if (cell == null) {
                    cell = row.createCell((short)i);
                }
                cell.setCellType(1);
                cell.setCellStyle(styleBorderBold);
                cell.setEncoding((short)1);
                cell.setCellValue(columnNames[i]);
                row.setHeightInPoints(30.0f);
                if (widths == null || widths.length <= i) continue;
                sheet.setColumnWidth((short)i, (short)((double)Integer.parseInt(widths[i]) * 37.5));
            }
            for (i = 0; i < columnIndexes.length; ++i) {
                int j = Integer.parseInt(columnIndexes[i]);
                for (int k = 0; k < dt.getRowCount(); ++k) {
                    HSSFCell cell;
                    row = sheet.getRow(k + 1);
                    if (row == null) {
                        row = sheet.createRow(k + 1);
                    }
                    if ((cell = row.getCell((short)i)) == null) {
                        cell = row.createCell((short)i);
                    }
                    cell.setCellType(1);
                    cell.setCellStyle(styleBorderNormal);
                    cell.setEncoding((short)1);
                    if (dt.get(k, j) == null) {
                        cell.setCellValue("");
                        continue;
                    }
                    if (dt.getDataColumn(j).getColumnType() == 0) {
                        cell.setCellValue(DateUtil.toString((Date)((Date)dt.get(k, j)), (String)"MM/dd/yyyy"));
                        continue;
                    }
                    cell.setCellValue(dt.getString(k, j));
                }
            }
            wb.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataTable xlsToDataTable(String fileName) throws Exception {
        return DataTableUtil.xlsToDataTable((String)fileName, (int)0);
    }

    public static DataTable xlsToDataTable(String fileName, String sheetName) throws Exception {
        HSSFWorkbook book = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        int index = book.getSheetIndex(sheetName);
        if (index < 0) {
            throw new RuntimeException("\u672a\u627e\u5230SheetName:" + sheetName);
        }
        return DataTableUtil.xlsToDataTable((HSSFWorkbook)book, (int)index);
    }

    public static DataTable xlsToDataTable(String fileName, int sheetNo) throws Exception {
        HSSFWorkbook book = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        return DataTableUtil.xlsToDataTable((HSSFWorkbook)book, (int)sheetNo);
    }

    public static DataTable xlsToDataTable(HSSFWorkbook book, int sheetNo) throws Exception {
        int i;
        HSSFSheet sheet = book.getSheetAt(sheetNo);
        int maxRow = sheet.getPhysicalNumberOfRows();
        int maxCol = sheet.getRow(0).getPhysicalNumberOfCells();
        DataColumn[] dcs = new DataColumn[maxCol];
        int StartRowIndex = 1;
        Object[][] values = new Object[maxRow - StartRowIndex][maxCol];
        Mapx map = new Mapx();
        for (i = 0; i < maxCol; ++i) {
            String name;
            DataColumn dc = new DataColumn();
            HSSFCell cell = sheet.getRow(0).getCell((short)i);
            String tmp = name = DataTableUtil.getCellValue((HSSFCell)cell);
            int k = 2;
            while (map.containsKey((Object)tmp)) {
                tmp = name + k++;
            }
            map.put((Object)tmp, (Object)tmp);
            dc.setColumnName(tmp);
            dc.setColumnType(1);
            dcs[i] = dc;
        }
        for (i = StartRowIndex; i < maxRow; ++i) {
            HSSFCell cell = sheet.getRow(i).getCell((short)0);
            for (int j = 0; j < maxCol; ++j) {
                cell = sheet.getRow(i).getCell((short)j);
                values[i - StartRowIndex][j] = DataTableUtil.getCellValue((HSSFCell)cell);
            }
            LogUtil.info((Object)("\u6b63\u5728\u8bfb\u53d6Excle\u6587\u4ef6\u7684\u7b2c" + i + "\u884c..."));
        }
        DataTable dt = new DataTable(dcs, values);
        return dt;
    }

    private static String getCellValue(HSSFCell cell) {
        String value = null;
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 0) {
            if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                value = DateUtil.toString((Date)cell.getDateCellValue());
            } else {
                value = NumberFormat.getNumberInstance().format(cell.getNumericCellValue());
                value = StringUtil.replaceEx((String)value, (String)",", (String)"");
            }
        } else {
            value = cell.getCellType() == 2 ? String.valueOf(cell.getNumericCellValue()) : cell.getStringCellValue();
        }
        value = DataTableUtil.trimEx((String)value);
        return value;
    }

    private static String trimEx(String str) {
        String r = str.trim();
        while (r.startsWith("\u3000")) {
            r = r.substring(1);
        }
        while (r.endsWith("\u3000")) {
            r = r.substring(0, r.length() - 1);
        }
        return r.trim();
    }

    public static DataTable extendBackupData(DataTable dt, String sql, String key) {
        for (int i = 0; i < dt.getRowCount(); ++i) {
            DataRow dr = dt.getDataRow(i);
            String keyValue = dr.getString(key);
            DataTable backdt = new QueryBuilder(sql, (Object)keyValue).executePagedDataTable(1, 0);
            if (i == 0) {
                for (int j = 0; j < backdt.getColCount(); ++j) {
                    backdt.getDataColumn(j).setColumnName("Backup" + backdt.getDataColumn(j).getColumnName());
                    dt.insertColumn(backdt.getDataColumn(j).getColumnName());
                }
            }
            if (backdt.getRowCount() != 1) continue;
            System.arraycopy(backdt.getDataRow(0).getDataValues(), 0, dt.getDataRow(i).getDataValues(), dt.getColCount() - backdt.getColCount(), backdt.getColCount());
        }
        return null;
    }

    public static DataTable getResultDataTable(DataTable dt3, int pageIndex, int pageSize) {
        int temp;
        DataTable dt = new DataTable();
        for (int i = 0; i < dt.getColCount(); ++i) {
            dt.insertColumn(dt3.getDataColumn(i));
        }
        int j = 0;
        int n = temp = (pageIndex + 1) * pageSize > dt3.getRowCount() ? dt3.getRowCount() - pageIndex * pageSize : dt3.getRowCount() - (pageIndex + 1) * pageSize;
        if (temp < pageSize && (pageIndex + 1) * pageSize > dt3.getRowCount()) {
            for (int i = 0; i < temp; ++i) {
                if (j >= pageSize) continue;
                dt.insertRow(dt3.getDataRow(i));
                ++j;
            }
        } else if (pageSize == 0 && pageIndex == 0) {
            for (int i = 0; i < dt3.getRowCount(); ++i) {
                dt.insertRow(dt3.getDataRow(i));
            }
        } else {
            for (int i = temp; i < dt3.getRowCount() - pageIndex * pageSize; ++i) {
                if (j >= pageSize) continue;
                dt.insertRow(dt3.getDataRow(i));
                ++j;
            }
        }
        return dt;
    }
}

