/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.data.DBConn;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class LobUtil {
    public static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        try {
            Reader r = clob.getCharacterStream();
            StringWriter sw = new StringWriter();
            char[] cs = new char[(int)clob.length()];
            try {
                r.read(cs);
                sw.write(cs);
                return sw.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] blobToBytes(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setClob(DBConn conn, PreparedStatement ps, int i, Object v) throws SQLException {
        if (conn.getDBConfig().DBType.equals("ORACLE")) {
            Class<?> clobClass = null;
            try {
                clobClass = Class.forName("oracle.sql.CLOB");
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                return;
            }
            Object clob = null;
            Connection oc = conn.getPhysicalConnection();
            try {
                Method m = clobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
                clob = m.invoke(null, oc, new Boolean(true), new Integer(1));
                m = clobClass.getMethod("open", Integer.TYPE);
                m.invoke(clob, new Integer(1));
                m = clobClass.getMethod("setCharacterStream", Long.TYPE);
                Writer writer = (Writer)m.invoke(clob, new Long(0L));
                writer.write(String.valueOf(v));
                writer.close();
                clobClass.getMethod("close", null).invoke(clob, null);
                ps.setClob(i, (Clob)clob);
            }
            catch (Exception e) {
                try {
                    if (clob != null) {
                        Method m = clobClass.getMethod("freeTemporary", clobClass);
                        m.invoke(null, clob);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        } else {
            ps.setObject(i, v);
        }
    }

    public static void setBlob(DBConn conn, PreparedStatement ps, int i, byte[] v) throws SQLException {
        if (conn.getDBConfig().DBType.equals("ORACLE")) {
            Class<?> blobClass = null;
            try {
                blobClass = Class.forName("oracle.sql.BLOB");
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                return;
            }
            Object blob = null;
            Connection oc = conn.getPhysicalConnection();
            try {
                Method m = blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
                blob = m.invoke(null, oc, new Boolean(true), new Integer(1));
                m = blobClass.getMethod("open", Integer.TYPE);
                m.invoke(blob, new Integer(1));
                m = blobClass.getMethod("getBinaryOutputStream", Long.TYPE);
                OutputStream out = (OutputStream)m.invoke(blob, new Long(0L));
                out.write(v);
                out.close();
                blobClass.getMethod("close", null).invoke(blob, null);
                ps.setBlob(i, (Blob)blob);
            }
            catch (Exception e) {
                try {
                    if (blob != null) {
                        Method m = blobClass.getMethod("freeTemporary", blobClass);
                        m.invoke(null, blob);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        } else {
            ps.setObject(i, v);
        }
    }
}

