/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.DataTable;
import java.util.ArrayList;
import java.util.List;

public class QueryBuilder {
    private ArrayList list = new ArrayList();
    private ArrayList batches;
    private String sql = null;
    private boolean batchMode;

    protected ArrayList getBatches() {
        return this.batches;
    }

    public QueryBuilder() {
    }

    public QueryBuilder(String sql) {
        this.setSQL(sql);
    }

    public QueryBuilder(String sql, int param) {
        this.setSQL(sql);
        this.add(param);
    }

    public QueryBuilder(String sql, long param) {
        this.setSQL(sql);
        this.add(param);
    }

    public QueryBuilder(String sql, Object param) {
        this.setSQL(sql);
        this.add(param);
    }

    public QueryBuilder(String sql, int param1, Object param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, long param1, Object param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, Object param1, int param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, Object param1, long param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, int param1, int param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, long param1, long param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, Object param1, Object param2) {
        this.setSQL(sql);
        this.add(param1);
        this.add(param2);
    }

    public QueryBuilder(String sql, List list) {
        this.setSQL(sql);
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        if (batchMode && this.batches == null) {
            this.batches = new ArrayList();
        }
        this.batchMode = batchMode;
    }

    public void addBatch() {
        if (!this.batchMode) {
            throw new RuntimeException("\u975e\u6279\u5904\u7406\u6a21\u5f0f\u4e0b\u4e0d\u80fd\u4f7f\u7528addBatch()");
        }
        this.batches.add(this.list);
        this.list = new ArrayList();
    }

    public void add(int param) {
        this.list.add(new Integer(param));
    }

    public void add(long param) {
        this.list.add(new Long(param));
    }

    public void add(Object param) {
        this.list.add(param);
    }

    public void set(int index, int param) {
        this.list.set(index, new Integer(param));
    }

    public void set(int index, long param) {
        this.list.set(index, new Long(param));
    }

    public void set(int index, Object param) {
        this.list.set(index, param);
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public void appendSQLPart(String sqlTail) {
        this.sql = this.sql + sqlTail;
    }

    public DataTable executeDataTable() {
        DataAccess dataAccess = new DataAccess();
        DataTable dt = null;
        try {
            dt = dataAccess.executeDataTable(this);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return dt;
    }

    public DataTable executePagedDataTable(int pageSize, int pageIndex) {
        DataAccess dataAccess = new DataAccess();
        DataTable dt = null;
        try {
            dt = dataAccess.executePagedDataTable(this, pageSize, pageIndex);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return dt;
    }

    public Object executeOneValue() {
        DataAccess dataAccess = new DataAccess();
        Object t = null;
        try {
            t = dataAccess.executeOneValue(this);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public String executeString() {
        Object o = this.executeOneValue();
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public int executeInt() {
        Object o = this.executeOneValue();
        if (o == null) {
            return 0;
        }
        return Integer.parseInt(o.toString());
    }

    public long executeLong() {
        Object o = this.executeOneValue();
        if (o == null) {
            return 0L;
        }
        return Long.parseLong(o.toString());
    }

    public int executeNoQuery() {
        DataAccess dataAccess = new DataAccess();
        int t = -1;
        try {
            t = dataAccess.executeNoQuery(this);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public String getSQL() {
        return this.sql;
    }

    public ArrayList getParams() {
        return this.list;
    }

    public void setParams(ArrayList list) {
        this.list = list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sql);
        sb.append("\t{");
        for (int i = 0; i < this.list.size(); ++i) {
            Object o;
            if (i != 0) {
                sb.append(",");
            }
            if ((o = this.list.get(i)) == null) {
                sb.append("null");
                continue;
            }
            String str = this.list.get(i).toString();
            if (str.length() > 40) {
                str = str.substring(0, 37);
                sb.append(str);
                sb.append("...");
                continue;
            }
            sb.append(str);
        }
        sb.append("}");
        return sb.toString();
    }
}

