/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.utility.StringUtil;
import java.util.ArrayList;

public class SelectSQLParser {
    private String SQL = null;
    private String lowerSQL = null;
    private String ColumnPart;
    private String FromPart;
    private String WherePart;
    private String OrderbyPart;
    private String GroupByPart;
    private String HavingPart;
    private String FormatSQL;
    private String[] Columns;
    private String[] Tables;
    private String[] Conditions;
    private String[] ConditionLogics;
    private String[] OrderByFields;
    private String[] GroupByFields;
    private String[] HavingConditions;
    private String[] HavingConditionLogics;

    public void setSQL(String sql) {
        if (sql == null || sql == "") {
            throw new NullPointerException();
        }
        this.SQL = sql.trim();
        this.lowerSQL = this.SQL.toLowerCase();
    }

    public void parse() throws Exception {
        int startIndex;
        int i;
        if (!this.lowerSQL.startsWith("select ")) {
            throw new Exception("String\uff1a\"" + this.SQL + "\" is not a Select SQL statement.");
        }
        this.ColumnPart = null;
        this.FromPart = null;
        this.WherePart = null;
        this.GroupByPart = null;
        this.HavingPart = null;
        this.OrderbyPart = null;
        this.FormatSQL = null;
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<String> tables = new ArrayList<String>();
        int leftBracketCount = 0;
        int rightBracketCount = 0;
        int singleQuoteCount = 0;
        for (i = startIndex = 6; i < this.SQL.length(); ++i) {
            if (this.SQL.charAt(i) == '(') {
                ++leftBracketCount;
            }
            if (this.SQL.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (this.SQL.charAt(i) == '\'') {
                ++singleQuoteCount;
            }
            if (leftBracketCount != rightBracketCount || singleQuoteCount % 2 != 0) continue;
            if (this.SQL.charAt(i) == ',') {
                cols.add(this.SQL.substring(startIndex, i).trim());
                startIndex = i + 1;
            }
            if (this.SQL.charAt(i) != ' ' || !this.lowerSQL.substring(i).trim().startsWith("from ")) continue;
            cols.add(this.SQL.substring(startIndex, i).trim());
            startIndex = this.lowerSQL.indexOf("from ", i) + 5;
            break;
        }
        this.Columns = new String[cols.size()];
        for (i = 0; i < cols.size(); ++i) {
            this.Columns[i] = (String)cols.get(i);
        }
        for (i = startIndex; i < this.SQL.length(); ++i) {
            if (this.SQL.charAt(i) == '(') {
                ++leftBracketCount;
            }
            if (this.SQL.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (this.SQL.charAt(i) == '\'') {
                ++singleQuoteCount;
            }
            if (leftBracketCount != rightBracketCount || singleQuoteCount % 2 != 0) continue;
            if (this.SQL.charAt(i) == ',') {
                tables.add(this.SQL.substring(startIndex, i).trim());
                startIndex = i + 1;
            }
            if (this.SQL.charAt(i) == ' ') {
                if (this.lowerSQL.substring(i).trim().startsWith("where ")) {
                    tables.add(this.SQL.substring(startIndex, i).trim());
                    this.parseWhere(this.SQL.substring(i + 1).trim());
                    break;
                }
                if (this.lowerSQL.substring(i).trim().startsWith("group ")) {
                    tables.add(this.SQL.substring(startIndex, i).trim());
                    this.parseGroupBy(this.SQL.substring(i + 1).trim());
                    break;
                }
                if (this.lowerSQL.substring(i).trim().startsWith("order ")) {
                    tables.add(this.SQL.substring(startIndex, i).trim());
                    this.parseOrderBy(this.SQL.substring(i + 1).trim());
                    break;
                }
            }
            if (i != this.SQL.length() - 1) continue;
            tables.add(this.SQL.substring(startIndex).trim());
        }
        this.Tables = new String[tables.size()];
        for (i = 0; i < tables.size(); ++i) {
            this.Tables[i] = (String)tables.get(i);
        }
    }

    private void parseWhere(String wherePart) {
        int i;
        int leftBracketCount = 0;
        int rightBracketCount = 0;
        int singleQuoteCount = 0;
        int startIndex = 6;
        String lowerWherePart = wherePart.toLowerCase();
        ArrayList<String> conditions = new ArrayList<String>();
        ArrayList<String> conditionLogics = new ArrayList<String>();
        for (i = startIndex; i < wherePart.length(); ++i) {
            if (wherePart.charAt(i) == '(') {
                ++leftBracketCount;
            }
            if (wherePart.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (wherePart.charAt(i) == '\'') {
                ++singleQuoteCount;
            }
            if (leftBracketCount != rightBracketCount || singleQuoteCount % 2 != 0) continue;
            if (wherePart.charAt(i) == ' ') {
                if (lowerWherePart.substring(i).trim().startsWith("and ")) {
                    conditions.add(wherePart.substring(startIndex, i).trim());
                    conditionLogics.add("and");
                    startIndex = i = lowerWherePart.indexOf("and ", i) + 3;
                }
                if (lowerWherePart.substring(i).trim().startsWith("or ")) {
                    conditions.add(wherePart.substring(startIndex, i).trim());
                    conditionLogics.add("or");
                    startIndex = i = lowerWherePart.indexOf("or ", i) + 2;
                }
                if (lowerWherePart.substring(i).trim().startsWith("group ")) {
                    conditions.add(wherePart.substring(startIndex, i).trim());
                    this.parseGroupBy(wherePart.substring(i + 1).trim());
                    break;
                }
                if (lowerWherePart.substring(i).trim().startsWith("order ")) {
                    conditions.add(wherePart.substring(startIndex, i).trim());
                    this.parseOrderBy(wherePart.substring(i + 1).trim());
                    break;
                }
            }
            if (i != wherePart.length() - 1) continue;
            conditions.add(wherePart.substring(startIndex).trim());
        }
        this.Conditions = new String[conditions.size()];
        if (conditionLogics.size() > 0) {
            this.ConditionLogics = new String[conditions.size()];
        }
        for (i = 0; i < conditions.size(); ++i) {
            this.Conditions[i] = (String)conditions.get(i);
            if (i >= conditionLogics.size()) continue;
            this.ConditionLogics[i] = (String)conditionLogics.get(i);
        }
    }

    private void parseGroupBy(String groupPart) {
        int i;
        int leftBracketCount = 0;
        int rightBracketCount = 0;
        int singleQuoteCount = 0;
        String lowerGroupPart = groupPart.toLowerCase();
        int startIndex = lowerGroupPart.indexOf(" by ") + 3;
        ArrayList<String> groupFields = new ArrayList<String>();
        for (i = startIndex; i < groupPart.length(); ++i) {
            if (groupPart.charAt(i) == '(') {
                ++leftBracketCount;
            }
            if (groupPart.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (groupPart.charAt(i) == '\'') {
                ++singleQuoteCount;
            }
            if (leftBracketCount != rightBracketCount || singleQuoteCount % 2 != 0) continue;
            if (groupPart.charAt(i) == ',') {
                groupFields.add(groupPart.substring(startIndex, i).trim());
                startIndex = i + 1;
            }
            if (groupPart.charAt(i) == ' ') {
                if (lowerGroupPart.substring(i).trim().startsWith("having ")) {
                    groupFields.add(groupPart.substring(startIndex, i).trim());
                    this.parseHaving(groupPart.substring(i + 1).trim());
                    break;
                }
                if (lowerGroupPart.substring(i).trim().startsWith("order ")) {
                    groupFields.add(groupPart.substring(startIndex, i).trim());
                    this.parseOrderBy(groupPart.substring(i + 1).trim());
                    break;
                }
            }
            if (i != groupPart.length() - 1) continue;
            groupFields.add(groupPart.substring(startIndex).trim());
        }
        this.GroupByFields = new String[groupFields.size()];
        for (i = 0; i < groupFields.size(); ++i) {
            this.GroupByFields[i] = (String)groupFields.get(i);
        }
    }

    private void parseOrderBy(String orderPart) {
        int startIndex;
        int i;
        int leftBracketCount = 0;
        int rightBracketCount = 0;
        int singleQuoteCount = 0;
        ArrayList<String> orderFields = new ArrayList<String>();
        for (i = startIndex = orderPart.toLowerCase().indexOf(" by ") + 3; i < orderPart.length(); ++i) {
            if (orderPart.charAt(i) == '(') {
                ++leftBracketCount;
            }
            if (orderPart.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (orderPart.charAt(i) == '\'') {
                ++singleQuoteCount;
            }
            if (leftBracketCount != rightBracketCount || singleQuoteCount % 2 != 0) continue;
            if (orderPart.charAt(i) == ',') {
                orderFields.add(orderPart.substring(startIndex, i).trim());
                startIndex = i + 1;
            }
            if (i != orderPart.length() - 1) continue;
            orderFields.add(orderPart.substring(startIndex).trim());
        }
        this.OrderByFields = new String[orderFields.size()];
        for (i = 0; i < orderFields.size(); ++i) {
            this.OrderByFields[i] = (String)orderFields.get(i);
        }
    }

    private void parseHaving(String havingPart) {
        int i;
        int leftBracketCount = 0;
        int rightBracketCount = 0;
        int singleQuoteCount = 0;
        int startIndex = 7;
        String lowerHavingPart = havingPart.toLowerCase();
        ArrayList<String> havingConditions = new ArrayList<String>();
        ArrayList<String> havingConditionLogics = new ArrayList<String>();
        for (i = startIndex; i < havingPart.length(); ++i) {
            if (havingPart.charAt(i) == '(') {
                ++leftBracketCount;
            }
            if (havingPart.charAt(i) == ')') {
                ++rightBracketCount;
            }
            if (havingPart.charAt(i) == '\'') {
                ++singleQuoteCount;
            }
            if (leftBracketCount != rightBracketCount || singleQuoteCount % 2 != 0) continue;
            if (havingPart.charAt(i) == ' ') {
                if (lowerHavingPart.substring(i).trim().startsWith("and ")) {
                    havingConditions.add(havingPart.substring(startIndex, i).trim());
                    havingConditionLogics.add("and");
                    startIndex = i = lowerHavingPart.indexOf("and ", i) + 3;
                }
                if (lowerHavingPart.substring(i).trim().startsWith("or ")) {
                    havingConditions.add(havingPart.substring(startIndex, i).trim());
                    havingConditionLogics.add("or");
                    startIndex = i = lowerHavingPart.indexOf("or ", i) + 2;
                }
                if (lowerHavingPart.substring(i).trim().startsWith("order ")) {
                    havingConditions.add(havingPart.substring(startIndex, i).trim());
                    this.parseOrderBy(havingPart.substring(i + 1).trim());
                    break;
                }
            }
            if (i != havingPart.length() - 1) continue;
            havingConditions.add(havingPart.substring(startIndex).trim());
        }
        this.HavingConditions = new String[havingConditions.size()];
        if (havingConditionLogics.size() > 0) {
            this.HavingConditionLogics = new String[havingConditionLogics.size()];
        }
        for (i = 0; i < havingConditions.size(); ++i) {
            this.HavingConditions[i] = (String)havingConditions.get(i);
            if (i >= havingConditions.size() - 1) continue;
            this.HavingConditionLogics[i] = (String)havingConditionLogics.get(i);
        }
    }

    public String getMSSQLPagedSQL() {
        int i;
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append("select * from (select ");
        for (i2 = 0; i2 < this.Columns.length; ++i2) {
            if (i2 != 0) {
                sb.append(",");
            }
            sb.append(this.Columns[i2]);
        }
        sb.append(",ROW_NUMBER() over (");
        if (this.OrderByFields != null) {
            sb.append("order by ");
            for (i2 = 0; i2 < this.OrderByFields.length; ++i2) {
                if (i2 != 0) {
                    sb.append(",");
                }
                sb.append(this.OrderByFields[i2]);
            }
        } else {
            String tmp = ("," + StringUtil.join((Object[])this.Columns, (String)",") + ",").toLowerCase();
            if (tmp.indexOf(",id,") >= 0) {
                sb.append("order by id");
            } else if (tmp.indexOf(",addtime,") >= 0) {
                sb.append("order by addtime");
            } else if (tmp.equals(",*,")) {
                sb.append("order by addtime");
            } else {
                String column = this.Columns[0];
                if (column.trim().indexOf(32) > 0) {
                    sb.append("order by id");
                } else {
                    sb.append("order by " + this.Columns[0]);
                }
            }
        }
        sb.append(") as _RowNumber");
        sb.append(" from ");
        for (i = 0; i < this.Tables.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.Tables[i]);
        }
        if (this.Conditions != null) {
            sb.append(" where ");
            for (i = 0; i < this.Conditions.length; ++i) {
                sb.append(" ");
                sb.append(this.Conditions[i]);
                if (i != this.Conditions.length - 1) {
                    sb.append(" ");
                    sb.append(this.ConditionLogics[i]);
                }
                sb.append(" ");
            }
        }
        if (this.GroupByFields != null) {
            sb.append(" group by ");
            for (i = 0; i < this.GroupByFields.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.GroupByFields[i]);
            }
        }
        if (this.HavingConditions != null) {
            sb.append(" having ");
            for (i = 0; i < this.HavingConditions.length; ++i) {
                sb.append(" ");
                sb.append(this.HavingConditions[i]);
                if (i != this.HavingConditions.length - 1) {
                    sb.append(" ");
                    sb.append(this.HavingConditionLogics[i]);
                }
                sb.append(" ");
            }
        }
        sb.append(") _Results where  _RowNumber between ? and ?");
        return sb.toString();
    }

    public String[] getColumns() {
        return this.Columns;
    }

    public String[] getConditions() {
        return this.Conditions;
    }

    public String[] getTables() {
        return this.Tables;
    }
}

