/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.data;

import com.sobey.bsp.framework.collection.Executor;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.Mapx;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    public static final int BACKUP = 4;
    public static final int DELETE_AND_BACKUP = 5;
    public static final int DELETE_AND_INSERT = 6;
    public static final int SQL = 7;
    protected boolean outerConnFlag = false;
    protected DataAccess dataAccess;
    protected List<Object> list = new ArrayList();
    private Mapx mapx = new Mapx();
    protected String BackupOperator;
    protected String BackupMemo;
    protected String ExceptionMessage;
    protected ArrayList<Executor> executorList = new ArrayList();
    protected String poolName;

    public void setDataAccess(DataAccess dAccess) {
        this.dataAccess = dAccess;
        this.outerConnFlag = true;
    }

    public void add(QueryBuilder qb) {
        this.list.add(new Object[]{qb, new Integer(7)});
    }

    public void add(Schema schema, int type) {
        this.list.add(new Object[]{schema, new Integer(type)});
    }

    public void add(SchemaSet set, int type) {
        this.list.add(new Object[]{set, new Integer(type)});
    }

    public void insert(Schema schema) {
        this.add(schema, 1);
    }

    public void insert(SchemaSet set) {
        this.add(set, 1);
    }

    public void update(Schema schema) {
        this.add(schema, 2);
    }

    public void delete(Schema schema) {
        this.add(schema, 3);
    }

    public void delete(SchemaSet set) {
        this.add(set, 3);
    }

    public void backup(Schema schema) {
        this.add(schema, 4);
    }

    public void backup(SchemaSet set) {
        this.add(set, 4);
    }

    public boolean commit() {
        return this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commit(boolean setAutoCommitStatus) {
        boolean NoErrFlag = true;
        try {
            if (!this.outerConnFlag) {
                this.dataAccess = new DataAccess(DBConnPool.getConnection((String)this.poolName));
            }
            if (!this.outerConnFlag || setAutoCommitStatus) {
                this.dataAccess.setAutoCommit(false);
            }
            this.dataAccess.setAllowActiveCloseConnection(false);
            for (int i = 0; i < this.list.size(); ++i) {
                int type;
                Object[] arr = (Object[])this.list.get(i);
                Object obj = arr[0];
                if (this.executeObject(obj, type = ((Integer)arr[1]).intValue())) continue;
                NoErrFlag = false;
                boolean bl = false;
                return bl;
            }
            this.dataAccess.commit();
            this.list.clear();
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u4e8b\u52a1\u9047\u5230\u5f02\u5e38", (Throwable)e);
            this.ExceptionMessage = e.getMessage();
            NoErrFlag = false;
            boolean arr = false;
            return arr;
        }
        finally {
            try {
                if (!NoErrFlag) {
                    this.dataAccess.rollback();
                }
                if (!this.outerConnFlag || setAutoCommitStatus) {
                    this.dataAccess.setAutoCommit(true);
                }
                if (!this.outerConnFlag && !this.dataAccess.allowActiveCloseConnection) {
                    this.dataAccess.close();
                }
            }
            catch (Exception e1) {
                log.error("\u5173\u95ed\u8d44\u6e90\u9047\u5230\u5f02\u5e38", (Throwable)e1);
            }
        }
        for (int i = 0; i < this.executorList.size(); ++i) {
            Executor executor = (Executor)this.executorList.get(i);
            executor.execute();
        }
        return true;
    }

    protected boolean executeObject(Object obj, int type) throws SQLException {
        if (obj instanceof QueryBuilder) {
            this.dataAccess.executeNoQuery((QueryBuilder)obj);
        } else if (obj instanceof Schema) {
            Schema s = (Schema)obj;
            s.setDataAccess(this.dataAccess);
            if (type == 1 ? !s.insert() : (type == 2 ? !s.update() : (type == 3 ? !s.delete() : (type == 4 ? !s.backup(this.BackupOperator, this.BackupMemo) : (type == 5 ? !s.deleteAndBackup(this.BackupOperator, this.BackupMemo) : type == 6 && !s.deleteAndInsert()))))) {
                return false;
            }
        } else if (obj instanceof SchemaSet) {
            SchemaSet s = (SchemaSet)obj;
            s.setDataAccess(this.dataAccess);
            if (type == 1 ? !s.insert() : (type == 2 ? !s.update() : (type == 3 ? !s.delete() : (type == 4 ? !s.backup(this.BackupOperator, this.BackupMemo) : (type == 5 ? !s.deleteAndBackup(this.BackupOperator, this.BackupMemo) : type == 6 && !s.deleteAndInsert()))))) {
                return false;
            }
        }
        return true;
    }

    public void clear() {
        this.mapx.clear();
    }

    public String getExceptionMessage() {
        return this.ExceptionMessage;
    }
}

