/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.mail;

import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class Mail {
    String to = "";
    String from = "";
    String host = "";
    String username = "";
    String password = "";
    String subject = "";
    String content = "";
    String domainUser = "";
    List<String> file = new ArrayList();

    public Mail() {
    }

    public Mail(String to, String from, String smtpServer, String username, String password, String subject, String content) {
        this.to = to;
        this.from = from;
        this.host = smtpServer;
        this.username = username;
        this.password = password;
        this.subject = subject;
        this.content = content;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassWord(String pwd) {
        this.password = pwd;
    }

    public void setUserName(String usn) {
        this.username = usn;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDomainUser(String domainUser) {
        this.domainUser = domainUser;
    }

    public String transferChinese(String strText) {
        try {
            strText = MimeUtility.encodeText((String)new String(strText.getBytes(), "UTF-8"), (String)"UTF-8", (String)"B");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strText;
    }

    public void attachfile(String fname) {
        this.file.add(fname);
    }

    public boolean sendMail() {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.auth", "true");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.from));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.to));
            msg.setSubject(this.subject);
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbpContent = new MimeBodyPart();
            mbpContent.setContent((Object)this.content, "text/html;charset=UTF-8");
            mp.addBodyPart((BodyPart)mbpContent);
            for (String fd : this.file) {
                MimeBodyPart mbpFile = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(fd);
                mbpFile.setDataHandler(new DataHandler((DataSource)fds));
                String filename = this.transferChinese(fds.getName());
                mbpFile.setFileName(filename);
                mp.addBodyPart((BodyPart)mbpFile);
            }
            this.file.clear();
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            msg.saveChanges();
            Transport transport = session.getTransport("smtp");
            transport.connect(this.host, StringUtil.isEmpty((String)this.domainUser) ? this.username : this.domainUser, this.password);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            transport.close();
        }
        catch (Exception mex) {
            mex.printStackTrace();
            LogUtil.error((Object)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!");
            return false;
        }
        return true;
    }
}

