/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BackupTableGenerator {
    private String fileName;
    private String aID = "ID";
    private Namespace nso;
    private Namespace nsc;
    private Namespace nsa;
    private int CurrentObjectID = 90000;
    private boolean isOracle = false;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void toBackupTable() throws Exception {
        File f = new File(this.fileName);
        if (!f.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String txt = FileUtil.readText((File)f);
        this.isOracle = txt.toLowerCase().indexOf("target=\"oracle") > 0;
        SAXReader reader = new SAXReader(false);
        Document doc = reader.read(f);
        Element root = doc.getRootElement();
        this.nso = root.getNamespaceForPrefix("o");
        this.nsc = root.getNamespaceForPrefix("c");
        this.nsa = root.getNamespaceForPrefix("a");
        Element rootObject = root.element(new QName("RootObject", this.nso));
        Element children = rootObject.element(new QName("Children", this.nsc));
        Element model = children.element(new QName("Model", this.nso));
        if (model.attributeValue("ID") == null) {
            if (model.attributeValue("Id") != null) {
                this.aID = "Id";
            } else {
                throw new RuntimeException("ID\u5c5e\u6027\u540d\u79f0\u672a\u5b9a\uff0cPDM\u7248\u672c\u4e0d\u6b63\u786e");
            }
        }
        List tables = model.element(new QName("Tables", this.nsc)).elements();
        for (int i = 0; i < tables.size(); ++i) {
            try {
                this.dealOneTable((Element)tables.get(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            String backupFileName = this.fileName.substring(0, this.fileName.lastIndexOf(46)) + "_B" + this.fileName.substring(this.fileName.lastIndexOf(46));
            XMLWriter output = new XMLWriter((OutputStream)new FileOutputStream(backupFileName), format);
            output.write(doc);
            output.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private int getObjectID() {
        return this.CurrentObjectID++;
    }

    private void dealOneTable(Element table) {
        String tableCode = table.elementText(new QName("Code", this.nsa));
        this.checkCode(tableCode, "\u8868\u4ee3\u7801");
        LogUtil.info((Object)tableCode);
        table.element(new QName("Name", this.nsa)).setText(table.elementText(new QName("Name", this.nsa)) + "\u5907\u4efd");
        table.element(new QName("Code", this.nsa)).setText("B" + table.elementText(new QName("Code", this.nsa)));
        String CreationDate = table.elementText(new QName("CreationDate", this.nsa));
        String Creator = table.elementText(new QName("Creator", this.nsa));
        String ModificationDate = table.elementText(new QName("ModificationDate", this.nsa));
        String Modifier2 = table.elementText(new QName("Modifier", this.nsa));
        Element eColumns = table.element(new QName("Columns", this.nsc));
        if (eColumns == null) {
            LogUtil.error((Object)("\u6ca1\u6709\u4e3a\u8868" + tableCode + "\u5b9a\u4e49\u5217!"));
            return;
        }
        List columns = eColumns.elements();
        Element template = (Element)columns.get(0);
        String templateObjectID = template.elementText(new QName("ObjectID", this.nsa));
        templateObjectID = templateObjectID.substring(0, templateObjectID.length() - 5);
        Element ele = eColumns.addElement(new QName("Column", this.nso));
        String objectID = "o" + this.getObjectID();
        ele.addAttribute(this.aID, objectID);
        ele.addElement(new QName("Name", this.nsa)).setText("\u5907\u4efd\u7f16\u53f7");
        ele.addElement(new QName("Code", this.nsa)).setText("BackupNo");
        ele.addElement(new QName("CreationDate", this.nsa)).setText(CreationDate);
        ele.addElement(new QName("Creator", this.nsa)).setText(Creator);
        ele.addElement(new QName("ModificationDate", this.nsa)).setText(ModificationDate);
        ele.addElement(new QName("Modifier", this.nsa)).setText(Modifier2);
        if (this.isOracle) {
            ele.addElement(new QName("DataType", this.nsa)).setText("varchar2(15)");
        } else {
            ele.addElement(new QName("DataType", this.nsa)).setText("varchar(15)");
        }
        ele.addElement(new QName("Length", this.nsa)).setText("15");
        ele.addElement(new QName("Mandatory", this.nsa)).setText("1");
        ele.addElement(new QName("ObjectID", this.nsa)).setText(templateObjectID + this.getObjectID());
        ele = eColumns.addElement(new QName("Column", this.nso));
        ele.addAttribute(this.aID, "o" + this.getObjectID());
        ele.addElement(new QName("Name", this.nsa)).setText("\u5907\u4efd\u4eba");
        ele.addElement(new QName("Code", this.nsa)).setText("BackupOperator");
        ele.addElement(new QName("CreationDate", this.nsa)).setText(CreationDate);
        ele.addElement(new QName("Creator", this.nsa)).setText(Creator);
        ele.addElement(new QName("ModificationDate", this.nsa)).setText(ModificationDate);
        ele.addElement(new QName("Modifier", this.nsa)).setText(Modifier2);
        if (this.isOracle) {
            ele.addElement(new QName("DataType", this.nsa)).setText("varchar2(200)");
        } else {
            ele.addElement(new QName("DataType", this.nsa)).setText("varchar(200)");
        }
        ele.addElement(new QName("Length", this.nsa)).setText("200");
        ele.addElement(new QName("Mandatory", this.nsa)).setText("1");
        ele.addElement(new QName("ObjectID", this.nsa)).setText(templateObjectID + this.getObjectID());
        ele = eColumns.addElement(new QName("Column", this.nso));
        ele.addAttribute(this.aID, "o" + this.getObjectID());
        ele.addElement(new QName("Name", this.nsa)).setText("\u5907\u4efd\u65f6\u95f4");
        ele.addElement(new QName("Code", this.nsa)).setText("BackupTime");
        ele.addElement(new QName("CreationDate", this.nsa)).setText(CreationDate);
        ele.addElement(new QName("Creator", this.nsa)).setText(Creator);
        ele.addElement(new QName("ModificationDate", this.nsa)).setText(ModificationDate);
        ele.addElement(new QName("Modifier", this.nsa)).setText(Modifier2);
        if (this.isOracle) {
            ele.addElement(new QName("DataType", this.nsa)).setText("date");
        } else {
            ele.addElement(new QName("DataType", this.nsa)).setText("datetime");
        }
        ele.addElement(new QName("Mandatory", this.nsa)).setText("1");
        ele.addElement(new QName("ObjectID", this.nsa)).setText(templateObjectID + this.getObjectID());
        ele = eColumns.addElement(new QName("Column", this.nso));
        ele.addAttribute(this.aID, "o" + this.getObjectID());
        ele.attribute(this.aID).setValue("o" + this.getObjectID());
        ele.addElement(new QName("Name", this.nsa)).setText("\u5907\u4efd\u5907\u6ce8");
        ele.addElement(new QName("Code", this.nsa)).setText("BackupMemo");
        ele.addElement(new QName("CreationDate", this.nsa)).setText(CreationDate);
        ele.addElement(new QName("Creator", this.nsa)).setText(Creator);
        ele.addElement(new QName("ModificationDate", this.nsa)).setText(ModificationDate);
        ele.addElement(new QName("Modifier", this.nsa)).setText(Modifier2);
        if (this.isOracle) {
            ele.addElement(new QName("DataType", this.nsa)).setText("varchar2(50)");
        } else {
            ele.addElement(new QName("DataType", this.nsa)).setText("varchar(50)");
        }
        ele.addElement(new QName("Length", this.nsa)).setText("50");
        ele.addElement(new QName("Mandatory", this.nsa)).setText("0");
        ele.addElement(new QName("ObjectID", this.nsa)).setText(templateObjectID + this.getObjectID());
        Element primaryKey = table.element(new QName("PrimaryKey", this.nsc));
        String keyRef = null;
        if (primaryKey != null && (primaryKey = primaryKey.element(new QName("Key", this.nso))) != null) {
            keyRef = primaryKey.attributeValue("Ref");
        }
        if (keyRef != null) {
            List keys = table.element(new QName("Keys", this.nsc)).elements();
            boolean keyFlag = false;
            for (int i = 0; i < keys.size(); ++i) {
                Element eKeyColumns;
                Element key = (Element)keys.get(i);
                if (!keyRef.equals(key.attributeValue(this.aID)) || (eKeyColumns = key.element(new QName("Key.Columns", this.nsc))) == null) continue;
                List keyColumns = eKeyColumns.elements();
                Element keyTemplate = (Element)keyColumns.get(0);
                Element backupIDKey = keyTemplate.createCopy();
                backupIDKey.attribute("Ref").setValue(objectID);
                eKeyColumns.add(backupIDKey);
                keyFlag = true;
                break;
            }
            if (!keyFlag) {
                LogUtil.error((Object)("\u8868" + tableCode + "\u672a\u627e\u5230\u4e3b\u952e!"));
            }
        }
    }

    private boolean checkCode(String code, String msgPrefix) {
        char[] ca = code.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ca[i])) continue;
                LogUtil.info((Object)(msgPrefix + code + "\u4e0d\u662f\u5408\u9002\u7684Java\u6807\u5fd7\u540d"));
                return false;
            }
            if (Character.isJavaIdentifierPart(ca[i])) continue;
            LogUtil.info((Object)(msgPrefix + code + "\u4e0d\u662f\u5408\u9002\u7684Java\u6807\u5fd7\u540d"));
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        BackupTableGenerator btg = new BackupTableGenerator();
        btg.setFileName("H:/Projects/SportYou/Doc/DataBase/MiddingCMS.pdm");
        try {
            btg.toBackupTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

