/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.messages.LongTimeTask;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.BufferedRandomAccessFile;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.NumberUtil;
import com.sobey.bsp.framework.utility.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import org.apache.tools.zip.ZipFile;

public class DBExport {
    private static final int PageSize = 500;
    private BufferedRandomAccessFile braf;
    private LongTimeTask task;

    public void setTask(LongTimeTask task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDB(String file) {
        FileUtil.delete((String)file);
        try {
            FileUtil.mkdir((String)file.substring(0, file.lastIndexOf("/")));
            this.braf = new BufferedRandomAccessFile(file, "rw");
            Class<?> c = null;
            try {
                c = Class.forName("com.sobey.bsp.schema.SCMS_CodeSchema");
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            String path = c.getResource("SCMS_CodeSchema.class").getPath();
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                } else if (path.startsWith("file:/")) {
                    path = path.substring(6);
                }
            } else if (path.startsWith("file:/")) {
                path = path.substring(5);
            }
            path = path.replaceAll("%20", " ");
            if (path.toLowerCase().indexOf(".jar!") > 0) {
                try {
                    path = path.substring(0, path.indexOf(".jar!") + 4);
                    ZipFile z = new ZipFile(path);
                    Enumeration all = z.getEntries();
                    int total = 0;
                    while (all.hasMoreElements()) {
                        String name = all.nextElement().toString();
                        if (!name.startsWith("com.sobey.bsp.schema.")) continue;
                        ++total;
                    }
                    all = z.getEntries();
                    for (int i = 0; i < total; ++i) {
                        String name = all.nextElement().toString();
                        if (!name.startsWith("com.sobey.bsp.schema.")) continue;
                        try {
                            if (this.task != null) {
                                this.task.setPercent(new Double((double)i * 100.0 / (double)total).intValue());
                                this.task.setCurrentInfo("\u6b63\u5728\u5bfc\u51fa\u8868" + name);
                            }
                            this.transferOneTable(name);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (this.braf != null) {
                        try {
                            this.braf.close();
                        }
                        catch (IOException ee) {
                            ee.printStackTrace();
                        }
                    }
                    if (this.braf != null) {
                        try {
                            this.braf.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    return;
                }
            }
            File p = new File(path.substring(0, path.toLowerCase().indexOf("scms_codeschema.class")));
            File[] fs = p.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].getName().endsWith("Schema.class")) continue;
                try {
                    if (this.task != null) {
                        this.task.setPercent(new Double((double)i * 100.0 / (double)fs.length).intValue());
                        this.task.setCurrentInfo("\u6b63\u5728\u5bfc\u51fa\u8868" + fs[i].getName());
                    }
                    this.transferOneTable("com/sobey/bsp/schema/" + fs[i].getName());
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            try {
                DataTable dt = new QueryBuilder("select Code from SCMS_Customtable where Type='Custom'").executeDataTable();
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    String code = dt.getString(i, 0);
                    this.transferCustomTable(code);
                }
            }
            catch (Throwable t) {
                LogUtil.warn((Object)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u81ea\u5b9a\u4e49\u8868");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (this.braf != null) {
                try {
                    this.braf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void transferOneTable(String schemaName) throws Exception {
        schemaName = schemaName.replaceAll("\\/", ".");
        if ((schemaName = schemaName.substring(0, schemaName.length() - 6)).equals("com.sobey.bsp.schema.SCMS_ASI_FavoritesSchema") || schemaName.equals("com.sobey.bsp.schema.SCMS_ASI_ScoreitemSchema") || schemaName.equals("com.sobey.bsp.schema.SCMS_ASI_ScoreSchema")) {
            System.out.println("-----------" + schemaName);
        }
        Schema schema = (Schema)Class.forName(schemaName).newInstance();
        int count = 0;
        try {
            count = new QueryBuilder("select count(*) from " + schema.TableCode).executeInt();
            for (int i = 0; i * 500 < count || i == 0 && count == 0; ++i) {
                SchemaSet set = schema.querySet(null, 500, i);
                byte[] bs = FileUtil.serialize((Serializable)set);
                bs = ZipUtil.zip((byte[])bs);
                this.braf.write(NumberUtil.toBytes((int)bs.length));
                this.braf.write(bs);
            }
        }
        catch (Exception e) {
            LogUtil.warn((Object)("Schema\u5bf9\u5e94\u7684\u8868\u4e0d\u5b58\u5728\uff1a" + schemaName));
            return;
        }
    }

    private void transferCustomTable(String table) throws Exception {
        int count = 0;
        try {
            QueryBuilder qb = new QueryBuilder("select * from " + table);
            count = DataAccess.getCount((String)DBConnPool.getDBConnConfig().DBType, (QueryBuilder)qb);
            for (int i = 0; i * 500 < count || i == 0 && count == 0; ++i) {
                DataTable dt = qb.executePagedDataTable(500, i);
                byte[] bs = table.getBytes();
                bs = FileUtil.serialize((Serializable)dt);
                bs = ZipUtil.zip((byte[])bs);
                this.braf.write(NumberUtil.toBytes((int)bs.length));
                this.braf.write(bs);
            }
        }
        catch (Exception e) {
            LogUtil.warn((Object)("\u5bf9\u5e94\u7684\u81ea\u5b9a\u4e49\u8868\u4e0d\u5b58\u5728\uff1a" + table));
            return;
        }
    }
}

