/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DBConn;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.DataCollection;
import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.LobUtil;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.orm.SchemaColumn;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.orm.SchemaUtil;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Schema
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private static final long serialVersionUID = 1L;
    protected String TableCode;
    protected SchemaColumn[] Columns;
    protected String InsertAllSQL;
    protected String UpdateAllSQL;
    protected String FillAllSQL;
    protected String DeleteSQL;
    protected String NameSpace;
    protected int bConnFlag = 0;
    protected boolean bOperateFlag = false;
    protected int[] operateColumnOrders;
    protected boolean[] HasSetFlag;
    protected transient DataAccess mDataAccess;

    public boolean insert() {
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        Statement pstmt = null;
        try {
            DBConn conn = this.mDataAccess.getConnection();
            pstmt = conn.prepareStatement(this.InsertAllSQL, 1003, 1007);
            for (int i = 0; i < this.Columns.length; ++i) {
                SchemaColumn sc = this.Columns[i];
                if (sc.isMandatory() && this.getV(i) == null) {
                    throw new SQLException("\u8868" + this.TableCode + "\u7684\u5217" + sc.getColumnName() + "\u4e0d\u80fd\u4e3a\u7a7a");
                }
                Object v = this.getV(i);
                SchemaUtil.setParam((SchemaColumn)sc, (PreparedStatement)pstmt, (DBConn)conn, (int)i, (Object)v);
            }
            int count = pstmt.executeUpdate();
            if (count == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean update() {
        String sql = this.UpdateAllSQL;
        if (this.bOperateFlag) {
            StringBuffer sb = new StringBuffer("update " + this.TableCode + " set ");
            for (int i = 0; i < this.operateColumnOrders.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.Columns[this.operateColumnOrders[i]].getColumnName());
                sb.append("=?");
            }
            sb.append(sql.substring(sql.indexOf(" where")));
            sql = sb.toString();
        }
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        Statement pstmt = null;
        try {
            Object v;
            int i;
            DBConn conn = this.mDataAccess.getConnection();
            pstmt = conn.prepareStatement(sql, 1003, 1007);
            if (this.bOperateFlag) {
                for (i = 0; i < this.operateColumnOrders.length; ++i) {
                    v = this.getV(this.operateColumnOrders[i]);
                    SchemaUtil.setParam((SchemaColumn)this.Columns[this.operateColumnOrders[i]], (PreparedStatement)pstmt, (DBConn)conn, (int)this.operateColumnOrders[i], (Object)v);
                }
            } else {
                for (i = 0; i < this.Columns.length; ++i) {
                    v = this.getV(i);
                    SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)i, (Object)v);
                }
            }
            int j = 0;
            for (i = 0; i < this.Columns.length; ++i) {
                SchemaColumn sc = this.Columns[i];
                if (!sc.isPrimaryKey()) continue;
                Object v2 = this.getV(sc.getColumnOrder());
                if (v2 == null) {
                    LogUtil.warn((Object)("\u4e0d\u6ee1\u8db3Update\u7684\u6761\u4ef6\uff0c" + this.TableCode + "Schema\u7684" + sc.getColumnName() + "\u4e3a\u7a7a"));
                    boolean bl = false;
                    return bl;
                }
                if (this.bOperateFlag) {
                    SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)(j + this.operateColumnOrders.length), (Object)v2);
                } else {
                    SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)(j + this.Columns.length), (Object)v2);
                }
                ++j;
            }
            pstmt.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean delete() {
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        Statement pstmt = null;
        try {
            DBConn conn = this.mDataAccess.getConnection();
            pstmt = conn.prepareStatement(this.DeleteSQL, 1003, 1007);
            int j = 0;
            for (int i = 0; i < this.Columns.length; ++i) {
                SchemaColumn sc = this.Columns[i];
                if (!sc.isPrimaryKey()) continue;
                Object v = this.getV(sc.getColumnOrder());
                if (v == null) {
                    LogUtil.warn((Object)("\u4e0d\u6ee1\u8db3delete\u7684\u6761\u4ef6\uff0c" + this.TableCode + "Schema\u7684" + sc.getColumnName() + "\u4e3a\u7a7a"));
                    boolean bl = false;
                    return bl;
                }
                SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)j, (Object)v);
                ++j;
            }
            pstmt.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean backup() {
        return this.backup(null, null);
    }

    public boolean backup(String backupOperator, String backupMemo) {
        try {
            int i;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? User.getUserName() : backupOperator;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? "admin" : backupOperator;
            String firstCode = this.TableCode.substring(0, this.TableCode.indexOf("_") + 1);
            String secondCode = this.TableCode.substring(this.TableCode.indexOf("_") + 1);
            secondCode = secondCode.substring(0, 1).toLowerCase() + secondCode.substring(1);
            Class<?> c = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Schema");
            Schema bSchema = (Schema)c.newInstance();
            for (i = 0; i < this.Columns.length; ++i) {
                bSchema.setV(i, this.getV(i));
            }
            bSchema.setV(i, (Object)SchemaUtil.getBackupNo());
            bSchema.setV(i + 1, (Object)backupOperator);
            bSchema.setV(i + 2, (Object)new Date());
            bSchema.setV(i + 3, (Object)backupMemo);
            if (this.bConnFlag == 0) {
                return bSchema.insert();
            }
            bSchema.setDataAccess(this.mDataAccess);
            return bSchema.insert();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAndInsert() {
        if (this.bConnFlag == 1) {
            if (!this.delete()) {
                return false;
            }
            return this.insert();
        }
        this.mDataAccess = new DataAccess();
        this.bConnFlag = 1;
        try {
            this.mDataAccess.setAutoCommit(false);
            this.delete();
            this.insert();
            this.mDataAccess.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.mDataAccess.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.mDataAccess.setAutoCommit(true);
                this.mDataAccess.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.mDataAccess = null;
            this.bConnFlag = 0;
        }
    }

    public boolean deleteAndBackup() {
        return this.deleteAndBackup(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteAndBackup(String backupOperator, String backupMemo) {
        try {
            int i;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? User.getUserName() : backupOperator;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? "admin" : backupOperator;
            String firstCode = this.TableCode.substring(0, this.TableCode.indexOf("_") + 1);
            String secondCode = this.TableCode.substring(this.TableCode.indexOf("_") + 1);
            secondCode = secondCode.substring(0, 1).toLowerCase() + secondCode.substring(1);
            Class<?> c = null;
            Class<?> s = null;
            try {
                c = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Schema");
                s = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Set");
            }
            catch (Exception e2) {
                System.out.println("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5907\u4efd\u8868 ,\u4e0d\u9700\u8981\u5907\u4efd!");
                return this.delete();
            }
            Schema bSchema = (Schema)c.newInstance();
            for (i = 0; i < this.Columns.length; ++i) {
                bSchema.setV(i, this.getV(i));
            }
            bSchema.setV(i, (Object)SchemaUtil.getBackupNo());
            bSchema.setV(i + 1, (Object)backupOperator);
            bSchema.setV(i + 2, (Object)new Date());
            bSchema.setV(i + 3, (Object)backupMemo);
            if (this.bConnFlag == 0) {
                this.mDataAccess = new DataAccess();
                this.bConnFlag = 1;
                try {
                    this.mDataAccess.setAutoCommit(false);
                    this.delete();
                    bSchema.setDataAccess(this.mDataAccess);
                    bSchema.insert();
                    this.mDataAccess.commit();
                    boolean bl = true;
                    return bl;
                }
                catch (SQLException e) {
                    LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
                    e.printStackTrace();
                    try {
                        this.mDataAccess.rollback();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.bConnFlag = 0;
                    try {
                        this.mDataAccess.setAutoCommit(true);
                        this.mDataAccess.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!this.delete()) {
                return false;
            }
            bSchema.setDataAccess(this.mDataAccess);
            return bSchema.insert();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean fill() {
        String sql = this.FillAllSQL;
        if (this.bOperateFlag) {
            StringBuffer sb = new StringBuffer("select ");
            for (int i = 0; i < this.operateColumnOrders.length; ++i) {
                if (i == 0) {
                    sb.append(this.Columns[this.operateColumnOrders[i]].getColumnName());
                    continue;
                }
                sb.append(",");
                sb.append(this.Columns[this.operateColumnOrders[i]].getColumnName());
            }
            sb.append(sql.substring(sql.indexOf(" from")));
            sql = sb.toString();
        }
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            boolean bl;
            int i;
            DBConn dbConn = this.mDataAccess.getConnection();
            pstmt = dbConn.prepareStatement(sql, 1003, 1007);
            int j = 0;
            for (i = 0; i < this.Columns.length; ++i) {
                SchemaColumn sc = this.Columns[i];
                if (!sc.isPrimaryKey()) continue;
                Object v = this.getV(sc.getColumnOrder());
                if (v == null) {
                    throw new RuntimeException("\u4e0d\u6ee1\u8db3fill\u7684\u6761\u4ef6\uff0c" + this.TableCode + "Schema\u7684" + sc.getColumnName() + "\u4e3a\u7a7a");
                }
                if (this.Columns[i].getColumnType() == 0) {
                    pstmt.setTimestamp(j + 1, new Timestamp(((Date)v).getTime()));
                } else {
                    pstmt.setObject(j + 1, v);
                }
                ++j;
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                if (this.bOperateFlag) {
                    for (i = 0; i < this.operateColumnOrders.length; ++i) {
                        if (this.Columns[this.operateColumnOrders[i]].getColumnType() == 10) {
                            if (dbConn.getDBConfig().DBType.equals("ORACLE") || dbConn.getDBConfig().DBType.equals("DB2")) {
                                this.setV(this.operateColumnOrders[i], (Object)LobUtil.clobToString((Clob)rs.getClob(i + 1)));
                                continue;
                            }
                            this.setV(this.operateColumnOrders[i], rs.getObject(i + 1));
                            continue;
                        }
                        if (this.Columns[this.operateColumnOrders[i]].getColumnType() == 2) {
                            this.setV(this.operateColumnOrders[i], (Object)LobUtil.blobToBytes((Blob)rs.getBlob(i + 1)));
                            continue;
                        }
                        this.setV(this.operateColumnOrders[i], rs.getObject(i + 1));
                    }
                } else {
                    for (i = 0; i < this.Columns.length; ++i) {
                        if (this.Columns[i].getColumnType() == 10) {
                            if (dbConn.getDBConfig().DBType.equals("ORACLE") || dbConn.getDBConfig().DBType.equals("DB2")) {
                                this.setV(i, (Object)LobUtil.clobToString((Clob)rs.getClob(i + 1)));
                                continue;
                            }
                            this.setV(i, rs.getObject(i + 1));
                            continue;
                        }
                        if (this.Columns[i].getColumnType() == 2) {
                            this.setV(i, (Object)LobUtil.blobToBytes((Blob)rs.getBlob(i + 1)));
                            continue;
                        }
                        this.setV(i, rs.getObject(i + 1));
                    }
                }
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        catch (Exception e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaSet querySet(QueryBuilder qb, int pageSize, int pageIndex) {
        if (qb != null && !qb.getSQL().trim().toLowerCase().startsWith("where")) {
            throw new RuntimeException("QueryBuilder\u4e2d\u7684SQL\u8bed\u53e5\u4e0d\u662f\u4ee5where\u5f00\u5934\u7684\u5b57\u7b26\u4e32");
        }
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        DBConn conn = this.mDataAccess.getConnection();
        StringBuffer sb = new StringBuffer("select ");
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            Schema schema;
            int i;
            if (this.bOperateFlag) {
                for (i = 0; i < this.operateColumnOrders.length; ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(this.Columns[this.operateColumnOrders[i]].getColumnName());
                }
            } else if (conn.getDBConfig().DBType.equals("MSSQL")) {
                for (i = 0; i < this.Columns.length; ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(this.Columns[i].getColumnName());
                }
            } else {
                sb.append("*");
            }
            sb.append(" from " + this.TableCode);
            if (qb == null) {
                boolean firstFlag = true;
                qb = new QueryBuilder();
                for (int i2 = 0; i2 < this.Columns.length; ++i2) {
                    SchemaColumn sc = this.Columns[i2];
                    if (this.isNull(sc)) continue;
                    if (firstFlag) {
                        sb.append(" where ");
                        sb.append(sc.getColumnName());
                        sb.append("=?");
                        firstFlag = false;
                    } else {
                        sb.append(" and ");
                        sb.append(sc.getColumnName());
                        sb.append("=?");
                    }
                    Object v = this.getV(sc.getColumnOrder());
                    qb.add(v);
                }
            } else {
                sb.append(" ");
                sb.append(qb.getSQL());
            }
            qb.setSQL(sb.toString());
            String pageSQL = qb.getSQL();
            if (pageSize > 0) {
                pageSQL = DataAccess.getPagedSQL((DBConn)conn, (QueryBuilder)qb, (int)pageSize, (int)pageIndex);
            }
            pageIndex = pageIndex < 0 ? 0 : pageIndex;
            pstmt = conn.prepareStatement(pageSQL);
            DataAccess.setParams((PreparedStatement)pstmt, (QueryBuilder)qb, (DBConn)conn);
            rs = pstmt.executeQuery();
            if (pageSize > 0 && !conn.getDBConfig().DBType.equals("MSSQL2000")) {
                qb.getParams().remove(qb.getParams().size() - 1);
                qb.getParams().remove(qb.getParams().size() - 1);
            }
            SchemaSet set = this.newSet();
            while (rs.next()) {
                int i3;
                schema = this.newInstance();
                if (this.bOperateFlag) {
                    for (i3 = 0; i3 < this.operateColumnOrders.length; ++i3) {
                        if (this.Columns[this.operateColumnOrders[i3]].getColumnType() == 10) {
                            if (conn.getDBConfig().DBType.equals("ORACLE") || conn.getDBConfig().DBType.equals("DB2")) {
                                schema.setV(this.operateColumnOrders[i3], (Object)LobUtil.clobToString((Clob)rs.getClob(i3 + 1)));
                                continue;
                            }
                            schema.setV(this.operateColumnOrders[i3], rs.getObject(i3 + 1));
                            continue;
                        }
                        if (this.Columns[this.operateColumnOrders[i3]].getColumnType() == 2) {
                            schema.setV(this.operateColumnOrders[i3], (Object)LobUtil.blobToBytes((Blob)rs.getBlob(i3 + 1)));
                            continue;
                        }
                        schema.setV(this.operateColumnOrders[i3], rs.getObject(i3 + 1));
                    }
                } else {
                    for (i3 = 0; i3 < this.Columns.length; ++i3) {
                        if (this.Columns[i3].getColumnType() == 10) {
                            if (conn.getDBConfig().DBType.equals("ORACLE") || conn.getDBConfig().DBType.equals("DB2")) {
                                schema.setV(i3, (Object)LobUtil.clobToString((Clob)rs.getClob(i3 + 1)));
                                continue;
                            }
                            schema.setV(i3, rs.getObject(i3 + 1));
                            continue;
                        }
                        if (this.Columns[i3].getColumnType() == 2) {
                            schema.setV(i3, (Object)LobUtil.blobToBytes((Blob)rs.getBlob(i3 + 1)));
                            continue;
                        }
                        schema.setV(i3, rs.getObject(i3 + 1));
                    }
                }
                set.add(schema);
            }
            set.setOperateColumns(this.operateColumnOrders);
            schema = set;
            return schema;
        }
        catch (Exception e) {
            LogUtil.error((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            e.printStackTrace();
            SchemaSet schemaSet = null;
            return schemaSet;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setOperateColumns(String[] colNames) {
        if (colNames == null || colNames.length == 0) {
            this.bOperateFlag = false;
            return;
        }
        this.operateColumnOrders = new int[colNames.length];
        int k = 0;
        for (int i = 0; i < colNames.length; ++i) {
            boolean flag = false;
            for (int j = 0; j < this.Columns.length; ++j) {
                if (!colNames[i].toString().toLowerCase().equals(this.Columns[j].getColumnName().toLowerCase())) continue;
                this.operateColumnOrders[k] = j;
                ++k;
                flag = true;
                break;
            }
            if (flag) continue;
            throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u540d" + colNames[i] + "\u4e0d\u6b63\u786e");
        }
        this.bOperateFlag = true;
    }

    public void setOperateColumns(int[] colOrder) {
        if (colOrder == null || colOrder.length == 0) {
            this.bOperateFlag = false;
            return;
        }
        this.operateColumnOrders = colOrder;
        this.bOperateFlag = true;
    }

    public void setDataAccess(DataAccess dAccess) {
        this.mDataAccess = dAccess;
        this.bConnFlag = 1;
    }

    protected boolean isNull(SchemaColumn sc) {
        return this.getV(sc.getColumnOrder()) == null;
    }

    public void setValue(Mapx map) {
        Object value = null;
        Object key = null;
        Object[] ks = map.keyArray();
        Object[] vs = map.valueArray();
        block2: for (int i = 0; i < map.size(); ++i) {
            value = vs[i];
            key = ks[i];
            for (int j = 0; j < this.Columns.length; ++j) {
                SchemaColumn sc = this.Columns[j];
                if (key == null || !key.toString().equalsIgnoreCase(sc.getColumnName())) continue;
                try {
                    int type = sc.getColumnType();
                    if (type == 0) {
                        if (value == null || "".equals(value)) continue block2;
                        this.setV(j, (Object)DateUtil.parseDateTime((String)value.toString()));
                        continue block2;
                    }
                    if (type == 6) {
                        this.setV(j, (Object)new Double(value.toString()));
                        continue block2;
                    }
                    if (type == 5) {
                        this.setV(j, (Object)new Float(value.toString()));
                        continue block2;
                    }
                    if (type == 7) {
                        this.setV(j, (Object)new Long(value.toString()));
                        continue block2;
                    }
                    if (type == 8) {
                        this.setV(j, (Object)new Integer(value.toString()));
                        continue block2;
                    }
                    this.setV(j, value);
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setValue(DataCollection dc) {
        String value = null;
        String key = null;
        Object[] ks = dc.keyArray();
        Object[] vs = dc.valueArray();
        block2: for (int i = 0; i < dc.size(); ++i) {
            if (!(vs[i] instanceof String) && vs[i] != null) continue;
            value = (String)vs[i];
            key = (String)ks[i];
            for (int j = 0; j < this.Columns.length; ++j) {
                SchemaColumn sc = this.Columns[j];
                if (!key.equalsIgnoreCase(sc.getColumnName())) continue;
                try {
                    int type = sc.getColumnType();
                    if (type == 0) {
                        if (value == null || "".equals(value)) continue block2;
                        if (DateUtil.isTime((String)value.toString())) {
                            this.setV(j, (Object)DateUtil.parseDateTime((String)value.toString(), (String)"HH:mm:ss"));
                            continue block2;
                        }
                        this.setV(j, (Object)DateUtil.parseDateTime((String)value.toString()));
                        continue block2;
                    }
                    if (type == 6) {
                        this.setV(j, (Object)new Double(value.toString()));
                        continue block2;
                    }
                    if (type == 5) {
                        this.setV(j, (Object)new Float(value.toString()));
                        continue block2;
                    }
                    if (type == 7) {
                        this.setV(j, (Object)new Long(value.toString()));
                        continue block2;
                    }
                    if (type == 8) {
                        this.setV(j, (Object)new Integer(value.toString()));
                        continue block2;
                    }
                    this.setV(j, (Object)value);
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setValue(DataRow dr) {
        String value = null;
        String key = null;
        boolean webMode = dr.isWebMode();
        dr.setWebMode(false);
        block2: for (int i = 0; i < dr.getColumnCount(); ++i) {
            value = dr.getString(i);
            key = dr.getDataColumns()[i].getColumnName();
            for (int j = 0; j < this.Columns.length; ++j) {
                SchemaColumn sc = this.Columns[j];
                if (!key.equalsIgnoreCase(sc.getColumnName())) continue;
                try {
                    int type = sc.getColumnType();
                    if (type == 0) {
                        if (value == null || "".equals(value)) continue block2;
                        this.setV(j, (Object)DateUtil.parseDateTime((String)value.toString()));
                        continue block2;
                    }
                    if (type == 6) {
                        this.setV(j, (Object)new Double(value.toString()));
                        continue block2;
                    }
                    if (type == 5) {
                        this.setV(j, (Object)new Float(value.toString()));
                        continue block2;
                    }
                    if (type == 7) {
                        this.setV(j, (Object)new Long(value.toString()));
                        continue block2;
                    }
                    if (type == 8) {
                        this.setV(j, (Object)new Integer(value.toString()));
                        continue block2;
                    }
                    this.setV(j, (Object)value);
                    continue block2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        dr.setWebMode(webMode);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < this.Columns.length; ++i) {
            sb.append(this.Columns[i].getColumnName());
            sb.append(":");
            sb.append(this.getV(i));
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public Object clone() {
        Schema s = this.newInstance();
        SchemaUtil.copyFieldValue((Schema)this, (Schema)s);
        return s;
    }

    public Mapx toMapx() {
        Mapx map = new Mapx();
        for (int i = 0; i < this.Columns.length; ++i) {
            map.put((Object)this.Columns[i].getColumnName(), this.getV(i));
        }
        return map;
    }

    public Mapx toMapx(boolean toLowerCase) {
        Mapx map = new Mapx();
        for (int i = 0; i < this.Columns.length; ++i) {
            String colName = this.Columns[i].getColumnName();
            if (toLowerCase) {
                colName = colName.toLowerCase();
            }
            map.put((Object)colName, this.getV(i));
        }
        return map;
    }

    public DataRow toDataRow() {
        int len = this.Columns.length;
        DataColumn[] dcs = new DataColumn[len];
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            DataColumn dc = new DataColumn();
            dc.setColumnName(this.Columns[i].getColumnName());
            dc.setColumnType(this.Columns[i].getColumnType());
            dcs[i] = dc;
            values[i] = this.getV(i);
        }
        return new DataRow(dcs, values);
    }

    public int getColumnCount() {
        return this.Columns.length;
    }

    public abstract void setV(int var1, Object var2);

    public abstract Object getV(int var1);

    protected abstract Schema newInstance();

    protected abstract SchemaSet newSet();
}

