/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.license.SystemInfo;
import com.sobey.bsp.framework.orm.BackupTableGenerator;
import com.sobey.bsp.framework.orm.SchemaGenerator;
import com.sobey.bsp.framework.security.ZRSACipher;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.bouncycastle.jce.provider.JDKX509CertificateFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaGenerator {
    private String fileName;
    private String outputDir;
    private String namespace;
    private String aID = "ID";
    private Namespace nso;
    private Namespace nsc;
    private Namespace nsa;
    private boolean isOracle = false;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    public void generate() throws Exception {
        try {
            String cert = "MIICnTCCAgagAwIBAgIBATANBgkqhkiG9w0BAQUFADBkMRIwEAYDVQQDDAlMaWNlbnNlQ0ExDTALBgNVBAsMBFNPRlQxDjAMBgNVBAoMBVpWSU5HMRAwDgYDVQQHDAdIQUlESUFOMQswCQYDVQQGEwJDTjEQMA4GA1UECAwHQkVJSklORzAgFw0wOTA0MTYwMzQ4NDhaGA81MDA3MDQyMDAzNDg0OFowZDESMBAGA1UEAwwJTGljZW5zZUNBMQ0wCwYDVQQLDARTT0ZUMQ4wDAYDVQQKDAVaVklORzEQMA4GA1UEBwwHSEFJRElBTjELMAkGA1UEBhMCQ04xEDAOBgNVBAgMB0JFSUpJTkcwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMStEFTKHuIaPzADjA7hrHSQn5jL5yCN+dabiP0vXfAthKWEOiaS8wAX8WX516PDPfyo2SL63h5Ihvn9BBpLqAgwvDyxoP6bpU85ZuvmbeI02EPgLCz1IK+Xibl4RmcaprKvjm5ec92zWLWTC4TEkdh+NPFkkL7yZskZNC4e40I9AgMBAAGjXTBbMB0GA1UdDgQWBBRwZt+eq7q/8MvUoSNW41Bzp2RD5zAfBgNVHSMEGDAWgBRwZt+eq7q/8MvUoSNW41Bzp2RD5zAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkqhkiG9w0BAQUFAAOBgQAummShucu9umvlsrGaJmw0xkFCwC8esLHe50sJkER2OreGPCdrQjEGytvYz4jtkqVyvLBDziuz29yeQUDjfVBuN7iZ9CuYeuI73uQoQeZOKLDQj2UZHag6XNCkSJTvh9g2JWOeAJjmwquwds+dONKRU/fol4JnrU7fMP/V0Ur3/w==";
            byte[] code = StringUtil.hexDecode((String)FileUtil.readText((String)(Config.getClassesPath() + "license.dat")).trim());
            JDKX509CertificateFactory certificatefactory = new JDKX509CertificateFactory();
            X509Certificate cer = (X509Certificate)certificatefactory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(StringUtil.base64Decode((String)cert)));
            PublicKey pubKey = cer.getPublicKey();
            ZRSACipher dc = new ZRSACipher();
            dc.init(2, (Key)pubKey);
            byte[] bs = new byte[code.length * 2];
            int indexBS = 0;
            int indexCode = 0;
            while (code.length - indexCode > 128) {
                indexBS += dc.doFinal(code, indexCode, 128, bs, indexBS);
                indexCode += 128;
            }
            indexBS += dc.doFinal(code, indexCode, code.length - indexCode, bs, indexBS);
            String str = new String(bs, 0, indexBS);
            Mapx mapx = StringUtil.splitToMapx((String)str, (String)";", (String)"=");
            String product = mapx.getString((Object)"Product");
            String macAddress = mapx.getString((Object)"MacAddress");
            String name = mapx.getString((Object)"Name");
            Date endDate = new Date(Long.parseLong(mapx.getString((Object)"TimeEnd")));
            if (endDate.getTime() < System.currentTimeMillis()) {
                LogUtil.fatal((Object)"License\u5df1\u8fc7\u671f!");
                System.exit(0);
            }
            if (name.indexOf("Trial") < 0 && !macAddress.equalsIgnoreCase(SystemInfo.getMacAddress())) {
                LogUtil.fatal((Object)"License\u4e2d\u6307\u5b9a\u7684Mac\u5730\u5740\u4e0e\u5b9e\u9645Mac\u5730\u5740\u4e0d\u4e00\u81f4!");
                System.exit(0);
            }
            product = product.toLowerCase();
            try {
                Class.forName("com.sobey.bsp.oa.workflow.FlowConfig");
                if (product.indexOf("zoa") < 0) {
                    LogUtil.fatal((Object)"License\u4e2d\u6ca1\u6709ZOA\u76f8\u5173\u7684\u6807\u8bb0!");
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Class.forName("com.sobey.bsp.cms.stat.StatUtil");
                if (product.indexOf("scms") < 0) {
                    LogUtil.fatal((Object)"License\u4e2d\u6ca1\u6709SCMS\u76f8\u5173\u7684\u6807\u8bb0!");
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Class.forName("com.sobey.bsp.shop.Goods");
                if (product.indexOf("zshop") < 0) {
                    LogUtil.fatal((Object)"License\u4e2d\u6ca1\u6709ZShop\u76f8\u5173\u7684\u6807\u8bb0!");
                    System.exit(0);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File f = new File(this.fileName);
        if (!f.exists()) {
            throw new RuntimeException(f.getAbsolutePath() + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        SAXReader reader = new SAXReader(false);
        Document doc = reader.read(f);
        Element root = doc.getRootElement();
        String txt = FileUtil.readText((File)f);
        this.isOracle = txt.toLowerCase().indexOf("target=\"oracle") > 0;
        this.nso = root.getNamespaceForPrefix("o");
        this.nsc = root.getNamespaceForPrefix("c");
        this.nsa = root.getNamespaceForPrefix("a");
        Element rootObject = root.element(new QName("RootObject", this.nso));
        Element children = rootObject.element(new QName("Children", this.nsc));
        Element model = children.element(new QName("Model", this.nso));
        if (model.attributeValue("ID") == null) {
            if (model.attributeValue("Id") != null) {
                this.aID = "Id";
            } else {
                throw new RuntimeException("ID\u5c5e\u6027\u540d\u79f0\u672a\u5b9a\uff0cPDM\u7248\u672c\u4e0d\u6b63\u786e");
            }
        }
        List tables = model.element(new QName("Tables", this.nsc)).elements();
        for (int i = 0; i < tables.size(); ++i) {
            try {
                this.generateOneTable((Element)tables.get(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void generateOneTable(Element table) {
        String tableName = table.elementText(new QName("Name", this.nsa));
        String tableCode = table.elementText(new QName("Code", this.nsa));
        String tableComment = table.elementText(new QName("Comment", this.nsa));
        Element eColumns = table.element(new QName("Columns", this.nsc));
        if (eColumns == null) {
            LogUtil.error((Object)("\u6ca1\u6709\u4e3a\u8868" + tableCode + "\u5b9a\u4e49\u5217!"));
            return;
        }
        List columns = eColumns.elements();
        SchemaColumn[] scs = new SchemaColumn[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            SchemaColumn sc = new SchemaColumn(this);
            Element column = (Element)columns.get(i);
            sc.ID = column.attributeValue(this.aID);
            sc.Name = column.elementText(new QName("Name", this.nsa));
            sc.Code = column.elementText(new QName("Code", this.nsa));
            sc.Comment = column.elementText(new QName("Comment", this.nsa));
            sc.DataType = column.elementText(new QName("DataType", this.nsa));
            String length = column.elementText(new QName("Length", this.nsa));
            try {
                if (length != null && !length.equals("")) {
                    sc.Length = Integer.parseInt(length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String precision = column.elementText(new QName("Precision", this.nsa));
            try {
                if (precision != null && !precision.equals("")) {
                    sc.Precision = Integer.parseInt(precision);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String mandatory = column.elementText(new QName("Mandatory", this.nsa));
            sc.Mandatory = mandatory != null && !mandatory.equals("") && !mandatory.equals("0");
            scs[i] = sc;
        }
        Element primaryKey = table.element(new QName("PrimaryKey", this.nsc));
        String keyRef = null;
        if (primaryKey != null && (primaryKey = primaryKey.element(new QName("Key", this.nso))) != null) {
            keyRef = primaryKey.attributeValue("Ref");
        }
        if (keyRef != null) {
            List keys = table.element(new QName("Keys", this.nsc)).elements();
            boolean keyFlag = false;
            for (int i = 0; i < keys.size(); ++i) {
                Element eKeyColumn;
                Element key = (Element)keys.get(i);
                if (!keyRef.equals(key.attributeValue(this.aID)) || (eKeyColumn = key.element(new QName("Key.Columns", this.nsc))) == null) continue;
                List keyColumns = eKeyColumn.elements();
                for (int j = 0; j < keyColumns.size(); ++j) {
                    String columnID = ((Element)keyColumns.get(j)).attributeValue("Ref");
                    for (int k = 0; k < scs.length; ++k) {
                        if (!scs[k].ID.equals(columnID)) continue;
                        scs[k].isPrimaryKey = true;
                    }
                }
                keyFlag = true;
                break;
            }
            if (!keyFlag) {
                LogUtil.error((Object)("\u8868" + tableCode + "\u672a\u627e\u5230\u4e3b\u952e!"));
            }
        }
        if (!this.checkCode(tableCode, "\u8868\u4ee3\u7801")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer dsb = new StringBuffer();
        StringBuffer hsb = new StringBuffer();
        StringBuffer svsb = new StringBuffer();
        StringBuffer gvsb = new StringBuffer();
        StringBuffer csb = new StringBuffer();
        StringBuffer isb = new StringBuffer();
        StringBuffer insertsb = new StringBuffer();
        StringBuffer updatesb = new StringBuffer();
        StringBuffer pksb = new StringBuffer();
        StringBuffer keysb = new StringBuffer();
        sb.append("package " + this.namespace + ";\n\n");
        isb.append("import com.sobey.bsp.framework.data.DataColumn;\n");
        isb.append("import com.sobey.bsp.framework.orm.Schema;\n");
        isb.append("import com.sobey.bsp.framework.orm.SchemaSet;\n");
        isb.append("import com.sobey.bsp.framework.orm.SchemaColumn;\n");
        isb.append("import com.sobey.bsp.framework.data.QueryBuilder;\n");
        hsb.append("\tpublic static final SchemaColumn[] _Columns = new SchemaColumn[] {\n");
        svsb.append("\tpublic void setV(int i, Object v) {\n");
        gvsb.append("\tpublic Object getV(int i) {\n");
        insertsb.append("\tprotected static final String _InsertAllSQL = \"insert into " + tableCode + " values(");
        updatesb.append("\tprotected static final String _UpdateAllSQL = \"update " + tableCode + " set ");
        pksb.append(" where ");
        boolean dateFlag = false;
        boolean blobFlag = false;
        boolean firstPKFlag = true;
        for (int i = 0; i < scs.length; ++i) {
            String code = scs[i].Code;
            if (i == 0) {
                insertsb.append("?");
                updatesb.append(code + "=?");
            } else {
                insertsb.append(",?");
                updatesb.append("," + code + "=?");
            }
            if (scs[i].isPrimaryKey) {
                if (firstPKFlag) {
                    pksb.append(code + "=?");
                    keysb.append(code);
                    firstPKFlag = false;
                } else {
                    pksb.append(" and " + code + "=?");
                    keysb.append(", " + code);
                }
            }
            if (!this.checkCode(code, "\u8868" + tableCode + "\u7684\u5b57\u6bb5")) {
                return;
            }
            String dataType = scs[i].DataType;
            if (dataType == null || dataType.equals("")) {
                LogUtil.error((Object)(this.fileName + "\u4e2d\u8868" + tableCode + "\u7684\u5b57\u6bb5" + code + "\u7684\u6570\u636e\u7c7b\u578b\u672a\u5b9a\u4e49!"));
                return;
            }
            String type = dataType.toLowerCase().trim();
            String ctype = null;
            String vtype = null;
            if (type.startsWith("nvarchar") || type.startsWith("varchar") || type.startsWith("char") || type.startsWith("nchar") || type.startsWith("enum")) {
                type = "String";
                ctype = "STRING";
                vtype = type;
            } else if (type.startsWith("long varchar") || type.startsWith("ntext") || type.startsWith("text") || type.startsWith("mediumtext") || type.startsWith("longtext") || type.startsWith("clob")) {
                type = "String";
                ctype = "CLOB";
                vtype = type;
            } else if (type.startsWith("int") || type.startsWith("bit") || type.startsWith("smallint") || type.startsWith("tinyint") || type.startsWith("mediumint")) {
                type = "int";
                ctype = "INTEGER";
                vtype = "Integer";
                if (this.isOracle && type.startsWith("int")) {
                    type = "long";
                    ctype = "LONG";
                    vtype = "Long";
                }
            } else if (type.startsWith("long") || type.startsWith("bigint")) {
                type = "long";
                ctype = "LONG";
                vtype = "Long";
            } else if (type.startsWith("float")) {
                type = "float";
                ctype = "FLOAT";
                vtype = "Float";
            } else if (type.startsWith("double") || type.startsWith("decimal") || type.startsWith("number")) {
                type = "double";
                ctype = "DOUBLE";
                vtype = "Double";
            } else if (type.startsWith("blob") || type.startsWith("image")) {
                type = "byte[]";
                ctype = "BLOB";
                vtype = type;
            } else if (type.startsWith("date") || type.startsWith("time")) {
                type = "Date";
                ctype = "DATETIME";
                vtype = type;
                dateFlag = true;
            } else {
                LogUtil.error((Object)(tableCode + "\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b" + type));
                return;
            }
            dsb.append("\tprivate " + vtype + " " + scs[i].Code + ";\n\n");
            String uCode = code.substring(0, 1).toUpperCase() + code.substring(1);
            csb.append("\t/**\n");
            csb.append("\t* \u83b7\u53d6\u5b57\u6bb5" + code + "\u7684\u503c\uff0c\u8be5\u5b57\u6bb5\u7684<br>\n");
            csb.append("\t* \u5b57\u6bb5\u540d\u79f0 :" + scs[i].Name + "<br>\n");
            csb.append("\t* \u6570\u636e\u7c7b\u578b :" + scs[i].DataType + "<br>\n");
            csb.append("\t* \u662f\u5426\u4e3b\u952e :" + scs[i].isPrimaryKey + "<br>\n");
            csb.append("\t* \u662f\u5426\u5fc5\u586b :" + scs[i].Mandatory + "<br>\n");
            if (scs[i].Comment != null) {
                csb.append("\t* \u5907\u6ce8\u4fe1\u606f :<br>\n");
                this.splitComment(csb, scs[i].Comment, "\t");
            }
            csb.append("\t*/\n");
            csb.append("\tpublic " + type + " get" + uCode + "() {\n");
            if (vtype.equals("Float") || vtype.equals("Integer") || vtype.equals("Long") || vtype.equals("Double")) {
                csb.append("\t\tif(" + code + "==null){return 0;}\n");
                csb.append("\t\treturn " + code + "." + type + "Value();\n");
            } else {
                csb.append("\t\treturn " + code + ";\n");
            }
            csb.append("\t}\n\n");
            csb.append("\t/**\n");
            csb.append("\t* \u8bbe\u7f6e\u5b57\u6bb5" + code + "\u7684\u503c\uff0c\u8be5\u5b57\u6bb5\u7684<br>\n");
            csb.append("\t* \u5b57\u6bb5\u540d\u79f0 :" + scs[i].Name + "<br>\n");
            csb.append("\t* \u6570\u636e\u7c7b\u578b :" + scs[i].DataType + "<br>\n");
            csb.append("\t* \u662f\u5426\u4e3b\u952e :" + scs[i].isPrimaryKey + "<br>\n");
            csb.append("\t* \u662f\u5426\u5fc5\u586b :" + scs[i].Mandatory + "<br>\n");
            if (scs[i].Comment != null) {
                csb.append("\t* \u5907\u6ce8\u4fe1\u606f :<br>\n");
                this.splitComment(csb, scs[i].Comment, "\t");
            }
            csb.append("\t*/\n");
            String tCode = code.substring(0, 1).toLowerCase() + code.substring(1);
            csb.append("\tpublic void set" + uCode + "(" + type + " " + tCode + ") {\n");
            if (vtype.equals("Float") || vtype.equals("Integer") || vtype.equals("Long") || vtype.equals("Double")) {
                csb.append("\t\tthis." + code + " = new " + vtype + "(" + tCode + ");\n");
            } else {
                csb.append("\t\tthis." + code + " = " + tCode + ";\n");
            }
            csb.append("    }\n\n");
            if (vtype.equals("Float") || vtype.equals("Integer") || vtype.equals("Long") || vtype.equals("Double")) {
                csb.append("\t/**\n");
                csb.append("\t* \u8bbe\u7f6e\u5b57\u6bb5" + code + "\u7684\u503c\uff0c\u8be5\u5b57\u6bb5\u7684<br>\n");
                csb.append("\t* \u5b57\u6bb5\u540d\u79f0 :" + scs[i].Name + "<br>\n");
                csb.append("\t* \u6570\u636e\u7c7b\u578b :" + scs[i].DataType + "<br>\n");
                csb.append("\t* \u662f\u5426\u4e3b\u952e :" + scs[i].isPrimaryKey + "<br>\n");
                csb.append("\t* \u662f\u5426\u5fc5\u586b :" + scs[i].Mandatory + "<br>\n");
                if (scs[i].Comment != null) {
                    csb.append("\t* \u5907\u6ce8\u4fe1\u606f :<br>\n");
                    this.splitComment(csb, scs[i].Comment, "\t");
                }
                csb.append("\t*/\n");
                csb.append("\tpublic void set" + uCode + "(String " + tCode + ") {\n");
                csb.append("\t\tif (" + tCode + " == null){\n");
                csb.append("\t\t\tthis." + code + " = null;\n");
                csb.append("\t\t\treturn;\n");
                csb.append("\t\t}\n");
                csb.append("\t\tthis." + code + " = new " + vtype + "(" + tCode + ");\n");
                csb.append("    }\n\n");
            }
            hsb.append("\t\tnew SchemaColumn(\"" + code + "\", DataColumn." + ctype + ", " + i + ", " + scs[i].Length + " , " + scs[i].Precision + " , " + scs[i].Mandatory + " , " + scs[i].isPrimaryKey + ")");
            if (i < scs.length - 1) {
                hsb.append(",\n");
            } else {
                hsb.append("\n");
            }
            if (vtype.equals("Float") || vtype.equals("Integer") || vtype.equals("Long") || vtype.equals("Double")) {
                svsb.append("\t\tif (i == " + i + "){if(v==null){" + code + " = null;}else{" + code + " = new " + vtype + "(v.toString());}return;}\n");
            } else {
                svsb.append("\t\tif (i == " + i + "){" + code + " = (" + vtype + ")v;return;}\n");
            }
            gvsb.append("\t\tif (i == " + i + "){return " + code + ";}\n");
        }
        if (dateFlag) {
            isb.append("import java.util.Date;\n");
        }
        isb.append("\n");
        sb.append(isb);
        sb.append("/**\n");
        sb.append(" * \u8868\u540d\u79f0\uff1a" + tableName);
        sb.append("<br>\n * \u8868\u4ee3\u7801\uff1a" + tableCode);
        if (tableComment != null) {
            sb.append("<br>\n * \u8868\u5907\u6ce8\uff1a<br>\n" + tableComment);
            this.splitComment(sb, tableComment, "");
        }
        sb.append("<br>\n * \u8868\u4e3b\u952e\uff1a" + keysb);
        sb.append("<br>\n */\n");
        sb.append("public class " + tableCode + "Schema extends Schema {\n");
        sb.append(dsb);
        hsb.append("\t};\n\n");
        hsb.append("\tpublic static final String _TableCode = \"" + tableCode + "\";\n\n");
        hsb.append("\tpublic static final String _NameSpace = \"" + this.namespace + "\";\n\n");
        insertsb.append(")\";\n\n");
        updatesb.append("");
        updatesb.append(pksb);
        updatesb.append("\";\n\n");
        hsb.append(insertsb);
        hsb.append(updatesb);
        hsb.append("\tprotected static final String _DeleteSQL = \"delete from " + tableCode + " " + pksb.toString() + "\";\n\n");
        hsb.append("\tprotected static final String _FillAllSQL = \"select * from " + tableCode + " " + pksb.toString() + "\";\n\n");
        hsb.append("\tpublic " + tableCode + "Schema(){\n");
        hsb.append("\t\tTableCode = _TableCode;\n");
        hsb.append("\t\tNameSpace = _NameSpace;\n");
        hsb.append("\t\tColumns = _Columns;\n");
        hsb.append("\t\tInsertAllSQL = _InsertAllSQL;\n");
        hsb.append("\t\tUpdateAllSQL = _UpdateAllSQL;\n");
        hsb.append("\t\tDeleteSQL = _DeleteSQL;\n");
        hsb.append("\t\tFillAllSQL = _FillAllSQL;\n");
        hsb.append("\t\tHasSetFlag = new boolean[" + scs.length + "];\n");
        hsb.append("\t}\n\n");
        hsb.append("\tprotected Schema newInstance(){\n");
        hsb.append("\t\treturn new " + tableCode + "Schema();\n");
        hsb.append("\t}\n\n");
        hsb.append("\tprotected SchemaSet newSet(){\n");
        hsb.append("\t\treturn new " + tableCode + "Set();\n");
        hsb.append("\t}\n\n");
        hsb.append("\tpublic " + tableCode + "Set query() {\n");
        hsb.append("\t\treturn query(null, -1, -1);\n");
        hsb.append("\t}\n\n");
        hsb.append("\tpublic " + tableCode + "Set query(QueryBuilder qb) {\n");
        hsb.append("\t\treturn query(qb, -1, -1);\n");
        hsb.append("\t}\n\n");
        hsb.append("\tpublic " + tableCode + "Set query(int pageSize, int pageIndex) {\n");
        hsb.append("\t\treturn query(null, pageSize, pageIndex);\n");
        hsb.append("\t}\n\n");
        hsb.append("\tpublic " + tableCode + "Set query(QueryBuilder qb , int pageSize, int pageIndex){\n");
        hsb.append("\t\treturn (" + tableCode + "Set)querySet(qb , pageSize , pageIndex);\n");
        hsb.append("\t}\n\n");
        svsb.append("\t}\n\n");
        gvsb.append("\t\treturn null;\n");
        gvsb.append("\t}\n\n");
        sb.append(hsb);
        sb.append(svsb);
        sb.append(gvsb);
        sb.append(csb);
        sb.append("}");
        FileUtil.writeText((String)(this.outputDir + "/" + tableCode + "Schema.java"), (String)sb.toString());
        this.generateSet(tableCode);
    }

    private void generateSet(String tableCode) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("package " + this.namespace + ";\n\n");
        sb.append("import " + this.namespace + "." + tableCode + "Schema;\n");
        sb.append("import com.sobey.bsp.framework.orm.SchemaSet;\n\n");
        sb.append("public class " + tableCode + "Set extends SchemaSet {\n");
        sb.append("\tpublic " + tableCode + "Set() {\n");
        sb.append("\t\tthis(10,0);\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic " + tableCode + "Set(int initialCapacity) {\n");
        sb.append("\t\tthis(initialCapacity,0);\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic " + tableCode + "Set(int initialCapacity,int capacityIncrement) {\n");
        sb.append("\t\tsuper(initialCapacity,capacityIncrement);\n");
        sb.append("\t\tTableCode = " + tableCode + "Schema._TableCode;\n");
        sb.append("\t\tColumns = " + tableCode + "Schema._Columns;\n");
        sb.append("\t\tNameSpace = " + tableCode + "Schema._NameSpace;\n");
        sb.append("\t\tInsertAllSQL = " + tableCode + "Schema._InsertAllSQL;\n");
        sb.append("\t\tUpdateAllSQL = " + tableCode + "Schema._UpdateAllSQL;\n");
        sb.append("\t\tFillAllSQL = " + tableCode + "Schema._FillAllSQL;\n");
        sb.append("\t\tDeleteSQL = " + tableCode + "Schema._DeleteSQL;\n");
        sb.append("\t}\n\n");
        sb.append("\tprotected SchemaSet newInstance(){\n");
        sb.append("\t\treturn new " + tableCode + "Set();\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic boolean add(" + tableCode + "Schema aSchema) {\n");
        sb.append("\t\treturn super.add(aSchema);\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic boolean add(" + tableCode + "Set aSet) {\n");
        sb.append("\t\treturn super.add(aSet);\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic boolean remove(" + tableCode + "Schema aSchema) {\n");
        sb.append("\t\treturn super.remove(aSchema);\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic " + tableCode + "Schema get(int index) {\n");
        sb.append("\t\t" + tableCode + "Schema tSchema = (" + tableCode + "Schema) super.getObject(index);\n");
        sb.append("\t\treturn tSchema;\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic boolean set(int index, " + tableCode + "Schema aSchema) {\n");
        sb.append("\t\treturn super.set(index, aSchema);\n");
        sb.append("\t}\n\n");
        sb.append("\tpublic boolean set(" + tableCode + "Set aSet) {\n");
        sb.append("\t\treturn super.set(aSet);\n");
        sb.append("\t}\n");
        sb.append("}\n ");
        FileUtil.writeText((String)(this.outputDir + "/" + tableCode + "Set.java"), (String)sb.toString());
    }

    private void splitComment(StringBuffer sb, String comment, String tab) {
        String[] a = comment.split("\n");
        for (int i = 0; i < a.length; ++i) {
            if (a[i].trim().equals("")) continue;
            sb.append(tab);
            sb.append(a[i].trim());
            sb.append("<br>\n");
        }
    }

    private boolean checkCode(String code, String msgPrefix) {
        char[] ca = code.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ca[i])) continue;
                LogUtil.error((Object)(msgPrefix + code + "\u4e0d\u662f\u5408\u9002\u7684Java\u6807\u5fd7\u540d"));
                return false;
            }
            if (Character.isJavaIdentifierPart(ca[i])) continue;
            LogUtil.error((Object)(msgPrefix + code + "\u4e0d\u662f\u5408\u9002\u7684Java\u6807\u5fd7\u540d"));
            return false;
        }
        return true;
    }

    public static void dealFile(String fileName, String namespace, String outputDir) {
        BackupTableGenerator btg = new BackupTableGenerator();
        btg.setFileName(fileName);
        try {
            btg.toBackupTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SchemaGenerator og = new SchemaGenerator();
        og.setFileName(fileName);
        og.setOutputDir(outputDir);
        og.setNamespace(namespace);
        try {
            og.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        og.setFileName(fileName.substring(0, fileName.length() - 4) + "_B.pdm");
        og.setOutputDir(outputDir);
        og.setNamespace(namespace);
        try {
            og.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void execute(String packageStr) {
        String str = Config.getValue((String)"App.PDM");
        String[] files = str.split("\\,");
        String prefix = Config.getContextRealPath();
        prefix = prefix.substring(0, prefix.length() - 2);
        prefix = prefix.substring(0, prefix.lastIndexOf("/") + 1);
        String javapath = prefix + "Java/" + packageStr.replaceAll("\\.", "/");
        FileUtil.mkdir((String)javapath);
        FileUtil.deleteEx((String)(javapath + "/.+java"));
        for (int i = 0; i < files.length; ++i) {
            String fileName = "DB/" + files[i] + ".pdm";
            SchemaGenerator.dealFile((String)fileName, (String)packageStr, (String)javapath);
        }
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

