/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DBConn;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaColumn;
import com.sobey.bsp.framework.orm.SchemaUtil;
import com.sobey.bsp.framework.utility.Filter;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public abstract class SchemaSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Schema[] elementData;
    private int elementCount;
    private int capacityIncrement;
    protected String TableCode;
    protected String NameSpace;
    protected SchemaColumn[] Columns;
    protected String InsertAllSQL;
    protected String UpdateAllSQL;
    protected String FillAllSQL;
    protected String DeleteSQL;
    protected int bConnFlag = 0;
    protected boolean bOperateFlag = false;
    protected int[] operateColumnOrders;
    protected transient DataAccess mDataAccess;

    protected SchemaSet(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new RuntimeException("SchemaSet\u7684\u521d\u59cb\u5bb9\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.elementData = new Schema[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.elementCount = 0;
    }

    protected SchemaSet(int initialCapacity) {
        this(initialCapacity, 0);
    }

    protected SchemaSet() {
        this(10);
    }

    public void setDataAccess(DataAccess dAccess) {
        this.mDataAccess = dAccess;
        this.bConnFlag = 1;
    }

    public boolean add(Schema s) {
        if (s == null || s.TableCode != this.TableCode) {
            LogUtil.warn((Object)("\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u662f\u4e00\u4e2a" + this.TableCode + "Schema"));
            return false;
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount] = s;
        ++this.elementCount;
        return true;
    }

    public boolean add(SchemaSet aSet) {
        if (aSet == null) {
            return false;
        }
        int n = aSet.size();
        this.ensureCapacityHelper(this.elementCount + n);
        for (int i = 0; i < n; ++i) {
            this.elementData[this.elementCount + i] = aSet.getObject(i);
        }
        this.elementCount += n;
        return true;
    }

    public boolean remove(Schema aSchema) {
        if (aSchema == null) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!aSchema.equals(this.elementData[i])) continue;
            int j = this.elementCount - i - 1;
            if (j > 0) {
                System.arraycopy(this.elementData, i + 1, this.elementData, i, j);
            }
            --this.elementCount;
            this.elementData[this.elementCount] = null;
            return true;
        }
        return false;
    }

    public boolean removeRange(int index, int length) {
        if (index < 0 || length < 0 || index + length > this.elementCount) {
            return false;
        }
        if (this.elementCount > index + length) {
            System.arraycopy(this.elementData, index + length, this.elementData, index, length);
        }
        for (int i = 0; i < length; ++i) {
            this.elementData[this.elementCount - i - 1] = null;
        }
        this.elementCount -= length;
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Schema getObject(int index) {
        if (index > this.elementCount) {
            throw new RuntimeException("SchemaSet\u7d22\u5f15\u8fc7\u5927," + index);
        }
        return this.elementData[index];
    }

    public boolean set(int index, Schema aSchema) {
        if (index > this.elementCount) {
            throw new RuntimeException("SchemaSet\u7d22\u5f15\u8fc7\u5927," + index);
        }
        this.elementData[index] = aSchema;
        return true;
    }

    public boolean set(SchemaSet aSet) {
        this.elementData = aSet.elementData;
        this.elementCount = aSet.elementCount;
        this.capacityIncrement = aSet.capacityIncrement;
        return true;
    }

    public int size() {
        return this.elementCount;
    }

    private void ensureCapacityHelper(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            Schema[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Schema[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public boolean insert() {
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        Statement pstmt = null;
        try {
            DBConn conn = this.mDataAccess.getConnection();
            boolean autoComit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(this.InsertAllSQL, 1003, 1007);
            for (int k = 0; k < this.elementCount; ++k) {
                for (int i = 0; i < this.Columns.length; ++i) {
                    Schema schema = this.elementData[k];
                    SchemaColumn sc = this.Columns[i];
                    if (sc.isMandatory() && schema.getV(i) == null) {
                        LogUtil.warn((Object)("\u8868" + this.TableCode + "\u7684\u5217" + sc.getColumnName() + "\u4e0d\u80fd\u4e3a\u7a7a"));
                        boolean bl = false;
                        return bl;
                    }
                    Object v = schema.getV(i);
                    SchemaUtil.setParam((SchemaColumn)sc, (PreparedStatement)pstmt, (DBConn)conn, (int)i, (Object)v);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (this.bConnFlag == 0) {
                conn.commit();
            }
            conn.setAutoCommit(autoComit);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            throw new RuntimeException(e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                pstmt = null;
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        String sql = this.UpdateAllSQL;
        if (this.bOperateFlag) {
            StringBuffer sb = new StringBuffer("update " + this.TableCode + " set ");
            for (int i = 0; i < this.operateColumnOrders.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.Columns[this.operateColumnOrders[i]].getColumnName());
                sb.append("=?");
            }
            sb.append(sql.substring(sql.indexOf(" where")));
            sql = sb.toString();
        }
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        Statement pstmt = null;
        try {
            DBConn conn = this.mDataAccess.getConnection();
            boolean autoComit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(sql, 1003, 1007);
            for (int k = 0; k < this.elementCount; ++k) {
                int i;
                Schema schema = this.elementData[k];
                if (this.bOperateFlag) {
                    for (i = 0; i < this.operateColumnOrders.length; ++i) {
                        Object v = schema.getV(this.operateColumnOrders[i]);
                        SchemaUtil.setParam((SchemaColumn)this.Columns[this.operateColumnOrders[i]], (PreparedStatement)pstmt, (DBConn)conn, (int)this.operateColumnOrders[i], (Object)v);
                    }
                } else {
                    for (i = 0; i < this.Columns.length; ++i) {
                        Object v = schema.getV(i);
                        SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)i, (Object)v);
                    }
                }
                int j = 0;
                for (i = 0; i < this.Columns.length; ++i) {
                    SchemaColumn sc = this.Columns[i];
                    if (!sc.isPrimaryKey()) continue;
                    Object v = schema.getV(sc.getColumnOrder());
                    if (v == null) {
                        LogUtil.warn((Object)("\u4e0d\u6ee1\u8db3Update\u7684\u6761\u4ef6\uff0c" + this.TableCode + "Schema\u7684" + sc.getColumnName() + "\u4e3a\u7a7a"));
                        boolean bl = false;
                        return bl;
                    }
                    if (this.bOperateFlag) {
                        SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)(j + this.operateColumnOrders.length), (Object)v);
                    } else {
                        SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)(j + this.Columns.length), (Object)v);
                    }
                    ++j;
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (this.bConnFlag == 0) {
                conn.commit();
            }
            conn.setAutoCommit(autoComit);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                pstmt = null;
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        if (this.bConnFlag == 0) {
            this.mDataAccess = new DataAccess();
        }
        Statement pstmt = null;
        try {
            DBConn conn = this.mDataAccess.getConnection();
            boolean autoComit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(this.DeleteSQL, 1003, 1007);
            for (int k = 0; k < this.elementCount; ++k) {
                Schema schema = this.elementData[k];
                int j = 0;
                for (int i = 0; i < this.Columns.length; ++i) {
                    SchemaColumn sc = this.Columns[i];
                    if (!sc.isPrimaryKey()) continue;
                    Object v = schema.getV(sc.getColumnOrder());
                    if (v == null) {
                        LogUtil.warn((Object)("\u4e0d\u6ee1\u8db3delete\u7684\u6761\u4ef6\uff0c" + this.TableCode + "Schema\u7684" + sc.getColumnName() + "\u4e3a\u7a7a"));
                        boolean bl = false;
                        return bl;
                    }
                    SchemaUtil.setParam((SchemaColumn)this.Columns[i], (PreparedStatement)pstmt, (DBConn)conn, (int)j, (Object)v);
                    ++j;
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (this.bConnFlag == 0) {
                conn.commit();
            }
            conn.setAutoCommit(autoComit);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            LogUtil.warn((Object)("\u64cd\u4f5c\u8868" + this.TableCode + "\u65f6\u53d1\u751f\u9519\u8bef:" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                pstmt = null;
            }
            if (this.bConnFlag == 0) {
                try {
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAndInsert() {
        if (this.bConnFlag == 1) {
            if (!this.delete()) {
                return false;
            }
            return this.insert();
        }
        this.mDataAccess = new DataAccess();
        this.bConnFlag = 1;
        try {
            this.mDataAccess.setAutoCommit(false);
            this.delete();
            this.insert();
            this.mDataAccess.commit();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                this.mDataAccess.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.mDataAccess.setAutoCommit(true);
                this.mDataAccess.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.mDataAccess = null;
            this.bConnFlag = 0;
        }
    }

    public boolean deleteAndBackup() {
        return this.deleteAndBackup(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteAndBackup(String backupOperator, String backupMemo) {
        try {
            int k;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? User.getUserName() : backupOperator;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? "admin" : backupOperator;
            System.out.println("tableCode -------" + this.TableCode);
            String firstCode = this.TableCode.substring(0, this.TableCode.indexOf("_") + 1);
            String secondCode = this.TableCode.substring(this.TableCode.indexOf("_") + 1);
            secondCode = secondCode.substring(0, 1).toLowerCase() + secondCode.substring(1);
            Class<?> c = null;
            Class<?> s = null;
            try {
                c = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Schema");
                s = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Set");
            }
            catch (Exception e2) {
                System.out.println("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5907\u4efd\u8868 ,\u4e0d\u9700\u8981\u5907\u4efd!");
                return this.delete();
            }
            SchemaSet bSet = (SchemaSet)s.newInstance();
            Date now = new Date();
            for (k = 0; k < this.elementCount; k += 1) {
                int i;
                Schema schema = this.elementData[k];
                Schema bSchema = (Schema)c.newInstance();
                for (i = 0; i < this.Columns.length; ++i) {
                    bSchema.setV(i, schema.getV(i));
                }
                bSchema.setV(i, (Object)SchemaUtil.getBackupNo());
                bSchema.setV(i + 1, (Object)backupOperator);
                bSchema.setV(i + 2, (Object)now);
                bSchema.setV(i + 3, (Object)backupMemo);
                bSet.add(bSchema);
            }
            if (this.bConnFlag == 1) {
                bSet.setDataAccess(this.mDataAccess);
                if (!this.delete()) {
                    return true;
                }
                bSet.insert();
                return true;
            }
            this.mDataAccess = new DataAccess();
            this.bConnFlag = 1;
            bSet.setDataAccess(this.mDataAccess);
            try {
                this.mDataAccess.setAutoCommit(false);
                this.delete();
                bSet.insert();
                this.mDataAccess.commit();
                k = 1;
                return k != 0;
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    this.mDataAccess.rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    this.mDataAccess.setAutoCommit(true);
                    this.mDataAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.mDataAccess = null;
                this.bConnFlag = 0;
            }
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    public boolean backup() {
        return this.backup(null, null);
    }

    public boolean backup(String backupOperator, String backupMemo) {
        try {
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? User.getUserName() : backupOperator;
            backupOperator = StringUtil.isEmpty((String)backupOperator) ? "admin" : backupOperator;
            String firstCode = this.TableCode.substring(0, this.TableCode.indexOf("_") + 1);
            String secondCode = this.TableCode.substring(this.TableCode.indexOf("_") + 1);
            secondCode = secondCode.substring(0, 1).toLowerCase() + secondCode.substring(1);
            Class<?> c = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Schema");
            Class<?> s = Class.forName("com.sobey.bsp.schema." + firstCode + "B" + secondCode + "Set");
            SchemaSet bSet = (SchemaSet)s.newInstance();
            Date now = new Date();
            for (int k = 0; k < this.elementCount; ++k) {
                int i;
                Schema schema = this.elementData[k];
                Schema bSchema = (Schema)c.newInstance();
                for (i = 0; i < this.Columns.length; ++i) {
                    bSchema.setV(i, schema.getV(i));
                }
                bSchema.setV(i, (Object)SchemaUtil.getBackupNo());
                bSchema.setV(i + 1, (Object)backupOperator);
                bSchema.setV(i + 2, (Object)now);
                bSchema.setV(i + 3, (Object)backupMemo);
                bSet.add(bSchema);
            }
            if (this.bConnFlag == 1) {
                bSet.setDataAccess(this.mDataAccess);
            }
            return bSet.insert();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setOperateColumns(String[] colNames) {
        if (colNames == null || colNames.length == 0) {
            this.bOperateFlag = false;
            return;
        }
        this.operateColumnOrders = new int[colNames.length];
        int k = 0;
        for (int i = 0; i < colNames.length; ++i) {
            boolean flag = false;
            for (int j = 0; j < this.Columns.length; ++j) {
                if (!colNames[i].toString().toLowerCase().equals(this.Columns[j].getColumnName().toLowerCase())) continue;
                this.operateColumnOrders[k] = j;
                ++k;
                flag = true;
                break;
            }
            if (flag) continue;
            throw new RuntimeException("\u6307\u5b9a\u7684\u5217\u540d" + colNames[i] + "\u4e0d\u6b63\u786e");
        }
        this.bOperateFlag = true;
    }

    public void setOperateColumns(int[] colOrder) {
        if (colOrder == null || colOrder.length == 0) {
            this.bOperateFlag = false;
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i].setOperateColumns(colOrder);
        }
        this.operateColumnOrders = colOrder;
        this.bOperateFlag = true;
    }

    public DataTable toDataTable() {
        int i;
        if (this.bOperateFlag) {
            int i2;
            DataColumn[] dcs = new DataColumn[this.operateColumnOrders.length];
            Object[][] values = new Object[this.elementCount][this.Columns.length];
            for (i2 = 0; i2 < this.operateColumnOrders.length; ++i2) {
                DataColumn dc = new DataColumn();
                dc.setColumnName(this.Columns[this.operateColumnOrders[i2]].getColumnName());
                dc.setColumnType(this.Columns[this.operateColumnOrders[i2]].getColumnType());
                dcs[i2] = dc;
            }
            for (i2 = 0; i2 < this.elementCount; ++i2) {
                for (int j = 0; j < this.operateColumnOrders.length; ++j) {
                    values[i2][j] = this.elementData[i2].getV(this.operateColumnOrders[j]);
                }
            }
            DataTable dt = new DataTable(dcs, values);
            return dt;
        }
        DataColumn[] dcs = new DataColumn[this.Columns.length];
        Object[][] values = new Object[this.elementCount][this.Columns.length];
        for (i = 0; i < this.Columns.length; ++i) {
            DataColumn dc = new DataColumn();
            dc.setColumnName(this.Columns[i].getColumnName());
            dc.setColumnType(this.Columns[i].getColumnType());
            dcs[i] = dc;
        }
        for (i = 0; i < this.elementCount; ++i) {
            for (int j = 0; j < this.Columns.length; ++j) {
                values[i][j] = this.elementData[i].getV(j);
            }
        }
        DataTable dt = new DataTable(dcs, values);
        return dt;
    }

    public Object clone() {
        SchemaSet set = this.newInstance();
        for (int i = 0; i < this.size(); ++i) {
            set.add((Schema)this.elementData[i].clone());
        }
        return set;
    }

    public void sort(Comparator c) {
        Schema[] newData = new Schema[this.elementCount];
        System.arraycopy(this.elementData, 0, newData, 0, this.elementCount);
        Arrays.sort(newData, c);
        this.elementData = newData;
    }

    public void sort(String columnName) {
        this.sort(columnName, "desc", false);
    }

    public void sort(String columnName, String order) {
        this.sort(columnName, order, false);
    }

    public void sort(String columnName, String order, boolean isNumber) {
        String cn = columnName;
        String od = order;
        this.sort((Comparator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public SchemaSet filter(Filter filter) {
        SchemaSet set = this.newInstance();
        for (int i = 0; i < this.elementData.length; ++i) {
            if (!filter.filter((Object)this.elementData[i])) continue;
            set.add((Schema)this.elementData[i].clone());
        }
        return set;
    }

    protected abstract SchemaSet newInstance();
}

