/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.data.DBConn;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.LobUtil;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaColumn;
import com.sobey.bsp.framework.orm.SchemaSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaUtil {
    private static long BackupNoBase = System.currentTimeMillis();

    public static boolean deleteByCondition(Schema conditionSchema) {
        return SchemaUtil.deleteByCondition((Schema)conditionSchema, (DataAccess)new DataAccess(), (int)0);
    }

    public static boolean delete(Schema conditionSchema, DataAccess dAccess) {
        return SchemaUtil.deleteByCondition((Schema)conditionSchema, (DataAccess)dAccess, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteByCondition(Schema conditionSchema, DataAccess dAccess, int bConnFlag) {
        SchemaColumn[] columns = conditionSchema.Columns;
        boolean firstFlag = true;
        StringBuffer sb = new StringBuffer(128);
        sb.append("delete from " + conditionSchema.TableCode);
        for (int i = 0; i < columns.length; ++i) {
            SchemaColumn sc = columns[i];
            if (conditionSchema.isNull(sc)) continue;
            if (firstFlag) {
                sb.append(" where ");
                sb.append(sc.getColumnName());
                sb.append("=?");
                firstFlag = false;
                continue;
            }
            sb.append(" and ");
            sb.append(sc.getColumnName());
            sb.append("=?");
        }
        DBConn conn = dAccess.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sb.toString(), 1003, 1007);
            int j = 0;
            for (int i = 0; i < columns.length; ++i) {
                SchemaColumn sc = columns[i];
                Object v = conditionSchema.getV(sc.getColumnOrder());
                if (v == null) continue;
                if (sc.getColumnType() == 0) {
                    pstmt.setDate(j + 1, new java.sql.Date(((Date)v).getTime()));
                } else {
                    pstmt.setObject(j + 1, v);
                }
                ++j;
            }
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                pstmt = null;
            }
            if (bConnFlag == 0) {
                conn = null;
                try {
                    dAccess.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static boolean copyFieldValue(Schema srcSchema, Schema destSchema) {
        try {
            SchemaColumn[] srcSC = srcSchema.Columns;
            SchemaColumn[] destSC = destSchema.Columns;
            block2: for (int i = 0; i < srcSC.length; ++i) {
                for (int j = 0; j < destSC.length; ++j) {
                    if (!srcSC[i].getColumnName().equals(destSC[j].getColumnName())) continue;
                    int order = destSC[j].getColumnOrder();
                    Object v = srcSchema.getV(srcSC[i].getColumnOrder());
                    if (v instanceof Date) {
                        destSchema.setV(order, ((Date)v).clone());
                    }
                    if (v instanceof Double) {
                        destSchema.setV(order, (Object)new Double((Double)v));
                    }
                    if (v instanceof Float) {
                        destSchema.setV(order, (Object)new Float(((Float)v).floatValue()));
                    }
                    if (v instanceof Integer) {
                        destSchema.setV(order, (Object)new Integer((Integer)v));
                    }
                    if (v instanceof Long) {
                        destSchema.setV(order, (Object)new Long((Long)v));
                    }
                    if (v instanceof byte[]) {
                        destSchema.setV(order, ((byte[])v).clone());
                    }
                    if (!(v instanceof String)) continue block2;
                    destSchema.setV(order, v);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static Schema getZSchemaFromBSchema(Schema bSchema) {
        String TableCode = bSchema.TableCode;
        if (!TableCode.startsWith("BZ")) {
            throw new RuntimeException("\u5fc5\u987b\u4f20\u5165B\u8868\u7684Schema");
        }
        try {
            Class<?> c = Class.forName(bSchema.NameSpace + "." + TableCode.substring(1) + "Schema");
            Schema schema = (Schema)c.newInstance();
            for (int i = 0; i < schema.Columns.length; ++i) {
                schema.setV(i, bSchema.getV(i));
            }
            return schema;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized String getBackupNo() {
        return String.valueOf(BackupNoBase++).substring(1);
    }

    public static void setParam(SchemaColumn sc, PreparedStatement pstmt, DBConn conn, int i, Object v) throws SQLException {
        if (v == null) {
            pstmt.setNull(i + 1, 12);
        } else if (sc.getColumnType() == 0) {
            pstmt.setTimestamp(i + 1, new Timestamp(((Date)v).getTime()));
        } else if (sc.getColumnType() == 10) {
            LobUtil.setClob((DBConn)conn, (PreparedStatement)pstmt, (int)(i + 1), (Object)v);
        } else if (sc.getColumnType() == 2) {
            LobUtil.setBlob((DBConn)conn, (PreparedStatement)pstmt, (int)(i + 1), (byte[])((byte[])v));
        } else {
            pstmt.setObject(i + 1, v);
        }
    }

    public static String getTableCode(Schema schema) {
        return schema.TableCode;
    }

    public static String getNameSpace(Schema schema) {
        return schema.NameSpace;
    }

    public static SchemaColumn[] getColumns(Schema schema) {
        return schema.Columns;
    }

    public static String getTableCode(SchemaSet set) {
        return set.TableCode;
    }

    public static String getNameSpace(SchemaSet set) {
        return set.NameSpace;
    }

    public static SchemaColumn[] getColumns(SchemaSet set) {
        return set.Columns;
    }
}

