/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Constant;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataAccess;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaColumn;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableCreator {
    private ArrayList list = new ArrayList();
    private String DBType;

    public TableCreator(String dbType) {
        this.DBType = dbType;
    }

    public void createTable(SchemaColumn[] scs, String tableCode) throws Exception {
        this.createTable(scs, tableCode, true);
    }

    public void createTable(SchemaColumn[] scs, String tableCode, boolean create) throws Exception {
        if (!create) {
            this.list.add("delete from " + tableCode);
        } else {
            if (this.DBType.equals("MSSQL")) {
                this.createTableMSSQL(scs, tableCode);
            }
            if (this.DBType.equals("MYSQL")) {
                this.createTableMYSQL(scs, tableCode);
            }
            if (this.DBType.equals("ORACLE")) {
                this.createTableOracle(scs, tableCode);
            }
            if (this.DBType.equals("DB2")) {
                this.createTableDB2(scs, tableCode);
            }
        }
    }

    public void executeAndClear(Transaction tran) {
        for (int i = 0; i < this.list.size(); ++i) {
            QueryBuilder qb = new QueryBuilder(this.list.get(i).toString());
            tran.add(qb);
        }
        this.list.clear();
    }

    public String toSQLType(int columnType) {
        if (this.DBType.equals("MSSQL")) {
            if (columnType == 3) {
                return "numeric";
            }
            if (columnType == 2) {
                return "varbinary(MAX)";
            }
            if (columnType == 0) {
                return "datetime";
            }
            if (columnType == 4) {
                return "decimal";
            }
            if (columnType == 6) {
                return "numeric";
            }
            if (columnType == 5) {
                return "numeric";
            }
            if (columnType == 8) {
                return "int";
            }
            if (columnType == 7) {
                return "bigint";
            }
            if (columnType == 9) {
                return "int";
            }
            if (columnType == 1) {
                return "varchar";
            }
            if (columnType == 10) {
                return "text";
            }
        }
        if (this.DBType.equals("ORACLE")) {
            if (columnType == 3) {
                return "DOUBLE PRECISION";
            }
            if (columnType == 2) {
                return "BLOB";
            }
            if (columnType == 0) {
                return "DATE";
            }
            if (columnType == 4) {
                return "DECIMAL";
            }
            if (columnType == 6) {
                return "NUMBER";
            }
            if (columnType == 5) {
                return "NUMBER";
            }
            if (columnType == 8) {
                return "INTEGER";
            }
            if (columnType == 7) {
                return "INTEGER";
            }
            if (columnType == 9) {
                return "INTEGER";
            }
            if (columnType == 1) {
                return "VARCHAR2";
            }
            if (columnType == 10) {
                return "CLOB";
            }
        }
        if (this.DBType.equals("DB2")) {
            if (columnType == 3) {
                return "DOUBLE PRECISION";
            }
            if (columnType == 2) {
                return "BLOB";
            }
            if (columnType == 0) {
                return "TIMESTAMP";
            }
            if (columnType == 4) {
                return "DECIMAL";
            }
            if (columnType == 6) {
                return "NUMERIC";
            }
            if (columnType == 5) {
                return "NUMERIC";
            }
            if (columnType == 8) {
                return "INTEGER";
            }
            if (columnType == 7) {
                return "BIGINT";
            }
            if (columnType == 9) {
                return "INTEGER";
            }
            if (columnType == 1) {
                return "VARCHAR";
            }
            if (columnType == 10) {
                return "CLOB";
            }
        }
        if (this.DBType.equals("MYSQL")) {
            if (columnType == 3) {
                return "double";
            }
            if (columnType == 2) {
                return "binary varying(MAX)";
            }
            if (columnType == 0) {
                return "datetime";
            }
            if (columnType == 4) {
                return "decimal";
            }
            if (columnType == 6) {
                return "double";
            }
            if (columnType == 5) {
                return "float";
            }
            if (columnType == 8) {
                return "int";
            }
            if (columnType == 7) {
                return "bigint";
            }
            if (columnType == 9) {
                return "int";
            }
            if (columnType == 1) {
                return "varchar";
            }
            if (columnType == 10) {
                return "mediumtext";
            }
        }
        throw new RuntimeException("\u6570\u636e\u5e93\u7c7b\u578b\u9519\u8bef:" + this.DBType + "\uff0c\u6216\u5b57\u6bb5\u7c7b\u578b\u672a\u77e5:" + columnType);
    }

    private void createTableMSSQL(SchemaColumn[] scs, String tableCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + tableCode + "(\n");
        StringBuffer ksb = new StringBuffer();
        for (int i = 0; i < scs.length; ++i) {
            SchemaColumn sc = scs[i];
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append("\t" + sc.getColumnName() + " ");
            String sqlType = this.toSQLType(sc.getColumnType());
            sb.append(sqlType + " ");
            if (sc.getColumnType() == 1 || sqlType.equalsIgnoreCase("NUMERIC") || sqlType.equalsIgnoreCase("DECIMAL")) {
                if (sc.getLength() == 0 && sc.getColumnType() == 1) {
                    throw new RuntimeException("\u5fc5\u987b\u4e3avarchar\u7c7b\u578b\u8bbe\u5b9a\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5" + sc.getColumnName() + "\u7684\u8bbe\u7f6e");
                }
                sb.append(TableCreator.getFieldExtDesc((SchemaColumn)sc));
            }
            if (sc.isMandatory()) {
                sb.append("not null");
            }
            if (!sc.isPrimaryKey()) continue;
            if (ksb.length() == 0) {
                ksb.append("\tconstraint PK_" + tableCode + " primary key nonclustered (");
            } else {
                ksb.append(",");
            }
            ksb.append(sc.getColumnName());
        }
        if (ksb.length() != 0) {
            ksb.append(")");
            sb.append(",\n" + ksb);
        }
        sb.append("\n)");
        this.dropTable(tableCode);
        this.list.add(sb.toString());
    }

    private void createTableOracle(SchemaColumn[] scs, String tableCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + tableCode + "(\n");
        StringBuffer ksb = new StringBuffer();
        for (int i = 0; i < scs.length; ++i) {
            SchemaColumn sc = scs[i];
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append("\t" + sc.getColumnName() + " ");
            String sqlType = this.toSQLType(sc.getColumnType());
            sb.append(sqlType + " ");
            if (sc.getColumnType() == 1 || sqlType.equalsIgnoreCase("NUMBER") || sqlType.equalsIgnoreCase("DECIMAL")) {
                if (sc.getLength() == 0 && sc.getColumnType() == 1) {
                    throw new RuntimeException("\u5fc5\u987b\u4e3avarchar\u7c7b\u578b\u8bbe\u5b9a\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5" + sc.getColumnName() + "\u7684\u8bbe\u7f6e");
                }
                sb.append(TableCreator.getFieldExtDesc((SchemaColumn)sc));
            }
            if (sc.isMandatory()) {
                sb.append("not null");
            }
            if (!sc.isPrimaryKey()) continue;
            if (ksb.length() == 0) {
                ksb.append("\tconstraint PK_" + tableCode + " primary key (");
            } else {
                ksb.append(",");
            }
            ksb.append(sc.getColumnName());
        }
        if (ksb.length() != 0) {
            ksb.append(")");
            sb.append(",\n" + ksb);
        }
        sb.append("\n)");
        this.dropTable(tableCode);
        this.list.add(sb.toString());
    }

    private void createTableDB2(SchemaColumn[] scs, String tableCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + tableCode + "(\n");
        StringBuffer ksb = new StringBuffer();
        for (int i = 0; i < scs.length; ++i) {
            SchemaColumn sc = scs[i];
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append("\t" + sc.getColumnName() + " ");
            String sqlType = this.toSQLType(sc.getColumnType());
            sb.append(sqlType + " ");
            if (sc.getColumnType() == 1 || sqlType.equalsIgnoreCase("NUMERIC") || sqlType.equalsIgnoreCase("DECIMAL")) {
                if (sc.getLength() == 0 && sc.getColumnType() == 1) {
                    throw new RuntimeException("\u5fc5\u987b\u4e3avarchar2\u7c7b\u578b\u8bbe\u5b9a\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5" + sc.getColumnName() + "\u7684\u8bbe\u7f6e");
                }
                sb.append(TableCreator.getFieldExtDesc((SchemaColumn)sc));
            }
            if (sc.isMandatory()) {
                sb.append("not null");
            }
            if (!sc.isPrimaryKey()) continue;
            if (ksb.length() == 0) {
                String pkName = tableCode;
                if (pkName.length() > 15) {
                    pkName = pkName.substring(0, 15);
                }
                ksb.append("\tconstraint PK_" + pkName + " primary key (");
            } else {
                ksb.append(",");
            }
            ksb.append(sc.getColumnName());
        }
        if (ksb.length() != 0) {
            ksb.append(")");
            sb.append(",\n" + ksb);
        }
        sb.append("\n)");
        this.dropTable(tableCode);
        this.list.add(sb.toString());
    }

    private void createTableMYSQL(SchemaColumn[] scs, String tableCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + tableCode + "(\n");
        StringBuffer ksb = new StringBuffer();
        for (int i = 0; i < scs.length; ++i) {
            SchemaColumn sc = scs[i];
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append("\t" + sc.getColumnName() + " ");
            String sqlType = this.toSQLType(sc.getColumnType());
            sb.append(sqlType + " ");
            if (sc.getLength() == 0 && sc.getColumnType() == 1) {
                throw new RuntimeException("\u5fc5\u987b\u4e3avarchar\u7c7b\u578b\u8bbe\u5b9a\u957f\u5ea6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5" + sc.getColumnName() + "\u7684\u8bbe\u7f6e");
            }
            sb.append(TableCreator.getFieldExtDesc((SchemaColumn)sc));
            if (sc.isMandatory()) {
                sb.append("not null");
            }
            if (!sc.isPrimaryKey()) continue;
            if (ksb.length() == 0) {
                ksb.append("\tprimary key (");
            } else {
                ksb.append(",");
            }
            ksb.append(sc.getColumnName());
        }
        if (ksb.length() != 0) {
            ksb.append(")");
            sb.append(",\n" + ksb);
        }
        sb.append("\n) engine=InnoDB default charset=" + Constant.GlobalCharset.replaceAll("\\-", "").toLowerCase());
        this.dropTable(tableCode);
        this.list.add(sb.toString());
    }

    public void modifyTable(Transaction tran, Mapx map, ArrayList deletedList, SchemaColumn[] scs, String tableCode) throws Exception {
        int i;
        int count = 0;
        int size = 500;
        if ("true".equals(Config.getValue((String)"App.MinimalMemory"))) {
            size = 100;
        }
        try {
            QueryBuilder qb = new QueryBuilder("select * from " + tableCode);
            count = DataAccess.getCount((String)DBConnPool.getDBConnConfig().DBType, (QueryBuilder)qb);
            i = 0;
            while ((double)i < (double)count * 1.0 / (double)size) {
                DataTable dt = qb.executePagedDataTable(size, i);
                FileUtil.serialize((Serializable)dt, (String)(Config.getContextRealPath() + "/WEB-INF/data/_tmp_" + tableCode + "_" + i + ".dat"));
                ++i;
            }
        }
        catch (Exception qb) {
            // empty catch block
        }
        TableCreator tc = new TableCreator(this.DBType);
        tc.createTable(scs, tableCode);
        tc.executeAndClear(tran);
        i = 0;
        while ((double)i < (double)count * 1.0 / (double)size) {
            int j;
            String fileName = Config.getContextRealPath() + "/WEB-INF/data/_tmp_" + tableCode + "_" + i + ".dat";
            DataTable dt = (DataTable)FileUtil.unserialize((String)fileName);
            FileUtil.delete((String)fileName);
            StringBuffer sb = new StringBuffer("insert into " + tableCode + "(");
            for (j = 0; j < scs.length; ++j) {
                if (j != 0) {
                    sb.append(",");
                }
                sb.append(scs[j].getColumnName());
            }
            sb.append(") values (");
            for (j = 0; j < scs.length; ++j) {
                if (j != 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
            sb.append(")");
            QueryBuilder qb = new QueryBuilder(sb.toString());
            qb.setBatchMode(true);
            for (int j2 = 0; j2 < dt.getRowCount(); ++j2) {
                for (int k = 0; k < scs.length; ++k) {
                    SchemaColumn sc = scs[k];
                    String v = null;
                    v = map.containsKey((Object)sc.getColumnName()) ? dt.getString(j2, map.getString((Object)sc.getColumnName())) : dt.getString(j2, sc.getColumnName());
                    if (StringUtil.isEmpty((String)v)) {
                        v = null;
                    }
                    if (v != null) {
                        if (sc.getColumnType() == 0 && !StringUtil.verify((String)v, (String)"DateTime")) {
                            throw new RuntimeException("\u4fee\u6539\u81ea\u5b9a\u4e49\u8868\u5b57\u6bb5\u65f6\u53d1\u751f\u9519\u8bef,\u5b57\u6bb5\u503c\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f:" + dt.getDataRow(j2));
                        }
                        if (sc.getColumnType() == 8 || sc.getColumnType() == 9) {
                            v = String.valueOf(new Double(Double.parseDouble(v)).intValue());
                        }
                        if (sc.getColumnType() == 7) {
                            v = String.valueOf(new Double(Double.parseDouble(v)).longValue());
                        }
                        if (sc.getColumnType() == 5) {
                            v = String.valueOf(new Double(Double.parseDouble(v)).floatValue());
                        }
                        if (sc.getColumnType() == 4 || sc.getColumnType() == 6 || sc.getColumnType() == 3) {
                            v = String.valueOf(Double.parseDouble(v));
                        }
                    }
                    qb.add((Object)v);
                }
                qb.addBatch();
            }
            tran.add(qb);
            ++i;
        }
    }

    public void dropTable(String tableCode) {
        String dropSQL = null;
        if (this.DBType.equals("MSSQL")) {
            dropSQL = "if exists (select 1 from  sysobjects where id = object_id('" + tableCode + "') and type='U') drop table " + tableCode;
        }
        if (this.DBType.equals("ORACLE")) {
            dropSQL = "drop table " + tableCode + " cascade constraints";
        }
        if (this.DBType.equals("DB2")) {
            dropSQL = "drop table " + tableCode;
        }
        if (this.DBType.equals("MYSQL")) {
            dropSQL = "drop table if exists " + tableCode;
        }
        this.list.add(dropSQL);
    }

    public static String getFieldExtDesc(SchemaColumn sc) {
        if (sc.getLength() != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            sb.append(sc.getLength());
            if (sc.getPrecision() != 0) {
                sb.append(",");
                sb.append(sc.getPrecision());
            }
            sb.append(") ");
            return sb.toString();
        }
        return "";
    }
}

