/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.orm.hbase;

import com.sobey.bsp.framework.orm.hbase.PutSchema;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

/*
 * Exception performing whole class analysis ignored.
 */
public class HBaseTemplate {
    private static HBaseTemplate instance = new HBaseTemplate();
    private static Configuration conf = null;

    public static HBaseTemplate getInstance() {
        return instance;
    }

    public boolean exists(PutSchema schema) {
        try {
            HTable table = new HTable(conf, schema.getTableName());
            return table.exists(new Get(schema.getRowkey()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void put(PutSchema schema) {
        try {
            HTable table = new HTable(conf, schema.getTableName());
            Put put = new Put(schema.getRowkey());
            put.add(schema.getColumnFamily(), schema.getColumnQualifier(), schema.getValue());
            table.put(put);
            table.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void putList(List<PutSchema> schemaList, String tableName) {
        try {
            HTable table = new HTable(conf, tableName);
            ArrayList<Put> putList = new ArrayList<Put>();
            for (PutSchema schema : schemaList) {
                Put put = new Put(schema.getRowkey());
                System.out.println(Bytes.toString((byte[])schema.getColumnFamily()) + "__" + Bytes.toString((byte[])schema.getColumnQualifier()) + "__" + Bytes.toString((byte[])schema.getValue()));
                put.add(schema.getColumnFamily(), schema.getColumnQualifier(), schema.getValue());
                putList.add(put);
            }
            table.put(putList);
            table.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<byte[]> getAllColumnQualifiersValue(PutSchema schema, String tableName) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            HTable table = new HTable(conf, tableName);
            Get get = new Get(schema.getRowkey());
            Result rs = table.get(get);
            for (KeyValue kv : rs.raw()) {
                byte[] value = kv.getValue();
                list.add(value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static byte[] getSingleColumnQualifierValue(PutSchema schema) {
        byte[] result = null;
        try {
            HTable table = new HTable(conf, schema.getTableName());
            Get get = new Get(schema.getRowkey());
            Result rs = table.get(get);
            KeyValue kv = rs.getColumnLatest(schema.getColumnFamily(), schema.getColumnQualifier());
            if (kv == null) {
                return null;
            }
            result = kv.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void createTable(String tableName, String[] familys, int version) throws Exception {
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            System.out.println("table already exists!");
        } else {
            HTableDescriptor tableDesc = new HTableDescriptor(tableName);
            for (int i = 0; i < familys.length; ++i) {
                HColumnDescriptor hd = new HColumnDescriptor(familys[i]);
                hd.setMaxVersions(version);
                tableDesc.addFamily(hd);
            }
            admin.createTable(tableDesc);
            System.out.println("create table " + tableName + " ok.");
        }
    }

    public static void createBatchTables(String[] families, int version, int years) throws Exception {
        try {
            Calendar cal1 = Calendar.getInstance();
            String currentDate = DateUtil.toString((Date)cal1.getTime(), (String)"yyyy_MM");
            String baseName = "vms_videolog_";
            HBaseTemplate.createTable((String)(baseName + currentDate), (String[])families, (int)1);
            for (int i = 0; i < years * 12; ++i) {
                cal1.add(2, 1);
                String tableName = baseName + DateUtil.toString((Date)cal1.getTime(), (String)"yyyy_MM");
                System.out.println("****************\u521b\u5efa\u6708\u4efd\u8868\uff1a" + tableName + "**********");
                HBaseTemplate.createTable((String)tableName, (String[])families, (int)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u6279\u5904\u7406\u521b\u5efa\u8868\u5931\u8d25");
        }
    }

    public static void insert2() {
        try {
            HTable table = new HTable(conf, "vms_videoinfo");
            ArrayList<Put> putList = new ArrayList<Put>();
            for (int i = 1; i <= 1; ++i) {
                Put put = new Put(Bytes.toBytes((String)"220-43476a981cc041359771b35079844c84"));
                put.add(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"name"), Bytes.toBytes((String)"\u8d85\u552f\u7f8e!"));
                putList.add(put);
            }
            table.put(putList);
            table.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insert() {
        try {
            HTable table = new HTable(conf, "content");
            String dateStr = "201304023";
            for (int i = 1; i <= 5; ++i) {
                Put put = new Put(Bytes.toBytes((String)("106-" + dateStr + "-" + i)));
                put.add(Bytes.toBytes((String)"info"), Bytes.toBytes((String)"name"), Bytes.toBytes((String)("\u738b\u4e94" + i)));
                put.add(Bytes.toBytes((String)"info"), Bytes.toBytes((String)"age"), Bytes.toBytes((int)(18 + i)));
                put.add(Bytes.toBytes((String)"info"), Bytes.toBytes((String)"address"), Bytes.toBytes((String)"\u4e2d\u56fd\u4e0a\u6d77"));
                put.add(Bytes.toBytes((String)"info"), Bytes.toBytes((String)"date"), Bytes.toBytes((String)"2013-04-23"));
                table.put(put);
            }
            table.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void query2() {
        try {
            HTable tab = new HTable(conf, "test");
            Get get = new Get("0-9d79dbf9fb1a42d7af9e2531b4842b53".getBytes());
            Scan s = new Scan();
            Result scanner = tab.get(get);
            System.out.println(Bytes.toString((byte[])scanner.getRow()) + "\t" + Bytes.toLong((byte[])scanner.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"count"))) + "\t");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void query() {
        try {
            HTable tab = new HTable(conf, "test");
            RowFilter filter = new RowFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new SubstringComparator("|5|4|"));
            byte[] POSTFIX = new byte[]{0};
            byte[] lastRow = null;
            long total = 0L;
            long times = 0L;
            System.out.println("coming times:" + ++times);
            Scan s = new Scan();
            s.setFilter((Filter)filter);
            s.setStartRow(Bytes.toBytes((long)1403200000000L));
            s.setStopRow(Bytes.toBytes((long)1403600000000L));
            int localRows = 0;
            ResultScanner scanner = tab.getScanner(s);
            for (Result result : scanner) {
                ++localRows;
                ++total;
                lastRow = result.getRow();
                byte[] time = Arrays.copyOfRange(result.getRow(), 0, 8);
                byte[] mType = Arrays.copyOfRange(result.getRow(), 9, 10);
                byte[] tType = Arrays.copyOfRange(result.getRow(), 11, 12);
                System.out.println("time" + Bytes.toLong((byte[])time) + "****" + "mType:" + Bytes.toString((byte[])mType) + "**" + "tType" + Bytes.toString((byte[])tType));
                System.out.println(Bytes.toString((byte[])result.getRow()) + "\t" + Bytes.toLong((byte[])result.getValue(Bytes.toBytes((String)"info"), Bytes.toBytes((String)"count"))) + "\t");
            }
            scanner.close();
            System.out.println("HBASE TOTAL DATA:" + total);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateTableDataByColumn(String tableName, String columnFamily, String columnName, String columnOldValue, String columnNewValue) {
        try {
            HTable tab = new HTable(conf, tableName);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)columnName), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)columnOldValue));
            Scan s = new Scan();
            s.setFilter((Filter)filter);
            ResultScanner scanner = tab.getScanner(s);
            long total = 0L;
            ArrayList<PutSchema> list = new ArrayList<PutSchema>();
            PutSchema schema = null;
            System.out.println("\u66f4\u65b0hbase\u6570\u636e\u5f00\u59cb");
            for (Result result : scanner) {
                ++total;
                System.out.println(Bytes.toString((byte[])result.getRow()) + "\t" + Bytes.toString((byte[])result.getValue(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)columnName))) + "\t");
                schema = new PutSchema();
                schema.setTableName(tableName);
                schema.setRowkey(Bytes.toBytes((String)Bytes.toString((byte[])result.getRow())));
                schema.setColumnFamily(Bytes.toBytes((String)columnFamily));
                schema.setColumnQualifier(Bytes.toBytes((String)columnName));
                schema.setValue(Bytes.toBytes((String)columnNewValue));
                list.add(schema);
            }
            HBaseTemplate.putList(list, (String)tableName);
            System.out.println("HBASE TOTAL DATA:" + total);
            System.out.println("\u66f4\u65b0hbase\u6570\u636e\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void importDataByDate() {
        try {
            HTable tab = new HTable(conf, "vms_videolog");
            byte[] POSTFIX = new byte[]{0};
            long total = 0L;
            long times = 0L;
            String today = DateUtil.toString((Date)new Date());
            String monthDate = today.substring(0, today.lastIndexOf("-"));
            String newTableName = "vms_videolog_" + monthDate.replace("-", "_");
            Calendar cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.roll(5, -1);
            String[] monthList = new String[cal.get(5)];
            for (int i = 1; i <= monthList.length; ++i) {
                cal.set(5, i);
                String date = DateUtil.toString((Date)cal.getTime());
                byte[] lastRow = null;
                SingleColumnValueFilter filter = null;
                PageFilter pageFilter = new PageFilter(100L);
                FilterList filterList = new FilterList();
                filter = new SingleColumnValueFilter(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"dc"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)date));
                filterList.addFilter((Filter)filter);
                filterList.addFilter((Filter)pageFilter);
                while (true) {
                    System.out.println("coming times:" + ++times);
                    Scan s = new Scan();
                    s.setFilter((Filter)filterList);
                    if (lastRow != null) {
                        byte[] startRow = Bytes.add(lastRow, (byte[])POSTFIX);
                        s.setStartRow(startRow);
                    }
                    int localRows = 0;
                    ArrayList<PutSchema> list = new ArrayList<PutSchema>();
                    PutSchema schema = null;
                    ResultScanner scanner = tab.getScanner(s);
                    if (null == scanner) continue;
                    for (Result result : scanner) {
                        ++total;
                        ++localRows;
                        lastRow = result.getRow();
                        System.out.println(Bytes.toString((byte[])lastRow));
                        KeyValue[] kv = result.raw();
                        for (int j = 0; j < kv.length; ++j) {
                            schema = new PutSchema();
                            schema.setTableName(newTableName);
                            schema.setRowkey(lastRow);
                            System.out.println(Bytes.toString((byte[])kv[j].getFamily()) + " ");
                            System.out.println(Bytes.toString((byte[])kv[j].getQualifier()) + " ");
                            System.out.println(Bytes.toString((byte[])kv[j].getValue()) + " ");
                            schema.setColumnFamily(kv[j].getFamily());
                            schema.setColumnQualifier(kv[j].getQualifier());
                            schema.setValue(kv[j].getValue());
                            list.add(schema);
                        }
                    }
                    scanner.close();
                    if (!list.isEmpty()) {
                        HBaseTemplate.putList(list, (String)newTableName);
                    }
                    if (localRows == 0 || localRows != 100) break;
                }
            }
            System.out.println("HBASE TOTAL DATA:" + total);
            System.out.println("\u66f4\u65b0hbase\u6570\u636e\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateTableDataByRowPrefix(String tableName, String prefix, String sid) {
        try {
            int localRows;
            HTable tab = new HTable(conf, tableName);
            PrefixFilter filter = new PrefixFilter(prefix.getBytes());
            PageFilter pageFilter = new PageFilter(10L);
            FilterList filterList = new FilterList();
            byte[] POSTFIX = new byte[]{0};
            byte[] lastRow = null;
            long total = 0L;
            long times = 0L;
            filterList.addFilter((Filter)filter);
            filterList.addFilter((Filter)pageFilter);
            do {
                System.out.println("coming times:" + ++times);
                Scan s = new Scan();
                s.setFilter((Filter)filterList);
                if (lastRow != null) {
                    byte[] startRow = Bytes.add(lastRow, (byte[])POSTFIX);
                    s.setStartRow(startRow);
                }
                localRows = 0;
                ArrayList<PutSchema> list = new ArrayList<PutSchema>();
                ArrayList<Delete> delList = new ArrayList<Delete>();
                PutSchema schema = null;
                Delete dt = null;
                String[] rowKeys = new String[2];
                ResultScanner scanner = tab.getScanner(s);
                for (Result result : scanner) {
                    ++total;
                    ++localRows;
                    lastRow = result.getRow();
                    System.out.println(Bytes.toString((byte[])lastRow));
                    dt = new Delete(lastRow);
                    rowKeys = Bytes.toString((byte[])lastRow).split("-");
                    schema = new PutSchema();
                    schema.setTableName(tableName);
                    schema.setRowkey(Bytes.toBytes((String)(sid + "-" + rowKeys[1])));
                    KeyValue[] kv = result.raw();
                    for (int i = 0; i < kv.length; ++i) {
                        System.out.println(Bytes.toString((byte[])kv[i].getFamily()) + " ");
                        System.out.println(Bytes.toString((byte[])kv[i].getQualifier()) + " ");
                        System.out.println(Bytes.toString((byte[])kv[i].getValue()) + " ");
                        schema.setColumnFamily(kv[i].getFamily());
                        schema.setColumnQualifier(kv[i].getQualifier());
                        schema.setValue(kv[i].getValue());
                    }
                    list.add(schema);
                    delList.add(dt);
                }
                scanner.close();
                HBaseTemplate.putList(list, (String)tableName);
                tab.delete(delList);
            } while (localRows != 0);
            System.out.println("HBASE TOTAL DATA:" + total);
            System.out.println("\u66f4\u65b0hbase\u6570\u636e\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertColumn(String tableName, String columnName) {
        try {
            int localRows;
            HTable tab = new HTable(conf, tableName);
            PageFilter pageFilter = new PageFilter(100L);
            long total = 0L;
            byte[] POSTFIX = new byte[]{0};
            byte[] lastRow = null;
            do {
                Scan s = new Scan();
                s.setFilter((Filter)pageFilter);
                if (lastRow != null) {
                    byte[] startRow = Bytes.add(lastRow, (byte[])POSTFIX);
                    s.setStartRow(startRow);
                }
                localRows = 0;
                ResultScanner scanner = tab.getScanner(s);
                ArrayList<PutSchema> list = new ArrayList<PutSchema>();
                PutSchema schema = null;
                for (Result result : scanner) {
                    ++total;
                    ++localRows;
                    lastRow = result.getRow();
                    schema = new PutSchema();
                    schema.setTableName(tableName);
                    schema.setRowkey(Bytes.toBytes((String)Bytes.toString((byte[])result.getRow())));
                    schema.setColumnFamily(Bytes.toBytes((String)"i"));
                    schema.setColumnQualifier(Bytes.toBytes((String)columnName));
                    schema.setValue(Bytes.toBytes((String)"5"));
                    list.add(schema);
                }
                scanner.close();
                HBaseTemplate.putList(list, (String)tableName);
                System.out.println("HBASE TOTAL DATA:" + total);
            } while (localRows != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertColumn(String tableName) {
        try {
            int localRows;
            HTable tab = new HTable(conf, tableName);
            PageFilter pageFilter = new PageFilter(100L);
            long total = 0L;
            byte[] POSTFIX = new byte[]{0};
            byte[] lastRow = null;
            do {
                Scan s = new Scan();
                s.setFilter((Filter)pageFilter);
                if (lastRow != null) {
                    byte[] startRow = Bytes.add(lastRow, (byte[])POSTFIX);
                    s.setStartRow(startRow);
                }
                localRows = 0;
                ResultScanner scanner = tab.getScanner(s);
                ArrayList<PutSchema> list = new ArrayList<PutSchema>();
                PutSchema schema = null;
                PutSchema schema1 = null;
                for (Result result : scanner) {
                    ++total;
                    ++localRows;
                    lastRow = result.getRow();
                    String rowKey = Bytes.toString((byte[])result.getRow());
                    String[] rowKeys = rowKey.split("-");
                    schema = new PutSchema();
                    schema.setTableName(tableName);
                    schema.setRowkey(Bytes.toBytes((String)Bytes.toString((byte[])result.getRow())));
                    schema.setColumnFamily(Bytes.toBytes((String)"i"));
                    schema.setColumnQualifier(Bytes.toBytes((String)"siteid"));
                    schema.setValue(Bytes.toBytes((String)rowKeys[0]));
                    schema1 = new PutSchema();
                    schema1.setTableName(tableName);
                    schema1.setRowkey(Bytes.toBytes((String)Bytes.toString((byte[])result.getRow())));
                    schema1.setColumnFamily(Bytes.toBytes((String)"i"));
                    schema1.setColumnQualifier(Bytes.toBytes((String)"id"));
                    schema1.setValue(Bytes.toBytes((String)rowKeys[1]));
                    list.add(schema);
                    list.add(schema1);
                }
                scanner.close();
                HBaseTemplate.putList(list, (String)tableName);
                System.out.println("HBASE TOTAL DATA:" + total);
            } while (localRows != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void delete(String siteId, List<String> list) {
        try {
            System.out.println("\u6e05\u9664hbase\u6570\u636e\u5f00\u59cb");
            HTable logTab = new HTable(conf, "vms_videolog");
            HTable infoTab = new HTable(conf, "vms_videoinfo");
            SingleColumnValueFilter filter = null;
            ArrayList<Delete> infoDelList = new ArrayList<Delete>();
            ArrayList<Delete> logDelList = new ArrayList<Delete>();
            Delete infoDel = null;
            Delete logDel = null;
            FilterList filterList = new FilterList();
            Scan s = new Scan();
            for (int i = 0; i < list.size(); ++i) {
                String id = list.get(i);
                String rowKey = siteId + "-" + id;
                infoDel = new Delete(Bytes.toBytes((String)rowKey));
                filter = new SingleColumnValueFilter(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"id"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)id));
                infoDelList.add(infoDel);
                filterList.addFilter((Filter)filter);
            }
            s.setFilter((Filter)filterList);
            ResultScanner scanner = logTab.getScanner(s);
            for (Result result : scanner) {
                logDel = new Delete(result.getRow());
                logDelList.add(logDel);
            }
            System.out.println("\u6e05\u9664hbase--vms_videolog\u8868\u6570\u636e\u5f00\u59cb");
            logTab.delete(logDelList);
            System.out.println("\u6e05\u9664hbase--vms_videolog\u8868\u6570\u636e\u7ed3\u675f");
            System.out.println("\u6e05\u9664hbase--vms_videoinfo\u8868\u6570\u636e\u5f00\u59cb");
            infoTab.delete(infoDelList);
            System.out.println("\u6e05\u9664hbase--vms_videoinfo\u8868\u6570\u636e\u7ed3\u675f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertData() {
        try {
            Long time = new SimpleDateFormat("yyyy-MM-dd HH").parse("2014-06-23 10").getTime();
            Long count = 0L;
            ArrayList<PutSchema> puts = new ArrayList<PutSchema>();
            PutSchema put = null;
            Object rowKey = null;
            String mType = null;
            String terminalType = null;
            String siteEmail = "pengmeng@sovey.com";
            String md5Email = StringUtil.md5Hex((String)siteEmail);
            for (int i = 0; i < 20; ++i) {
                put = new PutSchema();
                if (i < 5) {
                    time = time + 60L;
                    mType = "6";
                    terminalType = "0";
                    count = count + 5L;
                } else if (i >= 5 && i < 10) {
                    time = time + 60L;
                    mType = "6";
                    terminalType = "1";
                    count = count + 5L;
                } else if (i >= 10 && i < 15) {
                    time = time + 60L;
                    mType = "6";
                    terminalType = "2";
                    count = count + 5L;
                } else if (i >= 15 && i < 20) {
                    time = time + 60L;
                    mType = "6";
                    terminalType = "4";
                    count = count + 5L;
                }
                put.setTableName("test");
                put.setRowkey(Bytes.add((byte[])Bytes.toBytes((long)time), (byte[])Bytes.toBytes((String)("|" + mType + "|" + terminalType + "|"))));
                put.setColumnFamily(Bytes.toBytes((String)"info"));
                put.setColumnQualifier(Bytes.toBytes((String)"count"));
                put.setValue(Bytes.toBytes((long)count));
                puts.add(put);
            }
            HBaseTemplate.putList(puts, (String)"test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveBaseInfo(String tableName, String rowKey, String columnFamily, Map<String, String> columnsMap) {
        try {
            ArrayList<PutSchema> schemaList = new ArrayList<PutSchema>();
            PutSchema schema = new PutSchema();
            schema.setTableName(tableName);
            schema.setRowkey(Bytes.toBytes((String)rowKey));
            schema.setColumnFamily(Bytes.toBytes((String)columnFamily));
            for (String key : columnsMap.keySet()) {
                PutSchema schemaClone = schema;
                schemaClone.setColumnQualifier(Bytes.toBytes((String)key.toString()));
                schemaClone.setValue(Bytes.toBytes((String)columnsMap.get(key)));
                schemaList.add(schemaClone);
            }
            HBaseTemplate.putList(schemaList, (String)tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String siteEmail = "pengmeng@sobey.com";
            MessageDigest md = MessageDigest.getInstance("MD5");
            System.out.println(UUID.randomUUID().toString().getBytes().length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        conf = HBaseConfiguration.create();
    }
}

