/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.schedule;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.schedule.AbstractTaskManager;
import com.sobey.bsp.framework.schedule.CronMonitor;
import com.sobey.bsp.framework.schedule.GeneralTask;
import com.sobey.bsp.framework.schedule.GeneralTaskManager;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CronManager {
    private Timer mTimer;
    private CronMonitor mMonitor;
    private Mapx map = new Mapx();
    private static CronManager instance;
    private long interval;

    public static synchronized CronManager getInstance() {
        if (instance == null) {
            instance = new CronManager();
        }
        return instance;
    }

    public Mapx getManagers() {
        return this.map;
    }

    private CronManager() {
        this.init();
    }

    public void init() {
        if (!Config.isDatabaseConfiged) {
            return;
        }
        this.loadConfig();
        this.mTimer = new Timer(true);
        this.mMonitor = new CronMonitor();
        this.mTimer.schedule((TimerTask)this.mMonitor, 0L, this.interval);
        LogUtil.info((Object)("----" + Config.getAppCode() + "(" + Config.getAppName() + "): CronManager Initialized----"));
    }

    private void loadConfig() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("framework.xml");
        String path = url.getPath();
        SAXReader reader = new SAXReader(false);
        try {
            Document doc = reader.read(new File(path));
            Element root = doc.getRootElement();
            Element cron = root.element("cron");
            List types = cron.elements();
            GeneralTaskManager gtm = new GeneralTaskManager();
            this.map.put((Object)gtm.getCode(), (Object)gtm);
            for (int i = 0; i < types.size(); ++i) {
                String className;
                Element type = (Element)types.get(i);
                String tag = type.getName();
                if (tag.equals("config")) {
                    String name = type.attributeValue("name");
                    String value = type.getText();
                    if (!name.equals("RefreshInterval")) continue;
                    this.interval = Long.parseLong(value);
                    continue;
                }
                if (tag.equals("taskManager")) {
                    className = type.attributeValue("class");
                    try {
                        Object o = Class.forName(className).newInstance();
                        if (!(o instanceof AbstractTaskManager)) {
                            throw new RuntimeException("\u6307\u5b9a\u7684\u7c7b" + className + "\u4e0d\u662fCronTaskManager\u7684\u5b50\u7c7b.");
                        }
                        AbstractTaskManager ctm = (AbstractTaskManager)o;
                        this.map.put((Object)ctm.getCode(), (Object)ctm);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!tag.equals("task")) continue;
                className = type.attributeValue("class");
                try {
                    Object obj = Class.forName(className).newInstance();
                    if (!(obj instanceof GeneralTask)) {
                        throw new RuntimeException("\u6307\u5b9a\u7684\u7c7b" + className + "\u4e0d\u662fGeneralTask\u7684\u5b50\u7c7b.");
                    }
                    GeneralTask gt = (GeneralTask)Class.forName(className).newInstance();
                    gtm.add(gt);
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public Mapx getTaskTypes() {
        Mapx rmap = new Mapx();
        Object[] vs = this.map.valueArray();
        for (int i = 0; i < this.map.size(); ++i) {
            AbstractTaskManager ctm = (AbstractTaskManager)vs[i];
            if (ctm instanceof GeneralTaskManager) continue;
            rmap.put((Object)ctm.getCode(), (Object)ctm.getName());
        }
        return rmap;
    }

    public Mapx getConfigEnableTasks(String code) {
        AbstractTaskManager ctm = (AbstractTaskManager)this.map.get((Object)code);
        if (ctm == null) {
            return null;
        }
        return ctm.getConfigEnableTasks();
    }

    public AbstractTaskManager getCronTaskManager(String code) {
        return (AbstractTaskManager)this.map.get((Object)code);
    }

    public void destory() {
        if (this.mMonitor != null) {
            this.mMonitor.destory();
            this.mTimer.cancel();
        }
    }

    public long getInterval() {
        return this.interval;
    }
}

