/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.script;

import bsh.EvalError;
import bsh.Interpreter;
import com.sobey.bsp.framework.script.EvalException;
import com.sobey.bsp.framework.script.SecurityChecker;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptEngine {
    public static final int LANG_JAVASCRIPT = 0;
    public static final int LANG_JAVA = 1;
    private int language;
    private ArrayList carr = new ArrayList();
    private ArrayList parr = new ArrayList();
    private Mapx funcMap = new Mapx();
    private Mapx exceptionMap = new Mapx();
    private Mapx varMap = new Mapx();
    private boolean isNeedCheck;
    private static final Pattern JavaLineInfoPattern = Pattern.compile("error at line (\\d*?)\\, column (\\d*?)\\.", 34);

    public ScriptEngine(int language) {
        this.language = language;
    }

    public void importClass(String className) {
        this.carr.add(className);
    }

    public void importPackage(String pacckageName) {
        this.parr.add(pacckageName);
    }

    public void compileFunction(String funcName, String script) throws EvalException {
        if (this.isNeedCheck && !SecurityChecker.check((String)script)) {
            EvalException ee = new EvalException("\u811a\u672c\u4e2d\u5f15\u7528\u4e86\u88ab\u7981\u6b62\u7684\u5305\u6216\u8005\u7c7b!", "", "", 0, 0);
            this.exceptionMap.put((Object)funcName, (Object)ee);
            throw ee;
        }
        this.exceptionMap.remove((Object)funcName);
        StringBuffer sb = new StringBuffer();
        if (this.language == 1) {
            int i;
            for (i = 0; i < this.carr.size(); ++i) {
                sb.append("import " + this.carr.get(i) + ";\n");
            }
            for (i = 0; i < this.parr.size(); ++i) {
                sb.append("import " + this.parr.get(i) + ".*;\n");
            }
            sb.append(funcName + "(){\n");
            sb.append(script);
            sb.append("}\n");
            Interpreter itp = new Interpreter();
            try {
                itp.eval(sb.toString());
            }
            catch (EvalError e) {
                e.printStackTrace();
                String message = e.getMessage();
                Matcher m = JavaLineInfoPattern.matcher(message);
                int row = 0;
                int col = 0;
                String lineSource = "";
                if (m.find()) {
                    row = Integer.parseInt(m.group(1));
                    if (row <= this.carr.size()) {
                        message = "\u5f15\u5165\u7c7b\u53d1\u751f\u9519\u8bef!";
                        lineSource = this.carr.get(row - 1).toString();
                    } else if (row <= this.parr.size()) {
                        message = "\u5f15\u5165\u5305\u53d1\u751f\u9519\u8bef!";
                        lineSource = this.parr.get(row - 1).toString();
                    } else {
                        row = row - this.carr.size() - this.parr.size() - 1;
                        lineSource = script.split("\\n")[row - 1];
                        col = Integer.parseInt(m.group(2));
                    }
                }
                throw new EvalException("\u7b2c" + row + "\u884c\u6709\u8bed\u6cd5\u9519\u8bef: " + lineSource, message, lineSource, row, col);
            }
            this.funcMap.put((Object)funcName, (Object)itp);
        } else {
            int i;
            for (i = 0; i < this.carr.size(); ++i) {
                sb.append("importClass(Packages." + this.carr.get(i) + ");\n");
            }
            for (i = 0; i < this.parr.size(); ++i) {
                sb.append("importPackage(Packages." + this.parr.get(i) + ");\n");
            }
            sb.append("function " + funcName + "(){\n");
            sb.append(script);
            sb.append("}\n");
            sb.append(funcName + "();\n");
            Context ctx = Context.enter();
            ctx.setOptimizationLevel(1);
            Script compiledScript = null;
            try {
                compiledScript = ctx.compileString(sb.toString(), "", 1, null);
            }
            catch (EvaluatorException e) {
                int row = e.lineNumber() - 1;
                throw new EvalException("\u7b2c" + row + "\u884c\u6709\u8bed\u6cd5\u9519\u8bef: " + e.lineSource(), e.getMessage(), e.lineSource(), row, e.columnNumber());
            }
            this.funcMap.put((Object)funcName, (Object)compiledScript);
        }
    }

    public Object executeFunction(String funcName) throws EvalException {
        Object ee = this.exceptionMap.get((Object)funcName);
        if (ee != null) {
            throw (EvalException)ee;
        }
        Object o = this.funcMap.get((Object)funcName);
        if (this.language == 1) {
            try {
                Interpreter itp = (Interpreter)o;
                Object[] ks = this.varMap.keyArray();
                Object[] vs = this.varMap.valueArray();
                for (int i = 0; i < this.varMap.size(); ++i) {
                    itp.set(ks[i].toString(), vs[i]);
                }
                return itp.eval(funcName + "();");
            }
            catch (EvalError e) {
                e.printStackTrace();
                String message = e.getMessage();
                int col = 0;
                int row = e.getErrorLineNumber() - 1;
                throw new EvalException("\u7b2c" + row + "\u884c\u6709\u8bed\u6cd5\u9519\u8bef: " + e.getErrorText(), message, e.getErrorText(), row, col);
            }
        }
        try {
            Script compiledScript = (Script)o;
            Context ctx = Context.enter();
            ImporterTopLevel scope = new ImporterTopLevel(ctx);
            Object[] ks = this.varMap.keyArray();
            Object[] vs = this.varMap.valueArray();
            for (int i = 0; i < this.varMap.size(); ++i) {
                ScriptableObject.putProperty((Scriptable)scope, (String)ks[i].toString(), (Object)vs[i]);
            }
            return compiledScript.exec(ctx, (Scriptable)scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setVar(String name, Object value) {
        this.varMap.put((Object)name, value);
    }

    public int getLanguage() {
        return this.language;
    }

    public static Object evalJavaScript(String js) throws EvalException {
        Context ctx = Context.enter();
        ImporterTopLevel scope = new ImporterTopLevel(ctx);
        ctx.setOptimizationLevel(1);
        Script compiledScript = null;
        try {
            compiledScript = ctx.compileString(js, "", 1, null);
            return compiledScript.exec(ctx, (Scriptable)scope);
        }
        catch (EvaluatorException e) {
            int row = e.lineNumber() - 1;
            throw new EvalException("\u7b2c" + row + "\u884c\u6709\u8bed\u6cd5\u9519\u8bef: " + e.lineSource(), e.getMessage(), e.lineSource(), row, e.columnNumber());
        }
    }

    public static Object evalJava(String java) throws EvalException {
        Interpreter itp = new Interpreter();
        try {
            return itp.eval(java);
        }
        catch (EvalError e) {
            String message = e.getMessage();
            Matcher m = JavaLineInfoPattern.matcher(message);
            int row = 0;
            int col = 0;
            String lineSource = "";
            if (m.find()) {
                row = Integer.parseInt(m.group(1));
                lineSource = java.split("\\n")[row - 1];
                col = Integer.parseInt(m.group(2));
            }
            throw new EvalException("\u7b2c" + row + "\u884c\u6709\u8bed\u6cd5\u9519\u8bef: " + lineSource, message, lineSource, row, col);
        }
    }

    public void exit() {
        if (this.language == 0) {
            Context.exit();
        }
    }

    public boolean isNeedCheck() {
        return this.isNeedCheck;
    }

    public void setNeedCheck(boolean isNeedCheck) {
        this.isNeedCheck = isNeedCheck;
    }

    public static void main(String[] args) {
        ScriptEngine se = new ScriptEngine(1);
        se.setNeedCheck(false);
        se.importPackage("com.sobey.bsp.framework.cache");
        se.importPackage("com.sobey.bsp.framework.data");
        se.importPackage("com.sobey.bsp.framework.utility");
        se.importPackage("com.sobey.bsp.statical");
        se.importPackage("com.sobey.bsp.cms.template");
        se.importPackage("com.sobey.bsp.cms.pub");
        se.importPackage("com.sobey.bsp.cms.site");
        se.importPackage("com.sobey.bsp.cms.document");
        String script = FileUtil.readText((String)"D:/Script.txt");
        try {
            se.compileFunction("a", script);
            LogUtil.info((Object)se.executeFunction("a"));
        }
        catch (EvalException e) {
            e.printStackTrace();
        }
    }
}

