/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.securitycard;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Random;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class CardGenerator {
    final int LEFT_MARGIN = 36;
    final int TOP_MARGIN = 120;
    final int TABLE_WIDTH = 549;
    final int TABLE_HEIGHT = 720;
    public static final int TABLE_HORIZONTAL_NUM = 9;
    public static final int TABLE_VERTICAL_NUM = 14;
    final int TABLE_HORIZONTAL_TITLE_PADDING = 61;
    final int TABLE_VERTICAL_TITLE_PADDING = 51;
    final int TABLE_HORIZONTAL_LABLE_X = 71;
    final int TABLE_VERTICAL_LABLE_Y = 245;
    public static final String CARD_CODES_KEY = "cardCodes";
    public static final String SERIAL_CODES_KEY = "serialCode";
    String securityCardDir = Config.getValue((String)"securitycard.store.dir");
    String cardTemplate = "";
    private final String templateName = "securityCardTemplate.jpg";
    String webRootPath = "";
    private String userName = "";
    Logger logger = Logger.getLogger(CardGenerator.class);
    private int[][] cardCodes = new int[9][14];
    private String[] serialCode = new String[5];

    public CardGenerator(String userName) {
        this.userName = userName;
        this.getRandomCardVals();
        this.getRandomSerailCode();
        try {
            this.webRootPath = Config.getContextRealPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File dir = new File(this.securityCardDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.cardTemplate = this.securityCardDir + File.separator + "securityCardTemplate.jpg";
        File file = new File(this.cardTemplate);
        if (!file.exists()) {
            this.cardTemplate = this.webRootPath + "Icons" + File.separator + "securityCardTemplate.jpg";
        }
    }

    public boolean createCard() {
        FileInputStream is = null;
        BufferedImage buffImg = null;
        try {
            is = new FileInputStream(this.cardTemplate);
            JPEGImageDecoder jpegDecoder = JPEGCodec.createJPEGDecoder((InputStream)is);
            buffImg = jpegDecoder.decodeAsBufferedImage();
        }
        catch (ImageFormatException e1) {
            e1.printStackTrace();
            this.logger.error((Object)"\u5bc6\u4fdd\u5361\u80cc\u666f\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fdd\u8bc1\u5176\u683c\u5f0f\u4e3aJPEG!", (Throwable)e1);
            return false;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.logger.error((Object)"\u52a0\u8f7d\u5bc6\u4fdd\u5361\u80cc\u666f\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u5bc6\u4fdd\u5361\u80cc\u666f\u56fe\u7247\u5b58\u5728\uff01", (Throwable)e1);
            return false;
        }
        Graphics g = buffImg.getGraphics();
        int x = 71;
        int y = 245;
        Color color = Color.black;
        g.setColor(color);
        Font f = new Font("\u5b8b\u4f53", 1, 25);
        g.setFont(f);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 14; ++j) {
                g.drawString(this.cardCodes[i][j] + "", x, y);
                y += 51;
            }
            y = 245;
            x += 61;
        }
        color = new Color(255, 255, 255);
        g.setColor(color);
        f = new Font("\u5b8b\u4f53", 1, 28);
        g.setFont(f);
        StringBuffer scs = new StringBuffer();
        for (int i = 0; i < this.serialCode.length; ++i) {
            scs.append(this.serialCode[i]).append(" ");
        }
        g.drawString(scs.toString(), 141, 144);
        g.dispose();
        if (StringUtil.isEmpty((String)this.securityCardDir)) {
            this.securityCardDir = "";
        }
        try {
            FileOutputStream os = new FileOutputStream(this.securityCardDir + File.separator + this.userName + ".jpg");
            JPEGImageEncoder en = JPEGCodec.createJPEGEncoder((OutputStream)os);
            en.encode(buffImg);
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"\u751f\u6210\u5bc6\u4fdd\u5361\u9519\u8bef\uff0c\u8bf7\u786e\u4fdd\u5bc6\u4fdd\u5361\u80cc\u666f\u56fe\u7247\u5b58\u5728\u4e14\u683c\u5f0f\u4e3aJPEG\uff01", (Throwable)e);
            return false;
        }
        return true;
    }

    private void getRandomCardVals() {
        Random rand = new Random();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 14; ++j) {
                this.cardCodes[i][j] = rand.nextInt(1000);
            }
        }
    }

    private void getRandomSerailCode() {
        Random rand = new Random();
        for (int i = 0; i < this.serialCode.length; ++i) {
            String code;
            int randInt = rand.nextInt(1000);
            DecimalFormat df = new DecimalFormat("000");
            this.serialCode[i] = code = df.format(randInt);
        }
    }

    public String getCardJsonVals() {
        JSONArray cardVals = JSONArray.fromObject((Object)this.cardCodes);
        JSONArray serialVals = JSONArray.fromObject((Object)this.serialCode);
        JSONObject vals = new JSONObject();
        vals.put((Object)CARD_CODES_KEY, (Object)cardVals);
        vals.put((Object)SERIAL_CODES_KEY, (Object)serialVals);
        return vals.toString();
    }
}

