/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import com.sobey.bsp.framework.utility.Code39;
import com.sobey.bsp.framework.utility.GIFEncoder;
import com.sobey.bsp.framework.utility.LogUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class BarCode {
    public static String FORMAT_JPEG = "jpg";
    public static String FORMAT_GIF = "gif";
    public static String FORMAT_PNG = "png";
    public static String FORMAT_BMP = "bmp";
    public static int TYPE_CODE39 = 1;
    private BufferedImage image = null;
    private String codeStr = "";
    private String codeBinary = "";
    private String m_fileFormat = FORMAT_JPEG;
    private int codeType = TYPE_CODE39;
    private boolean isTextVisable = true;
    private String bgColor = "#FFFFFF";
    private String fgColor = "000000";
    private int xMargin = 10;
    private int yMargin = 10;
    private int barHeight = 40;
    private int barWidth = 1;
    private int barRatio = 3;

    public BarCode(String code) {
        this.codeStr = code;
    }

    public BufferedImage getImage() {
        this.generatedImage();
        return this.image;
    }

    public void getOutputStream(OutputStream os) throws IOException {
        this.generatedImage();
        if (this.m_fileFormat.equals(FORMAT_GIF)) {
            GIFEncoder gif = new GIFEncoder((Image)this.image, os);
            gif.encode();
        } else {
            ImageIO.write((RenderedImage)this.image, this.m_fileFormat, os);
        }
    }

    public void writeToFile(String fileName) throws IOException {
        this.generatedImage();
        File f = new File(fileName);
        FileOutputStream os = new FileOutputStream(f);
        GIFEncoder gif = new GIFEncoder((Image)this.image, (OutputStream)os);
        gif.encode();
        ((OutputStream)os).close();
    }

    public byte[] getBytes() throws IOException {
        this.generatedImage();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GIFEncoder gif = new GIFEncoder((Image)this.image, (OutputStream)bos);
        gif.encode();
        return bos.toByteArray();
    }

    public void generatedImage() {
        int w_Start = this.xMargin;
        int h_Start = this.yMargin;
        if (this.codeType == TYPE_CODE39) {
            this.codeBinary = Code39.transferCode((String)this.codeStr);
        }
        int barWidthTotal = 0;
        for (int i = 0; i < this.codeBinary.length(); ++i) {
            if (this.codeBinary.charAt(i) == '1') {
                barWidthTotal += this.barRatio * this.barWidth;
                continue;
            }
            barWidthTotal += this.barWidth;
        }
        int imageWidth = this.xMargin * 2 + barWidthTotal;
        int imageHeight = h_Start + this.barHeight + (h_Start > 15 ? h_Start : 15);
        this.image = new BufferedImage(imageWidth, imageHeight, 1);
        BarCode.setImageBgColor((BufferedImage)this.image, (String)this.bgColor);
        Graphics g = this.image.getGraphics();
        Font font = new Font(null, 0, 11);
        g.setFont(font);
        g.setColor(Color.decode(this.fgColor));
        for (int i = 0; i < this.codeBinary.length(); ++i) {
            if (this.codeBinary.charAt(i) == '1') {
                if (i % 2 == 0) {
                    g.fillRect(w_Start, h_Start, this.barRatio * this.barWidth, this.barHeight);
                }
                w_Start += this.barRatio * this.barWidth;
                continue;
            }
            if (i % 2 == 0) {
                g.fillRect(w_Start, h_Start, this.barWidth, this.barHeight);
            }
            w_Start += this.barWidth;
        }
        if (this.isTextVisable) {
            FontMetrics fonM = g.getFontMetrics();
            int yFont = fonM.getAscent() + fonM.getDescent();
            int xFont = fonM.stringWidth(this.codeStr);
            g.drawString(this.codeStr.toUpperCase(), imageWidth / 2 - xFont / 2, h_Start + yFont - 3 + this.barHeight);
        }
    }

    public void setBgColor(String str) {
        this.bgColor = str;
    }

    public void setCodeType(int type) {
        this.codeType = type;
    }

    public void setFormatType(String str) {
        this.m_fileFormat = str;
    }

    public void setForeColor(String str) {
        this.fgColor = str;
    }

    public void setTextVisable(boolean bFlag) {
        this.isTextVisable = bFlag;
    }

    public void setXMargin(int x) {
        this.xMargin = x;
    }

    public void setYMargin(int y) {
        this.yMargin = y;
    }

    public void setBarWidth(int bw) {
        this.barWidth = bw;
    }

    public void setBarHeight(int bh) {
        this.barHeight = bh;
    }

    public void setBarRatio(int br) {
        this.barRatio = br;
    }

    private static void setImageBgColor(BufferedImage image, String strColor) {
        Graphics g = image.getGraphics();
        String t_Str = new String(strColor);
        Color t_Color = g.getColor();
        if (!t_Str.startsWith("#")) {
            t_Str = "#" + t_Str;
        }
        if (t_Str.length() != 7) {
            LogUtil.warn((Object)("BarCode:\u9519\u8bef\u7684\u989c\u8272\u503c" + t_Str));
            return;
        }
        g.setColor(Color.decode(t_Str));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.setColor(t_Color);
    }

    public static void main(String[] args) {
        String code = "SINO2345";
        System.out.println(Code39.transferCode((String)code));
        BarCode barcode = new BarCode(code);
        barcode.setFormatType(FORMAT_GIF);
        try {
            System.out.println(barcode.getBytes().length);
        }
        catch (IOException ex) {
            System.out.println("\u6761\u5f62\u7801\u5de5\u5177BarCode:\u5199\u6587\u4ef6\u9519\u8bef");
        }
    }
}

