/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import com.sobey.bsp.framework.utility.BufferedRandomAccessFile;
import com.sobey.bsp.framework.utility.FileCachedMapx;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.NumberUtil;
import com.sobey.bsp.framework.utility.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileCachedMapx {
    private Mapx map;
    private boolean compressible;
    private int total;
    private int size;
    private int modCount;
    private short maxFileIndex;
    private int maxItemInMemory = 1000;
    private String cacheDirectory;
    private BufferedRandomAccessFile[] addressFiles = null;
    private BufferedRandomAccessFile[] keyFiles = null;
    private BufferedRandomAccessFile[] valueFiles = null;
    private static final int AddressCountInOneFile = 0x10000000;
    private static final int MaxFileSize = 0x7D000000;
    private static final int DefaultCountInMemory = 100;
    private int addressFileCount;

    public FileCachedMapx(String cacheDir) {
        this(cacheDir, 65536, 100);
    }

    public FileCachedMapx(String cacheDir, boolean compressiable) {
        this(cacheDir, 65536, compressiable, 100);
    }

    public FileCachedMapx(String cacheDir, int initEntrySize) {
        this(cacheDir, initEntrySize, true, 100);
    }

    public FileCachedMapx(String cacheDir, boolean compressiable, int maxItemInMemory) {
        this(cacheDir, 65536, compressiable, maxItemInMemory);
    }

    public FileCachedMapx(String cacheDir, int initEntrySize, int maxItemInMemory) {
        this(cacheDir, initEntrySize, true, maxItemInMemory);
    }

    public FileCachedMapx(String cacheDir, int initEntrySize, boolean compressiable, int maxItemInMemory) {
        this.cacheDirectory = cacheDir;
        this.total = new Double(Math.pow(2.0, Math.ceil(Math.log(initEntrySize) / Math.log(2.0)))).intValue();
        this.compressible = compressiable;
        this.maxItemInMemory = maxItemInMemory;
        this.map = new Mapx(maxItemInMemory);
        this.loadInfo();
    }

    private void initFiles() {
        try {
            int i;
            this.addressFileCount = new Double(Math.ceil((double)this.total * 1.0 / 2.68435456E8)).intValue();
            this.addressFiles = new BufferedRandomAccessFile[this.addressFileCount];
            int prefix = new Double(Math.log(this.total / 16) / Math.log(2.0)).intValue();
            for (i = 0; i < this.addressFileCount; ++i) {
                this.addressFiles[i] = new BufferedRandomAccessFile(this.cacheDirectory + prefix + "key" + i + ".idx", "rw");
                if (i != this.addressFileCount - 1) continue;
                this.addressFiles[i].setLength((long)((this.total - (this.addressFileCount - 1) * 0x10000000) * 9));
            }
            this.keyFiles = new BufferedRandomAccessFile[this.maxFileIndex + 1];
            this.valueFiles = new BufferedRandomAccessFile[this.maxFileIndex + 1];
            for (i = 0; i <= this.maxFileIndex; ++i) {
                this.keyFiles[i] = new BufferedRandomAccessFile(this.cacheDirectory + "key" + i + ".dat", "rw");
                this.valueFiles[i] = new BufferedRandomAccessFile(this.cacheDirectory + "value" + i + ".dat", "rw");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeData(String k, Object v) {
        block6: {
            int index = this.hash((Object)k);
            int c = index % 0x10000000;
            index /= 0x10000000;
            if (this.addressFiles == null) {
                this.initFiles();
            }
            try {
                BufferedRandomAccessFile f = this.addressFiles[index];
                f.seek((long)(c * 9));
                Key key = this.getKey(f);
                if (key == null) {
                    f.seek((long)(c * 9));
                    this.writeFile(f, k, v);
                    break block6;
                }
                if (key.KeyString.equals(k)) {
                    this.updateByKey(key, v);
                    return;
                }
                do {
                    f = this.keyFiles[key.KeyFileIndex];
                    int pos = key.keyAddress + key.KeyLength - 9;
                    f.seek((long)pos);
                    key = this.getKey(f);
                    if (key != null) continue;
                    f.seek((long)pos);
                    this.writeFile(f, k, v);
                    break block6;
                } while (!key.KeyString.equals(k));
                this.updateByKey(key, v);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeFile(BufferedRandomAccessFile f, String k, Object v) throws IOException {
        int vpos;
        int vNewSize;
        f.writeByte(1);
        f.writeShort((int)this.maxFileIndex);
        byte[] bk = k.getBytes();
        byte[] bv = this.toBytes(v);
        f.writeShort(22 + bk.length);
        BufferedRandomAccessFile kf = this.keyFiles[this.maxFileIndex];
        BufferedRandomAccessFile vf = this.valueFiles[this.maxFileIndex];
        int kpos = (int)kf.length();
        long kNewSize = kpos + 22 + bk.length;
        if (kNewSize > 0x7D000000L) {
            this.maxFileIndex = (short)(this.maxFileIndex + 1);
            BufferedRandomAccessFile fk = new BufferedRandomAccessFile(this.cacheDirectory + "key" + this.maxFileIndex + ".dat", "rw");
            BufferedRandomAccessFile fv = new BufferedRandomAccessFile(this.cacheDirectory + "value" + this.maxFileIndex + ".dat", "rw");
            this.keyFiles = (BufferedRandomAccessFile[])ArrayUtils.add((Object[])this.keyFiles, (Object)fk);
            this.valueFiles = (BufferedRandomAccessFile[])ArrayUtils.add((Object[])this.valueFiles, (Object)fv);
            kf = this.keyFiles[this.maxFileIndex];
            kNewSize = 22 + bk.length;
            kpos = 0;
        }
        if ((vNewSize = (vpos = (int)vf.length()) + 9 + bk.length + bv.length) > 0x7D000000) {
            this.maxFileIndex = (short)(this.maxFileIndex + 1);
            BufferedRandomAccessFile fk = new BufferedRandomAccessFile(this.cacheDirectory + "key" + this.maxFileIndex + ".dat", "rw");
            BufferedRandomAccessFile fv = new BufferedRandomAccessFile(this.cacheDirectory + "value" + this.maxFileIndex + ".dat", "rw");
            this.keyFiles = (BufferedRandomAccessFile[])ArrayUtils.add((Object[])this.keyFiles, (Object)fk);
            this.valueFiles = (BufferedRandomAccessFile[])ArrayUtils.add((Object[])this.valueFiles, (Object)fv);
            vf = this.valueFiles[this.maxFileIndex];
            vNewSize = 9 + bk.length + bv.length;
            vpos = 0;
        }
        f.writeInt(kpos);
        kf.setLength(kNewSize);
        kf.seek((long)kpos);
        kf.writeByte(1);
        kf.writeShort((int)this.maxFileIndex);
        kf.writeInt(9 + bk.length + bv.length);
        kf.writeInt(vpos);
        kf.writeShort(bk.length);
        kf.write(bk);
        vf.setLength((long)vNewSize);
        vf.seek((long)vpos);
        vf.writeByte(1);
        vf.writeInt(bk.length);
        vf.writeInt(bv.length);
        vf.write(bk);
        vf.write(bv);
    }

    private void updateByKey(Key key, Object v) throws IOException {
        byte[] bv = this.toBytes(v);
        BufferedRandomAccessFile f = this.valueFiles[key.DataFileIndex];
        int pos = (int)f.length();
        int newDataLength = key.KeyLength - 13 + bv.length;
        if (newDataLength > key.DataLength) {
            int newSize;
            if (key.DataFileIndex < this.maxFileIndex) {
                key.DataFileIndex = this.maxFileIndex;
                f = this.valueFiles[this.maxFileIndex];
                pos = (int)f.length();
            }
            if ((newSize = pos + newDataLength) > 0x7D000000) {
                f.seek((long)key.DataAddress);
                f.writeByte(0);
                this.maxFileIndex = (short)(this.maxFileIndex + 1);
                BufferedRandomAccessFile fk = new BufferedRandomAccessFile(this.cacheDirectory + "key" + this.maxFileIndex + ".dat", "rw");
                BufferedRandomAccessFile fv = new BufferedRandomAccessFile(this.cacheDirectory + "value" + this.maxFileIndex + ".dat", "rw");
                this.keyFiles = (BufferedRandomAccessFile[])ArrayUtils.add((Object[])this.keyFiles, (Object)fk);
                this.valueFiles = (BufferedRandomAccessFile[])ArrayUtils.add((Object[])this.valueFiles, (Object)fv);
                f = this.valueFiles[this.maxFileIndex];
                key.DataFileIndex = this.maxFileIndex;
                pos = 0;
                f.setLength((long)newDataLength);
            } else {
                pos = (int)f.length();
                f.setLength((long)newSize);
            }
            f = this.keyFiles[key.KeyFileIndex];
            f.seek((long)(key.keyAddress + 1));
            f.writeShort((int)this.maxFileIndex);
            f.writeInt(newDataLength);
            f.writeInt(pos);
            ++this.modCount;
        } else {
            f = this.keyFiles[key.KeyFileIndex];
            f.seek((long)(key.keyAddress + 3));
            f.writeInt(newDataLength);
            pos = key.DataAddress;
        }
        f = this.valueFiles[key.DataFileIndex];
        f.seek((long)pos);
        f.writeByte(1);
        byte[] bk = key.KeyString.getBytes();
        f.writeInt(bk.length);
        f.writeInt(bv.length);
        f.write(bk);
        f.write(bv);
    }

    private Key getKey(BufferedRandomAccessFile f) throws IOException {
        if (f.length() == 0L || f.readByte() == 0) {
            return null;
        }
        Key key = new Key();
        key.KeyFileIndex = f.readShort();
        key.KeyLength = f.readShort();
        key.keyAddress = f.readInt();
        f = this.keyFiles[key.KeyFileIndex];
        f.seek((long)key.keyAddress);
        if (f.readByte() == 0) {
            return null;
        }
        key.DataFileIndex = f.readShort();
        key.DataLength = f.readInt();
        key.DataAddress = f.readInt();
        f.readShort();
        byte[] bs = null;
        try {
            bs = new byte[key.KeyLength - 22];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f.read(bs);
        key.KeyString = new String(bs);
        return key;
    }

    private Key readKey(int index, String k) {
        int c = index % 0x10000000;
        index /= 0x10000000;
        if (this.addressFiles == null) {
            this.initFiles();
        }
        try {
            BufferedRandomAccessFile f = this.addressFiles[index];
            f.seek((long)(c * 9));
            Key key = this.getKey(f);
            if (key == null || key.KeyString.equals(k)) {
                return key;
            }
            do {
                f = this.keyFiles[key.KeyFileIndex];
                int pos = key.keyAddress + key.KeyLength - 9;
                f.seek((long)pos);
            } while ((key = this.getKey(f)) != null && !key.KeyString.equals(k));
            return key;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object readData(String k) throws IOException {
        int i = this.hash((Object)k);
        Key key = this.readKey(i, k);
        if (key == null) {
            return null;
        }
        BufferedRandomAccessFile f = this.valueFiles[key.DataFileIndex];
        f.seek((long)(key.DataAddress + 9 + key.KeyLength - 22));
        byte[] bv = new byte[key.DataLength - 9 - key.KeyLength + 22];
        f.read(bv);
        return this.toObject(bv);
    }

    private Object toObject(byte[] bs) {
        if (bs == null || bs.length == 0) {
            return null;
        }
        if (this.compressible) {
            try {
                bs = ZipUtil.unzip((byte[])bs);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (bs.length == 0) {
            return null;
        }
        byte type = bs[0];
        bs = ArrayUtils.subarray((byte[])bs, (int)1, (int)bs.length);
        if (type == 1) {
            return new Integer(NumberUtil.toInt((byte[])bs, (int)0));
        }
        if (type == 2) {
            return new Long(NumberUtil.toLong((byte[])bs));
        }
        if (type == 3) {
            return new String(bs);
        }
        if (type == 4) {
            return bs;
        }
        if (type == 5) {
            int[] arr = new int[bs.length / 4];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = NumberUtil.toInt((byte[])bs, (int)(i * 4));
            }
            return arr;
        }
        if (type == 6) {
            long[] arr = new long[bs.length / 8];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = NumberUtil.toInt((byte[])bs, (int)(i * 8));
            }
            return arr;
        }
        if (type == 7) {
            int length;
            ByteBuffer bb = ByteBuffer.allocate(bs.length);
            bb.put(bs);
            bb.flip();
            ArrayList<String> arr = new ArrayList<String>();
            int index = 0;
            do {
                length = bb.getInt();
                byte[] t = new byte[length];
                bb.get(t);
                arr.add(new String(t));
            } while ((index += 4 + length) != bs.length);
            String[] r = new String[arr.size()];
            for (int i = 0; i < r.length; ++i) {
                r[i] = (String)arr.get(i);
            }
            return r;
        }
        if (type == 8) {
            return FileUtil.unserialize((byte[])bs);
        }
        return null;
    }

    private byte[] toBytes(Object v) {
        int type = 0;
        byte[] bs = null;
        if (v instanceof Integer) {
            type = 1;
            bs = NumberUtil.toBytes((int)((Integer)v));
        } else if (v instanceof Long) {
            type = 2;
            bs = NumberUtil.toBytes((long)((Long)v));
        } else if (v instanceof String) {
            type = 3;
            bs = ((String)v).getBytes();
        } else if (v instanceof byte[]) {
            type = 4;
            bs = (byte[])v;
        } else if (v instanceof int[]) {
            type = 5;
            int[] arr = (int[])v;
            bs = new byte[4 * arr.length];
            for (int i = 0; i < arr.length; ++i) {
                NumberUtil.toBytes((int)arr[i], (byte[])bs, (int)(i * 4));
            }
        } else if (v instanceof long[]) {
            type = 6;
            long[] arr = (long[])v;
            bs = new byte[8 * arr.length];
            for (int i = 0; i < arr.length; ++i) {
                NumberUtil.toBytes((long)arr[i], (byte[])bs, (int)(i * 8));
            }
        } else if (v instanceof String[]) {
            type = 7;
            String[] arr = (String[])v;
            bs = new byte[]{};
            for (int i = 0; i < arr.length; ++i) {
                byte[] b = null;
                b = arr[i].getBytes();
                bs = ArrayUtils.addAll((byte[])bs, (byte[])NumberUtil.toBytes((int)b.length));
                bs = ArrayUtils.addAll((byte[])bs, (byte[])b);
            }
        } else if (v instanceof Serializable) {
            type = 8;
            bs = FileUtil.serialize((Serializable)((Serializable)v));
        }
        if (this.compressible) {
            return ZipUtil.zip((byte[])ArrayUtils.add((byte[])bs, (int)0, (byte)type));
        }
        return ArrayUtils.add((byte[])bs, (int)0, (byte)type);
    }

    private void loadInfo() {
        File f = new File(this.cacheDirectory);
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((f = new File(this.cacheDirectory + "meta.dat")).exists()) {
            byte[] bs = FileUtil.readByte((File)f);
            this.size = NumberUtil.toInt((byte[])bs, (int)0);
            this.total = NumberUtil.toInt((byte[])bs, (int)4);
            this.modCount = NumberUtil.toInt((byte[])bs, (int)8);
            this.maxFileIndex = NumberUtil.toShort((byte[])bs, (int)12);
            this.compressible = NumberUtil.toShort((byte[])bs, (int)14) == 1;
        } else {
            this.size = 0;
            this.maxFileIndex = 0;
            this.modCount = 0;
        }
    }

    public synchronized void save() {
        if (this.cacheDirectory != null) {
            File f = new File(this.cacheDirectory + "meta.dat");
            byte[] bs = new byte[16];
            NumberUtil.toBytes((int)this.size, (byte[])bs, (int)0);
            NumberUtil.toBytes((int)this.total, (byte[])bs, (int)4);
            NumberUtil.toBytes((int)this.modCount, (byte[])bs, (int)8);
            NumberUtil.toBytes((short)this.maxFileIndex, (byte[])bs, (int)12);
            NumberUtil.toBytes((short)((short)(this.compressible ? 1 : 0)), (byte[])bs, (int)14);
            FileUtil.writeByte((File)f, (byte[])bs);
        }
    }

    public synchronized void close() {
        int i;
        this.save();
        if (this.keyFiles != null) {
            for (i = 0; i < this.keyFiles.length; ++i) {
                try {
                    this.keyFiles[i].close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.addressFiles != null) {
            for (i = 0; i < this.addressFiles.length; ++i) {
                try {
                    this.addressFiles[i].close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.valueFiles != null) {
            for (i = 0; i < this.valueFiles.length; ++i) {
                try {
                    this.valueFiles[i].close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized boolean containsKey(String k) {
        if (this.map.containsKey((Object)k)) {
            return true;
        }
        int i = this.hash((Object)k);
        return this.readKey(i, k) != null;
    }

    public synchronized Entry firstEntry() {
        return Entry.first((FileCachedMapx)this);
    }

    private synchronized void put2(String k, Object value) {
        Object o = null;
        if (this.maxItemInMemory != 0) {
            o = this.map.put((Object)k, value);
        }
        try {
            if (o == null) {
                int i = this.hash((Object)k);
                Key key = this.readKey(i, k);
                if (key == null) {
                    this.writeData(k, value);
                    ++this.size;
                    if ((double)this.size > (double)this.total * 0.75) {
                        this.resize();
                    }
                } else {
                    this.writeData(k, value);
                }
            } else {
                this.writeData(k, value);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.save();
    }

    public void put(String k, Serializable v) {
        this.put2(k, (Object)v);
    }

    public void put(String k, int v) {
        this.put2(k, (Object)new Integer(v));
    }

    public void put(String k, long v) {
        this.put2(k, (Object)new Long(v));
    }

    public void put(String k, String v) {
        this.put2(k, (Object)v);
    }

    public void put(String k, byte[] v) {
        this.put2(k, (Object)v);
    }

    public void put(String k, int[] v) {
        this.put2(k, (Object)v);
    }

    public void put(String k, long[] v) {
        this.put2(k, (Object)v);
    }

    public void put(String k, String[] v) {
        this.put2(k, (Object)v);
    }

    public int getInt(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return Integer.MIN_VALUE;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b!");
    }

    public long getLong(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return Long.MIN_VALUE;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b!");
    }

    public String getString(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)((Object)o);
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b!");
    }

    public byte[] getByteArray(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b:" + key);
    }

    public int[] getIntArray(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b!");
    }

    public long[] getLongArray(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof long[]) {
            return (long[])o;
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b!");
    }

    public String[] getStringArray(String key) {
        Serializable o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        throw new RuntimeException("Key\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b!");
    }

    private synchronized void resize() throws IOException {
        if ((double)this.size < (double)this.total * 0.75) {
            return;
        }
        int total2 = this.total * 2;
        int fileCount = new Double(Math.ceil((double)total2 * 1.0 / 2.68435456E8)).intValue();
        BufferedRandomAccessFile[] files = new BufferedRandomAccessFile[fileCount];
        int prefix = new Double(Math.log(total2 / 16) / Math.log(2.0)).intValue();
        for (int i = 0; i < fileCount; ++i) {
            files[i] = new BufferedRandomAccessFile(this.cacheDirectory + prefix + "key" + i + ".idx", "rw");
            if (i == this.addressFileCount - 1) {
                files[i].setLength((long)((total2 - (this.addressFileCount - 1) * 0x10000000) * 9));
                continue;
            }
            files[i].setLength(-1879048192L);
        }
        byte[] empty = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < this.keyFiles.length; ++i) {
            BufferedRandomAccessFile f = this.keyFiles[i];
            int pos = 0;
            while (f.length() > (long)pos) {
                f.seek((long)pos);
                byte deleted = f.readByte();
                f.skipBytes(10);
                short len = f.readShort();
                if (deleted == 1) {
                    byte[] bs = new byte[len];
                    f.read(bs);
                    f.seek((long)(pos + 13 + len));
                    f.write(empty);
                    String k = new String(bs);
                    int index = FileCachedMapx.hash((Object)k, (int)total2);
                    int c = index % 0x10000000;
                    BufferedRandomAccessFile af = files[index /= 0x10000000];
                    af.seek((long)(c * 9));
                    if (af.readByte() == 0) {
                        af.seek((long)(c * 9));
                        af.writeByte(1);
                        af.writeShort(i);
                        af.writeShort(22 + bs.length);
                        af.writeInt(pos);
                    } else {
                        int pos2;
                        BufferedRandomAccessFile kf;
                        af.seek((long)(c * 9));
                        Key key = this.getKey(af);
                        if (key == null) {
                            throw new RuntimeException("\u53d1\u751f\u81f4\u547d\u9519\u8bef\uff0c\u5e94\u5f53\u6709Key\u7684\u4f4d\u7f6e\u672a\u627e\u5230Key.");
                        }
                        do {
                            kf = this.keyFiles[key.KeyFileIndex];
                            pos2 = key.keyAddress + key.KeyLength - 9;
                            kf.seek((long)pos2);
                        } while ((key = this.getKey(kf)) != null);
                        kf.seek((long)pos2);
                        kf.writeByte(1);
                        kf.writeShort(i);
                        kf.writeShort(22 + bs.length);
                        kf.writeInt(pos);
                    }
                }
                pos += len + 22;
            }
        }
        BufferedRandomAccessFile[] tmp = this.addressFiles;
        this.addressFiles = files;
        this.total = total2;
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i].delete();
        }
    }

    public synchronized Serializable get(String k) {
        Object o = null;
        if (this.maxItemInMemory != 0) {
            o = this.map.get((Object)k);
        }
        if (o != null) {
            return (Serializable)o;
        }
        try {
            return (Serializable)this.readData(k);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized boolean remove(String k) {
        this.map.remove((Object)k);
        int index = this.hash((Object)k);
        int c = index % 0x10000000;
        index /= 0x10000000;
        try {
            int pos2;
            short index2;
            if (this.addressFiles == null) {
                this.initFiles();
            }
            BufferedRandomAccessFile f = this.addressFiles[index];
            f.seek((long)(c * 9));
            Key key = this.getKey(f);
            if (key == null) {
                return false;
            }
            if (key.KeyString.equals(k)) {
                f = this.keyFiles[key.KeyFileIndex];
                int pos = key.keyAddress + key.KeyLength - 9;
                f.seek((long)pos);
                if (f.readByte() == 0) {
                    f = this.addressFiles[index];
                    f.seek((long)(c * 9));
                    f.writeByte(0);
                } else {
                    f.seek((long)pos);
                    byte[] bs = new byte[9];
                    f.read(bs);
                    f = this.addressFiles[index];
                    f.seek((long)(c * 9));
                    f.write(bs);
                }
                f = this.keyFiles[key.KeyFileIndex];
                f.seek((long)key.keyAddress);
                f.writeByte(0);
                f = this.valueFiles[key.DataFileIndex];
                f.seek((long)key.DataAddress);
                f.writeByte(0);
                --this.size;
                ++this.modCount;
                this.save();
                return true;
            }
            do {
                index2 = key.KeyFileIndex;
                f = this.keyFiles[index2];
                pos2 = key.keyAddress + key.KeyLength - 9;
                f.seek((long)pos2);
                key = this.getKey(f);
                if (key != null) continue;
                return false;
            } while (!key.KeyString.equals(k));
            f = this.keyFiles[key.KeyFileIndex];
            f.seek((long)key.keyAddress);
            f.writeByte(0);
            int pos = key.keyAddress + key.KeyLength - 9;
            f.seek((long)pos);
            if (f.readByte() == 1) {
                f.seek((long)pos);
                byte[] bs = new byte[9];
                f.read(bs);
                f = this.keyFiles[index2];
                f.seek((long)pos2);
                f.write(bs);
            }
            f = this.valueFiles[key.DataFileIndex];
            f.seek((long)key.DataAddress);
            f.writeByte(0);
            --this.size;
            ++this.modCount;
            this.save();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized void refactor() {
        if ((double)this.total * 0.5 > (double)this.modCount) {
            return;
        }
    }

    private int hash(Object x) {
        return FileCachedMapx.hash((Object)x, (int)this.total);
    }

    public static int hash(Object x, int length) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public String getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(String cacheDirectory) {
        if (cacheDirectory.endsWith("/") || cacheDirectory.endsWith("\\")) {
            cacheDirectory = cacheDirectory + "/";
        }
        this.cacheDirectory = cacheDirectory;
    }

    public int getMaxItemInMemory() {
        return this.maxItemInMemory;
    }

    public void setMaxItemInMemory(int maxItemInMemory) {
        this.maxItemInMemory = maxItemInMemory;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    static /* synthetic */ BufferedRandomAccessFile[] access$000(FileCachedMapx x0) {
        return x0.valueFiles;
    }

    static /* synthetic */ Object access$100(FileCachedMapx x0, byte[] x1) {
        return x0.toObject(x1);
    }

    static /* synthetic */ BufferedRandomAccessFile[] access$200(FileCachedMapx x0) {
        return x0.addressFiles;
    }

    static /* synthetic */ void access$300(FileCachedMapx x0) {
        x0.initFiles();
    }

    static /* synthetic */ BufferedRandomAccessFile[] access$400(FileCachedMapx x0) {
        return x0.keyFiles;
    }

    static /* synthetic */ short access$500(FileCachedMapx x0) {
        return x0.maxFileIndex;
    }
}

