/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import com.sobey.bsp.framework.utility.GIFEncoder;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.NumberUtil;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageJDKUtil {
    public static BufferedImage scaleRate(BufferedImage srcImage, double rate) {
        return ImageJDKUtil.scaleRate((BufferedImage)srcImage, (double)rate, (double)rate, null);
    }

    public static BufferedImage scaleRate(BufferedImage srcImage, int width, int height) {
        double w = srcImage.getWidth();
        double h = srcImage.getHeight();
        if (w < (double)width && h < (double)height) {
            return srcImage;
        }
        if (height == 0) {
            if (w <= (double)width) {
                return srcImage;
            }
            return ImageJDKUtil.scaleRate((BufferedImage)srcImage, (double)((double)width / w), (double)((double)width / w), null);
        }
        if (width == 0) {
            if (h <= (double)height) {
                return srcImage;
            }
            return ImageJDKUtil.scaleRate((BufferedImage)srcImage, (double)((double)height / h), (double)((double)height / h), null);
        }
        if (w / h > (double)(width / height)) {
            return ImageJDKUtil.scaleRate((BufferedImage)srcImage, (double)((double)width / w), (double)((double)width / w), null);
        }
        return ImageJDKUtil.scaleRate((BufferedImage)srcImage, (double)((double)height / h), (double)((double)height / h), null);
    }

    public static BufferedImage gray(BufferedImage srcImage) {
        BufferedImage dstImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), srcImage.getType());
        Graphics2D g2 = dstImage.createGraphics();
        RenderingHints hints = g2.getRenderingHints();
        g2.dispose();
        ColorSpace grayCS = ColorSpace.getInstance(1003);
        ColorConvertOp colorConvertOp = new ColorConvertOp(grayCS, hints);
        colorConvertOp.filter(srcImage, dstImage);
        return dstImage;
    }

    public static BufferedImage scaleRate(BufferedImage srcImage, double xscale, double yscale, RenderingHints hints) {
        int width = (int)((double)srcImage.getWidth() * xscale);
        int height = (int)((double)srcImage.getHeight() * yscale);
        BufferedImage image = new BufferedImage(width, height, 1);
        image.getGraphics().drawImage(srcImage.getScaledInstance(width, height, 16), 0, 0, null);
        return image;
    }

    public static BufferedImage scaleFixed(BufferedImage srcImage, int width, int height, boolean changeRate) {
        if (changeRate) {
            int srcWidth = srcImage.getWidth();
            int srcHeight = srcImage.getHeight();
            int w = 0;
            int h = 0;
            double wScale = (double)srcWidth * 1.0 / (double)width * 1.0;
            double hScale = (double)srcHeight * 1.0 / (double)height * 1.0;
            if (wScale > hScale) {
                int srcWidth2 = (int)((double)width * hScale);
                w = (srcWidth - srcWidth2) / 2;
                srcWidth = srcWidth2;
                h = 0;
            } else {
                int srcHeight2 = (int)((double)height * wScale);
                h = (srcHeight - srcHeight2) / 2;
                srcHeight = srcHeight2;
                w = 0;
            }
            CropImageFilter cropFilter = new CropImageFilter(w, h, srcWidth, srcHeight);
            Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(srcImage.getSource(), cropFilter));
            BufferedImage bi = new BufferedImage(srcWidth, srcHeight, 1);
            bi.getGraphics().drawImage(img, 0, 0, null);
            return ImageJDKUtil.scaleRate((BufferedImage)bi, (int)width, (int)height);
        }
        BufferedImage bi = new BufferedImage(width, height, 1);
        bi.getGraphics().drawImage(srcImage.getScaledInstance(width, height, 16), 0, 0, null);
        return bi;
    }

    public static void scaleFixedImageFile(String srcFile, String destFile, int width, int height) throws IOException {
        ImageJDKUtil.scaleFixedImageFile((String)srcFile, (String)destFile, (int)width, (int)height, (boolean)true);
    }

    public static void scaleFixedImageFile(String srcFile, String destFile, int width, int height, boolean changeRate) throws IOException {
        File f = new File(srcFile);
        try {
            BufferedImage image = ImageIO.read(f);
            BufferedImage newImage = ImageJDKUtil.scaleFixed((BufferedImage)image, (int)width, (int)height, (boolean)changeRate);
            ImageJDKUtil.writeImageFile((String)destFile, (BufferedImage)newImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        ImageJDKUtil.scaleFixedImageFile((String)"e:/3.jpg", (String)"e:/4.jpg", (int)300, (int)300);
    }

    public static void scaleRateImageFile(String srcFile, String destFile, int width, int height) throws IOException {
        File f = new File(srcFile);
        try {
            BufferedImage image = ImageIO.read(f);
            BufferedImage newImage = ImageJDKUtil.scaleRate((BufferedImage)image, (int)width, (int)height);
            ImageJDKUtil.writeImageFile((String)destFile, (BufferedImage)newImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scaleRateImageFile(File srcFile, String destFile, int width, int height) throws IOException {
        File f = srcFile;
        try {
            BufferedImage image = ImageIO.read(f);
            BufferedImage newImage = ImageJDKUtil.scaleRate((BufferedImage)image, (int)width, (int)height);
            ImageJDKUtil.writeImageFile((String)destFile, (BufferedImage)newImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scaleRateImageFile(String srcFile, String destFile, double rate) throws IOException {
        File f = new File(srcFile);
        try {
            BufferedImage image = ImageIO.read(f);
            BufferedImage newImage = ImageJDKUtil.scaleRate((BufferedImage)image, (double)rate);
            ImageJDKUtil.writeImageFile((String)destFile, (BufferedImage)newImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void scaleRateImageFile(File srcFile, String destFile, double rate) throws IOException {
        File f = srcFile;
        try {
            BufferedImage image = ImageIO.read(f);
            BufferedImage newImage = ImageJDKUtil.scaleRate((BufferedImage)image, (double)rate);
            ImageJDKUtil.writeImageFile((String)destFile, (BufferedImage)newImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void grayImageFile(String srcFile, String destFile) throws IOException {
        ImageJDKUtil.writeImageFile((String)destFile, (BufferedImage)ImageJDKUtil.gray((BufferedImage)ImageIO.read(new File(srcFile))));
    }

    public static void writeImageFile(String fileName, BufferedImage image) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        if (fileName.toLowerCase().endsWith(".gif")) {
            GIFEncoder gif = new GIFEncoder((Image)image, (OutputStream)fos);
            gif.encode();
        }
        if (fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".jpeg") || fileName.toLowerCase().endsWith(".png")) {
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(1.0f, false);
            encoder.encode(image);
        }
        fos.flush();
        fos.close();
    }

    public static Dimension getDimension(String fileName) throws IOException {
        File f = new File(fileName);
        return ImageJDKUtil.getDimension((File)f);
    }

    public static Dimension getDimension(File f) throws IOException {
        BufferedImage image = ImageIO.read(f);
        if (image == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(image.getWidth(), image.getHeight());
    }

    public static final void pressImage(String targetImg, String pressImg, int position) {
        try {
            File file = new File(targetImg);
            BufferedImage src = ImageIO.read(file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            if (wideth <= 300 && height <= 300) {
                return;
            }
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            File file_press = new File(pressImg);
            if (!file_press.exists()) {
                LogUtil.warn((Object)("\u6c34\u5370\u56fe\u7247\u4e0d\u5b58\u5728\uff1a" + pressImg));
                return;
            }
            BufferedImage src_press = ImageIO.read(file_press);
            int wideth_press = ((Image)src_press).getWidth(null);
            int height_press = ((Image)src_press).getHeight(null);
            int x = 0;
            int y = 0;
            int bianju = 20;
            int[][][] positions = new int[][][]{new int[][]{{bianju, bianju}, {(wideth - wideth_press) / 2, bianju}, {wideth - wideth_press - bianju, bianju}}, new int[][]{{bianju, (height - height_press) / 2}, {(wideth - wideth_press) / 2, (height - height_press) / 2}, {wideth - wideth_press - bianju, (height - height_press) / 2}}, new int[][]{{bianju, height - height_press - bianju}, {(wideth - wideth_press) / 2, height - height_press - bianju}, {wideth - wideth_press - bianju, height - height_press - bianju}}};
            if (position == 0) {
                position = NumberUtil.getRandomInt((int)9) + 1;
            }
            x = positions[(position - 1) / 3][(position - 1) % 3][0];
            y = positions[(position - 1) / 3][(position - 1) % 3][1];
            g.drawImage(src_press, x, y, wideth_press, height_press, null);
            g.dispose();
            FileOutputStream out = new FileOutputStream(targetImg);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(image);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void pressImage(String targetImg, String pressImg) {
        ImageJDKUtil.pressImage((String)targetImg, (String)pressImg, (int)9);
    }

    public static void pressText(String targetImg, String pressText, int color, int fontSize, int position) {
        ImageJDKUtil.pressText((String)targetImg, (String)pressText, (String)"\u5b8b\u4f53", (int)1, (int)color, (int)fontSize, (int)position);
    }

    public static void pressText(String targetImg, String pressText, String fontName, int fontStyle, int color, int fontSize, int position) {
        try {
            int y;
            int x;
            File _file = new File(targetImg);
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            if (wideth <= 300 && height <= 300) {
                return;
            }
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            g.setColor(new Color(color));
            g.setFont(new Font(fontName, fontStyle, fontSize));
            if (position == 0) {
                x = NumberUtil.getRandomInt((int)wideth);
                x = x < fontSize * 2 ? fontSize * 2 : x;
                y = NumberUtil.getRandomInt((int)height);
                y = y < fontSize * 2 / 2 ? fontSize * 2 : y;
            } else {
                x = wideth * ((position - 1) % 3) / 3 + fontSize * 2;
                y = height * ((position - 1) / 3) / 3 + fontSize * 2;
            }
            if (x > wideth - fontSize * pressText.length() * 4 / 3) {
                x = wideth - fontSize * pressText.length() * 4 / 3;
            }
            if (y > height - fontSize) {
                y = height - fontSize;
            }
            ((Graphics)g).drawString(pressText, x, y);
            g.dispose();
            FileOutputStream out = new FileOutputStream(targetImg);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(image);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void transform(File src, File dest) {
        ImageJDKUtil.transform((File)src, (File)dest, (int)1600);
    }

    public static void transform(File src, File dest, int nw) {
        try {
            AffineTransform transform = new AffineTransform();
            BufferedImage bis = ImageIO.read(src);
            int w = bis.getWidth();
            int h = bis.getHeight();
            int nh = nw * h / w;
            double sx = (double)nw / (double)w;
            double sy = (double)nh / (double)h;
            transform.setToScale(sx, sy);
            AffineTransformOp ato = new AffineTransformOp(transform, null);
            BufferedImage bid = new BufferedImage(nw, nh, 5);
            ato.filter(bis, bid);
            ImageIO.write((RenderedImage)bid, "jpg", dest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

