/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.utility.ExitEventListener;
import com.sobey.bsp.framework.utility.LogUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Mapx
extends LinkedHashMap {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INIT_CAPACITY = 16;
    private static final long serialVersionUID = 200904201752L;
    private final int maxCapacity;
    private final boolean maxFlag;
    private int hitCount = 0;
    private int missCount = 0;
    private long lastWarnTime = 0L;
    private ExitEventListener listener;

    public Mapx(int maxCapacity, boolean lruFlag) {
        super(maxCapacity, 0.75f, lruFlag);
        this.maxCapacity = maxCapacity;
        this.maxFlag = true;
    }

    public Mapx(int maxCapacity) {
        this(maxCapacity, true);
    }

    public Mapx() {
        super(16, 0.75f, false);
        this.maxCapacity = 0;
        this.maxFlag = false;
    }

    @Override
    public Object clone() {
        Mapx map = (Mapx)super.clone();
        Object[] ks = this.keyArray();
        Object[] vs = this.valueArray();
        for (int i = 0; i < ks.length; ++i) {
            Object v = vs[i];
            if (!(v instanceof Mapx)) continue;
            map.put(ks[i], ((Mapx)v).clone());
        }
        return map;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        boolean flag;
        boolean bl = flag = this.maxFlag && this.size() > this.maxCapacity;
        if (flag && this.listener != null) {
            this.listener.onExit(eldest.getKey(), eldest.getValue());
        }
        return flag;
    }

    public void setExitEventListener(ExitEventListener listener) {
        this.listener = listener;
    }

    public Object[] keyArray() {
        if (this.size() == 0) {
            return new Object[0];
        }
        Object[] arr = new Object[this.size()];
        int i = 0;
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            arr[i++] = iter.next();
        }
        return arr;
    }

    public Object[] valueArray() {
        if (this.size() == 0) {
            return new Object[0];
        }
        Object[] arr = new Object[this.size()];
        int i = 0;
        Iterator iter = this.values().iterator();
        while (iter.hasNext()) {
            arr[i++] = iter.next();
        }
        return arr;
    }

    public String getString(Object key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public void put(Object key, int num) {
        this.put(key, (Object)new Integer(num));
    }

    @Override
    public void put(Object key, long num) {
        this.put(key, (Object)new Long(num));
    }

    public int getInt(Object key) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o != null) {
            try {
                return Integer.parseInt(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public long getLong(Object key) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o != null) {
            try {
                return Long.parseLong(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (this.maxFlag) {
            if (o == null) {
                ++this.missCount;
            } else {
                ++this.hitCount;
            }
            if (this.missCount > 1000 && (double)this.hitCount * 1.0 / (double)this.missCount < 0.1 && System.currentTimeMillis() - this.lastWarnTime > 1000000L) {
                this.lastWarnTime = System.currentTimeMillis();
                StackTraceElement[] stack = new Throwable().getStackTrace();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < stack.length; ++i) {
                    StackTraceElement ste = stack[i];
                    if (ste.getClassName().indexOf("DBConnPoolImpl") != -1) continue;
                    sb.append("\t");
                    sb.append(ste.getClassName());
                    sb.append(".");
                    sb.append(ste.getMethodName());
                    sb.append("(),\u884c\u53f7:");
                    sb.append(ste.getLineNumber());
                    sb.append("\n");
                }
                LogUtil.warn((Object)"\u7f13\u5b58\u547d\u4e2d\u7387\u8fc7\u4f4e!");
                LogUtil.warn((Object)sb);
            }
        }
        return o;
    }

    public static Mapx convertToMapx(Map map) {
        Mapx mapx = new Mapx();
        mapx.putAll(map);
        return mapx;
    }

    public DataTable toDataTable() {
        DataColumn[] dcs = new DataColumn[]{new DataColumn("Key", 1), new DataColumn("Value", 1)};
        Object[] ks = this.keyArray();
        Object[][] vs = new Object[ks.length][2];
        DataTable dt = new DataTable(dcs, vs);
        for (int i = 0; i < ks.length; ++i) {
            dt.set(i, 0, ks[i]);
            dt.set(i, 1, this.get(ks[i]));
        }
        return dt;
    }
}

