/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static final String DEFAULT_PAGE_DIR = "template/";
    public static final String DEFAULT_CHAR_SET = "UTF-8";
    private static final String CONF_FILE = "velocity.properties";
    private static VelocityUtil util = null;
    private VelocityEngine engine = null;
    private static Map cache = new HashMap(0);

    public static synchronized VelocityUtil getInstance() {
        util = new VelocityUtil();
        return util;
    }

    public String renderTemplate(String template, Context context) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bytes);
        this.engine.mergeTemplate(DEFAULT_PAGE_DIR + template, context, (Writer)writer);
        writer.flush();
        String outputTemplate = new String(bytes.toByteArray());
        writer.close();
        return outputTemplate;
    }

    private VelocityUtil() {
        try {
            this.engine = new VelocityEngine();
            this.engine.init(this.loadVelocityProps());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties loadVelocityProps() throws Exception {
        Properties props = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(CONF_FILE);
        props.load(is);
        return props;
    }

    public String render(String template, String para, Object value) {
        Context context;
        Object obj = cache.get(template);
        if (obj == null) {
            context = new VelocityContext();
            cache.put(template, context);
        } else {
            context = (Context)obj;
        }
        context.put(para, value);
        String txt = null;
        try {
            txt = this.renderTemplate(template, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return txt;
    }

    public String getRequestXml(String template, String content, Object object) throws Exception {
        return this.render(template, content, object);
    }
}

