/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class WaterMark {
    private String imageFile = "";
    private String fontName = "\u5b8b\u4f53";
    private Color fontColor = Color.RED;
    private int fontSize = 14;
    public int imageHeight = 0;
    public int imageWidth = 0;

    public void setFont(String fontName, int fontColor, int fontSize) {
        this.fontName = fontName;
        this.fontColor = new Color(fontColor);
        this.fontSize = fontSize;
    }

    public void openFile(String imgf) {
        this.imageFile = imgf;
        if (this.imageFile.equals("")) {
            return;
        }
        try {
            File _file = new File(this.imageFile);
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            this.imageWidth = wideth;
            this.imageHeight = height;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(String text, int position, int ws) throws Exception {
        if (this.imageFile.equals("")) {
            return;
        }
        try {
            File img = new File(this.imageFile);
            BufferedImage src = ImageIO.read(img);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            int left = 0;
            int top = 0;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(this.fontColor);
            g.setFont(new Font(this.fontName, 0, this.fontSize));
            int strlen = text.getBytes().length / 2;
            if (ws < 0) {
                ws = 8;
            }
            switch (position) {
                case 1: {
                    left = ws;
                    top = this.fontSize + ws;
                    break;
                }
                case 2: {
                    left = width - strlen * this.fontSize - ws;
                    top = this.fontSize + ws;
                    break;
                }
                case 3: {
                    left = (width - strlen * this.fontSize) / 2;
                    top = (height - this.fontSize) / 2 + ws;
                    break;
                }
                case 4: {
                    left = ws;
                    top = height - ws;
                    break;
                }
                case 5: {
                    left = width - strlen * this.fontSize - ws;
                    top = height - ws;
                    break;
                }
                default: {
                    left = width - strlen * this.fontSize - ws;
                    top = height - ws;
                }
            }
            if (left < 0) {
                left = 0;
            }
            if (top < 0) {
                top = 0;
            }
            ((Graphics)g).drawString(text, left, top);
            g.dispose();
            FileOutputStream out = new FileOutputStream(this.imageFile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(image);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

