/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.utility;

import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    public static byte[] zip(byte[] bs) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Deflater def = new Deflater();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, def);
        try {
            dos.write(bs);
            dos.finish();
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] r = bos.toByteArray();
        return r;
    }

    public static byte[] gzip(byte[] bs) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream dos = new GZIPOutputStream(bos);
            dos.write(bs);
            dos.finish();
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] r = bos.toByteArray();
        return r;
    }

    public static void zip(String srcFile, String destFile) throws Exception {
        FileOutputStream os = new FileOutputStream(destFile);
        ZipUtil.zip((File)new File(srcFile), (OutputStream)os);
        os.flush();
        ((OutputStream)os).close();
    }

    public static void zip(File srcFile, OutputStream destStream) throws Exception {
        List fileList = ZipUtil.getSubFiles((File)srcFile);
        ZipOutputStream zos = new ZipOutputStream(destStream);
        ZipEntry ze = null;
        byte[] buf = new byte[1024];
        int readLen = 0;
        for (int i = 0; i < fileList.size(); ++i) {
            File f = (File)fileList.get(i);
            ze = new ZipEntry(ZipUtil.getAbsFileName((File)srcFile, (File)f));
            ze.setSize(f.length());
            ze.setTime(f.lastModified());
            LogUtil.info((Object)("\u6b63\u5728\u538b\u7f29: " + f.getPath()));
            zos.putNextEntry(ze);
            if (!f.isFile()) continue;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                zos.write(buf, 0, readLen);
            }
            ((InputStream)is).close();
            zos.flush();
        }
        zos.close();
        LogUtil.info((Object)"\u538b\u7f29\u5b8c\u6bd5\uff01");
    }

    public static void zipBatch(String[] srcFiles, String destFile) throws Exception {
        FileOutputStream os = new FileOutputStream(destFile);
        ZipUtil.zipBatch((String[])srcFiles, (OutputStream)os);
        os.flush();
        ((OutputStream)os).close();
    }

    public static void zipBatch(String[] srcFiles, OutputStream destStream) throws Exception {
        File[] files = new File[srcFiles.length];
        for (int i = 0; i < srcFiles.length; ++i) {
            files[i] = new File(srcFiles[i]);
        }
        ZipUtil.zipBatch((File[])files, (OutputStream)destStream);
    }

    public static void zipBatch(File[] srcFiles, OutputStream destStream) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(destStream);
        for (int k = 0; k < srcFiles.length; ++k) {
            List fileList = ZipUtil.getSubFiles((File)srcFiles[k]);
            ZipEntry ze = null;
            byte[] buf = new byte[1024];
            int readLen = 0;
            for (int i = 0; i < fileList.size(); ++i) {
                File f = (File)fileList.get(i);
                ze = new ZipEntry(ZipUtil.getAbsFileName((File)srcFiles[k], (File)f));
                ze.setSize(f.length());
                ze.setTime(f.lastModified());
                LogUtil.info((Object)("\u6b63\u5728\u538b\u7f29: " + f.getPath()));
                zos.putNextEntry(ze);
                if (!f.isFile()) continue;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                    zos.write(buf, 0, readLen);
                }
                ((InputStream)is).close();
            }
        }
        zos.close();
        LogUtil.info((Object)"\u538b\u7f29\u5b8c\u6bd5\uff01");
    }

    public static void zipStream(InputStream is, OutputStream os, String fileName) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(os);
        ZipEntry ze = null;
        byte[] buf = new byte[1024];
        int readLen = 0;
        ze = new ZipEntry(fileName);
        ze.setTime(System.currentTimeMillis());
        LogUtil.info((Object)("\u6b63\u5728\u538b\u7f29\u6d41:   " + fileName));
        zos.putNextEntry(ze);
        long total = 0L;
        while ((readLen = is.read(buf, 0, 1024)) != -1) {
            zos.write(buf, 0, readLen);
            total += (long)readLen;
        }
        ze.setSize(total);
        zos.flush();
        zos.close();
        LogUtil.info((Object)"\u538b\u7f29\u5b8c\u6bd5\uff01");
    }

    public static byte[] unzip(byte[] bs) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(bs);
        bos = new ByteArrayOutputStream();
        Inflater inf = new Inflater();
        InflaterInputStream dis = new InflaterInputStream(bis, inf);
        byte[] buf = new byte[1024];
        try {
            int c;
            while ((c = dis.read(buf)) != -1) {
                bos.write(buf, 0, c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] r = bos.toByteArray();
        return r;
    }

    public static byte[] ungzip(byte[] bs) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(bs);
        bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int c;
            GZIPInputStream gis = new GZIPInputStream(bis);
            while ((c = gis.read(buf)) != -1) {
                bos.write(buf, 0, c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] r = bos.toByteArray();
        return r;
    }

    public static boolean unzip(String srcFileName, String destPath) {
        try {
            ZipFile zipFile = new ZipFile(srcFileName);
            Enumeration e = zipFile.getEntries();
            ZipEntry zipEntry = null;
            new File(destPath).mkdirs();
            while (e.hasMoreElements()) {
                int c;
                zipEntry = (ZipEntry)e.nextElement();
                LogUtil.info((Object)("\u6b63\u5728\u89e3\u538b " + zipEntry.getName()));
                if (zipEntry.isDirectory()) {
                    new File(destPath + File.separator + zipEntry.getName()).mkdirs();
                    continue;
                }
                File f = new File(destPath + File.separator + zipEntry.getName());
                f.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(zipEntry);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buf = new byte[1024];
                while ((c = in.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, c);
                }
                ((OutputStream)out).close();
                in.close();
            }
            LogUtil.info((Object)"\u89e3\u538b\u5b8c\u6bd5\uff01");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean unzip(String srcFileName, String destPath, boolean isPath) {
        if (isPath) {
            return ZipUtil.unzip((String)srcFileName, (String)destPath);
        }
        try {
            ZipFile zipFile = new ZipFile(srcFileName);
            Enumeration e = zipFile.getEntries();
            ZipEntry zipEntry = null;
            new File(destPath).mkdirs();
            while (e.hasMoreElements()) {
                int c;
                zipEntry = (ZipEntry)e.nextElement();
                LogUtil.info((Object)("\u6b63\u5728\u89e3\u538b " + zipEntry.getName()));
                if (zipEntry.isDirectory()) continue;
                String fileName = zipEntry.getName();
                if (fileName.lastIndexOf("/") != -1) {
                    fileName = fileName.substring(fileName.lastIndexOf("/"));
                }
                File f = new File(destPath + "/" + fileName);
                InputStream in = zipFile.getInputStream(zipEntry);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buf = new byte[1024];
                while ((c = in.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, c);
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                in.close();
            }
            zipFile.close();
            LogUtil.info((Object)"\u89e3\u538b\u5b8c\u6bd5\uff01");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static List getSubFiles(File baseDir) {
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(baseDir);
        if (baseDir.isDirectory()) {
            File[] tmp = baseDir.listFiles();
            for (int i = 0; i < tmp.length; ++i) {
                ret.addAll(ZipUtil.getSubFiles((File)tmp[i]));
            }
        }
        return ret;
    }

    private static String getAbsFileName(File baseDir, File realFileName) {
        File real = realFileName;
        File base = baseDir;
        String ret = real.getName();
        if (real.isDirectory()) {
            ret = ret + "/";
        }
        while (real != base && (real = real.getParentFile()) != null) {
            if (real.equals(base)) {
                ret = real.getName() + "/" + ret;
                break;
            }
            ret = real.getName() + "/" + ret;
        }
        return ret;
    }

    public static void main(String[] args) {
        byte[] bs = FileUtil.readByte((String)"H:/shop.html");
        try {
            for (int i = 0; i < 10000; ++i) {
                bs = ZipUtil.zip((byte[])bs);
                bs = ZipUtil.unzip((byte[])bs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

