/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.xml.impl;

import com.sobey.bsp.framework.xml.XMLDocument;
import com.sobey.bsp.schema.SCMS_VideoSchema;
import com.sobey.bsp.schema.SCMS_VideoSet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class ContentInfoToXML
implements XMLDocument {
    public void createXML(String filename, Map<String, Object> map) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("CMSContentinfo");
        root.addElement("Contentid").addText(map.get("contentid").toString());
        root.addElement("Title").addText(map.get("title").toString());
        root.addElement("Tag").addText(map.get("tag").toString());
        root.addElement("Description").addText(map.get("description").toString());
        root.addElement("CreateTime").addText(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get("createTime")));
        if (map.get("series") != null) {
            root.addElement("SeriesName").addText(map.get("seriesName").toString());
            root.addElement("Part").addText(map.get("part").toString());
            root.addElement("Total").addText(map.get("total").toString());
            root.addElement("MainPlayer").addText(map.get("mainPlayer").toString());
            root.addElement("Director").addText(map.get("director").toString());
            root.addElement("ShootTopic").addText(map.get("shootTopic").toString());
            root.addElement("FirstPlayTime").addText(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get("firstPlayTime")));
        }
        Element siteAndCatalog = root.addElement("SiteAndCatalog");
        List siteAndCatalogList = (List)map.get("siteAndCatalog");
        Element keyFrames = root.addElement("KeyFrame");
        JSONArray ja = (JSONArray)map.get("keyFrame");
        Element contentFile = root.addElement("ContentFile");
        SCMS_VideoSet videoSet = (SCMS_VideoSet)map.get("videoset");
        for (String str : siteAndCatalogList) {
            Element item = siteAndCatalog.addElement("Item");
            item.addText(str);
        }
        if (ja != null && ja.size() > 0) {
            for (int i = 0; i < ja.size(); ++i) {
                Element keyFrameItem = keyFrames.addElement("KeyFrameItem");
                keyFrameItem.addText(ja.get(i).toString());
            }
        }
        for (int i = 0; i < videoSet.size(); ++i) {
            SCMS_VideoSchema video = videoSet.get(i);
            Element fileItem = contentFile.addElement("FileItem");
            fileItem.addElement("FileTypeID").addText(video.getFileTypeId());
            fileItem.addElement("FileLength").addText(map.get("programLength").toString());
            fileItem.addElement("FileSize").addText(video.getFileSize());
            if (map.get(video.getFileTypeId()) == null) continue;
            Element slices = fileItem.addElement("Slices");
            SCMS_VideoSet sliceVideoSet = (SCMS_VideoSet)map.get(video.getFileTypeId());
            for (int j = 0; j < sliceVideoSet.size(); ++j) {
                SCMS_VideoSchema sliceVideo = sliceVideoSet.get(j);
                Element sliceItem = slices.addElement("SliceItem");
                sliceItem.addElement("Number").addText(sliceVideo.getProp1());
                sliceItem.addElement("Length").addText(sliceVideo.getProp2());
                sliceItem.addElement("Size").addText(sliceVideo.getProp3());
                sliceItem.addElement("FileUrl").addText(sliceVideo.getFileName());
            }
        }
        try {
            XMLWriter xmlWriter = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

