/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataCollection;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_DistrictSchema;
import com.sobey.bsp.schema.SCMS_DistrictSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class District
extends Page {
    static Mapx codeMap;
    static Mapx nameMap;
    static DataTable table;

    public static void dg1BindDistrict(DataGridAction dga) {
        String sql = " select * from SCMS_District where TreeLevel = 1 or TreeLevel = 2 order by CodeOrder ";
        if (dga.getTotal() == 0) {
            dga.setTotal(new QueryBuilder("select count(*) from SCMS_District where TreeLevel = 1 or TreeLevel = 2"));
        }
        dga.bindData(new QueryBuilder(sql));
    }

    public static void dg1BindDistrictList(DataGridAction dga) {
        String code = dga.getParam("Code");
        if (StringUtil.isEmpty((String)code)) {
            dga.bindData(new DataTable());
            return;
        }
        String parentCode = "";
        SCMS_DistrictSchema district = new SCMS_DistrictSchema();
        district.setCode(code);
        district.fill();
        parentCode = "0".equals(district.getType()) ? code.substring(0, 2) : code.substring(0, 4);
        dga.setTotal(new QueryBuilder("select count(*) from SCMS_District where TreeLevel = '3' and code like ?", (Object)(parentCode + "%")));
        dga.bindData(new QueryBuilder(" select * from SCMS_District where TreeLevel = '3' and code like ? order by CodeOrder ", (Object)(parentCode + "%")));
    }

    public static Mapx init(Mapx params) {
        Mapx map = new Mapx();
        String code = (String)params.get((Object)"Code");
        map.put((Object)"Code", (Object)code);
        String Name = new QueryBuilder("select name from SCMS_District where code = ?", (Object)code).executeString();
        map.put((Object)"Name", (Object)Name);
        return map;
    }

    public static Mapx initDialog(Mapx params) {
        params.put((Object)"Name", (Object)"");
        return params;
    }

    public void add() {
        SCMS_DistrictSchema district = new SCMS_DistrictSchema();
        String code = this.$V("Code");
        district.setCode(code);
        if (district.fill()) {
            this.Response.setLogInfo(0, district.getCode() + "\u5df2\u7ecf\u5b58\u5728\u4e86!");
            return;
        }
        district.setValue((DataCollection)this.Request);
        if (district.insert()) {
            this.Response.setLogInfo(1, "\u65b0\u5efa\u6210\u529f!");
        } else {
            this.Response.setLogInfo(0, "\u65b0\u5efa\u5931\u8d25!");
        }
    }

    public void dg1Edit() {
        DataTable dt = (DataTable)this.Request.get("DT");
        SCMS_DistrictSet set = new SCMS_DistrictSet();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            SCMS_DistrictSchema district = new SCMS_DistrictSchema();
            district.setCode(dt.getString(i, "Code"));
            if (!district.fill()) {
                this.Response.setLogInfo(0, "\u60a8\u8981\u4fee\u6539\u7684\u9879" + dt.getString(i, "Code") + "\u4e0d\u5b58\u5728!");
                return;
            }
            district.setValue(dt.getDataRow(i));
            set.add(district);
        }
        if (set.update()) {
            District.generateDistrictJS();
            this.Response.setStatus(1);
            this.Response.setMessage("\u4fdd\u5b58\u6210\u529f!");
        } else {
            this.Response.setStatus(0);
            this.Response.setMessage("\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    public void del() {
        String IDs = this.$V("IDs");
        String[] ids = IDs.split(",");
        String code = "";
        Transaction trans = new Transaction();
        SCMS_DistrictSchema district = new SCMS_DistrictSchema();
        for (int i = 0; i < ids.length; ++i) {
            district.setCode(ids[i]);
            if (!district.fill()) continue;
            if (district.getTreeLevel() == 1) {
                code = ids[i].substring(0, 2);
            } else if (district.getTreeLevel() == 2) {
                code = ids[i].substring(0, 4);
            } else if (district.getTreeLevel() == 3) {
                code = ids[i];
            }
            trans.add((SchemaSet)district.query(new QueryBuilder(" where Code like ?", (Object)(code + "%"))), 3);
        }
        if (trans.commit()) {
            this.Response.setLogInfo(1, "\u5220\u9664\u6210\u529f");
        } else {
            this.Response.setLogInfo(0, "\u5220\u9664\u5931\u8d25");
        }
    }

    public static void generateDistrictJS() {
        SCMS_DistrictSet set = new SCMS_DistrictSchema().query(new QueryBuilder("where code!='000000' order by code"));
        StringBuffer provinceMap = new StringBuffer();
        StringBuffer cityMap = new StringBuffer();
        StringBuffer districtMap = new StringBuffer();
        provinceMap.append("var provinceMap = [");
        cityMap.append("var cityMap = {\n");
        districtMap.append("var districtMap = {\n");
        boolean firstProv = true;
        boolean firstCity = true;
        boolean firstDistrict = true;
        for (int i = 0; i < set.size(); ++i) {
            int k;
            int j;
            SCMS_DistrictSchema d = set.get(i);
            if ("1".equals(d.getType())) {
                if (!firstProv) {
                    provinceMap.append(",");
                }
                firstProv = false;
                provinceMap.append("'" + d.getCode() + "','" + d.getName() + "'");
                if (!firstCity) {
                    cityMap.append(",\n");
                }
                cityMap.append("'" + d.getCode() + "':[");
                for (j = i + 1; j < set.size(); ++j) {
                    d = set.get(j);
                    if ("2".equals(d.getType())) {
                        firstCity = false;
                        if (j == i + 1) {
                            cityMap.append("'" + d.getCode() + "','" + d.getName() + "'");
                        } else {
                            cityMap.append(",'" + d.getCode() + "','" + d.getName() + "'");
                        }
                        if (!firstDistrict) {
                            districtMap.append(",\n");
                        }
                        districtMap.append("'" + d.getCode() + "':[");
                        for (k = j + 1; k < set.size() && "3".equals((d = set.get(k)).getType()); ++k) {
                            firstDistrict = false;
                            if (k == j + 1) {
                                districtMap.append("'" + d.getCode() + "','" + d.getName() + "'");
                                continue;
                            }
                            districtMap.append(",'" + d.getCode() + "','" + d.getName() + "'");
                        }
                        districtMap.append("]");
                        continue;
                    }
                    if ("1".equals(d.getType()) || "0".equals(d.getType())) break;
                }
                cityMap.append("]");
                continue;
            }
            if (!"0".equals(d.getType())) continue;
            if (!firstProv) {
                provinceMap.append(",");
            }
            firstProv = false;
            provinceMap.append("'" + d.getCode() + "','" + d.getName() + "'");
            if (!firstCity) {
                cityMap.append(",\n");
            }
            cityMap.append("'" + d.getCode() + "':[");
            for (j = i; j < i + 1; ++j) {
                d = set.get(j);
                if ("0".equals(d.getType())) {
                    firstCity = false;
                    cityMap.append("'" + d.getCode() + "','" + d.getName() + "'");
                    if (!firstDistrict) {
                        districtMap.append(",\n");
                    }
                    districtMap.append("'" + d.getCode() + "':[");
                    for (k = j + 1; k < set.size() && "3".equals((d = set.get(k)).getType()); ++k) {
                        firstDistrict = false;
                        if (k == j + 1) {
                            districtMap.append("'" + d.getCode() + "','" + d.getName() + "'");
                            continue;
                        }
                        districtMap.append(",'" + d.getCode() + "','" + d.getName() + "'");
                    }
                    districtMap.append("]");
                    continue;
                }
                if ("1".equals(d.getType())) break;
            }
            cityMap.append("]");
        }
        provinceMap.append("];\n");
        cityMap.append("};\n");
        districtMap.append("};\n");
        String path = Config.getContextRealPath() + "WEB-INF/classes/com/sobey/bsp/Platform/district.template";
        String func = FileUtil.readText((String)path);
        String JS = Config.getContextRealPath() + "Framework/District.js";
        FileUtil.writeText((String)JS, (String)(provinceMap.toString() + cityMap.toString() + districtMap.toString() + func));
    }

    public static String getProvinceName(String address) {
        String name;
        int j;
        if (codeMap == null) {
            table = new QueryBuilder("select Name,Code from SCMS_District where code like '11%' or code like '12%' or code like '31%' or code like '50%' or treelevel in (1,2,3) order by treelevel,code desc").executeDataTable();
            codeMap = table.toMapx(0, 1);
            nameMap = table.toMapx(1, 0);
        }
        for (j = 0; j < table.getRowCount(); ++j) {
            name = table.getString(j, "Name");
            if (address.indexOf(name) < 0) continue;
            return name;
        }
        for (j = 0; j < table.getRowCount(); ++j) {
            name = table.getString(j, "Name");
            if (!address.startsWith(name.substring(0, 2))) continue;
            return name;
        }
        for (j = 0; j < table.getRowCount(); ++j) {
            name = table.getString(j, "Name");
            if (address.indexOf(name.substring(0, 2)) < 0) continue;
            return name;
        }
        return null;
    }
}

