/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform;

import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_ActlistSchema;
import com.sobey.bsp.schema.SCMS_ActlistSet;
import com.sobey.bsp.schema.SCMS_ChannelsSchema;
import com.sobey.cms.interfaces.sonInterfaces.Data.AudioInterfaceData;
import com.sobey.cms.interfaces.sonInterfaces.Data.ChannelInterfaceData;
import com.sobey.cms.interfaces.sonInterfaces.Data.SeriesInterfaceData;
import com.sobey.cms.interfaces.sonInterfaces.Data.VideoInterfaceData;
import com.sobey.cms.interfaces.sonInterfaces.impl.SiteCommonInterfaceImpl;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.NewInterfacesMethod;
import com.sobey.scms.channel.util.ChannelLibUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class InterfaceAPI
extends Page {
    public void getInterfaceData() {
        String result = "";
        String content = "";
        try {
            String method = this.$V("method");
            String token = this.$V("partnerToken");
            result = this.getResult();
            if (StringUtil.isNotEmpty((String)token)) {
                DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
                String siteId = InterfacesMethod.getSiteIdByToken((String)token);
                if ("false".equals(siteId)) {
                    content = "\u60a8\u8f93\u5165\u7684partnerToken\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684partnerToken\u503c\uff01";
                } else {
                    Map map = InterfacesMethod.checkExpiredTime((String)siteId);
                    content = (String)map.get("finalResult");
                    if (StringUtil.isEmpty((String)content)) {
                        DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                        if (this.isUserAuthenticated(token)) {
                            if (StringUtil.isNotEmpty((String)method)) {
                                if ("authenticate".equalsIgnoreCase(method)) {
                                    SiteCommonInterfaceImpl sci = new SiteCommonInterfaceImpl();
                                    content = sci.authenticate(token);
                                } else if ("getCatalogList".equalsIgnoreCase(method)) {
                                    content = this.getCatalogList(token);
                                } else if ("getVideoList".equalsIgnoreCase(method)) {
                                    content = this.getVideoList(token, siteId);
                                } else if ("getChannelList".equalsIgnoreCase(method)) {
                                    content = this.getChannelList(token, siteId);
                                } else if ("getChannelById".equalsIgnoreCase(method)) {
                                    content = this.getChannelById(token, siteId);
                                } else if ("getSeriesList".equalsIgnoreCase(method)) {
                                    content = this.getSeriesList(token, siteId);
                                } else if ("getSeriesById".equalsIgnoreCase(method)) {
                                    content = this.getSeriesById(token, siteId);
                                } else if ("getVideoById".equalsIgnoreCase(method)) {
                                    content = this.getVideoById(token, siteId);
                                } else if ("getSeriesInfo".equalsIgnoreCase(method)) {
                                    content = this.getSeriesInfo(token, siteId);
                                } else if ("getAudioList".equalsIgnoreCase(method)) {
                                    content = this.getAudioList(token, siteId);
                                } else if ("getAudioById".equalsIgnoreCase(method)) {
                                    content = this.getAudioById(token, siteId);
                                } else if ("getChannelActList".equalsIgnoreCase(method)) {
                                    content = this.getChannelActList(token, siteId);
                                }
                            }
                        } else {
                            content = "\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u63a5\u53e3\u6216\u8005\u8be5\u63a5\u53e3\u5df2\u7ecf\u88ab\u505c\u7528";
                        }
                    }
                }
                result = URLEncoder.encode(result, "UTF-8");
                content = URLEncoder.encode(content, "UTF-8");
                content = content.replaceAll("\\+{1,}", "%20");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.$S("params", (Object)result);
        this.$S("result", (Object)content);
    }

    public String getResult() {
        String result = "";
        String method = this.$V("method");
        if (StringUtil.isNotEmpty((String)method)) {
            if ("authenticate".equalsIgnoreCase(method)) {
                result = this.authenticate();
            } else if ("getCatalogList".equalsIgnoreCase(method)) {
                result = this.getCatalogList();
            } else if ("getVideoList".equalsIgnoreCase(method)) {
                result = this.getVideoList();
            } else if ("getChannelList".equalsIgnoreCase(method)) {
                result = this.getChannelList();
            } else if ("getChannelById".equalsIgnoreCase(method)) {
                result = this.getChannelById();
            } else if ("getSeriesList".equalsIgnoreCase(method)) {
                result = this.getSeriesList();
            } else if ("getSeriesById".equalsIgnoreCase(method)) {
                result = this.getSeriesById();
            } else if ("getVideoById".equalsIgnoreCase(method)) {
                result = this.getVideoById();
            } else if ("getSeriesInfo".equalsIgnoreCase(method)) {
                result = this.getSeriesInfo();
            } else if ("getAudioList".equalsIgnoreCase(method)) {
                result = this.getAudioList();
            } else if ("getAudioById".equalsIgnoreCase(method)) {
                result = this.getAudioById();
            } else if ("getChannelActList".equalsIgnoreCase(method)) {
                result = this.getChannelActList();
            }
        }
        return result;
    }

    private String getChannelActList(String token, String siteId) {
        String date = "";
        String startDate = this.$V("getChannelActList_startDate");
        String type = this.$V("getChannelActList_type");
        String endDate = this.$V("getChannelActList_endDate");
        String channelId = this.$V("getChannelActList_channelId");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        JSONArray playBill = new JSONArray();
        try {
            if (StringUtil.isEmpty((String)channelId)) {
                String finalResult = "\u60a8\u8f93\u5165\u7684channelId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684channelId";
                return finalResult;
            }
            if (StringUtil.isEmpty((String)startDate)) {
                String finalResult = "\u60a8\u8f93\u5165\u7684startDate\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5f00\u59cb\u65f6\u95f4";
                return finalResult;
            }
            long endCount = 0L;
            if (!StringUtil.isEmpty((String)endDate)) {
                endCount = (format.parse(endDate).getTime() - format.parse(startDate).getTime()) / 1000L / 24L / 60L / 60L;
            }
            JSONObject obj = new JSONObject();
            int j = 0;
            while ((long)j <= endCount) {
                JSONArray ja = new JSONArray();
                date = format.format(DateUtil.addDay((Date)format.parse(startDate), (int)j));
                SCMS_ActlistSchema actList = new SCMS_ActlistSchema();
                QueryBuilder qb = new QueryBuilder();
                qb.setSQL("where cid='" + channelId + "' " + " and playTime like '%" + date + "%' " + " and endTime like '%" + date + "%'" + " order by playTime");
                SCMS_ActlistSet actSet = actList.query(qb);
                SCMS_ChannelsSchema channel = new SCMS_ChannelsSchema();
                channel.setId(channelId);
                channel.fill();
                JSONObject jo = new JSONObject();
                if (actSet != null && !actSet.isEmpty()) {
                    String format1 = "yyyy-MM-dd HH:mm:ss";
                    for (int i = 0; i < actSet.size(); ++i) {
                        actList = actSet.get(i);
                        String startTime = actList.getPlayTime();
                        String endTime = actList.getEndTime();
                        String programLength = com.sobey.bsp.framework.utility.DateUtil.getTimeStr((long)((FormatDateUtil.parseDateByFormat((String)endTime, (String)format1).getTime() - FormatDateUtil.parseDateByFormat((String)startTime, (String)format1).getTime()) / 1000L));
                        jo.put((Object)"name", (Object)actList.getName());
                        jo.put((Object)"description", (Object)actList.getName());
                        jo.put((Object)"length", (Object)programLength);
                        jo.put((Object)"id", (Object)actList.getId());
                        jo.put((Object)"startTime", (Object)startTime);
                        jo.put((Object)"endTime", (Object)endTime);
                        jo.put((Object)"url", (Object)ChannelLibUtil.getUrlJSONArrayByType((String)channel.getId(), (long)Long.parseLong(siteId), (int)channel.getMediaType(), (String)type, (boolean)true));
                        jo.put((Object)"channelId", (Object)channelId);
                        ja.add((Object)jo);
                    }
                    obj.put((Object)"date", (Object)date);
                    obj.put((Object)"playBill", (Object)ja);
                    playBill.add((Object)obj);
                }
                ++j;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return playBill.toString();
    }

    private String getAudioById(String token, String siteId) {
        String finalResult = "";
        try {
            String contentSourceId = this.$V("getAudioById_audioId");
            String sourceFlag = this.$V("getAudioById_sourceFlag");
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            String audioSourceIdsString = "";
            if (!StringUtil.isNotEmpty((String)contentSourceId)) {
                finalResult = "\u60a8\u8f93\u5165\u7684audioId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684audioId";
                return finalResult;
            }
            String[] contentSourceIds = contentSourceId.split(",");
            audioSourceIdsString = InterfacesMethod.getIdsString((String[])contentSourceIds);
            AudioInterfaceData aid = new AudioInterfaceData();
            finalResult = aid.getAudioInfoByInfo(siteId, sourceFlag, audioSourceIdsString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u4fe1\u606f";
        }
        return finalResult;
    }

    private String getAudioList(String token, String siteId) {
        String finalResult = "";
        try {
            String catalogStyle = this.$V("getAudioList_catalogStyle");
            String catalogPath = this.$V("getAudioList_catalogPath");
            String getAllData = this.$V("getAudioList_getAllData");
            String keywords = this.$V("getAudioList_keywords");
            String startTime = this.$V("getAudioList_startTime");
            String endTime = this.$V("getAudioList_endTime");
            String pageSize = this.$V("getAudioList_pageSize");
            String pageNum = this.$V("getAudioList_pageNum");
            String sortField = this.$V("getAudioList_sortField");
            String sort = this.$V("getAudioList_sort");
            String status = this.$V("getAudioList_status");
            String sourceFlag = this.$V("getAudioList_sourceFlag");
            String modifyFlag = this.$V("getAudioList_modifyFlag");
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "PublishDate";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            if (StringUtil.isEmpty((String)catalogStyle)) {
                catalogStyle = "0";
            }
            if (StringUtil.isEmpty((String)getAllData)) {
                getAllData = "0";
            }
            if (StringUtil.isEmpty((String)pageSize)) {
                pageSize = "10";
            }
            if (StringUtil.isEmpty((String)pageNum)) {
                pageNum = "1";
            }
            if (StringUtil.isEmpty((String)status)) {
                status = "1";
            }
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            if (StringUtil.isEmpty((String)modifyFlag)) {
                modifyFlag = "false";
            }
            keywords = keywords == null ? "" : keywords.trim();
            int catalogType = 6;
            DataTable InnerCodeDT = null;
            String innerCodeString = "";
            String catalogIdString = "";
            String sql = "";
            if (StringUtil.isEmpty((String)catalogPath)) {
                finalResult = "\u8f93\u5165\u7684\u680f\u76ee\u8def\u5f84\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9catalogPath\u53c2\u6570";
                return finalResult;
            }
            if ("1".equals(catalogStyle) && !InterfacesMethod.checkIsInteger((String)catalogPath)) {
                finalResult = "\u5f53catalogStyle\u503c\u4e3a1\u65f6\uff0ccatalogPath\u5e94\u8be5\u4e3a0\u6216\u8005\u6b63\u6574\u6570\uff01";
                return finalResult;
            }
            if (StringUtil.isNotEmpty((String)(sql = InterfacesMethod.getCatalogSql((String)catalogPath, (String)catalogStyle, (int)catalogType, (String)sql)))) {
                InnerCodeDT = new QueryBuilder(sql).executeDataTable();
                innerCodeString = InnerCodeDT.getString(0, "innercode");
                catalogIdString = InnerCodeDT.getString(0, "id");
            }
            AudioInterfaceData aid = new AudioInterfaceData();
            finalResult = aid.getAudioListDataByInfo(siteId, getAllData, sortField, sort, pageSize, pageNum, status, sourceFlag, modifyFlag, startTime, endTime, keywords, innerCodeString, catalogIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u5217\u8868\u4fe1\u606f";
        }
        return finalResult;
    }

    private String getSeriesInfo(String token, String siteId) {
        String finalResult = "";
        try {
            String seriesSourceId = this.$V("getSeriesInfo_seriesId");
            String sortField = this.$V("getSeriesInfo_sortField");
            String sort = this.$V("getSeriesInfo_sort");
            String pageSize = "";
            String pageNum = "";
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "part";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "ASC";
            }
            if (StringUtil.isEmpty((String)pageSize)) {
                pageSize = "10";
            }
            if (StringUtil.isEmpty((String)pageNum)) {
                pageNum = "1";
            }
            if (StringUtil.isEmpty((String)seriesSourceId)) {
                finalResult = "\u60a8\u8f93\u5165\u7684seriesId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684seriesId";
                return finalResult;
            }
            SeriesInterfaceData sid = new SeriesInterfaceData();
            finalResult = sid.getSeriesInfoData(seriesSourceId, sortField, sort, pageSize, pageNum);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u7535\u89c6\u5267\u5267\u96c6\u89c6\u9891\u4fe1\u606f";
        }
        return finalResult;
    }

    private String getVideoById(String token, String siteId) {
        String finalResult = "";
        try {
            String videoIds = this.$V("getVideoById_videoId");
            String sourceFlag = this.$V("getVideoById_sourceFlag");
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            String videoIdsString = "";
            if (!StringUtil.isNotEmpty((String)videoIds)) {
                finalResult = "\u60a8\u8f93\u5165\u7684videoId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684videoId";
                return finalResult;
            }
            String[] contentSourceIds = videoIds.split(",");
            videoIdsString = InterfacesMethod.getIdsString((String[])contentSourceIds);
            VideoInterfaceData vid = new VideoInterfaceData();
            finalResult = vid.getVideoInfoByInfo(siteId, sourceFlag, videoIdsString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u89c6\u9891\u4fe1\u606f";
        }
        return finalResult;
    }

    private String getSeriesById(String token, String siteId) {
        String finalResult = "";
        try {
            String seriesSourceId = this.$V("getSeriesById_seriesId");
            SeriesInterfaceData sid = new SeriesInterfaceData();
            finalResult = sid.getSeriesByIdData(siteId, seriesSourceId);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u8be5\u7535\u89c6\u5267\u5916\u58f3\u4fe1\u606f";
        }
        return finalResult;
    }

    private String getSeriesList(String token, String siteId) {
        String finalResult = "";
        try {
            String catalogStyle = this.$V("getSeriesList_catalogStyle");
            String catalogPath = this.$V("getSeriesList_catalogPath");
            String getAllData = this.$V("getSeriesList_getAllData");
            String keywords = this.$V("getSeriesList_keywords");
            String startTime = this.$V("getSeriesList_startTime");
            String endTime = this.$V("getSeriesList_endTime");
            String pageSize = this.$V("getSeriesList_pageSize");
            String pageNum = this.$V("getSeriesList_pageNum");
            String sortField = this.$V("getSeriesList_sortField");
            String sort = this.$V("getSeriesList_sort");
            String status = this.$V("getSeriesList_status");
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "PublishDate";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            if (StringUtil.isEmpty((String)catalogStyle)) {
                catalogStyle = "0";
            }
            if (StringUtil.isEmpty((String)getAllData)) {
                getAllData = "0";
            }
            if (StringUtil.isEmpty((String)pageSize)) {
                pageSize = "10";
            }
            if (StringUtil.isEmpty((String)pageNum)) {
                pageNum = "1";
            }
            if (StringUtil.isEmpty((String)status)) {
                status = "1";
            }
            keywords = keywords == null ? "" : keywords.trim();
            int catalogType = 7;
            DataTable InnerCodeDT = null;
            String innerCodeString = "";
            String catalogIdString = "";
            String sql = "";
            if (StringUtil.isEmpty((String)catalogPath)) {
                finalResult = "\u8f93\u5165\u7684\u680f\u76ee\u8def\u5f84\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9catalogPath\u53c2\u6570";
                return finalResult;
            }
            if ("1".equals(catalogStyle)) {
                if (!this.checkIsInteger(catalogPath)) {
                    finalResult = "\u5f53catalogStyle\u503c\u4e3a1\u65f6\uff0ccatalogPath\u5e94\u8be5\u4e3a0\u6216\u8005\u6b63\u6574\u6570\uff01";
                    return finalResult;
                }
                int catalogId = Integer.parseInt(catalogPath);
                if (catalogId > 0) {
                    sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and id=" + catalogId;
                    InnerCodeDT = new QueryBuilder(sql).executeDataTable();
                    innerCodeString = InnerCodeDT.getString(0, "innercode");
                    catalogIdString = InnerCodeDT.getString(0, "id");
                }
            } else {
                String[] catalogPaths = catalogPath.split("@");
                if (catalogPaths.length > 1) {
                    String inSql = "";
                    String inString = "";
                    sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and name='" + catalogPaths[catalogPaths.length - 1] + "' and treelevel=" + (catalogPaths.length - 1);
                    for (int i = catalogPaths.length - 2; i > 0; --i) {
                        inSql = inSql + " and parentid in (select id from SCMS_Catalog where name='" + catalogPaths[i] + "' and treelevel=" + i;
                        inString = inString + ")";
                    }
                    sql = sql + inSql + inString;
                    InnerCodeDT = new QueryBuilder(sql).executeDataTable();
                    innerCodeString = InnerCodeDT.getString(0, "innercode");
                    catalogIdString = InnerCodeDT.getString(0, "id");
                }
            }
            SeriesInterfaceData sid = new SeriesInterfaceData();
            finalResult = sid.getSeriesListData(siteId, getAllData, sortField, sort, pageSize, pageNum, status, startTime, endTime, keywords, innerCodeString, catalogIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u7535\u89c6\u5267\u5916\u58f3\u4fe1\u606f";
        }
        return finalResult;
    }

    private String getChannelById(String token, String siteId) {
        String result = "";
        String type = this.$V("getChannelById_type");
        String channelId = this.$V("getChannelById_channelId");
        if (type != null && !"".equals(type)) {
            type = type.toUpperCase();
        }
        try {
            ChannelInterfaceData cid = new ChannelInterfaceData();
            result = cid.getChannelByIdData(siteId, type, channelId);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u76f4\u64ad\u5217\u8868";
        }
        return result;
    }

    private String getChannelList(String token, String siteId) {
        String result = "";
        String type = this.$V("getChannelList_type");
        String channelType = this.$V("getChannelList_channelType");
        String sortField = "";
        String sort = "";
        if (type != null && !"".equals(type)) {
            type = type.toUpperCase();
        }
        if (StringUtil.isEmpty((String)sortField)) {
            sortField = "PublishDate";
        }
        if (StringUtil.isEmpty((String)sort)) {
            sort = "DESC";
        }
        try {
            ChannelInterfaceData cid = new ChannelInterfaceData();
            result = cid.getChannelListData(siteId, type, sortField, sort, channelType);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u76f4\u64ad\u5217\u8868";
        }
        return result;
    }

    private String getVideoList(String token, String siteId) {
        String finalResult = "";
        try {
            String catalogStyle = this.$V("getVideoList_catalogStyle");
            String catalogPath = this.$V("getVideoList_catalogPath");
            String getAllData = this.$V("getVideoList_getAllData");
            String keywords = this.$V("getVideoList_keywords");
            String startTime = this.$V("getVideoList_startTime");
            String endTime = this.$V("getVideoList_endTime");
            String pageSize = this.$V("getVideoList_pageSize");
            String pageNum = this.$V("getVideoList_pageNum");
            String sortField = this.$V("getVideoList_sortField");
            String sort = this.$V("getVideoList_sort");
            String status = this.$V("getVideoList_status");
            String modifyFlag = this.$V("getVideoList_modifyFlag");
            String sourceFlag = this.$V("getVideoList_sourceFlag");
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "PublishDate";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            if (StringUtil.isEmpty((String)catalogStyle)) {
                catalogStyle = "0";
            }
            if (StringUtil.isEmpty((String)getAllData)) {
                getAllData = "0";
            }
            if (StringUtil.isEmpty((String)pageSize)) {
                pageSize = "10";
            }
            if (StringUtil.isEmpty((String)pageNum)) {
                pageNum = "1";
            }
            if (StringUtil.isEmpty((String)status)) {
                status = "1";
            }
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            if (StringUtil.isEmpty((String)modifyFlag)) {
                modifyFlag = "false";
            }
            keywords = keywords == null ? "" : keywords.trim();
            int catalogType = 5;
            DataTable InnerCodeDT = null;
            String innerCodeString = "";
            String catalogIdString = "";
            String catalogSql = "";
            if (StringUtil.isEmpty((String)catalogPath)) {
                finalResult = "\u8f93\u5165\u7684\u680f\u76ee\u8def\u5f84\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9catalogPath\u53c2\u6570";
                return finalResult;
            }
            if ("1".equals(catalogStyle) && !NewInterfacesMethod.checkIsInteger((String)catalogPath)) {
                finalResult = "\u5f53catalogStyle\u503c\u4e3a1\u65f6\uff0ccatalogPath\u5e94\u8be5\u4e3a0\u6216\u8005\u6b63\u6574\u6570\uff01";
                return finalResult;
            }
            if (StringUtil.isNotEmpty((String)(catalogSql = NewInterfacesMethod.getCatalogSql((String)catalogPath, (String)catalogStyle, (int)catalogType, (String)catalogSql)))) {
                InnerCodeDT = new QueryBuilder(catalogSql).executeDataTable();
                innerCodeString = InnerCodeDT.getString(0, "innercode");
                catalogIdString = InnerCodeDT.getString(0, "id");
            }
            VideoInterfaceData vid = new VideoInterfaceData();
            finalResult = vid.getVideoListDataByInfo(siteId, getAllData, sortField, sort, pageSize, pageNum, status, sourceFlag, modifyFlag, startTime, endTime, keywords, innerCodeString, catalogIdString, new ArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u89c6\u9891\u4fe1\u606f";
        }
        return finalResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCatalogList(String token) {
        String result = "";
        JSONArray catalogArray = new JSONArray();
        try {
            String catalogType = this.$V("getCatalogList_catalogType");
            String catalogStyle = this.$V("getCatalogList_catalogStyle");
            String catalogPath = this.$V("getCatalogList_catalogPath");
            String getAllData = this.$V("getCatalogList_getAllData");
            String sortField = "";
            String sort = "";
            DataTable catalogDT = null;
            DataTable InnerCodeDT = null;
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "ORDERFLAG";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            if (StringUtil.isEmpty((String)catalogType)) {
                catalogType = String.valueOf(5);
            }
            if (StringUtil.isEmpty((String)catalogStyle)) {
                catalogStyle = "0";
            }
            if (StringUtil.isEmpty((String)getAllData)) {
                getAllData = "0";
            }
            if (StringUtil.isEmpty((String)catalogPath)) {
                return "\u8f93\u5165\u7684\u680f\u76ee\u8def\u5f84\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9catalogPath\u53c2\u6570";
            }
            String sql = "";
            String inSql = "";
            String inString = "";
            String orderBy = " ORDER BY " + sortField + " " + sort;
            if ("1".equals(catalogStyle)) {
                if (!this.checkIsInteger(catalogPath)) {
                    return "\u5f53catalogStyle\u503c\u4e3a1\u65f6\uff0ccatalogPath\u5e94\u8be5\u4e3a0\u6216\u8005\u6b63\u6574\u6570\uff01";
                }
                int catalogId = Integer.parseInt(catalogPath);
                if (catalogId == 0) {
                    catalogDT = "1".equals(getAllData) ? new QueryBuilder("select * from SCMS_Catalog where type=" + catalogType + "  ORDER BY " + sortField + " " + sort).executeDataTable() : new QueryBuilder("select * from SCMS_Catalog where type=" + catalogType + " and treelevel=1 ORDER BY " + sortField + " " + sort).executeDataTable();
                } else {
                    if (catalogId <= 0) return "ID\u7c7b\u578b\u67e5\u8be2\u6570\u636e\uff0c\u4f46\u60a8\u8f93\u5165\u7684ID\u4e0d\u6b63\u786e\uff0c\u8bf7\u60a8\u91cd\u65b0\u8f93\u5165\uff01";
                    if ("1".equals(getAllData)) {
                        sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and id=" + catalogId;
                        InnerCodeDT = new QueryBuilder(sql).executeDataTable();
                        String innerCodeString = InnerCodeDT.getString(0, "innercode");
                        catalogDT = new QueryBuilder("select * from SCMS_Catalog where type=" + catalogType + " and length(innercode)>" + innerCodeString.length() + " and innercode like '" + innerCodeString + "%' ORDER BY " + sortField + " " + sort).executeDataTable();
                    } else {
                        sql = "select * from SCMS_Catalog where type=" + catalogType + " and parentid=" + catalogId;
                        catalogDT = new QueryBuilder(sql).executeDataTable();
                    }
                }
            } else {
                String[] catalogPaths = catalogPath.split("@");
                if ("1".equals(getAllData)) {
                    if (catalogPaths.length == 1) {
                        catalogDT = new QueryBuilder("select * from SCMS_Catalog where type=" + catalogType + "  ORDER BY " + sortField + " " + sort).executeDataTable();
                    } else {
                        sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and name='" + catalogPaths[catalogPaths.length - 1] + "' and treelevel=" + (catalogPaths.length - 1);
                        for (int i = catalogPaths.length - 2; i > 0; --i) {
                            inSql = inSql + " and parentid in (select id from SCMS_Catalog where name='" + catalogPaths[i] + "' and treelevel=" + i;
                            inString = inString + ")";
                        }
                        sql = sql + inSql + inString;
                        InnerCodeDT = new QueryBuilder(sql).executeDataTable();
                        String innerCodeString = InnerCodeDT.getString(0, "innercode");
                        catalogDT = new QueryBuilder("select * from SCMS_Catalog where type=" + catalogType + " and length(innercode)>" + innerCodeString.length() + " and innercode like '" + innerCodeString + "%' ORDER BY " + sortField + " " + sort).executeDataTable();
                    }
                } else if (catalogPaths.length == 1) {
                    catalogDT = new QueryBuilder("select * from SCMS_Catalog where type=" + catalogType + " and treelevel=1 ORDER BY " + sortField + " " + sort).executeDataTable();
                } else {
                    sql = "select * from SCMS_Catalog where type=" + catalogType;
                    for (int i = catalogPaths.length - 1; i > 0; --i) {
                        inSql = inSql + " and parentid in (select id from SCMS_Catalog where name='" + catalogPaths[i] + "' and treelevel=" + i;
                        inString = inString + ")";
                    }
                    sql = sql + inSql + inString + orderBy;
                    catalogDT = new QueryBuilder(sql).executeDataTable();
                }
            }
            int j = 0;
            while (j < catalogDT.getRowCount()) {
                JSONObject catalog = new JSONObject();
                String name = catalogDT.getString(j, "Name");
                String parentId = catalogDT.getString(j, "ParentID");
                String innerCode = catalogDT.getString(j, "innerCode");
                String id = catalogDT.getString(j, "ID");
                String treeLevel = catalogDT.getString(j, "treelevel");
                catalog.put((Object)"catalogId", (Object)id);
                catalog.put((Object)"name", (Object)name);
                catalog.put((Object)"parentId", (Object)parentId);
                catalog.put((Object)"innerCode", (Object)innerCode);
                catalog.put((Object)"treeLevel", (Object)treeLevel);
                catalogArray.add((Object)catalog);
                ++j;
            }
            return catalogArray.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u680f\u76ee\u5217\u8868\u4fe1\u606f";
        }
    }

    private String getAudioById() {
        String finalResult = "method=getAudioById";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getAudioById_dataType");
        String audioId = this.$V("getAudioById_audioId");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)audioId)) {
            finalResult = finalResult + "&audioId=" + audioId;
        }
        return finalResult;
    }

    private String getAudioList() {
        String finalResult = "method=getAudioList";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getAudioList_dataType");
        String catalogStyle = this.$V("getAudioList_catalogStyle");
        String catalogPath = this.$V("getAudioList_catalogPath");
        String getAllData = this.$V("getAudioList_getAllData");
        String keywords = this.$V("getAudioList_keywords");
        String startTime = this.$V("getAudioList_startTime");
        String endTime = this.$V("getAudioList_endTime");
        String pageSize = this.$V("getAudioList_pageSize");
        String pageNum = this.$V("getAudioList_pageNum");
        String sortField = this.$V("getAudioList_sortField");
        String sort = this.$V("getAudioList_sort");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)catalogStyle)) {
            finalResult = finalResult + "&catalogStyle=" + catalogStyle;
        }
        if (StringUtil.isNotEmpty((String)catalogPath)) {
            finalResult = finalResult + "&catalogPath=" + catalogPath;
        }
        if (StringUtil.isNotEmpty((String)getAllData)) {
            finalResult = finalResult + "&getAllData=" + getAllData;
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            finalResult = finalResult + "&keywords=" + keywords;
        }
        if (StringUtil.isNotEmpty((String)startTime)) {
            finalResult = finalResult + "&startTime=" + startTime;
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            finalResult = finalResult + "&endTime=" + endTime;
        }
        if (StringUtil.isNotEmpty((String)pageSize)) {
            finalResult = finalResult + "&pageSize=" + pageSize;
        }
        if (StringUtil.isNotEmpty((String)pageNum)) {
            finalResult = finalResult + "&pageNum=" + pageNum;
        }
        if (StringUtil.isNotEmpty((String)sortField)) {
            finalResult = finalResult + "&sortField=" + sortField;
        }
        if (StringUtil.isNotEmpty((String)sort)) {
            finalResult = finalResult + "&sort=" + sort;
        }
        return finalResult;
    }

    private String getSeriesById() {
        String finalResult = "method=getSeriesById";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getSeriesById_dataType");
        String seriesId = this.$V("getSeriesById_seriesId");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)seriesId)) {
            finalResult = finalResult + "&seriesId=" + seriesId;
        }
        return finalResult;
    }

    private String getSeriesList() {
        String finalResult = "method=getSeriesList";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getSeriesList_dataType");
        String catalogStyle = this.$V("getSeriesList_catalogStyle");
        String catalogPath = this.$V("getSeriesList_catalogPath");
        String getAllData = this.$V("getSeriesList_getAllData");
        String keywords = this.$V("getSeriesList_keywords");
        String startTime = this.$V("getSeriesList_startTime");
        String endTime = this.$V("getSeriesList_endTime");
        String pageSize = this.$V("getSeriesList_pageSize");
        String pageNum = this.$V("getSeriesList_pageNum");
        String sortField = this.$V("getSeriesList_sortField");
        String sort = this.$V("getSeriesList_sort");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)catalogStyle)) {
            finalResult = finalResult + "&catalogStyle=" + catalogStyle;
        }
        if (StringUtil.isNotEmpty((String)catalogPath)) {
            finalResult = finalResult + "&catalogPath=" + catalogPath;
        }
        if (StringUtil.isNotEmpty((String)getAllData)) {
            finalResult = finalResult + "&getAllData=" + getAllData;
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            finalResult = finalResult + "&keywords=" + keywords;
        }
        if (StringUtil.isNotEmpty((String)startTime)) {
            finalResult = finalResult + "&startTime=" + startTime;
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            finalResult = finalResult + "&endTime=" + endTime;
        }
        if (StringUtil.isNotEmpty((String)pageSize)) {
            finalResult = finalResult + "&pageSize=" + pageSize;
        }
        if (StringUtil.isNotEmpty((String)pageNum)) {
            finalResult = finalResult + "&pageNum=" + pageNum;
        }
        if (StringUtil.isNotEmpty((String)sortField)) {
            finalResult = finalResult + "&sortField=" + sortField;
        }
        if (StringUtil.isNotEmpty((String)sort)) {
            finalResult = finalResult + "&sort=" + sort;
        }
        return finalResult;
    }

    private String getSeriesInfo() {
        String finalResult = "method=getSeriesInfo";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getSeriesInfo_dataType");
        String seriesId = this.$V("getSeriesInfo_seriesId");
        String sortField = this.$V("getSeriesInfo_sortField");
        String sort = this.$V("getSeriesInfo_sort");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)seriesId)) {
            finalResult = finalResult + "&seriesId=" + seriesId;
        }
        if (StringUtil.isNotEmpty((String)sortField)) {
            finalResult = finalResult + "&sortField=" + sortField;
        }
        if (StringUtil.isNotEmpty((String)sort)) {
            finalResult = finalResult + "&sort=" + sort;
        }
        return finalResult;
    }

    private String getChannelActList() {
        String finalResult = "method=getChannelActList";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getChannelActList_dataType");
        String startDate = this.$V("getChannelActList_startDate");
        String endDate = this.$V("getChannelActList_endDate");
        String channelId = this.$V("getChannelActList_channelId");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)startDate)) {
            finalResult = finalResult + "&startDate=" + startDate;
        }
        if (StringUtil.isNotEmpty((String)endDate)) {
            finalResult = finalResult + "&endDate=" + endDate;
        }
        if (StringUtil.isNotEmpty((String)channelId)) {
            finalResult = finalResult + "&channelId=" + channelId;
        }
        return finalResult;
    }

    private String getChannelById() {
        String finalResult = "method=getChannelById";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getChannelById_dataType");
        String type = this.$V("getChannelById_type");
        String channelId = this.$V("getChannelById_channelId");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)type)) {
            finalResult = finalResult + "&type=" + type;
        }
        if (StringUtil.isNotEmpty((String)channelId)) {
            finalResult = finalResult + "&channelId=" + channelId;
        }
        return finalResult;
    }

    private String getChannelList() {
        String finalResult = "method=getChannelList";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getChannelList_dataType");
        String type = this.$V("getChannelList_type");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)type)) {
            finalResult = finalResult + "&type=" + type;
        }
        return finalResult;
    }

    private String getVideoById() {
        String finalResult = "method=getVideoById";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getVideoById_dataType");
        String videoId = this.$V("getVideoById_videoId");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)videoId)) {
            finalResult = finalResult + "&videoId=" + videoId;
        }
        return finalResult;
    }

    private String getVideoList() {
        String finalResult = "method=getVideoList";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getVideoList_dataType");
        String catalogStyle = this.$V("getVideoList_catalogStyle");
        String catalogPath = this.$V("getVideoList_catalogPath");
        String getAllData = this.$V("getVideoList_getAllData");
        String keywords = this.$V("getVideoList_keywords");
        String startTime = this.$V("getVideoList_startTime");
        String endTime = this.$V("getVideoList_endTime");
        String pageSize = this.$V("getVideoList_pageSize");
        String pageNum = this.$V("getVideoList_pageNum");
        String sortField = this.$V("getVideoList_sortField");
        String sort = this.$V("getVideoList_sort");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)catalogStyle)) {
            finalResult = finalResult + "&catalogStyle=" + catalogStyle;
        }
        if (StringUtil.isNotEmpty((String)catalogPath)) {
            finalResult = finalResult + "&catalogPath=" + catalogPath;
        }
        if (StringUtil.isNotEmpty((String)getAllData)) {
            finalResult = finalResult + "&getAllData=" + getAllData;
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            finalResult = finalResult + "&keywords=" + keywords;
        }
        if (StringUtil.isNotEmpty((String)startTime)) {
            finalResult = finalResult + "&startTime=" + startTime;
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            finalResult = finalResult + "&endTime=" + endTime;
        }
        if (StringUtil.isNotEmpty((String)pageSize)) {
            finalResult = finalResult + "&pageSize=" + pageSize;
        }
        if (StringUtil.isNotEmpty((String)pageNum)) {
            finalResult = finalResult + "&pageNum=" + pageNum;
        }
        if (StringUtil.isNotEmpty((String)sortField)) {
            finalResult = finalResult + "&sortField=" + sortField;
        }
        if (StringUtil.isNotEmpty((String)sort)) {
            finalResult = finalResult + "&sort=" + sort;
        }
        return finalResult;
    }

    private String getCatalogList() {
        String finalResult = "method=getCatalogList";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("getCatalogList_dataType");
        String catalogType = this.$V("getCatalogList_catalogType");
        String catalogStyle = this.$V("getCatalogList_catalogStyle");
        String catalogPath = this.$V("getCatalogList_catalogPath");
        String getAllData = this.$V("getCatalogList_getAllData");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        if (StringUtil.isNotEmpty((String)catalogType)) {
            finalResult = finalResult + "&catalogType=" + catalogType;
        }
        if (StringUtil.isNotEmpty((String)catalogStyle)) {
            finalResult = finalResult + "&catalogStyle=" + catalogStyle;
        }
        if (StringUtil.isNotEmpty((String)catalogPath)) {
            finalResult = finalResult + "&catalogPath=" + catalogPath;
        }
        if (StringUtil.isNotEmpty((String)getAllData)) {
            finalResult = finalResult + "&getAllData=" + getAllData;
        }
        return finalResult;
    }

    private String authenticate() {
        String finalResult = "method=authenticate";
        String partnerToken = this.$V("partnerToken");
        String dataType = this.$V("authenticate_dataType");
        if (StringUtil.isNotEmpty((String)partnerToken)) {
            finalResult = finalResult + "&partnerToken=" + partnerToken;
        }
        if (StringUtil.isNotEmpty((String)dataType)) {
            finalResult = finalResult + "&dataType=" + dataType;
        }
        return finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postHttp(String httpurl, String data) {
        String content = "";
        HttpURLConnection connection = null;
        try {
            URL url = new URL(httpurl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            connection.setRequestMethod("POST");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            out.write(data);
            out.flush();
            String sCurrentLine = "";
            InputStream l_urlStream = connection.getInputStream();
            BufferedReader l_reader = new BufferedReader(new InputStreamReader(l_urlStream, "UTF-8"));
            while ((sCurrentLine = l_reader.readLine()) != null) {
                content = content + sCurrentLine;
            }
            out.close();
            out = null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
        }
        return content;
    }

    private boolean checkIsInteger(String catalogPath) {
        boolean result = false;
        if (catalogPath.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$")) {
            result = true;
        }
        return result;
    }

    private boolean isUserAuthenticated(String token) {
        boolean isAuthenticated = false;
        if (StringUtil.isNotEmpty((String)token)) {
            DataTable dt = new QueryBuilder("select * from scms_partner_authenticate where token='" + token + "'").executeDataTable();
            if (dt == null || dt.getRowCount() == 0) {
                isAuthenticated = false;
            } else {
                String date = dt.getString(0, "expiredate");
                if (StringUtil.isEmpty((String)date)) {
                    isAuthenticated = false;
                } else {
                    String status = dt.getString(0, "status");
                    if (status.equals("1")) {
                        isAuthenticated = true;
                    } else if (status.equals("0")) {
                        isAuthenticated = false;
                    }
                }
            }
        }
        return isAuthenticated;
    }
}

