/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform;

import com.chinamclound.vms.constant.InterfaceNoticeTypeEnum;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataCollection;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.HtmlUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.notice.AfreshPushXlw;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.InterfacesCache;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_CatalogSet;
import com.sobey.bsp.schema.SCMS_Interfaces_catalogSchema;
import com.sobey.bsp.schema.SCMS_Interfaces_catalogSet;
import com.sobey.bsp.schema.SCMS_Interfaces_manageSchema;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class InterfacesManage
extends Page {
    public static void dg1DataBind(DataGridAction dga) {
        String partnername = dga.getParam("partnername");
        String searchDate = dga.getParam("SearchDate");
        String isAudit = dga.getParam("SearchStatus");
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isNotEmpty((String)partnername)) {
            builder.append(" AND PARTNERNAME LIKE '%" + partnername + "%' ");
        }
        if (StringUtil.isNotEmpty((String)searchDate)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDate);
            if (day == 0) {
                builder.append(" AND CREATETIME like '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                builder.append(" AND CREATETIME like '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                builder.append(" AND CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                builder.append(" AND CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                builder.append(" AND CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                builder.append(" AND CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        if (StringUtil.isNotEmpty((String)isAudit) && !"-1".equals(isAudit)) {
            builder.append(" AND ISAUDIT = '" + isAudit + "' ");
        }
        builder.append(" ORDER BY CREATETIME DESC ");
        String sql = "select weight,id,url,partnerCode,isAutoPush,partnerKey,partnerName,createUser,createTime,status,siteid,'' as isAuditEnable,'' as isStatusEnable,'' as statusName from scms_interfaces_manage where 1=1 ";
        sql = sql + builder.toString();
        String countsql = "select count(id) from scms_interfaces_manage where 1=1 " + builder.toString();
        dga.setTotal(new QueryBuilder(countsql));
        DataTable dt = new QueryBuilder(sql).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        if (null == dt || dt.getRowCount() == 0) {
            dga.dataTable2JSON(new DataTable());
            return;
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String status = dt.getString(i, "status");
            isAudit = dt.getString(i, "isAudit");
            partnername = dt.getString(i, "partnerName");
            if ("1".equals(status)) {
                dt.set(i, "statusName", (Object)"\u505c\u7528");
            } else {
                dt.set(i, "statusName", (Object)"\u5f00\u542f");
            }
            String siteid = dt.getString(i, "siteid");
            if (!StringUtil.isNotEmpty((String)siteid)) continue;
            DataTable siteDT = new QueryBuilder("select name,id from scms_site where id in (" + siteid + ")").executeDataTable();
            if (siteDT == null || siteDT.getRowCount() <= 0) {
                dt.set(i, "siteid", (Object)"");
                continue;
            }
            dt.set(i, "siteid", (Object)HtmlUtil.dataTableToOptions((DataTable)siteDT, (Object)siteDT.get(0, "name")));
        }
        dga.dataTable2JSON(dt);
    }

    public static Mapx initAuthenticate(Mapx params) {
        String id = params.getString((Object)"ID");
        if (StringUtil.isEmpty((String)id)) {
            return new Mapx();
        }
        String sql = "select weight,autoRetry,id,url,partnerCode,isAutoPush,partnerKey,partnerName,status,siteid,remark,userName,password,clientID,clientSecret,isStandardAgreement,noticeType from scms_interfaces_manage where id='" + id + "'";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        if (null == dt || dt.getRowCount() == 0) {
            return new Mapx();
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            for (int j = 0; j < dt.getColCount(); ++j) {
                String key = dt.getDataColumn(j).getColumnName();
                String values = dt.getString(i, j);
                params.put((Object)key, (Object)values);
            }
        }
        return params;
    }

    public void save() {
        Transaction transaction = new Transaction();
        boolean autoRetryChange = false;
        String id = this.$V("id");
        String partnerName = this.$V("partnerName");
        String partnerCode = this.$V("partnerCode");
        String isStandardAgreement = this.$V("isStandardAgreement");
        try {
            String siteid = Application.getCurrentSiteID() + "";
            SCMS_Interfaces_manageSchema scmsInterfacesManageSchema = new SCMS_Interfaces_manageSchema();
            scmsInterfacesManageSchema.setIsStandardAgreement(Integer.valueOf(Integer.parseInt(isStandardAgreement)));
            int noticeType = this.getNoticeType(isStandardAgreement, this.$V("noticeType"), partnerCode);
            scmsInterfacesManageSchema.setNoticeType(Integer.valueOf(noticeType));
            if (StringUtil.isEmpty((String)id)) {
                boolean allowRepeatAdd = this.getAllowRepeatAdd(partnerCode);
                if (!allowRepeatAdd) {
                    this.Response.setStatus(0);
                    this.Response.setMessage("\u8be5\u5382\u5546\u4ee3\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u4ee5\u91cd\u590d\u6dfb\u52a0\uff01");
                    return;
                }
                scmsInterfacesManageSchema.setValue((DataCollection)this.Request);
                scmsInterfacesManageSchema.setIsAutoPush(this.$V("autoPush"));
                int autoRetry = Integer.valueOf(this.$V("autoRetry"));
                scmsInterfacesManageSchema.setAutoRetry(Integer.valueOf(autoRetry));
                if (1 == autoRetry) {
                    autoRetryChange = true;
                }
                long authenticId = NoUtil.getMaxID((String)"InterfacesManageID");
                scmsInterfacesManageSchema.setID(Long.valueOf(authenticId));
                scmsInterfacesManageSchema.setSiteid(siteid);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                scmsInterfacesManageSchema.setCreateTime(simpleDateFormat.format(new Date()));
                scmsInterfacesManageSchema.setCreateUser(User.getUserName());
                transaction.add((Schema)scmsInterfacesManageSchema, 1);
                DataTable dataTable = (DataTable)this.Request.get("dt");
                for (int i = 0; null != dataTable && i < dataTable.getRowCount(); ++i) {
                    if (!"1".equals(dataTable.getString(i, "video_browse"))) continue;
                    String innerCode = dataTable.getString(i, "innerCode");
                    long catalogId = this.getCatalogId(innerCode);
                    SCMS_Interfaces_catalogSchema scmsInterfacesCatalogSchema = new SCMS_Interfaces_catalogSchema();
                    scmsInterfacesCatalogSchema.setInnerCode(innerCode);
                    scmsInterfacesCatalogSchema.setInterfacesID(Long.valueOf(authenticId));
                    scmsInterfacesCatalogSchema.setCatalogId(Long.valueOf(catalogId));
                    transaction.add((Schema)scmsInterfacesCatalogSchema, 1);
                }
            } else {
                long interfacesID = Long.parseLong(id);
                scmsInterfacesManageSchema.setID(Long.valueOf(interfacesID));
                if (scmsInterfacesManageSchema.fill()) {
                    scmsInterfacesManageSchema.setPartnerName(partnerName);
                    int autoRetry = Integer.valueOf(this.$V("autoRetry"));
                    int oldAutoRetry = scmsInterfacesManageSchema.getAutoRetry();
                    scmsInterfacesManageSchema.setAutoRetry(Integer.valueOf(autoRetry));
                    if (oldAutoRetry != autoRetry) {
                        autoRetryChange = true;
                    }
                    scmsInterfacesManageSchema.setValue((DataCollection)this.Request);
                    scmsInterfacesManageSchema.setIsAutoPush(this.$V("autoPush"));
                    transaction.add((Schema)scmsInterfacesManageSchema, 2);
                    this.delInterfacesCatalog(interfacesID);
                    DataTable dt = (DataTable)this.Request.get("dt");
                    for (int i = 0; null != dt && i < dt.getRowCount(); ++i) {
                        if (!"1".equals(dt.getString(i, "video_browse"))) continue;
                        String innerCode = dt.getString(i, "innerCode");
                        long catalogId = this.getCatalogId(innerCode);
                        SCMS_Interfaces_catalogSchema scmsInterfacesCatalogSchema = new SCMS_Interfaces_catalogSchema();
                        scmsInterfacesCatalogSchema.setInnerCode(innerCode);
                        scmsInterfacesCatalogSchema.setInterfacesID(Long.valueOf(interfacesID));
                        scmsInterfacesCatalogSchema.setCatalogId(Long.valueOf(catalogId));
                        transaction.add((Schema)scmsInterfacesCatalogSchema, 1);
                    }
                }
            }
            if (transaction.commit()) {
                if ("1".equals(scmsInterfacesManageSchema.getStatus())) {
                    InterfacesCache.putInterfacesSchema((String)siteid, (String)scmsInterfacesManageSchema.getPartnerCode(), (SCMS_Interfaces_manageSchema)scmsInterfacesManageSchema);
                }
                if (autoRetryChange) {
                    AfreshPushXlw apx = new AfreshPushXlw();
                    apx.initTimerPush(Application.getCurrentSiteID());
                }
                this.Response.setStatus(1);
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u4fdd\u5b58\u6570\u636e\u5e93\u5931\u8d25\uff01");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean getAllowRepeatAdd(String partnerCode) {
        if ("VideoBack".equals(partnerCode)) {
            return true;
        }
        String countsql = "select count(id) from scms_interfaces_manage where partnerCode='" + partnerCode + "'";
        int count = new QueryBuilder(countsql).executeInt();
        return count <= 0;
    }

    private int getNoticeType(String isStandardAgreement, String noticeType, String partnerCode) {
        if ("1".equals(isStandardAgreement)) {
            return Integer.parseInt(noticeType);
        }
        if ("ChinaCache".equals(partnerCode) || "FastWeb".equals(partnerCode) || "Letv".equals(partnerCode) || "yf".equals(partnerCode) || "dl".equals(partnerCode) || "ali".equals(partnerCode) || "yp".equals(partnerCode) || "st".equals(partnerCode)) {
            return InterfaceNoticeTypeEnum.CDN.getIndex();
        }
        if ("VideoBack".equals(partnerCode)) {
            return InterfaceNoticeTypeEnum.VIDEO_BACK.getIndex();
        }
        return InterfaceNoticeTypeEnum.CMS.getIndex();
    }

    private void delInterfacesCatalog(long interfacesID) {
        String sqlCatalog = "DELETE FROM scms_interfaces_catalog where interfacesID='" + interfacesID + "'";
        QueryBuilder qb = new QueryBuilder();
        qb.setSQL(sqlCatalog);
        qb.executeNoQuery();
    }

    private void setInterfacesType(String partnerCode, SCMS_Interfaces_manageSchema schema) {
        if ("ChinaCache".equals(partnerCode) || "FastWeb".equals(partnerCode) || "Letv".equals(partnerCode) || "yf".equals(partnerCode) || "dl".equals(partnerCode) || "ali".equals(partnerCode) || "yp".equals(partnerCode) || "st".equals(partnerCode) || "VideoBack".equals(partnerCode)) {
            schema.setNoticeType(Integer.valueOf(0));
        } else {
            schema.setNoticeType(Integer.valueOf(1));
        }
    }

    public void isEnableAuthenticate() {
        String siteid = Application.getCurrentSiteID() + "";
        String id = this.$V("id");
        String status = this.$V("status");
        String sql = "update scms_interfaces_manage set status='" + status + "' where id='" + id + "'";
        int count = new QueryBuilder(sql).executeNoQuery();
        if (count > 0) {
            SCMS_Interfaces_manageSchema schema = new SCMS_Interfaces_manageSchema();
            schema.setID(Long.valueOf(Long.parseLong(id)));
            if (schema.fill()) {
                if ("1".equals(status)) {
                    InterfacesCache.putInterfacesSchema((String)siteid, (String)schema.getPartnerCode(), (SCMS_Interfaces_manageSchema)schema);
                } else {
                    InterfacesCache.delInterfacesSchema((String)siteid, (String)schema.getPartnerCode());
                }
            }
            this.Response.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        } else {
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }

    public String get_siteEmail() {
        DataTable dta = new QueryBuilder("select email from scms_site").executeDataTable();
        String email = dta.getString(0, "email");
        return email;
    }

    public void authenticate() {
        String id = this.$V("id");
        String isAudit = this.$V("isAudit");
        String sql = "update scms_interfaces_manage set isAudit='" + isAudit + "' where id='" + id + "'";
        int count = new QueryBuilder(sql).executeNoQuery();
        if (count > 0) {
            this.Response.setStatus(1);
            this.Response.setMessage("\u5382\u5546\u8ba4\u8bc1\u6210\u529f\uff01");
        } else {
            this.Response.setStatus(0);
            this.Response.setMessage("\u5382\u5546\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
    }

    public void delAuthenticate() {
        String ids = this.$V("id");
        String siteid = Application.getCurrentSiteID() + "";
        ArrayList<String> contentIds = new ArrayList<String>();
        if (!StringUtil.checkID((String)ids)) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u9519\u8bef\u7684\u53c2\u6570!");
            return;
        }
        for (String element : ids.split(",")) {
            contentIds.add(element);
        }
        int sum = 0;
        int size = contentIds.size();
        for (int i = 0; i < size; ++i) {
            Transaction transaction = new Transaction();
            Long id = Long.parseLong((String)contentIds.get(i));
            SCMS_Interfaces_manageSchema schema = new SCMS_Interfaces_manageSchema();
            schema.setID(id);
            schema.fill();
            transaction.add((Schema)schema, 3);
            if (!transaction.commit()) continue;
            InterfacesCache.delInterfacesSchema((String)siteid, (String)schema.getPartnerCode());
            this.delInterfacesCatalog(id.longValue());
            ++sum;
        }
        int n = size - sum;
        if (n != 0) {
            this.Response.setMessage("\u6709" + n + "\u6761\u8bb0\u5f55\u5220\u9664\u5931\u8d25\uff01");
        } else {
            this.Response.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        }
    }

    public void getVideoMetadata() {
        String key = "video";
        JSONObject jos = this.getMetadata(5, key);
        this.Response.setMessage(jos.toString());
    }

    public void getSeriesMetadate() {
        String key = "series";
        JSONObject jos = this.getMetadata(7, key);
        this.Response.setMessage(jos.toString());
    }

    public void getAudioMetadata() {
        String key = "audio";
        JSONObject jos = this.getMetadata(6, key);
        this.Response.setMessage(jos.toString());
    }

    private JSONObject getMetadata(int type, String key) {
        JSONObject jos = new JSONObject();
        JSONArray ja = new JSONArray();
        String sql = "SELECT fieldCode,fieldName FROM scms_metadata_all where type='" + type + "'";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject jo = new JSONObject();
            Object fieldCode = dt.get(i, "fieldCode");
            Object fieldName = dt.get(i, "fieldName");
            jo.put((Object)"code", (Object)fieldCode.toString());
            jo.put((Object)"name", (Object)fieldName.toString());
            ja.add((Object)jo);
        }
        if (type == 5 || type == 7) {
            String columnSql = "SELECT code,name FROM scms_site_column;";
            DataTable columnDt = new QueryBuilder(columnSql).executeDataTable();
            for (int i = 0; i < columnDt.getRowCount(); ++i) {
                JSONObject jo = new JSONObject();
                Object code = columnDt.get(i, "code");
                Object name = columnDt.get(i, "name");
                jo.put((Object)"code", (Object)code.toString());
                jo.put((Object)"name", (Object)name.toString());
                ja.add((Object)jo);
            }
        }
        jos.put((Object)key, (Object)ja.toString());
        return jos;
    }

    public void getCheckedCatalog() {
        String sql = "select InnerCode from scms_interfaces_catalog where interfacesID=?";
        String id = this.$V("id");
        DataTable dt = new QueryBuilder(sql, (Object)id).executeDataTable();
        if (null == dt || dt.getRowCount() <= 0) {
            this.Response.put((Object)"checkedCatalog", (Object)"");
        }
        this.Response.put((Object)"checkedCatalog", (Object)StringUtil.join((Object[])dt.getColumnValues(0)));
    }

    public static void savePushCatalog(long catalogId) {
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        if (catalog.fill()) {
            long parentID = catalog.getParentID();
            if (parentID == 0L) {
                return;
            }
            String innerCode = catalog.getInnerCode();
            SCMS_Interfaces_catalogSchema interfacesCatalog = new SCMS_Interfaces_catalogSchema();
            QueryBuilder qb = new QueryBuilder("where catalogId=" + catalogId);
            SCMS_Interfaces_catalogSet interfacesCatalogSet = interfacesCatalog.query(qb);
            if (interfacesCatalogSet != null && interfacesCatalogSet.size() > 0) {
                return;
            }
            QueryBuilder qb1 = new QueryBuilder("where catalogId=" + parentID);
            interfacesCatalogSet = interfacesCatalog.query(qb1);
            if (interfacesCatalogSet != null && interfacesCatalogSet.size() > 0) {
                Transaction transaction = new Transaction();
                for (int i = 0; i < interfacesCatalogSet.size(); ++i) {
                    SCMS_Interfaces_catalogSchema intfCatalog = new SCMS_Interfaces_catalogSchema();
                    intfCatalog = interfacesCatalogSet.get(i);
                    intfCatalog.setCatalogId(Long.valueOf(catalogId));
                    intfCatalog.setInnerCode(innerCode);
                    transaction.add((Schema)intfCatalog, 1);
                }
                transaction.commit();
            }
        }
    }

    private long getCatalogId(String innerCode) {
        SCMS_CatalogSchema catalogInfo = new SCMS_CatalogSchema();
        QueryBuilder qb = new QueryBuilder("where InnerCode = '" + innerCode + "'");
        SCMS_CatalogSet catalogSet = catalogInfo.query(qb);
        if (catalogSet != null && catalogSet.size() > 0) {
            catalogInfo = catalogSet.get(0);
            return catalogInfo.getID();
        }
        return -1L;
    }
}

