/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform;

import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataCollection;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.securitycard.MailUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.framework.utility.UUIDUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_Partner_authenticateSchema;
import com.sobey.scms.contentinfo.DemandMediaCommon;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class PartnerAuthenticate
extends Page {
    public static void dg1DataBind(DataGridAction dga) {
        String partnername = dga.getParam("partnername");
        String searchDate = dga.getParam("SearchDate");
        String isAudit = dga.getParam("SearchStatus");
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isNotEmpty((String)partnername)) {
            builder.append(" AND PARTNERNAME LIKE '%" + partnername + "%' ");
        }
        if (StringUtil.isNotEmpty((String)searchDate)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDate);
            if (day == 0) {
                builder.append(" AND CREATETIME like '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                builder.append(" AND CREATETIME like '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                builder.append(" AND CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                builder.append(" AND CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                builder.append(" AND CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                builder.append(" AND CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        if (StringUtil.isNotEmpty((String)isAudit) && !"-1".equals(isAudit)) {
            builder.append(" AND ISAUDIT = '" + isAudit + "' ");
        }
        builder.append(" ORDER BY CREATETIME DESC ");
        String sql = "select defaultFlag, id,partnerCode,alias,partnerName,createUser,token,createTime,expireDate,isAudit,status,accessCount,siteid,'' as subpartnerName,'' as isAuditEnable,'' as isStatusEnable,'' as statusName, '' as defaultHtml from scms_partner_authenticate where 1=1 ";
        sql = sql + builder.toString();
        String countsql = "select count(id) from scms_partner_authenticate where 1=1 " + builder.toString();
        dga.setTotal(new QueryBuilder(countsql));
        DataTable dt = new QueryBuilder(sql).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        if (null == dt || dt.getRowCount() == 0) {
            dga.dataTable2JSON(new DataTable());
            return;
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            Date expireDate;
            String status = dt.getString(i, "status");
            String id = dt.getString(i, "id");
            String expireDateString = dt.getString(i, "expireDate");
            dt.set(i, "subpartnerName", (Object)DemandMediaCommon.controlMediaTitleLength((String)dt.getString(i, "partnerName")));
            if (!"0".equals(expireDateString) && (expireDate = dt.getDate(i, "expireDate")) != null && new Date().getTime() > expireDate.getTime()) {
                dt.set(i, "expireDate", (Object)("<font color='red'>" + expireDateString + "</front>"));
            }
            if ("1".equals(dt.getString(i, "defaultFlag"))) {
                dt.set(i, "defaultHtml", (Object)"<font color='red'>(\u5f53\u524d\u9ed8\u8ba4)</front>");
            } else {
                dt.set(i, "defaultHtml", (Object)"");
            }
            isAudit = dt.getString(i, "isAudit");
            partnername = dt.getString(i, "partnerName");
            if ("1".equals(status)) {
                dt.set(i, "statusName", (Object)"\u505c\u7528");
                continue;
            }
            dt.set(i, "statusName", (Object)"\u5f00\u542f");
        }
        dga.dataTable2JSON(dt);
    }

    public static Mapx initAuthenticate(Mapx params) {
        String id = params.getString((Object)"ID");
        if (StringUtil.isEmpty((String)id)) {
            return new Mapx();
        }
        String sql = "select id,partnerCode,alias,partnerName,expireDate,isAudit,status,accessCount,siteid,tel,email,mobile,remark from scms_partner_authenticate where id='" + id + "'";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        if (null == dt || dt.getRowCount() == 0) {
            return new Mapx();
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            for (int j = 0; j < dt.getColCount(); ++j) {
                String key = dt.getDataColumn(j).getColumnName();
                String values = dt.getString(i, j);
                params.put((Object)key, (Object)values);
            }
        }
        return params;
    }

    public void save() {
        Transaction transaction = new Transaction();
        String id = this.$V("id");
        String partnerName = this.$V("partnerName");
        String partnerCode = this.$V("partnerCode");
        String isAudit = this.$V("isAudit");
        String token = "";
        try {
            SCMS_Partner_authenticateSchema schema = new SCMS_Partner_authenticateSchema();
            if (StringUtil.isEmpty((String)id)) {
                long authenticId = NoUtil.getMaxID((String)"AuthenticateId");
                String sql = "select count(id) from SCMS_Partner_authenticate where partnerCode='" + partnerCode + "'";
                int count = new QueryBuilder(sql).executeInt();
                if (count > 0) {
                    this.Response.setStatus(0);
                    this.Response.setMessage("\u5f53\u524d\u5382\u5546\u5df2\u7ecf\u5b58\u5728\uff01");
                } else {
                    if (StringUtil.isNotEmpty((String)isAudit) && "1".equals(isAudit)) {
                        token = StringUtil.md5Hex((String)(UUIDUtil.generate() + new Date()));
                        this.add_tokens(token, Application.getCurrentSiteID());
                    }
                    schema.setIsAudit(isAudit);
                    schema.setID(Long.valueOf(authenticId));
                    schema.setPartnerCode(partnerCode);
                    schema.setPartnerName(partnerName);
                    schema.setSiteid(Application.getCurrentSiteID() + "");
                    schema.setAlias(partnerCode);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String nowTime = format.format(new Date());
                    schema.setCreateTime(nowTime);
                    schema.setCreateUser(User.getUserName());
                    schema.setValue((DataCollection)this.Request);
                    schema.setToken(token);
                    transaction.add((Schema)schema, 1);
                    MailUtil mu = new MailUtil();
                    mu.sendTokenMail(schema.getEmail(), schema.getPartnerName(), schema.getToken(), 0, String.valueOf(Application.getCurrentSiteID()));
                    this.Response.setStatus(1);
                }
            } else {
                schema.setID(Long.valueOf(Long.parseLong(id)));
                if (schema.fill()) {
                    if (StringUtil.isNotEmpty((String)isAudit) && "0".equals(isAudit) && StringUtil.isNotEmpty((String)schema.getToken())) {
                        this.del_tokens(schema.getToken(), Application.getCurrentSiteID());
                        schema.setToken(token);
                    } else if (StringUtil.isNotEmpty((String)isAudit) && "1".equals(isAudit) && StringUtil.isEmpty((String)schema.getToken())) {
                        token = StringUtil.md5Hex((String)(UUIDUtil.generate() + new Date()));
                        this.add_tokens(token, Application.getCurrentSiteID());
                        schema.setToken(token);
                        MailUtil mu = new MailUtil();
                        mu.sendTokenMail(schema.getEmail(), partnerName, schema.getToken(), 1, String.valueOf(Application.getCurrentSiteID()));
                    }
                    schema.setIsAudit(isAudit);
                    schema.setPartnerCode(partnerCode);
                    schema.setPartnerName(partnerName);
                    schema.setAlias(partnerCode);
                    schema.setValue((DataCollection)this.Request);
                    transaction.add((Schema)schema, 2);
                }
            }
            if (transaction.commit()) {
                if (this.Response.Status == 1) {
                    this.Response.setStatus(1);
                } else {
                    this.Response.setStatus(0);
                }
            } else {
                this.Response.setStatus(2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void isEnableAuthenticate() {
        String id = this.$V("id");
        String status = this.$V("status");
        String sql = "update scms_partner_authenticate set status='" + status + "' where id='" + id + "'";
        int count = new QueryBuilder(sql).executeNoQuery();
        if (count > 0) {
            this.Response.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        } else {
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }

    public int del_tokens(String token, long siteId) {
        String email = this.get_siteEmail();
        int count = 0;
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        DataTable dt1 = new QueryBuilder("select tokens from scms_userdbconninfo where username='" + email + "'").executeDataTable();
        String tokens = dt1.getString(0, "tokens");
        String tokensString = "";
        if (StringUtil.isNotEmpty((String)tokens)) {
            String[] tokenArray = tokens.split(",");
            tokensString = tokenArray[0];
            for (int i = 0; i < tokenArray.length; ++i) {
                if (!StringUtil.isNotEmpty((String)token) || token.equals(tokenArray[i]) || !StringUtil.isNotEmpty((String)tokenArray[i])) continue;
                tokensString = tokensString + "," + tokenArray[i];
            }
            String sql = "update scms_userdbconninfo set tokens='" + tokensString + "' where username='" + email + "'";
            count = new QueryBuilder(sql).executeNoQuery();
        }
        DBConnPool.setDBConnPool((Long)siteId);
        return count;
    }

    public String get_siteEmail() {
        DataTable dta = new QueryBuilder("select email from scms_site").executeDataTable();
        String email = dta.getString(0, "email");
        return email;
    }

    public int add_tokens(String token, long siteId) {
        String email = this.get_siteEmail();
        int count = 0;
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        DataTable dt = new QueryBuilder("select tokens from scms_userdbconninfo where username='" + email + "'").executeDataTable();
        String tokens = dt.getString(0, "tokens");
        tokens = StringUtil.isNotEmpty((String)tokens) ? tokens + "," + token : "," + token;
        String sql = "update scms_userdbconninfo set tokens='" + tokens + "' where username='" + email + "'";
        count = new QueryBuilder(sql).executeNoQuery();
        DBConnPool.setDBConnPool((Long)siteId);
        return count;
    }

    public void authenticate() {
        String id = this.$V("id");
        String isAudit = this.$V("isAudit");
        String token = "";
        if (StringUtil.isNotEmpty((String)isAudit) && "1".equals(isAudit)) {
            token = StringUtil.md5Hex((String)(UUIDUtil.generate() + new Date()));
        }
        if (this.add_tokens(token, Application.getCurrentSiteID()) == 1) {
            String sql = "update scms_partner_authenticate set isAudit='" + isAudit + "',token='" + token + "' where id='" + id + "'";
            int count = new QueryBuilder(sql).executeNoQuery();
            if (count > 0) {
                this.Response.setStatus(1);
                this.Response.setMessage("\u5382\u5546\u8ba4\u8bc1\u6210\u529f\uff01");
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u5382\u5546\u8ba4\u8bc1\u5931\u8d25\uff01");
            }
        } else {
            this.Response.setStatus(0);
            this.Response.setMessage("\u5382\u5546\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
    }

    public void delAuthenticate() {
        String ids = this.$V("id");
        ArrayList<String> contentIds = new ArrayList<String>();
        if (!StringUtil.checkID((String)ids)) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u9519\u8bef\u7684\u53c2\u6570!");
            return;
        }
        for (String element : ids.split(",")) {
            contentIds.add(element);
        }
        for (int i = 0; i < contentIds.size(); ++i) {
            int count;
            String sql;
            DataTable dt = new QueryBuilder("select token from scms_partner_authenticate where id=" + (String)contentIds.get(i)).executeDataTable();
            String token = dt.getString(0, "token");
            if (StringUtil.isNotEmpty((String)token)) {
                if (this.del_tokens(token, Application.getCurrentSiteID()) == 1) {
                    sql = "delete from scms_partner_authenticate where id in (" + (String)contentIds.get(i) + ")";
                    count = new QueryBuilder(sql).executeNoQuery();
                    if (count > 0) {
                        this.Response.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
                        continue;
                    }
                    this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
                    continue;
                }
                this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
                continue;
            }
            sql = "delete from scms_partner_authenticate where id in (" + (String)contentIds.get(i) + ")";
            count = new QueryBuilder(sql).executeNoQuery();
            if (count > 0) {
                this.Response.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
                continue;
            }
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }
}

