/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.RequestImpl;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.HtmlUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.RolePriv;
import com.sobey.bsp.platform.RoleTabCatalog;
import com.sobey.bsp.platform.RoleTabMenu;
import com.sobey.bsp.platform.RoleTranscodeAuthority;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_PrivilegeSchema;
import com.sobey.bsp.schema.SCMS_PrivilegeSet;
import com.sobey.bsp.schema.SCMS_RoleSchema;
import com.sobey.bsp.schema.SCMS_RoleSet;
import com.sobey.bsp.schema.SCMS_UserRoleSchema;
import com.sobey.bsp.schema.SCMS_UserRoleSet;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Role
extends Page {
    public static final Mapx PrivTypeMap = new Mapx();
    public static final Mapx CatalogTypeMap;

    public static Mapx initEditDialog(Mapx params) {
        String type = params.getString((Object)"type");
        if (StringUtil.isNotEmpty((String)type) && "add".equals(type)) {
            return params;
        }
        String RoleCode = params.get((Object)"RoleCode").toString();
        try {
            if (RoleCode == null || "".equals(RoleCode)) {
                RoleCode = params.getString((Object)"Cookie.Role.LastRoleCode");
                if (RoleCode == null || "".equals(RoleCode)) {
                    return params;
                }
            } else if (!StringUtil.isChinese((String)RoleCode)) {
                RoleCode = new String(params.getString((Object)"RoleCode").getBytes("ISO-8859-1"), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        SCMS_RoleSchema role = new SCMS_RoleSchema();
        role.setRoleCode(RoleCode);
        if (!role.fill()) {
            System.out.println("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u89d2\u8272\uff01\uff01\uff01");
            return params;
        }
        Mapx map = role.toMapx();
        return map;
    }

    public static DataTable rolelist(Mapx params, DataRow parentDR) {
        String sql = "SELECT ROLENAME,ROLECODE FROM SCMS_ROLE ORDER BY ROLECODE DESC";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        if (null != dt && dt.getRowCount() > 0) {
            return dt;
        }
        return new DataTable();
    }

    public static void dg1DataBind(DataGridAction dga) {
        String roleCode = dga.getParam("RoleName");
        String searchDate = dga.getParam("SearchDate");
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isNotEmpty((String)roleCode)) {
            builder.append(" AND ROLENAME LIKE '%" + roleCode + "%' ");
        }
        if (StringUtil.isNotEmpty((String)searchDate)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDate);
            if (day == 0) {
                builder.append(" AND ADDTIME like '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                builder.append(" AND ADDTIME like '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                builder.append(" AND ADDTIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                builder.append(" AND ADDTIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                builder.append(" AND ADDTIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                builder.append(" AND ADDTIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        builder.append(" ORDER BY ADDTIME DESC ");
        dga.setTotal(new QueryBuilder("SELECT count(ROLECODE) FROM SCMS_ROLE WHERE 1=1 " + builder.toString()));
        DataTable dt = new QueryBuilder("SELECT ROLECODE,ROLENAME,ADDTIME,ADDUSER,SITEID,MODIFYTIME,MODIFYUSER,MEMO FROM SCMS_ROLE WHERE 1=1 " + builder.toString()).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        for (int i = 0; null != dt && dt.getRowCount() > 0 && i < dt.getRowCount(); ++i) {
            String realname = dt.getString(i, "ADDUSER");
            String memoInfo = dt.getString(i, "MEMO");
            memoInfo = memoInfo.length() > 25 ? memoInfo.substring(0, 25) + "..." : memoInfo;
            realname = User.getRealName((String)realname);
            dt.set(i, "ADDUSER", (Object)realname);
            dt.set(i, "MEMO", (Object)memoInfo);
        }
        dga.dataTable2JSON(dt);
    }

    public void save() {
        String RoleCode = this.$V("RoleCode").trim();
        String RoleName = this.$V("RoleName");
        String type = this.$V("type");
        String Memo = this.$V("Memo");
        int method = 1;
        if (StringUtil.isNotEmpty((String)RoleCode) && "0".equals(RoleCode.substring(0, 1))) {
            this.Response.setLogInfo(0, "\u65b0\u5efa\u5931\u8d25,\u89d2\u8272\u4ee3\u7801\u5b57\u7b26\u4e2d\u4e0d\u80fd\u4ee50\u5f00\u5934");
            return;
        }
        SCMS_RoleSchema role = new SCMS_RoleSchema();
        if (StringUtil.isChinese((String)RoleCode)) {
            this.Response.setLogInfo(0, "\u65b0\u5efa\u5931\u8d25,\u89d2\u8272\u4ee3\u7801\u4e0d\u80fd\u4e3a\u4e2d\u6587");
            return;
        }
        role.setRoleCode(RoleCode.toLowerCase());
        if (role.fill() && "add".equals(type)) {
            this.Response.setLogInfo(0, "\u89d2\u8272\u7f16\u7801" + role.getRoleCode() + "\u5df2\u7ecf\u5b58\u5728\u4e86\uff0c\u8bf7\u9009\u62e9\u53e6\u5916\u7684\u89d2\u8272\u7f16\u7801\uff01");
            return;
        }
        Date currentDate = new Date();
        String currentUserName = User.getUserName();
        if ("add".equals(type)) {
            role.setAddUser(currentUserName);
        }
        role.setAddTime(currentDate);
        role.setMemo(Memo);
        role.setRoleName(RoleName);
        role.setSiteid(Long.valueOf(Application.getCurrentSiteID()));
        Transaction trans = new Transaction();
        if ("add".equals(type)) {
            trans.add((Schema)role, 1);
        } else {
            trans.add((Schema)role, 2);
            method = 2;
        }
        SCMS_PrivilegeSet privilegeSet = new SCMS_PrivilegeSet();
        RoleTabMenu.saveRoleMenu((String)RoleCode, (Transaction)trans, (SCMS_PrivilegeSet)privilegeSet, (RequestImpl)this.Request);
        RoleTabMenu.saveRoleChannel((String)RoleCode, (Transaction)trans, (SCMS_PrivilegeSet)privilegeSet, (RequestImpl)this.Request);
        RoleTabCatalog.saveRoleCatalog((String)RoleCode, (Transaction)trans, (SCMS_PrivilegeSet)privilegeSet, (RequestImpl)this.Request, (String)"audio");
        RoleTabCatalog.saveRoleCatalog((String)RoleCode, (Transaction)trans, (SCMS_PrivilegeSet)privilegeSet, (RequestImpl)this.Request, (String)"video");
        RoleTabCatalog.saveRoleCatalog((String)RoleCode, (Transaction)trans, (SCMS_PrivilegeSet)privilegeSet, (RequestImpl)this.Request, (String)"series");
        RoleTranscodeAuthority.saveRoleTranscode((String)RoleCode, (Transaction)trans, (SCMS_PrivilegeSet)privilegeSet, (RequestImpl)this.Request);
        trans.add((SchemaSet)privilegeSet, 1);
        String msg = "\u4fee\u6539";
        String subType = "SaveUser";
        if ("add".equals(type)) {
            msg = "\u6dfb\u52a0";
            subType = "AddUser";
        }
        if (trans.commit()) {
            RolePriv.updateAllPriv((String)RoleCode);
            UserLog.log((String)"User", (String)subType, (String)(msg + "\u89d2\u8272\uff1a" + RoleCode + "\u6210\u529f"), (String)this.Request.getClientIP());
            this.Response.setLogInfo(1, "\u4fdd\u5b58\u6210\u529f!");
        } else {
            this.Response.setLogInfo(0, "\u4fdd\u5b58\u5931\u8d25!");
            UserLog.log((String)"User", (String)subType, (String)(msg + "\u89d2\u8272\uff1a" + RoleCode + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
    }

    public void del() {
        String RoleCode = this.Request.getString("RoleCode");
        String roleCodes = "";
        String[] roles = RoleCode.split(",");
        for (int i = 0; i < roles.length; ++i) {
            roleCodes = roleCodes + "'" + roles[i] + "',";
        }
        roleCodes = roleCodes.substring(0, roleCodes.lastIndexOf(","));
        Transaction trans = new Transaction();
        SCMS_RoleSet roleSet = new SCMS_RoleSchema().query(new QueryBuilder(" where rolecode in (" + roleCodes + ")"));
        for (int i = 0; i < roleSet.size(); ++i) {
            SCMS_RoleSchema role = roleSet.get(i);
            if ("everyone".equalsIgnoreCase(role.getRoleCode())) {
                this.Response.setLogInfo(0, "everyone\u4e3a\u7cfb\u7edf\u81ea\u5e26\u7684\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
                UserLog.log((String)"User", (String)"DelUser", (String)("\u5220\u9664\u89d2\u8272:" + role.getRoleName() + "\u5931\u8d25"), (String)this.Request.getClientIP());
                return;
            }
            if (!"admin".equalsIgnoreCase(role.getRoleCode())) continue;
            this.Response.setLogInfo(0, "admin\u4e3a\u7cfb\u7edf\u81ea\u5e26\u7684\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            UserLog.log((String)"User", (String)"DelUser", (String)("\u5220\u9664\u89d2\u8272:" + role.getRoleName() + "\u5931\u8d25"), (String)this.Request.getClientIP());
            return;
        }
        trans.add((SchemaSet)roleSet, 3);
        SCMS_UserRoleSchema userRole = new SCMS_UserRoleSchema();
        SCMS_UserRoleSet userRoleSet = userRole.query(new QueryBuilder("WHERE ROLECODE in (" + roleCodes + ")"));
        if (userRoleSet.size() > 0) {
            this.Response.setStatus(2);
            return;
        }
        trans.add((SchemaSet)userRoleSet, 3);
        trans.add((SchemaSet)new SCMS_PrivilegeSchema().query(new QueryBuilder("WHERE OWNERTYPE=? AND OWNER in (" + roleCodes + ") ", (Object)"R")), 3);
        if (trans.commit()) {
            int i;
            for (i = 0; i < userRoleSet.size(); ++i) {
                PubFun.initUserRoleMap((String)userRoleSet.get(i).getUserName());
            }
            for (i = 0; i < roles.length; ++i) {
                RolePriv.updateAllPriv((String)roles[i]);
            }
            this.Response.setLogInfo(1, "\u5220\u9664\u6210\u529f!");
            UserLog.log((String)"User", (String)"DelUser", (String)("\u5220\u9664\u89d2\u8272:" + RoleCode + "\u6210\u529f"), (String)this.Request.getClientIP());
        } else {
            this.Response.setLogInfo(0, "\u5220\u9664\u5931\u8d25!");
            UserLog.log((String)"User", (String)"DelUser", (String)("\u5220\u9664\u89d2\u8272:" + RoleCode + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
    }

    public static Mapx catalogList(Mapx params) {
        params.put((Object)"PrivType", (Object)HtmlUtil.mapxToOptions((Map)PrivTypeMap, (Object)"article"));
        return params;
    }

    static {
        PrivTypeMap.put((Object)"video", (Object)"\u89c6\u9891\u680f\u76ee");
        PrivTypeMap.put((Object)"audio", (Object)"\u97f3\u9891\u680f\u76ee");
        CatalogTypeMap = new Mapx();
        CatalogTypeMap.put((Object)"video", 5);
        CatalogTypeMap.put((Object)"audio", 6);
    }
}

