/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform.ffmpegutil;

import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.platform.ffmpegutil.CmdExecuter;
import com.sobey.bsp.platform.ffmpegutil.FFMpegUtil;
import com.sobey.bsp.platform.ffmpegutil.IStringGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FFMpegUtil
implements IStringGetter {
    private long runtime = 0L;
    private String ffmpegUri;
    private String originFileUri;
    private FFMpegUtilStatus status = FFMpegUtilStatus.Empty;
    private boolean isSupported;
    private List<String> cmd = new ArrayList();

    public FFMpegUtil(String ffmpegUri, String originFileUri) {
        this.ffmpegUri = ffmpegUri;
        this.originFileUri = originFileUri;
    }

    public Long getRuntime() {
        try {
            this.runtime = 0L;
            this.status = FFMpegUtilStatus.GettingRuntime;
            this.cmd.clear();
            this.cmd.add(this.ffmpegUri);
            this.cmd.add("-i");
            this.cmd.add(this.originFileUri);
            CmdExecuter.exec((List)this.cmd, (IStringGetter)this);
        }
        catch (Exception e) {
            System.out.println("\u76d1\u6d4b\u51fa\u9519");
        }
        return this.runtime;
    }

    public boolean isSupported() {
        this.isSupported = true;
        this.status = FFMpegUtilStatus.CheckingFile;
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        CmdExecuter.exec((List)this.cmd, (IStringGetter)this);
        return this.isSupported;
    }

    public void makeScreenCut(String imageSavePath, String screenSize) {
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        this.cmd.add("-y");
        this.cmd.add("-f");
        this.cmd.add("image2");
        this.cmd.add("-ss");
        this.cmd.add("8");
        this.cmd.add("-t");
        this.cmd.add("0.001");
        this.cmd.add("-s");
        this.cmd.add(screenSize);
        this.cmd.add(imageSavePath);
        CmdExecuter.exec((List)this.cmd, null);
    }

    public void videoTransfer(String fileSavePath, String screenSize, int audioByte, int audioCollection, double quality, double fps) {
        this.cmd.clear();
        this.cmd.add(this.ffmpegUri);
        this.cmd.add("-i");
        this.cmd.add(this.originFileUri);
        this.cmd.add("-y");
        this.cmd.add("-ab");
        this.cmd.add(Integer.toString(audioByte));
        this.cmd.add("-ar");
        this.cmd.add(Integer.toString(audioCollection));
        this.cmd.add("-qscale");
        this.cmd.add(Double.toString(quality));
        this.cmd.add("-r");
        this.cmd.add(Double.toString(fps));
        this.cmd.add("-s");
        this.cmd.add(screenSize);
        this.cmd.add(fileSavePath);
        CmdExecuter.exec((List)this.cmd, null);
    }

    public void dealString(String str) {
        switch (1.$SwitchMap$com$sobey$bsp$platform$ffmpegutil$FFMpegUtil$FFMpegUtilStatus[this.status.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Matcher m = Pattern.compile("Unknown format").matcher(str);
                if (!m.find()) break;
                this.isSupported = false;
                break;
            }
            case 3: {
                try {
                    System.out.println("\u5904\u7406\u65f6\u957f");
                    Matcher m = Pattern.compile("Duration: (.*?), start: (.*?), bitrate: (\\d*) kb\\/s").matcher(str);
                    while (m.find()) {
                        String msg = m.group(1);
                        msg = msg.substring(0, msg.lastIndexOf("."));
                        System.out.println("\u89c6\u9891\u65f6\u957f\uff1a" + msg);
                        this.runtime = FormatDateUtil.getTimeMillis((String)msg);
                    }
                    break;
                }
                catch (Exception e) {
                    System.out.println("\u5904\u7406\u65f6\u957f\u5931\u8d25");
                }
            }
        }
    }
}

