/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.platform.pub;

import com.sobey.bsp.framework.cache.CacheManager;
import com.sobey.bsp.framework.controls.CodeSource;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;

public class PlatformCodeSource
extends CodeSource {
    public DataTable getCodeData(String codeType, Mapx params) {
        DataTable dt = null;
        String conditionField = params.getString((Object)"ConditionField");
        String conditionValue = params.getString((Object)"ConditionValue");
        if ("District".equals(codeType)) {
            QueryBuilder qb = new QueryBuilder("select code,name from SCMS_District where " + conditionField + "=?", (Object)conditionValue);
            String parentCode = params.getString((Object)"ParentCode");
            if (StringUtil.isNotEmpty((String)parentCode)) {
                qb.appendSQLPart(" and Code like ?");
                if (parentCode.startsWith("11") || parentCode.startsWith("12") || parentCode.startsWith("31") || parentCode.startsWith("50")) {
                    qb.add((Object)(parentCode.substring(0, 2) + "%"));
                    qb.appendSQLPart(" and TreeLevel=3");
                } else if (parentCode.endsWith("0000")) {
                    qb.add((Object)(parentCode.substring(0, 2) + "%"));
                    qb.appendSQLPart(" and TreeLevel=2");
                } else if (parentCode.endsWith("00")) {
                    qb.add((Object)(parentCode.substring(0, 4) + "%"));
                    qb.appendSQLPart(" and TreeLevel=3");
                } else {
                    qb.add((Object)"#");
                }
            } else if (conditionField.equals("1")) {
                return new DataTable();
            }
            dt = qb.executeDataTable();
        } else if ("User".equals(codeType)) {
            QueryBuilder qb = new QueryBuilder("select UserName,UserName as 'Name',RealName,isBranchAdmin from SCMS_User where " + conditionField + "=?", (Object)conditionValue);
            dt = qb.executeDataTable();
        } else {
            Mapx map = CacheManager.get((String)"Code", (String)codeType);
            if (conditionValue.equals("2")) {
                map.remove((Object)"01");
            }
            if (map != null) {
                dt = map.toDataTable();
            }
        }
        return dt;
    }
}

