/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.threadmanager;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamclound.vms.constant.MicroBusinessTypeEnum;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_ChannelRecordSchema;
import com.sobey.bsp.schema.SCMS_ChannelRecordSet;
import com.sobey.bsp.schema.SCMS_ChannelsSchema;
import com.sobey.bsp.threadmanager.NetworkService;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import com.sobey.cms.interfaces.tool.util.ChannelRecordLogUtil;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.scms.channel.ChannelLib;
import com.sobey.scms.trasncode.MPCCall;
import com.sobey.scms.trasncode.strategy.SedlStrategyContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChannelRecordThread
extends ThreadTask {
    private static final Logger log = LoggerFactory.getLogger(ChannelRecordThread.class);
    private SCMS_ChannelRecordSchema scmsChannelRecordSchema;

    public ChannelRecordThread(SCMS_ChannelRecordSchema scmsChannelRecordSchema) {
        this.scmsChannelRecordSchema = scmsChannelRecordSchema;
    }

    public void run() {
        log.info("\u6536\u5f55\u8ba1\u5212\u5f00\u59cb\u6267\u884c");
        Long siteId = this.scmsChannelRecordSchema.getSiteId();
        DBConnPool.setDBConnPool((Long)siteId);
        try {
            String channelId = this.scmsChannelRecordSchema.getChannelId();
            boolean verifyDataIsNormal = this.verifyDataIsNormal(channelId);
            if (!verifyDataIsNormal) {
                return;
            }
            String path = this.builderPath(siteId);
            String winVideoUploadPath = PathUtil.builderPath((String[])new String[]{Config.getValue((long)siteId, (String)"winVideoUploadDir"), path});
            String linuxVideoUploadPath = PathUtil.builderPath((String[])new String[]{Config.getValue((long)siteId, (String)"linuxVideoUploadDir"), path});
            boolean isSedPath = this.isSedPath(siteId);
            String winSedlRelativePath = this.getWinSedlRelativePath(isSedPath, siteId, path);
            String linuxSedlRelativePath = this.getLinuxSedlRelativePath(isSedPath, siteId, path);
            this.updateChannelRecordStatusAndFilePath(linuxVideoUploadPath);
            new JSONObject();
            JSONObject infoJSONObject = JSONObject.fromObject((Object)this.scmsChannelRecordSchema.getInfo());
            JSONObject liveUrlJSONObject = ChannelLib.getliveDownloadUrl((String)channelId, (long)siteId, (String)infoJSONObject.getString("liveStreamId"));
            this.fillInfoJSONObject(path, infoJSONObject, liveUrlJSONObject);
            if ("true".equals(Config.getValue((long)siteId, (String)"liveCut.isDownloadFlag"))) {
                this.downloadFile(siteId, winVideoUploadPath, linuxVideoUploadPath, infoJSONObject, liveUrlJSONObject);
            }
            ChannelRecordThread.generateVideoSedlFile((JSONObject)infoJSONObject, (String)linuxSedlRelativePath, (String)winSedlRelativePath, (String)this.scmsChannelRecordSchema.getContentSourceId(), (String)this.scmsChannelRecordSchema.getTitle());
            String workflowType = Config.getValue((long)siteId, (String)"liveCut.workflowType");
            if ("1".equals(workflowType)) {
                this.processByWorkFlow(siteId, winSedlRelativePath, infoJSONObject);
            } else {
                MPCCall.generateMixXml((String)winVideoUploadPath, (String)winSedlRelativePath, (String)this.scmsChannelRecordSchema.getContentSourceId(), (String)this.scmsChannelRecordSchema.getTitle(), (long)this.scmsChannelRecordSchema.getSiteId(), (String)"0", (String)"-1", (int)8, (Integer)MicroBusinessTypeEnum.LIVE_DEMOLITION.getIndex());
            }
            log.info("\u6536\u5f55\u8ba1\u5212\u6267\u884c\u7ed3\u675f");
        }
        catch (Exception e) {
            log.error("\u6536\u5f55\u8ba1\u5212\u5f00\u59cb\u6267\u884c\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean verifyDataIsNormal(String channelId) {
        SCMS_ChannelsSchema scmsChannelsSchema = new SCMS_ChannelsSchema();
        scmsChannelsSchema.setId(channelId);
        if (!scmsChannelsSchema.fill()) {
            this.updateStatusAndRecordLogByNotExist();
            return false;
        }
        return this.scmsChannelRecordSchema.getStatus() == 9;
    }

    private String getLinuxSedlRelativePath(boolean isSedPath, Long siteId, String path) {
        String linuxSedlRelativePath = null;
        linuxSedlRelativePath = isSedPath ? PathUtil.builderPath((String[])new String[]{Config.getValue((long)siteId, (String)"linuxSedlUploadDir"), path}) : PathUtil.builderPath((String[])new String[]{Config.getValue((long)siteId, (String)"linuxVideoUploadDir"), path});
        return linuxSedlRelativePath;
    }

    private String getWinSedlRelativePath(boolean isSedPath, Long siteId, String path) {
        String winSedlRelativePath = null;
        winSedlRelativePath = isSedPath ? PathUtil.builderPath((String[])new String[]{Config.getValue((long)siteId, (String)"winSedlUploadDir"), path}) : PathUtil.builderPath((String[])new String[]{Config.getValue((long)siteId, (String)"winVideoUploadDir"), path});
        return winSedlRelativePath;
    }

    private boolean isSedPath(Long siteId) {
        boolean isSedPath = false;
        String winSedlUploadDir = Config.getValue((long)siteId, (String)"winSedlUploadDir");
        String linuxSedlUploadDir = Config.getValue((long)siteId, (String)"linuxSedlUploadDir");
        if (StringUtil.isNotEmpty((String)winSedlUploadDir) && StringUtil.isNotEmpty((String)linuxSedlUploadDir)) {
            isSedPath = true;
        }
        return isSedPath;
    }

    private void fillInfoJSONObject(String path, JSONObject infoJSONObject, JSONObject liveUrlJSONObject) {
        infoJSONObject.put((Object)"liveUrls", (Object)liveUrlJSONObject);
        infoJSONObject.put((Object)"outFile", (Object)PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxOutFileDir"), path, "mix.ts"}));
        infoJSONObject.put((Object)"winOutFile", (Object)StringUtil.replaceAllToBack_Slant((String)PathUtil.builderPath((String[])new String[]{Config.getValue((String)"winOutFileDir"), path, "mix.ts"})));
    }

    private String builderPath(Long siteId) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd/");
        String timeString = simpleDateFormat.format(new Date());
        return PathUtil.builderPathEndSlash((String[])new String[]{SiteUtil.getAlias((long)siteId), "/source/recode", timeString, this.scmsChannelRecordSchema.getContentSourceId()});
    }

    private void processByWorkFlow(Long siteId, String winSedlRelativePath, JSONObject infoJSONObject) {
        Transaction transaction = new Transaction();
        String workFlowUrl = Config.getValue((long)siteId, (String)"liveCut.workflowUrl");
        String workFlowResult = NetworkService.workflowAddTask((String)"T002", (String)this.initParams(this.scmsChannelRecordSchema, winSedlRelativePath + "mix.sedl", infoJSONObject), (String)workFlowUrl);
        JSONObject workFlowJo = JSONObject.fromObject((Object)workFlowResult);
        if ("101".equals(workFlowJo.getString("code"))) {
            ChannelRecordLogUtil.addLog((Transaction)transaction, (Long)this.scmsChannelRecordSchema.getId(), (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u6210\u529f", (String)this.scmsChannelRecordSchema.getCreateUser(), (String)"WorkFlow");
        } else {
            ChannelRecordLogUtil.addLog((Transaction)transaction, (Long)this.scmsChannelRecordSchema.getId(), (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u5931\u8d25", (String)this.scmsChannelRecordSchema.getCreateUser(), (String)"WorkFlow");
        }
    }

    private void updateChannelRecordStatusAndRecordLogByDownloadFailure() {
        Transaction transaction = new Transaction();
        ChannelRecordLogUtil.addLog((Transaction)transaction, (Long)this.scmsChannelRecordSchema.getId(), (String)"\u89c6\u9891\u4e0b\u8f7d\u5931\u8d25", (String)this.scmsChannelRecordSchema.getCreateUser(), (String)"Download");
        this.scmsChannelRecordSchema.setStatus(Integer.valueOf(0));
        transaction.add((Schema)this.scmsChannelRecordSchema, 2);
        transaction.commit();
    }

    private void updateChannelRecordStatusAndRecordLogByDownloadSuccess() {
        Transaction transaction = new Transaction();
        ChannelRecordLogUtil.addLog((Transaction)transaction, (Long)this.scmsChannelRecordSchema.getId(), (String)"\u89c6\u9891\u4e0b\u8f7d\u6210\u529f", (String)this.scmsChannelRecordSchema.getCreateUser(), (String)"Download");
        this.scmsChannelRecordSchema.setStatus(Integer.valueOf(5));
        transaction.add((Schema)this.scmsChannelRecordSchema, 2);
        transaction.commit();
    }

    private boolean downloadFile(Long siteId, String winVideoUploadPath, String linuxVideoUploadPath, JSONObject infoJSONObject, JSONObject liveUrlJSONObject) throws IOException {
        boolean result = true;
        JSONArray timeJSONArray = infoJSONObject.getJSONArray("times");
        String url = liveUrlJSONObject.getJSONArray("downloadCutUrl").getJSONObject(0).getString("url");
        for (int i = 0; i < timeJSONArray.size(); ++i) {
            String filename = i + ".flv";
            String logName = i + ".log";
            JSONObject timeJSONObject = timeJSONArray.getJSONObject(i);
            String remoteUrl = this.getRemoteUrl(siteId, url, timeJSONObject);
            String downloadUrl = StringUtil.replaceAllToBack_Slant((String)(winVideoUploadPath + filename));
            log.info("\u5f00\u59cb\u8fdb\u5165\u4e0b\u8f7ddownUploadUrl-----------------" + downloadUrl);
            JSONObject timeJsonObj = ChannelRecordThread.downAndReadFile((String)remoteUrl, (String)linuxVideoUploadPath, (String)filename, (String)logName);
            if (timeJsonObj == null) {
                log.error("\u4e0b\u8f7d\u5931\u8d25,remoteUrl:{}", (Object)remoteUrl);
                result = false;
                break;
            }
            String beginTime = timeJsonObj.getString("Begintime");
            if ("-1".equals(beginTime)) {
                result = false;
                log.error("\u4e0b\u8f7d\u5931\u8d25,remoteUrl:{},\u83b7\u5f97\u4e0d\u4e86Begintime", (Object)remoteUrl);
                break;
            }
            timeJSONObject.put((Object)"downloadUrl", (Object)downloadUrl);
        }
        if (result) {
            this.updateChannelRecordStatusAndRecordLogByDownloadSuccess();
        } else {
            this.updateChannelRecordStatusAndRecordLogByDownloadFailure();
        }
        return result;
    }

    private String getRemoteUrl(Long siteId, String url, JSONObject timeJSONObject) {
        InterfacesMethod interfacesMethod;
        JSONObject pkJSONObject;
        Long startTime = Long.parseLong(timeJSONObject.getString("startTime"));
        Long endTime = Long.parseLong(timeJSONObject.getString("endTime"));
        String remoteUrl = url + "&starttime=" + startTime + "&endtime=" + endTime + "&shiftmode=accurate";
        if ("true".equals(Config.getValue((String)"ms3.guardFlag")) && (pkJSONObject = (interfacesMethod = new InterfacesMethod()).getMs3Passkey(siteId, true)).getLong("status") == 1L) {
            remoteUrl = remoteUrl + "&passkey=" + pkJSONObject.getString("passkey");
        }
        return remoteUrl;
    }

    private void updateChannelRecordStatusAndFilePath(String linuxVideoUploadPath) {
        Transaction transaction = new Transaction();
        this.scmsChannelRecordSchema.setStatus(Integer.valueOf(3));
        this.scmsChannelRecordSchema.setFilePath(linuxVideoUploadPath);
        transaction.add((Schema)this.scmsChannelRecordSchema, 2);
        transaction.commit();
    }

    private void updateStatusAndRecordLogByNotExist() {
        Transaction transaction = new Transaction();
        this.scmsChannelRecordSchema.setStatus(Integer.valueOf(0));
        transaction.add((Schema)this.scmsChannelRecordSchema, 2);
        ChannelRecordLogUtil.addLog((Transaction)transaction, (Long)this.scmsChannelRecordSchema.getId(), (String)"\u6536\u5f55\u8ba1\u5212\u6267\u884c\u5931\u8d25,\u76f4\u64ad\u9891\u9053\u4e0d\u5b58\u5728\uff01", (String)this.scmsChannelRecordSchema.getCreateUser(), (String)"EXECUTE");
        transaction.commit();
    }

    public static void execute() {
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        QueryBuilder qb = new QueryBuilder("select id from scms_account WHERE status = 1");
        DataTable dt = qb.executeDataTable();
        if (dt != null && dt.getRowCount() > 0) {
            try {
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    try {
                        long sid = dt.getLong(i, "id");
                        DBConnPool.setDBConnPool((Long)sid);
                        SCMS_ChannelRecordSchema scms_channelRecordSchema = new SCMS_ChannelRecordSchema();
                        SCMS_ChannelRecordSet scms_channelRecordSet = scms_channelRecordSchema.query(new QueryBuilder("WHERE STATUS = 5  "));
                        for (int j = 0; j < scms_channelRecordSet.size(); ++j) {
                            scms_channelRecordSchema = scms_channelRecordSet.get(j);
                            ChannelRecordThread th = new ChannelRecordThread(scms_channelRecordSchema);
                            ThreadPoolManager.getInstance().addTask((ThreadTask)th);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LogUtil.info((Object)("\u7ad9\u70b9\uff1a" + dt.getLong(i, "id") + ",\u6267\u884c\u6536\u5f55\u8ba1\u5212\u51fa\u9519\uff01"));
                    }
                }
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u6536\u5f55\u8ba1\u5212\u524d\u5148\u81ea\u52a8\u6dfb\u52a0\u65b0\u7684\u6536\u5f55\u8ba1\u5212\u9047\u5230\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject downAndReadFile(String remoteUrl, String linuxVideoUploadPath, String filename, String logName) throws IOException {
        JSONObject jsonObject = new JSONObject();
        String currentFileName = filename;
        linuxVideoUploadPath = linuxVideoUploadPath.replace("//", "/").replace("/", File.separator);
        ChannelRecordThread.parentFileMkdirsIfRequired((String)linuxVideoUploadPath);
        Process process = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader lineNumberReader = null;
        try {
            File file = new File(PathUtil.builderPath((String[])new String[]{linuxVideoUploadPath, currentFileName}));
            if (file != null && !file.exists()) {
                file.createNewFile();
            }
            String logPath = PathUtil.builderPath((String[])new String[]{linuxVideoUploadPath, logName});
            String linux = "wget --limit-rate=10m -nv -S " + remoteUrl + " -O " + file + " -o " + logPath;
            log.info("\u4e0b\u8f7d\u8bf7\u6c42\u8def\u5f84\u547d\u4ee4------" + linux);
            process = Runtime.getRuntime().exec(linux);
            inputStreamReader = new InputStreamReader(process.getInputStream());
            lineNumberReader = new LineNumberReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String line = "";
            while ((line = ((LineNumberReader)lineNumberReader).readLine()) != null) {
                stringBuffer.append(line).append("\n");
            }
            log.info("\u8fd4\u56de\u7ed3\u679c:------" + stringBuffer.toString());
            Map resultMap = ChannelRecordThread.getFullOfFileDataTextByEncoding((String)logPath, (String)"UTF-8");
            if (((Boolean)resultMap.get("downLoad")).booleanValue()) {
                jsonObject.put((Object)"Begintime", (Object)((String)resultMap.get("Begintime")));
                jsonObject.put((Object)"Offset", (Object)((String)resultMap.get("Offset")));
            } else {
                jsonObject = null;
                log.error("\u89c6\u9891\u4e0b\u8f7d\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            jsonObject = null;
            log.error("\u89c6\u9891\u4e0b\u8f7d\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (lineNumberReader != null) {
                lineNumberReader.close();
            }
        }
        log.info("\u4e0b\u8f7d\u540e\u7ec4\u88c5\u7684jsonObject\u6570\u636e:{}", (Object)jsonObject);
        return jsonObject;
    }

    private static void parentFileMkdirsIfRequired(String linuxVideoUploadPath) {
        File parentFile = new File(linuxVideoUploadPath);
        if (!parentFile.exists()) {
            log.info("\u6587\u4ef6\u5939\u521b\u5efa\u5f00\u59cb...-------->" + linuxVideoUploadPath);
            parentFile.mkdirs();
        }
    }

    public static Map<String, Object> getFullOfFileDataTextByEncoding(String strFileNameWithSuffix, String strEncoding) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("downLoad", false);
        StringBuffer strbuf = new StringBuffer();
        try (FileInputStream is = new FileInputStream(strFileNameWithSuffix);
             InputStreamReader sRead = new InputStreamReader((InputStream)is, strEncoding);
             BufferedReader bufferedReader = new BufferedReader(sRead);){
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf("200 OK") > -1) {
                    map.put("downLoad", true);
                } else if (str.indexOf("Begintime: ") > -1) {
                    map.put("Begintime", str.substring(str.indexOf("Begintime: ") + "Begintime: ".length()));
                } else if (str.indexOf("Offset: ") > -1) {
                    map.put("Offset", str.substring(str.indexOf("Offset: ") + "Offset: ".length()));
                }
                strbuf.append(str + "\r\n");
            }
        }
        map.put("result", strbuf);
        return map;
    }

    public static void generateVideoSedlFile(JSONObject datalist, String linuxSedlRelativePath, String winSedlRelativePath, String id, String name) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("datalist", datalist);
            map.put("linuxSedlRelativePath", linuxSedlRelativePath);
            map.put("winSedlRelativePath", winSedlRelativePath);
            map.put("name", name);
            map.put("id", id);
            SedlStrategyContext sedlStrategyContext = new SedlStrategyContext();
            sedlStrategyContext.writeXml(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject downAndReadFile(String remotfilePath, String abpath, String savefilename) {
        JSONObject jo = new JSONObject();
        boolean flag = false;
        log.info("\u5f00\u59cb\u4e86....-------->" + abpath);
        String uname = savefilename;
        abpath = abpath.replace("//", "/").replace("/", File.separator);
        File f1 = new File(abpath);
        log.info("\u6587\u4ef6\u5939\u521b\u5efa\u5f00\u59cb...-------->" + abpath);
        if (!f1.exists()) {
            log.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u521b\u5efa...-------->" + abpath);
            f1.mkdirs();
        }
        log.info("\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f------------------->" + abpath);
        OutputStream oputstream = null;
        InputStream iputstream = null;
        try {
            File file = new File(abpath + "/" + uname);
            log.info("\u6e90\u6587\u4ef6\u5730\u5740---------------------->" + abpath + "/" + uname);
            if (file != null && !file.exists()) {
                file.createNewFile();
            }
            log.info("\u4e0b\u8f7d\u8bf7\u6c42\u8def\u5f84\u5730\u5740------" + remotfilePath);
            oputstream = new FileOutputStream(file);
            URL url = new URL(remotfilePath);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.connect();
            String begintime = uc.getHeaderField("Begintime");
            String offset = uc.getHeaderField("Offset");
            log.info("\u5f00\u59cb\u65f6\u95f4\u70b9========\u300b" + begintime);
            log.info("\u5411\u524d\u504f\u79fb\u65f6\u95f4========\u300b" + offset);
            jo.put((Object)"Begintime", (Object)begintime);
            jo.put((Object)"Offset", (Object)offset);
            iputstream = uc.getInputStream();
            byte[] buffer = new byte[4096];
            int byteRead = -1;
            while ((byteRead = iputstream.read(buffer)) != -1) {
                oputstream.write(buffer, 0, byteRead);
            }
            oputstream.flush();
        }
        catch (Exception e) {
            jo = null;
            log.error("\u89c6\u9891\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                if (oputstream != null) {
                    oputstream.close();
                }
                if (iputstream != null) {
                    iputstream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return jo;
    }

    public String initParams(SCMS_ChannelRecordSchema vr, String sedlPath, JSONObject listData) {
        String result = "";
        try {
            new JSONObject();
            JSONObject injo = JSONObject.fromObject((Object)this.scmsChannelRecordSchema.getInfo());
            String catalogId = this.scmsChannelRecordSchema.getCatalogid() + "";
            String transcodeId = injo.getString("transcodeId");
            String uid = injo.getString("uid");
            String orderId = injo.getString("orderid");
            String username = injo.getString("userName");
            String token = injo.getString("token");
            String contentSourceId = this.scmsChannelRecordSchema.getContentSourceId();
            JSONObject jo = new JSONObject();
            JSONObject business_data = new JSONObject();
            JSONObject ROOT = new JSONObject();
            JSONObject WorkFlow = new JSONObject();
            JSONObject Data = new JSONObject();
            JSONArray importJa = new JSONArray();
            importJa.add((Object)1);
            WorkFlow.put((Object)"piid", (Object)"");
            WorkFlow.put((Object)"title", (Object)this.scmsChannelRecordSchema.getTitle());
            WorkFlow.put((Object)"import", (Object)importJa);
            WorkFlow.put((Object)"orderId", (Object)orderId);
            JSONObject MediaFile2 = new JSONObject();
            MediaFile2.put((Object)"FileName", (Object)sedlPath);
            MediaFile2.put((Object)"InPoint", (Object)0);
            MediaFile2.put((Object)"OutPoint", (Object)-1);
            JSONArray TaskInfo = new JSONArray();
            JSONObject TaskInfoChild1 = new JSONObject();
            TaskInfoChild1.put((Object)"Scope", (Object)"channelCut");
            JSONObject TaskInfoChild1Data = new JSONObject();
            JSONObject TranscodeParam = new JSONObject();
            TranscodeParam.put((Object)"joblist", (Object)transcodeId);
            TranscodeParam.put((Object)"transType", (Object)"joblist");
            TranscodeParam.put((Object)"actionType", (Object)"compose");
            TranscodeParam.put((Object)"type", (Object)"1");
            TranscodeParam.put((Object)"IsSplit", (Object)"true");
            TranscodeParam.put((Object)"platFormID", (Object)catalogId);
            TranscodeParam.put((Object)"platFormName", (Object)"");
            TranscodeParam.put((Object)"title", (Object)this.scmsChannelRecordSchema.getTitle());
            TranscodeParam.put((Object)"library", (Object)"\u6210\u54c1\u5e93");
            TranscodeParam.put((Object)"uid", (Object)uid);
            TranscodeParam.put((Object)"username", (Object)username);
            TranscodeParam.put((Object)"from_id", (Object)"");
            TranscodeParam.put((Object)"task_id", (Object)this.scmsChannelRecordSchema.getContentSourceId());
            if (injo.has("bst")) {
                TranscodeParam.put((Object)"programInfo", (Object)injo.getJSONObject("bst"));
            } else {
                TranscodeParam.put((Object)"programInfo", null);
            }
            if (injo.has("publishPlatform")) {
                TranscodeParam.put((Object)"publishPlatform", (Object)injo.getJSONArray("publishPlatform"));
            } else {
                TranscodeParam.put((Object)"publishPlatform", null);
            }
            if (injo.has("specialEffects")) {
                TranscodeParam.put((Object)"specialEffects", (Object)injo.getString("specialEffects"));
            } else {
                TranscodeParam.put((Object)"specialEffects", (Object)"0");
            }
            JSONObject quickCutUrlJo = listData.getJSONObject("liveUrls").getJSONObject("quickCutUrl");
            Double quickCut_width = quickCutUrlJo.getDouble("width");
            Double quickCut_height = quickCutUrlJo.getDouble("height");
            TranscodeParam.put((Object)"hdMark", (Object)0);
            if (1.7777777777777777 == quickCut_width / quickCut_height) {
                TranscodeParam.put((Object)"hdMark", (Object)1);
            } else if (1.3333333333333333 == quickCut_width / quickCut_height) {
                TranscodeParam.put((Object)"hdMark", (Object)0);
            }
            JSONArray BaseInfo = new JSONArray();
            for (int i = 0; i < 1; ++i) {
                JSONObject newitem = new JSONObject();
                newitem.put((Object)"file_path", (Object)sedlPath);
                BaseInfo.add((Object)newitem);
            }
            TaskInfoChild1Data.put((Object)"TranscodeParam", (Object)TranscodeParam);
            TaskInfoChild1Data.put((Object)"BaseInfo", (Object)BaseInfo);
            TaskInfoChild1.put((Object)"Data", (Object)TaskInfoChild1Data);
            TaskInfo.add((Object)TaskInfoChild1);
            Data.put((Object)"MediaFile", (Object)MediaFile2);
            Data.put((Object)"TaskInfo", (Object)TaskInfo);
            ROOT.put((Object)"WorkFlow", (Object)WorkFlow);
            ROOT.put((Object)"Data", (Object)Data);
            business_data.put((Object)"ROOT", (Object)ROOT);
            business_data.put((Object)"USERNAME", (Object)username);
            business_data.put((Object)"UID", (Object)uid);
            business_data.put((Object)"TOKEN", (Object)token);
            jo.put((Object)"business_data", (Object)business_data);
            result = business_data.toString();
            System.out.println(business_data.toString());
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return result;
    }
}

