/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.threadmanager;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamclound.vms.constant.MicroBusinessTypeEnum;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_MediaCutSchema;
import com.sobey.bsp.schema.SCMS_MediaCutSet;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import com.sobey.cms.interfaces.tool.util.MediaCutLogUtil;
import com.sobey.scms.trasncode.MPCCall;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class MediaCutRecordThread
extends ThreadTask {
    private SCMS_MediaCutSchema scmsMediaCutSchema;

    public MediaCutRecordThread() {
    }

    public MediaCutRecordThread(SCMS_MediaCutSchema scmsMediaCutSchema) {
        this.scmsMediaCutSchema = scmsMediaCutSchema;
    }

    public void run() {
        System.out.println("\u5fae\u7f16\u8ba1\u5212\u5f00\u59cb\u6267\u884c");
        Long siteId = Long.parseLong(this.scmsMediaCutSchema.getSiteid());
        DBConnPool.setDBConnPool((Long)siteId);
        try {
            if (this.scmsMediaCutSchema.getStatus() != 9) {
                return;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd/");
            String timeString = simpleDateFormat.format(new Date());
            String pathEndSlash = PathUtil.builderPathEndSlash((String[])new String[]{SiteUtil.getAlias((long)siteId), "/source/recode", timeString, this.scmsMediaCutSchema.getContentSourceId()});
            String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir");
            String sourceHost = PathUtil.builderPathEndSlash((String[])new String[]{winVideoUploadDir, SiteUtil.getAlias((long)siteId)});
            String winVideoUploadPath = PathUtil.builderPath((String[])new String[]{winVideoUploadDir, pathEndSlash});
            boolean isSedl = this.isSedl();
            String winSedlRelativePath = this.getWinSedlRelativePath(pathEndSlash, isSedl);
            String linuxSedlRelativePath = this.getLinuxSedlRelativePath(pathEndSlash, isSedl);
            JSONObject infoJSONObject = JSONObject.fromObject((Object)this.scmsMediaCutSchema.getInfo());
            JSONArray timesJSONArray = JSONArray.fromObject((Object)infoJSONObject.getString("times"));
            ArrayList list = new ArrayList();
            for (int i = 0; i < timesJSONArray.size(); ++i) {
                DataTable dataTable;
                JSONObject timeJSONObject = timesJSONArray.getJSONObject(i);
                String id = timeJSONObject.getString("id");
                String mediaSourceTableName = "scms_contentinfo";
                if (6 == this.scmsMediaCutSchema.getType()) {
                    mediaSourceTableName = "scms_audioinfo";
                }
                if ((dataTable = new QueryBuilder("select title, path  from " + mediaSourceTableName + " " + " where ContentSourceId='" + id + "'").executeDataTable()) == null || dataTable.getRowCount() < 1) {
                    this.updateMediaCutStatusAndRecordLogFailure(id);
                    return;
                }
                JSONObject times2JSONObject = timeJSONObject.getJSONObject("times");
                String path = dataTable.getString(0, "path");
                String sourceVideoPath = StringUtil.replaceAllToSlant((String)(sourceHost + path));
                Long timeStart = Long.parseLong(times2JSONObject.getString("startTime"));
                Long timeEnd = Long.parseLong(times2JSONObject.getString("endTime"));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(i + "", sourceVideoPath + "@@" + timeStart / 1000L * 25L + "@@" + timeEnd / 1000L * 25L);
                map.put(i + "", sourceVideoPath + "@@" + timeStart + "@@" + timeEnd);
                list.add(map);
            }
            this.scmsMediaCutSchema.setFilePath(pathEndSlash);
            this.scmsMediaCutSchema.setStatus(Integer.valueOf(5));
            Transaction transaction = new Transaction();
            MediaCutRecordThread.generateVideoSedlFile(list, (String)linuxSedlRelativePath, (String)this.scmsMediaCutSchema.getContentSourceId(), (String)this.scmsMediaCutSchema.getTitle());
            transaction.add((Schema)this.scmsMediaCutSchema, 2);
            if (transaction.commit()) {
                int businessType = this.scmsMediaCutSchema.getType() == 6 ? MicroBusinessTypeEnum.AUDIO.getIndex() : MicroBusinessTypeEnum.VIDEO.getIndex();
                MPCCall.generateMixXml((String)winVideoUploadPath, (String)winSedlRelativePath, (String)this.scmsMediaCutSchema.getContentSourceId(), (String)this.scmsMediaCutSchema.getTitle(), (long)Long.parseLong(this.scmsMediaCutSchema.getSiteid()), (String)"1", (String)"-1", (int)this.scmsMediaCutSchema.getType(), (Integer)businessType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateMediaCutStatusAndRecordLogFailure(String id) {
        Transaction transaction = new Transaction();
        MediaCutLogUtil.addLog((Transaction)transaction, (Long)this.scmsMediaCutSchema.getId(), (String)("\u5feb\u62c6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6[" + id + "]\u4e0d\u5b58\u5728\uff01"), (String)this.scmsMediaCutSchema.getOpUser(), (String)"EXECUTE");
        this.scmsMediaCutSchema.setStatus(Integer.valueOf(0));
        transaction.add((Schema)this.scmsMediaCutSchema, 2);
        transaction.commit();
    }

    private String getLinuxSedlRelativePath(String pathEndSlash, boolean isSedl) {
        String linuxSedlRelativePath = null;
        linuxSedlRelativePath = isSedl ? PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxSedlUploadDir"), pathEndSlash}) : PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxVideoUploadDir"), pathEndSlash});
        return linuxSedlRelativePath;
    }

    private String getWinSedlRelativePath(String pathEndSlash, boolean isSedl) {
        String winSedlRelativePath = null;
        winSedlRelativePath = isSedl ? PathUtil.builderPath((String[])new String[]{Config.getValue((String)"winSedlUploadDir"), pathEndSlash}) : PathUtil.builderPath((String[])new String[]{Config.getValue((String)"winVideoUploadDir"), pathEndSlash});
        return winSedlRelativePath;
    }

    private boolean isSedl() {
        boolean isSedl = false;
        if (StringUtil.isNotEmpty((String)Config.getValue((String)"winSedlUploadDir")) && StringUtil.isNotEmpty((String)Config.getValue((String)"linuxSedlUploadDir"))) {
            isSedl = true;
        }
        return isSedl;
    }

    public static void execute() {
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        QueryBuilder qb = new QueryBuilder("select id from scms_account WHERE status = 1");
        DataTable dt = qb.executeDataTable();
        if (dt != null && dt.getRowCount() > 0) {
            try {
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    try {
                        long sid = dt.getLong(i, "id");
                        DBConnPool.setDBConnPool((Long)sid);
                        SCMS_MediaCutSchema svr = new SCMS_MediaCutSchema();
                        SCMS_MediaCutSet svrSet = svr.query(new QueryBuilder("WHERE STATUS = 5  "));
                        for (int j = 0; j < svrSet.size(); ++j) {
                            svr = svrSet.get(j);
                            MediaCutRecordThread th = new MediaCutRecordThread(svr);
                            ThreadPoolManager.getInstance().addTask((ThreadTask)th);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LogUtil.info((Object)("\u7ad9\u70b9\uff1a" + dt.getLong(i, "id") + ",\u6267\u884c\u6536\u5f55\u8ba1\u5212\u51fa\u9519\uff01"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void generateVideoSedlFile(List<Map<String, String>> datalist, String filePath, String id, String name) {
        try {
            File newFile;
            StringBuilder videoParams = new StringBuilder();
            StringBuilder audioParams = new StringBuilder();
            StringBuilder physicalParams = new StringBuilder();
            long begin = 0L;
            for (int i = 0; i < datalist.size(); ++i) {
                Map<String, String> map = datalist.get(i);
                String[] split = map.get(i + "").split("@@");
                String videoXml = "";
                videoXml = i == 0 ? "<ref clipid='" + i + "' begin='0' clipbegin='" + split[1] + "' clipend='" + split[2] + "' cliptype='0' channel='0' format='0' transtype='0'/>" : "<ref clipid='" + i + "' begin='" + begin + "' clipbegin='" + split[1] + "' clipend='" + split[2] + "' cliptype='0' channel='0' format='0' transtype='0'/>";
                String physicalXml = " <map id='" + i + "' fmtid='0' extfile='' clipfile='" + split[0] + "'/>";
                begin += Long.parseLong(split[2]) - Long.parseLong(split[1]);
                videoParams.append(videoXml);
                physicalParams.append(physicalXml);
            }
            String xml = "<?xml version='1.0' encoding='utf-8'?><sbedl version='3' length='' name='" + name + "' fmtid='-1' maxid='6' id='" + id + "' fps='25' AcquireType='1'>" + "<video>" + videoParams.toString() + " </video>" + " <audio>" + audioParams.toString() + " </audio>" + " <physical>" + physicalParams.toString() + " </physical>" + "</sbedl>";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((newFile = new File(filePath, "mix.sedl")).exists()) {
                newFile.delete();
            }
            newFile.createNewFile();
            FileUtil.writeText((String)newFile.getAbsolutePath(), (String)xml, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int dayForWeek(Date date) {
        int dayForWeek = 0;
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dayForWeek;
    }
}

