/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.threadmanager;

import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ThreadPoolManager {
    private static long _next_task_id = 0L;
    public static final int DEFAULT_THREAD_NUM = 5;
    public static final int MAX_THREAD_NUM = 20;
    public int _cur_thread_num = 0;
    public boolean _is_closed = true;
    public List<ThreadTask> taskQueue = Collections.synchronizedList(new LinkedList());
    public WorkThread[] threads;
    private static ThreadPoolManager _instance = null;

    private ThreadPoolManager() {
        this._cur_thread_num = 5;
        this.threads = new WorkThread[this._cur_thread_num];
        for (int i = 0; i < this._cur_thread_num; ++i) {
            this.threads[i] = new WorkThread(this, i);
        }
    }

    public ThreadPoolManager(int thread_num) {
        this._cur_thread_num = thread_num;
        this.threads = new WorkThread[this._cur_thread_num];
        for (int i = 0; i < this._cur_thread_num; ++i) {
            this.threads[i] = new WorkThread(this, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolManager getInstance() {
        if (_instance != null) return _instance;
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (_instance != null) return _instance;
            _instance = new ThreadPoolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public static synchronized long generateTaskId() {
        return _next_task_id++;
    }

    public void start() {
        this._is_closed = false;
        for (int i = 0; i < this._cur_thread_num; ++i) {
            this.threads[i].start();
        }
        LogUtil.info((Object)String.format("ThreadPool Initialized----,init " + this._cur_thread_num + " thread", new Object[0]));
    }

    public void close() {
        if (!this._is_closed) {
            this.waitforfinish();
            this._is_closed = true;
            this.taskQueue.clear();
        }
        LogUtil.info((Object)"Thread pool close!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitforfinish() {
        ThreadPoolManager threadPoolManager = this;
        synchronized (threadPoolManager) {
            this._is_closed = true;
            this.notifyAll();
        }
        for (int i = 0; i < this._cur_thread_num; ++i) {
            this.threads[i].stopThread();
            LogUtil.info((Object)String.format("Thread [%d] stop!", i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ThreadTask new_task) {
        if (this._is_closed) {
            LogUtil.info((Object)"\u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed");
            throw new IllegalStateException();
        }
        List list = this.taskQueue;
        synchronized (list) {
            if (new_task != null) {
                this.taskQueue.add(new_task);
                this.taskQueue.notifyAll();
            }
        }
    }

    public int getTaskCount() {
        return this.taskQueue.size();
    }
}

