/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.threadmanager;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamclound.vms.constant.MicroBusinessTypeEnum;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ChannelRecordLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_VideoRecordSchema;
import com.sobey.bsp.schema.SCMS_VideoRecordSet;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.scms.contentinfo.interfaces.impl.CatalogInterfaceImpl;
import com.sobey.scms.contentinfo.interfaces.impl.ImageInfoInterfaceImpl;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.MPCCall;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class VideoRecordThread
extends ThreadTask {
    private SCMS_VideoRecordSchema vr;

    public VideoRecordThread() {
    }

    public VideoRecordThread(SCMS_VideoRecordSchema vr) {
        this.vr = vr;
    }

    public void run() {
        Long siteId = Long.parseLong(this.vr.getSiteid());
        DBConnPool.setDBConnPool((Long)siteId);
        try {
            Transaction transaction = new Transaction();
            SCMS_ContentinfoSchema ParentContentinfo = new SCMS_ContentinfoSchema();
            ParentContentinfo.setContentID(this.vr.getContentID());
            if (!ParentContentinfo.fill()) {
                this.vr.setStatus(0);
                transaction.add((Schema)this.vr, 2);
                SCMS_ChannelRecordLogSchema log = new SCMS_ChannelRecordLogSchema();
                log.setID(NoUtil.getMaxID((String)"VideoRecordLogId"));
                log.setContentId(this.vr.getId().longValue());
                log.setAction("EXECUTE");
                log.setActionDetail("\u6536\u5f55\u8ba1\u5212\u6267\u884c\u5931\u8d25,\u89c6\u9891\u6570\u636e\u4e0d\u5b58\u5728\uff01");
                log.setAddTime(new Date());
                log.setAddUser(this.vr.getOpUser());
                transaction.add((Schema)log, 1);
                this.vr.setStatus(0);
                transaction.add((Schema)this.vr, 2);
                transaction.commit();
                return;
            }
            if (this.vr.getStatus() != 9) {
                // empty if block
            }
            String linuxVideoUploadDir = Config.getValue((String)"linuxVideoUploadDir");
            String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir");
            String sourceHost = PathUtil.builderPathEndSlash((String[])new String[]{winVideoUploadDir, SiteUtil.getAlias((long)siteId)});
            String videoPath = StringUtil.replaceAllToSlant((String)(sourceHost + ParentContentinfo.getPath()));
            String alias = SiteUtil.getAlias((long)siteId);
            String sourceRecode = "/source/recode/";
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd/");
            String time = format.format(new Date());
            String linuxVideoUploadPath = PathUtil.builderPathEndSlash((String[])new String[]{linuxVideoUploadDir, SiteUtil.getAlias((long)siteId), sourceRecode, time, this.vr.getContentSourceId()});
            String winVideoUploadPath = PathUtil.builderPathEndSlash((String[])new String[]{winVideoUploadDir, SiteUtil.getAlias((long)siteId), sourceRecode, time, this.vr.getContentSourceId()});
            JSONArray timeArray = JSONArray.fromObject((Object)this.vr.getTimes());
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String backUploadUrl = "";
            boolean savePhyFlag = true;
            ArrayList list = new ArrayList();
            long inpoint = 0L;
            long outpoint = 0L;
            for (int i = 0; i < timeArray.size(); ++i) {
                JSONObject item = timeArray.getJSONObject(i);
                long timeStart = formatDate.parse(this.vr.getExecutTime() + " " + item.getString("startTime")).getTime() - formatDate.parse(this.vr.getExecutTime() + " " + "00:00:00").getTime();
                long timeEnd = formatDate.parse(this.vr.getExecutTime() + " " + item.getString("endTime")).getTime() - formatDate.parse(this.vr.getExecutTime() + " " + "00:00:00").getTime();
                long frams = (timeEnd - timeStart) / 1000L * 25L;
                backUploadUrl = winVideoUploadPath;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(i + "", videoPath + "@@" + timeStart / 1000L * 25L + "@@" + timeEnd / 1000L * 25L);
                map.put(i + "", videoPath + "@@" + timeStart + "@@" + timeEnd);
                list.add(map);
                if (i != 0) continue;
                inpoint = timeStart;
                outpoint = timeEnd;
            }
            VideoRecordThread.generateVideoSedlFile(list, (String)linuxVideoUploadPath, (String)this.vr.getContentSourceId(), (String)this.vr.getTitle());
            VideoRecordThread.updateStaus((SCMS_VideoRecordSchema)this.vr);
            String title = this.vr.getTitle();
            SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
            if (timeArray.size() == 1 && savePhyFlag) {
                title = ContentUtil.getTitle((String)title, (int)5, (int)0);
                Long contentId = NoUtil.getMaxID((String)"ContentID");
                contentinfo.setContentID(contentId);
                contentinfo.setContentSourceId(this.vr.getContentSourceId());
                contentinfo.setTitle(title);
                contentinfo.setCreateTime(new Date());
                contentinfo.setDescription(this.vr.getDescription());
                contentinfo.setModifyTime(new Date());
                contentinfo.setCreatorName(this.vr.getOpUser());
                if (StringUtil.isNotEmpty((String)backUploadUrl) && (backUploadUrl = StringUtil.replaceAllToSlant((String)backUploadUrl)).indexOf("/source/recode") != -1) {
                    backUploadUrl = backUploadUrl.substring(backUploadUrl.indexOf("/source/recode"));
                }
                contentinfo.setPath(ParentContentinfo.getPath());
                contentinfo.setInpoint(Long.valueOf(inpoint * 10000L));
                contentinfo.setOutpoint(Long.valueOf(outpoint * 10000L));
                contentinfo.setPath(ParentContentinfo.getPath());
                contentinfo.setSourceSystemID(Integer.valueOf(5));
                contentinfo.setSourceSystemName("");
                contentinfo.setTranscodeid(this.vr.getTranscodeid());
                contentinfo.setIsSourceVideo(Integer.valueOf(0));
                contentinfo.setIsPublish(this.vr.getIsPublish());
                contentinfo.setStatus(Long.valueOf(2L));
                contentinfo.setTag("");
                contentinfo.setProgramLength("");
                contentinfo.setSiteid(siteId);
                contentinfo.setKeyFrame("");
                contentinfo.setMediaPathType(Integer.valueOf(1));
                contentinfo.setCatalogid(this.vr.getCatalogid());
                CatalogInterfaceImpl catalog = new CatalogInterfaceImpl();
                contentinfo.setCatalogInnerCode(catalog.getCatalogInnerCode(Long.parseLong(this.vr.getCatalogid())));
                InterfacesMethod im = new InterfacesMethod();
                JSONArray ja = new JSONArray();
                ja = im.getCatalogPathAndIds(ja, Long.parseLong(this.vr.getCatalogid()));
                String fristCatalogName = ((JSONObject)ja.get(0)).getString("catalogName");
                String classifyType = ContentUtil.getClassifyTypeByCatalogName((String)fristCatalogName);
                contentinfo.setClassifyType(classifyType);
                JSONObject imageInfo = new JSONObject();
                imageInfo.put((Object)"contentSourceId", (Object)contentinfo.getContentSourceId());
                imageInfo.put((Object)"contentId", (Object)contentinfo.getContentID());
                imageInfo.put((Object)"mediaType", (Object)5);
                imageInfo.put((Object)"terminal", (Object)1);
                String keyFrame = this.vr.getPic();
                if (keyFrame.indexOf("/upload/Image/default/") > 0) {
                    keyFrame = keyFrame.substring(keyFrame.indexOf("/upload/Image/default/"), keyFrame.length());
                }
                imageInfo.put((Object)"imageUrl", (Object)keyFrame);
                ImageInfoInterfaceImpl iii = new ImageInfoInterfaceImpl();
                iii.saveImageInfo(imageInfo, transaction);
                contentinfo.setKeyFrame(keyFrame);
                transaction.add((Schema)contentinfo, 1);
            }
            transaction.add((Schema)this.vr, 2);
            if (transaction.commit()) {
                if (this.vr.getStatus() != 0) {
                    if (timeArray.size() == 1) {
                        this.vr.setStatus(2);
                        VideoRecordThread.updateStaus((SCMS_VideoRecordSchema)this.vr);
                        UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u89c6\u9891" + this.vr.getTitle() + "\u5165\u5e93\u6210\u529f"), (String)"\u89c6\u9891\u5feb\u62c6", (String)this.vr.getOpUser());
                        ContentSearchMediator.publishVideo2Search((String)String.valueOf(contentinfo.getContentID()), (String)alias, (long)siteId);
                        MPCCall.generateXml((String)videoPath, (String)String.valueOf(this.vr.getTranscodeid()), (String)contentinfo.getContentSourceId(), (String)contentinfo.getTitle(), (long)siteId, (String)String.valueOf(inpoint * 10000L), (String)String.valueOf(outpoint * 10000L));
                    } else {
                        this.vr.setStatus(5);
                        VideoRecordThread.updateStaus((SCMS_VideoRecordSchema)this.vr);
                        MPCCall.generateMixXml((String)winVideoUploadPath, (String)winVideoUploadPath, (String)this.vr.getContentSourceId(), (String)this.vr.getTitle(), (long)Long.parseLong(this.vr.getSiteid()), (String)"1", (String)"-1", (int)5, (Integer)MicroBusinessTypeEnum.QUICK_RELEASE.getIndex());
                    }
                }
            } else {
                this.vr.setStatus(0);
                VideoRecordThread.updateStaus((SCMS_VideoRecordSchema)this.vr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateStaus(SCMS_VideoRecordSchema vr) {
        Transaction ta = new Transaction();
        ta.add((Schema)vr, 2);
        ta.commit();
    }

    public static void execute() {
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        QueryBuilder qb = new QueryBuilder("select id from scms_account WHERE status = 1");
        DataTable dt = qb.executeDataTable();
        if (dt != null && dt.getRowCount() > 0) {
            try {
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    try {
                        long sid = dt.getLong(i, "id");
                        DBConnPool.setDBConnPool((Long)sid);
                        SCMS_VideoRecordSchema svr = new SCMS_VideoRecordSchema();
                        SCMS_VideoRecordSet svrSet = svr.query(new QueryBuilder("WHERE STATUS = 5  "));
                        for (int j = 0; j < svrSet.size(); ++j) {
                            svr = svrSet.get(j);
                            VideoRecordThread th = new VideoRecordThread(svr);
                            ThreadPoolManager.getInstance().addTask((ThreadTask)th);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LogUtil.info((Object)("\u7ad9\u70b9\uff1a" + dt.getLong(i, "id") + ",\u6267\u884c\u6536\u5f55\u8ba1\u5212\u51fa\u9519\uff01"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean DownAndReadFile(String remotfilePath, String abpath, String savefilename) {
        boolean flag = false;
        String uname = savefilename;
        abpath = abpath.replace("//", "/").replace("/", File.separator);
        File f1 = new File(abpath);
        System.out.println("\u6587\u4ef6\u5939\u521b\u5efa\u5f00\u59cb...-------->" + abpath);
        if (!f1.exists()) {
            System.out.println("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u521b\u5efa...-------->" + abpath);
            f1.mkdirs();
        }
        System.out.println("\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f------------------->" + abpath);
        try {
            File file = new File(abpath + "/" + uname);
            System.out.println("\u6e90\u6587\u4ef6\u5730\u5740---------------------->" + abpath + "/" + uname);
            if (file != null && !file.exists()) {
                file.createNewFile();
            }
            FileOutputStream oputstream = new FileOutputStream(file);
            URL url = new URL(remotfilePath);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.connect();
            InputStream iputstream = uc.getInputStream();
            byte[] buffer = new byte[4096];
            int byteRead = -1;
            while ((byteRead = iputstream.read(buffer)) != -1) {
                ((OutputStream)oputstream).write(buffer, 0, byteRead);
            }
            oputstream.flush();
            iputstream.close();
            ((OutputStream)oputstream).close();
            FileInputStream fs = new FileInputStream(new File(abpath + "//" + uname));
            InputStreamReader isr = new InputStreamReader((InputStream)fs, "UTF-8");
            fs.close();
            isr.close();
            flag = true;
        }
        catch (Exception e) {
            System.out.println("\u89c6\u9891\u4e0b\u8f7d\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        return flag;
    }

    public static void generateVideoSedlFile(List<Map<String, String>> datalist, String filePath, String id, String name) {
        try {
            File newFile;
            StringBuilder videoParams = new StringBuilder();
            StringBuilder audioParams = new StringBuilder();
            StringBuilder physicalParams = new StringBuilder();
            Long begin = 0L;
            for (int i = 0; i < datalist.size(); ++i) {
                Map<String, String> map = datalist.get(i);
                String videoXml = "";
                videoXml = i == 0 ? "<ref clipid='" + i + "' begin='0' clipbegin='" + map.get(i + "").split("@@")[1] + "' clipend='" + map.get(i + "").split("@@")[2] + "' cliptype='0' channel='0' format='0' transtype='0'/>" : "<ref clipid='" + i + "' begin='" + begin.toString() + "' clipbegin='" + map.get(i + "").split("@@")[1] + "' clipend='" + map.get(i + "").split("@@")[2] + "' cliptype='0' channel='0' format='0' transtype='0'/>";
                begin = begin + (Long.parseLong(map.get(i + "").split("@@")[2]) - Long.parseLong(map.get(i + "").split("@@")[1]));
                String physicalXml = " <map id='" + i + "' fmtid='0' extfile='' clipfile='" + map.get(i + "").split("@@")[0] + "'/>";
                videoParams.append(videoXml);
                physicalParams.append(physicalXml);
            }
            String xml = "<?xml version='1.0' encoding='utf-8'?><sbedl version='3' length='' name='" + name + "' fmtid='-1' maxid='6' id='" + id + "' fps='25' AcquireType='1'>" + "<video>" + videoParams.toString() + " </video>" + " <audio>" + audioParams.toString() + " </audio>" + " <physical>" + physicalParams.toString() + " </physical>" + "</sbedl>";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((newFile = new File(filePath, "mix.sedl")).exists()) {
                newFile.delete();
            }
            newFile.createNewFile();
            System.out.println("\u5408\u6210\u8f6c\u7801MPC\u8bfb\u53d6\u7684\u9759\u6001\u6587\u4ef6==========>" + xml);
            FileUtil.writeText((String)newFile.getAbsolutePath(), (String)xml, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int dayForWeek(Date date) {
        int dayForWeek = 0;
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dayForWeek;
    }

    public static void main(String[] s) {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            long timeStart = formatDate.parse("2015-11-12 00:00:20.5").getTime() - formatDate.parse("2015-11-12 00:00:00").getTime();
            System.out.println(timeStart * 10000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

