/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.vms.business.workflow.core;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_StepSchema;
import com.sobey.bsp.vms.business.workflow.core.Node;
import com.sobey.bsp.vms.business.workflow.core.Workflow;
import com.sobey.bsp.vms.business.workflow.core.WorkflowAction;
import com.sobey.bsp.vms.business.workflow.core.WorkflowException;
import com.sobey.bsp.vms.business.workflow.core.WorkflowInstance;
import com.sobey.bsp.vms.business.workflow.core.WorkflowStep;
import com.sobey.bsp.vms.business.workflow.core.WorkflowUtil;
import java.util.Date;
import java.util.List;

public class Context {
    private WorkflowInstance instance;
    private SCMS_StepSchema step;
    private Mapx variables;
    private Workflow flow;
    private Transaction tran;
    private boolean variableFlag = false;

    public Context(Transaction tran, SCMS_StepSchema step) throws WorkflowException {
        this.tran = tran;
        this.flow = WorkflowUtil.findWorkflow((long)step.getWorkflowID());
        this.instance = WorkflowUtil.findInstance((long)step.getInstanceID());
        this.step = step;
        this.variables = WorkflowUtil.getDataVariables((String)this.instance.getDataID(), (String)step.getDataVersionID());
    }

    public Context(Transaction tran, WorkflowInstance instance, SCMS_StepSchema step) {
        this.tran = tran;
        this.flow = WorkflowUtil.findWorkflow((long)step.getWorkflowID());
        this.instance = instance;
        this.step = step;
        if (step.getID() != 1L) {
            this.variables = WorkflowUtil.getDataVariables((String)instance.getDataID(), (String)step.getDataVersionID());
        }
    }

    protected Context(long workflowID) {
        this.flow = WorkflowUtil.findWorkflow((long)workflowID);
    }

    public WorkflowInstance getInstance() {
        return this.instance;
    }

    public SCMS_StepSchema getStep() {
        return this.step;
    }

    public Mapx getVariables() {
        return this.variables;
    }

    public Workflow getWorkflow() {
        return this.flow;
    }

    public Transaction getTransaction() {
        return this.tran;
    }

    public String getOwner() {
        return User.getUserName();
    }

    public String getOwnerOrgan() {
        return User.getBranchInnerCode();
    }

    public void setStepOrgan(String organNames) {
        this.step.setAllowOrgan(organNames);
    }

    public void setStepRole(String roleNames) {
        this.step.setAllowRole(roleNames);
    }

    public void setStepUser(String userNames) {
        this.step.setAllowUser(userNames);
    }

    public Object getValue(String fieldName) {
        return this.variables.get((Object)fieldName);
    }

    public void setValue(String fieldName, String value) {
        this.variableFlag = true;
        this.variables.put((Object)fieldName, (Object)value);
    }

    public void setValue(String fieldName, long value) {
        this.variableFlag = true;
        this.variables.put((Object)fieldName, value);
    }

    public void setValue(String fieldName, int value) {
        this.variableFlag = true;
        this.variables.put((Object)fieldName, value);
    }

    public void save() {
        this.tran.add((Schema)this.step, 2);
        this.tran.commit();
        this.tran.clear();
        if (this.variableFlag) {
            WorkflowUtil.saveDataVariables((Context)this);
        }
    }

    public boolean isOwnRole(String roleName) {
        String roles = "," + PubFun.getRoleNames((List)PubFun.getRoleCodesByUserName((String)User.getUserName())) + ",";
        return roles.indexOf(roleName = "," + roleName + ",") >= 0;
    }

    public String getFlowName() {
        return this.instance.getName();
    }

    public String getWorkflowName() {
        return WorkflowUtil.findWorkflow((long)this.instance.getWorkflowID()).getName();
    }

    public String getStepName() {
        return WorkflowUtil.getStepName((long)this.flow.getID(), (int)this.step.getNodeID());
    }

    public void gotoStep(String stepName) throws Exception {
        Node[] nodes = this.flow.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node.getType().equals("ActionNode") || !node.getName().equalsIgnoreCase(stepName)) continue;
            WorkflowStep newStep = new WorkflowStep();
            newStep.setID(NoUtil.getMaxID((String)"WorkflowStepID"));
            newStep.setWorkflowID(this.flow.getID());
            newStep.setAllowOrgan(node.getData().getString((Object)"Organ"));
            newStep.setAllowRole(node.getData().getString((Object)"Role"));
            newStep.setAllowUser(node.getData().getString((Object)"User"));
            newStep.setNodeID(node.getID());
            newStep.setActionID(-4);
            newStep.setInstanceID(this.instance.getID());
            newStep.setPreviousStepID(this.step.getID());
            newStep.setStartTime(new Date());
            newStep.setOperators(User.getUserName());
            newStep.setState("Unread");
            newStep.setAddTime(new Date());
            newStep.setAddUser(User.getUserName());
            if (node.getType().equals("StartNode")) {
                newStep.setAllowUser(this.instance.getAddUser());
                newStep.setState("Underway");
                newStep.setOwner(this.instance.getAddUser());
            }
            Context context = new Context(this.tran, this.instance, (SCMS_StepSchema)newStep);
            WorkflowUtil.findAdapter().onStepCreate(context);
            WorkflowAction.executeMethod((Context)this, (Node)this.flow.findNode(newStep.getNodeID()), (String)"Pre");
            context.save();
            if ("EndNode".equalsIgnoreCase(node.getType())) {
                newStep.setState("Finish");
                newStep.setFinishTime(new Date());
                newStep.setOwner("SYSTEM");
                this.instance.setState("Completed");
                this.tran.add((Schema)context.getInstance(), 2);
            }
            this.tran.add((Schema)newStep, 1);
        }
    }
}

