/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.vms.business.workflow.core;

import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.schema.SCMS_WorkflowSchema;
import com.sobey.bsp.vms.business.workflow.core.Node;
import com.sobey.bsp.vms.business.workflow.core.WorkflowTransition;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Workflow
extends SCMS_WorkflowSchema {
    private static final long serialVersionUID = 1L;
    public static final String STARTNODE = "StartNode";
    public static final String ENDNODE = "EndNode";
    public static final String COMMONNODE = "Node";
    public static final String ACTIONNODE = "ActionNode";
    private Node[] nodes;
    private Mapx data = new Mapx();

    protected synchronized void init() {
        try {
            Element ele;
            int i;
            SAXReader sax = new SAXReader();
            Document doc = null;
            StringReader reader = new StringReader(this.getConfigXML());
            doc = sax.read((Reader)reader);
            List list = doc.getRootElement().elements("config");
            for (i = 0; i < list.size(); ++i) {
                ele = (Element)list.get(i);
                this.data.put((Object)ele.attributeValue("name"), (Object)ele.attributeValue("value"));
            }
            list = doc.getRootElement().elements("node");
            this.nodes = new Node[list.size()];
            for (i = 0; i < list.size(); ++i) {
                Node node;
                ele = (Element)list.get(i);
                this.nodes[i] = node = new Node(this, ele);
            }
            for (i = 0; i < this.nodes.length; ++i) {
                WorkflowTransition[] wts = this.nodes[i].getTransitions();
                for (int j = 0; j < wts.length; ++j) {
                    wts[j].init();
                }
            }
        }
        catch (DocumentException e1) {
            e1.printStackTrace();
        }
    }

    public Mapx getData() {
        return this.data;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public Node findNode(int id) {
        if (this.nodes == null) {
            this.init();
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].getID() != id) continue;
            return this.nodes[i];
        }
        return null;
    }

    public Node getStartNode() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getType().equals(STARTNODE)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public Node getEndNode() {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getType().equals(ENDNODE)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public WorkflowTransition findTransition(int id) {
        if (this.nodes == null) {
            this.init();
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            WorkflowTransition[] wts = this.nodes[i].getTransitions();
            for (int j = 0; j < wts.length; ++j) {
                if (wts[j].getID() != id) continue;
                return wts[j];
            }
        }
        return null;
    }

    public static Workflow convert(SCMS_WorkflowSchema schema) {
        Workflow wf = new Workflow();
        for (int i = 0; i < wf.getColumnCount(); ++i) {
            wf.setV(i, schema.getV(i));
        }
        wf.init();
        return wf;
    }
}

