/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.vms.business.workflow.core;

import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_StepSchema;
import com.sobey.bsp.schema.SCMS_StepSet;
import com.sobey.bsp.vms.business.workflow.core.Context;
import com.sobey.bsp.vms.business.workflow.core.Node;
import com.sobey.bsp.vms.business.workflow.core.Workflow;
import com.sobey.bsp.vms.business.workflow.core.WorkflowException;
import com.sobey.bsp.vms.business.workflow.core.WorkflowInstance;
import com.sobey.bsp.vms.business.workflow.core.WorkflowStep;
import com.sobey.bsp.vms.business.workflow.core.WorkflowTransition;
import com.sobey.bsp.vms.business.workflow.core.WorkflowUtil;
import com.sobey.bsp.vms.business.workflow.methods.ConditionMethod;
import com.sobey.bsp.vms.business.workflow.methods.ConditionScript;
import com.sobey.bsp.vms.business.workflow.methods.MethodScript;
import com.sobey.bsp.vms.business.workflow.methods.NodeMethod;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkflowAction {
    public static final int TEMPORARYSAVE_ACTIONID = -1;
    public static final int START_ACTIONID = -2;
    public static final int APPLY_ACTIONID = -3;
    public static final int SCRIPT_ACTIONID = -4;
    public static final int RESTART_ACTIONID = -5;
    public static final int FORCEEND_ACTIONID = -6;
    private int id;
    private String name;
    private Mapx data;
    private Node node;
    private Context context;

    protected WorkflowAction(int id, String name, Mapx data) {
        this.id = id;
        this.name = name;
        this.data = data;
    }

    public WorkflowAction(Node node) {
        if (!node.getType().equals("ActionNode")) {
            throw new RuntimeException("WorkflowAction\u5fc5\u987b\u662f\u52a8\u4f5c\u8282\u70b9!");
        }
        this.id = node.getID();
        this.name = node.getName();
        this.data = node.getData();
        this.node = node;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Mapx getData() {
        return this.data;
    }

    public void execute(Transaction tran, long instanceID, String memo) throws Exception {
        this.execute(tran, WorkflowUtil.findInstance((long)instanceID), memo);
    }

    public void execute(Transaction tran, long instanceID, String selectedUser, String memo) throws Exception {
        this.execute(tran, WorkflowUtil.findInstance((long)instanceID), selectedUser, memo);
    }

    public void execute(Context context, String selectedUser, String memo) throws Exception {
        this.execute(context.getTransaction(), context.getInstance(), context.getStep(), selectedUser, memo);
    }

    public void execute(Transaction tran, WorkflowInstance instance, String memo) throws Exception {
        this.execute(tran, instance, null, memo);
    }

    public void execute(Transaction tran, WorkflowInstance instance, String selectedUser, String memo) throws Exception {
        if (this.id == -5) {
            this.restartInstance(tran, instance, memo);
            return;
        }
        SCMS_StepSchema step = WorkflowUtil.findCurrentStep((long)instance.getID());
        this.execute(tran, instance, step, selectedUser, memo);
    }

    public void execute(Transaction tran, WorkflowInstance instance, SCMS_StepSchema step, String selectedUser, String memo) throws Exception {
        if (this.id == -5) {
            this.restartInstance(tran, instance, memo);
            return;
        }
        this.context = new Context(tran, instance, step);
        step.setMemo(memo);
        if (this.id == -1) {
            WorkflowUtil.findAdapter().onTemporarySave(this.context);
            this.context.save();
        } else {
            step.setState("Finish");
            step.setFinishTime(new Date());
            step.setOwner(User.getUserName());
            Workflow wf = WorkflowUtil.findWorkflow((long)this.context.getStep().getWorkflowID());
            WorkflowAction.executeMethod((Context)this.context, (Node)wf.findNode(step.getNodeID()), (String)"Post");
            if (!this.context.getInstance().getState().equals("Completed")) {
                WorkflowAction.executeMethod((Context)this.context, (Node)wf.findNode(this.id), (String)"Post");
            }
            WorkflowUtil.findAdapter().onActionExecute(this.context, this);
            this.context.save();
            if (!this.context.getInstance().getState().equals("Completed")) {
                this.tryCreateNextStep(selectedUser);
            }
        }
    }

    public void restartInstance(Transaction tran, WorkflowInstance instance, String memo) {
        instance.setState("Activated");
        tran.add((Schema)instance, 2);
        QueryBuilder qb = new QueryBuilder("update SCMS_Step set State=? where InstanceID=? and (State=? or State=?)");
        qb.add((Object)"Finish");
        qb.add(instance.getID());
        qb.add((Object)"Underway");
        qb.add((Object)"Unread");
        tran.add(qb);
        Workflow flow = WorkflowUtil.findWorkflow((long)instance.getWorkflowID());
        WorkflowStep newStep = new WorkflowStep();
        newStep.setID(NoUtil.getMaxID((String)"WorkflowStepID"));
        newStep.setWorkflowID(instance.getWorkflowID());
        newStep.setNodeID(flow.getStartNode().getID());
        newStep.setActionID(-5);
        newStep.setPreviousStepID((long)flow.getEndNode().getID());
        newStep.setInstanceID(instance.getID());
        newStep.setDataVersionID("0");
        newStep.setOwner(User.getUserName());
        newStep.setStartTime(new Date());
        newStep.setMemo("\u91cd\u65b0\u5f00\u59cb\u6d41\u7a0b");
        newStep.setOperators(User.getUserName());
        newStep.setState("Underway");
        newStep.setAddTime(new Date());
        newStep.setAddUser(User.getUserName());
        tran.add((Schema)newStep, 1);
        tran.commit();
        Context context = new Context(tran, instance, (SCMS_StepSchema)newStep);
        WorkflowUtil.findAdapter().onStepCreate(context);
        context.save();
    }

    private void tryCreateNextStep(String selectedUser) throws Exception {
        if (this.node == null) {
            throw new WorkflowException("\u4e0d\u6b63\u786e\u7684WorkflowAction\u5bf9\u8c61\uff0cnode\u672a\u7f6e\u503c");
        }
        WorkflowTransition[] wts = this.node.getTransitions();
        for (int i = 0; i < wts.length; ++i) {
            String[] users;
            WorkflowTransition wt = wts[i];
            if (!this.checkConditions(wt)) continue;
            if (!this.checkOtherLine(wt)) {
                this.context.getStep().setState("Wait");
                this.context.save();
                return;
            }
            if ("1".equals(this.node.getWorkflow().findNode(this.context.getStep().getNodeID()).getData().get((Object)"SignJointly"))) {
                QueryBuilder qb = new QueryBuilder("update SCMS_Step set State=? where InstanceID=? and State=?");
                qb.add((Object)"Finish");
                qb.add(this.context.getStep().getInstanceID());
                qb.add((Object)"Wait");
            }
            WorkflowStep newStep = new WorkflowStep();
            newStep.setID(NoUtil.getMaxID((String)"WorkflowStepID"));
            newStep.setWorkflowID(this.context.getInstance().getWorkflowID());
            newStep.setAllowOrgan(wt.getTargetNode().getData().getString((Object)"Organ"));
            newStep.setAllowRole(wt.getTargetNode().getData().getString((Object)"Role"));
            newStep.setAllowUser(wt.getTargetNode().getData().getString((Object)"User"));
            newStep.setNodeID(wt.getTargetNode().getID());
            newStep.setActionID(this.getID());
            newStep.setInstanceID(this.context.getInstance().getID());
            newStep.setPreviousStepID(this.context.getStep().getID());
            newStep.setStartTime(new Date());
            newStep.setOperators(User.getUserName());
            newStep.setState("Unread");
            newStep.setAddTime(new Date());
            newStep.setAddUser(User.getUserName());
            if ("1".equals(wt.getTargetNode().getData().get((Object)"SignJointly"))) {
                users = WorkflowUtil.getPrivUsers((SCMS_StepSchema)newStep);
                if (users == null || users.length == 0) {
                    throw new WorkflowException("\u6ca1\u6709\u53ef\u64cd\u4f5c\u6b65\u9aa4\u7684\u7528\u6237\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb!");
                }
                for (int j = 0; j < users.length; ++j) {
                    if (j == 0) {
                        newStep.setAllowUser(users[j]);
                        newStep.setAllowOrgan(null);
                        newStep.setAllowRole(null);
                        continue;
                    }
                    SCMS_StepSchema step = (SCMS_StepSchema)newStep.clone();
                    step.setAllowUser(users[j]);
                    step.setAllowOrgan(null);
                    step.setAllowRole(null);
                    step.setID(NoUtil.getMaxID((String)"WorkflowStepID"));
                    this.context.getTransaction().add((Schema)step, 1);
                }
            } else if (StringUtil.isNotEmpty((String)selectedUser)) {
                if (!StringUtil.checkID((String)selectedUser)) {
                    throw new RuntimeException("\u53ef\u80fd\u7684SQL\u6ce8\u5165\uff1a" + selectedUser);
                }
                newStep.setAllowUser(selectedUser);
                newStep.setAllowOrgan(null);
                newStep.setAllowRole(null);
            }
            if (wt.getTargetNode().getType().equals("StartNode")) {
                newStep.setAllowUser(this.context.getInstance().getAddUser());
                newStep.setState("Underway");
                newStep.setOwner(this.context.getStep().getOperators());
            }
            this.context = new Context(this.context.getTransaction(), this.context.getInstance(), (SCMS_StepSchema)newStep);
            if (!"EndNode".equalsIgnoreCase(wt.getTargetNode().getType())) {
                if ("1".equals(this.context.getWorkflow().getData().get((Object)"NotifyNextStep"))) {
                    users = WorkflowUtil.getPrivUsers((SCMS_StepSchema)newStep);
                    if (users == null || users.length == 0) {
                        throw new WorkflowException("\u6ca1\u6709\u53ef\u64cd\u4f5c\u6b65\u9aa4\u7684\u7528\u6237\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb!");
                    }
                    WorkflowUtil.findAdapter().notifyNextStep(this.context, users);
                } else if (!WorkflowUtil.hasPrivUser((SCMS_StepSchema)newStep)) {
                    throw new WorkflowException("\u6ca1\u6709\u53ef\u64cd\u4f5c\u6b65\u9aa4\u7684\u7528\u6237\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb!");
                }
            }
            WorkflowUtil.findAdapter().onStepCreate(this.context);
            WorkflowAction.executeMethod((Context)this.context, (Node)WorkflowUtil.findWorkflow((long)newStep.getWorkflowID()).findNode(newStep.getNodeID()), (String)"Pre");
            if (!this.context.getInstance().getState().equals("Completed")) {
                if ("EndNode".equalsIgnoreCase(wt.getTargetNode().getType())) {
                    newStep.setState("Finish");
                    newStep.setFinishTime(new Date());
                    newStep.setOwner(User.getUserName());
                    this.context.getInstance().setState("Completed");
                    this.context.getTransaction().add((Schema)this.context.getInstance(), 2);
                }
                this.context.getTransaction().add((Schema)newStep, 1);
                this.context.getTransaction().commit();
                this.context.getTransaction().clear();
            }
            this.context.save();
        }
    }

    public boolean checkConditions(WorkflowTransition wt) throws Exception {
        Object[] keyArray = wt.getData().keyArray();
        boolean flag = true;
        for (int i = 0; i < keyArray.length; ++i) {
            String key = (String)keyArray[i];
            String value = wt.getData().getString((Object)key);
            if ("Script".equalsIgnoreCase(key) && StringUtil.isNotEmpty((String)value)) {
                ConditionScript cs = new ConditionScript();
                cs.setScript(value);
                flag = cs.validate(this.context);
                continue;
            }
            if (!"Method".equalsIgnoreCase(key) || !StringUtil.isNotEmpty((String)value)) continue;
            Object o = Class.forName(value).newInstance();
            ConditionMethod cm = null;
            if (!(o instanceof ConditionMethod)) {
                throw new WorkflowException(value + "\u6ca1\u6709\u5b9e\u73b0ConditionMethod\u62bd\u8c61\u7c7b");
            }
            cm = (ConditionMethod)o;
            flag = cm.validate(this.context);
        }
        return flag;
    }

    private boolean checkOtherLine(WorkflowTransition wt) {
        QueryBuilder qb = new QueryBuilder("where InstanceID=? and ID<>? and (State=? or State=?)", this.context.getInstance().getID(), this.context.getStep().getID());
        qb.add((Object)"Underway");
        qb.add((Object)"Unread");
        SCMS_StepSet set = new SCMS_StepSchema().query(qb);
        for (int i = 0; i < set.size(); ++i) {
            int nodeID = set.get(i).getNodeID();
            if (!this.isLinked(nodeID, wt.getTargetNode().getID(), 1)) continue;
            return false;
        }
        return true;
    }

    private boolean isLinked(int src, int target, int level) {
        if (level > 50) {
            return false;
        }
        Workflow wf = WorkflowUtil.findWorkflow((long)this.context.getInstance().getWorkflowID());
        WorkflowTransition[] wts = wf.findNode(src).getTransitions();
        for (int j = 0; j < wts.length; ++j) {
            if (wts[j].getFromNode().getID() == wts[j].getTargetNode().getID()) continue;
            if (wts[j].getTargetNode().getID() == target) {
                return true;
            }
            if (!this.isLinked(wts[j].getTargetNode().getID(), target, level + 1)) continue;
            return true;
        }
        return false;
    }

    public static void executeMethod(Context context, Node node, String type) throws Exception {
        String method = node.getData().getString((Object)(type + "Action"));
        String script = node.getData().getString((Object)(type + "Script"));
        if (StringUtil.isNotEmpty((String)method)) {
            Object o = Class.forName(method).newInstance();
            NodeMethod nm = null;
            if (!(o instanceof NodeMethod)) {
                throw new WorkflowException(method + "\u6ca1\u6709\u5b9e\u73b0NodeMethod\u62bd\u8c61\u7c7b");
            }
            nm = (NodeMethod)o;
            nm.execute(context);
        }
        if (StringUtil.isNotEmpty((String)script)) {
            MethodScript sa = new MethodScript(script);
            sa.execute(context);
        }
    }

    public static WorkflowAction getTemporarySaveAction() {
        return new WorkflowAction(-1, "\u4fdd\u5b58", new Mapx());
    }

    public static WorkflowAction getRestartAction() {
        return new WorkflowAction(-5, "\u91cd\u65b0\u5904\u7406", new Mapx());
    }

    public static WorkflowAction getApplyAction(int nodeID) {
        Mapx map = new Mapx();
        map.put((Object)"NodeID", nodeID);
        return new WorkflowAction(-3, "\u7533\u8bf7\u5904\u7406", map);
    }
}

