/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.vms.business.workflow.core;

import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.vms.business.workflow.core.Context;
import com.sobey.bsp.vms.business.workflow.core.Node;
import com.sobey.bsp.vms.business.workflow.core.WorkflowException;
import com.sobey.bsp.vms.business.workflow.methods.ConditionMethod;
import com.sobey.bsp.vms.business.workflow.methods.ConditionScript;
import java.util.List;
import org.dom4j.Element;

public class WorkflowTransition {
    private Node node;
    private int id;
    private String name;
    private Mapx map;
    private Node targetNode;
    private String target;

    public WorkflowTransition(Node node, Element ele) {
        this.node = node;
        String strid = ele.attributeValue("id");
        this.id = Integer.parseInt(strid.substring(strid.lastIndexOf("e") + 1));
        this.name = ele.attributeValue("name");
        this.target = ele.attributeValue("target").substring(ele.attributeValue("target").lastIndexOf("e") + 1);
        List list = ele.elements("data");
        this.map = new Mapx();
        for (int i = 0; i < list.size(); ++i) {
            Element data = (Element)list.get(i);
            String k = data.attributeValue("type");
            String v = data.getText();
            this.map.put((Object)k, (Object)v);
        }
    }

    protected void init() {
        int targetID = Integer.parseInt(this.target);
        this.targetNode = this.node.getWorkflow().findNode(targetID);
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Mapx getData() {
        return this.map;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public Node getFromNode() {
        return this.node;
    }

    public boolean validate(Context context) throws Exception {
        Object[] keyArray = this.map.keyArray();
        boolean flag = true;
        for (int i = 0; i < keyArray.length; ++i) {
            String key = (String)keyArray[i];
            String value = this.map.getString((Object)key);
            if ("Script".equalsIgnoreCase(key) && StringUtil.isNotEmpty((String)value)) {
                ConditionScript cs = new ConditionScript();
                cs.setScript(value);
                flag = cs.validate(context);
                continue;
            }
            if (!"Method".equalsIgnoreCase(key) || !StringUtil.isNotEmpty((String)value)) continue;
            Object o = Class.forName(value).newInstance();
            ConditionMethod cm = null;
            if (!(o instanceof ConditionMethod)) {
                throw new WorkflowException(value + "\u6ca1\u6709\u5b9e\u73b0ConditionMethod\u62bd\u8c61\u7c7b");
            }
            cm = (ConditionMethod)o;
            flag = cm.validate(context);
        }
        return flag;
    }
}

