/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.vms.business.workflow.core;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_InstanceSchema;
import com.sobey.bsp.schema.SCMS_InstanceSet;
import com.sobey.bsp.schema.SCMS_StepSchema;
import com.sobey.bsp.schema.SCMS_StepSet;
import com.sobey.bsp.schema.SCMS_WorkflowSchema;
import com.sobey.bsp.vms.business.workflow.WorkflowAdapter;
import com.sobey.bsp.vms.business.workflow.core.Context;
import com.sobey.bsp.vms.business.workflow.core.Node;
import com.sobey.bsp.vms.business.workflow.core.Workflow;
import com.sobey.bsp.vms.business.workflow.core.WorkflowAction;
import com.sobey.bsp.vms.business.workflow.core.WorkflowException;
import com.sobey.bsp.vms.business.workflow.core.WorkflowInstance;
import com.sobey.bsp.vms.business.workflow.core.WorkflowStep;
import com.sobey.bsp.vms.business.workflow.core.WorkflowTransition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkflowUtil {
    private static Mapx WorkflowMap = new Mapx();
    private static Object mutex = new Object();
    private static WorkflowAdapter adapter;
    public static int workflowtype;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workflow findWorkflow(long workflowID) {
        Long key = new Long(workflowID);
        if (WorkflowMap.containsKey((Object)key)) {
            return (Workflow)WorkflowMap.get((Object)key);
        }
        Workflow wf = new Workflow();
        wf.setID(workflowID);
        if (!wf.fill()) {
            return null;
        }
        wf.init();
        Object object = mutex;
        synchronized (object) {
            WorkflowMap.put((Object)key, (Object)wf);
        }
        return wf;
    }

    public static Context createInstance(Transaction tran, long workflowID, String name, String dataID, String dataVersionID) throws Exception {
        WorkflowInstance instance = new WorkflowInstance();
        instance.setWorkflowID(workflowID);
        instance.setAddTime(new Date());
        instance.setAddUser(User.getUserName());
        instance.setDataID(dataID);
        instance.setName(name);
        instance.setState("Activated");
        instance.setID(NoUtil.getMaxID((String)"WorkflowInstanceID"));
        tran.add((Schema)instance, 1);
        SCMS_StepSchema newStep = new SCMS_StepSchema();
        newStep.setID(NoUtil.getMaxID((String)"WorkflowStepID"));
        newStep.setWorkflowID(instance.getWorkflowID());
        newStep.setNodeID(WorkflowUtil.findWorkflow((long)instance.getWorkflowID()).getStartNode().getID());
        newStep.setActionID(-2);
        newStep.setPreviousStepID(-1L);
        newStep.setInstanceID(instance.getID());
        newStep.setDataVersionID(dataVersionID);
        newStep.setOwner(User.getUserName());
        newStep.setStartTime(new Date());
        newStep.setMemo("");
        newStep.setOperators(User.getUserName());
        newStep.setState("Underway");
        newStep.setAddTime(new Date());
        newStep.setAddUser(User.getUserName());
        tran.add((Schema)newStep, 1);
        Context context = new Context(tran, instance, newStep);
        WorkflowUtil.findAdapter().onStepCreate(context);
        WorkflowAction.executeMethod((Context)context, (Node)WorkflowUtil.findWorkflow((long)instance.getWorkflowID()).getStartNode(), (String)"Post");
        return context;
    }

    public static WorkflowInstance findInstance(long workflowID, String dataID) throws WorkflowException {
        SCMS_InstanceSchema wi = new SCMS_InstanceSchema();
        wi.setWorkflowID(workflowID);
        wi.setDataID(dataID);
        SCMS_InstanceSet set = wi.query();
        if (set.size() == 0) {
            throw new WorkflowException("\u672a\u80fd\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u5b9e\u4f8b\uff1aWorkflowID=" + workflowID + ",DataID=" + dataID);
        }
        if (set.size() > 1) {
            throw new WorkflowException("\u627e\u5230\u7684\u5de5\u4f5c\u6d41\u5b9e\u4f8b\u4e2a\u6570\u5927\u4e8e\u4e00\uff1aWorkflowID=" + workflowID + ",DataID=" + dataID);
        }
        wi = set.get(0);
        WorkflowInstance wfi = new WorkflowInstance();
        for (int i = 0; i < wfi.getColumnCount(); ++i) {
            wfi.setV(i, wi.getV(i));
        }
        return wfi;
    }

    public static WorkflowInstance findInstance(long instanceID) throws WorkflowException {
        SCMS_InstanceSchema wi = new SCMS_InstanceSchema();
        wi.setID(instanceID);
        if (!wi.fill()) {
            throw new WorkflowException("\u672a\u80fd\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u5b9e\u4f8b\uff1aID=" + instanceID);
        }
        WorkflowInstance wfi = new WorkflowInstance();
        for (int i = 0; i < wfi.getColumnCount(); ++i) {
            wfi.setV(i, wi.getV(i));
        }
        return wfi;
    }

    public static WorkflowStep findStep(long stepID) throws WorkflowException {
        SCMS_StepSchema step = new SCMS_StepSchema();
        step.setID(stepID);
        if (!step.fill()) {
            throw new WorkflowException("\u672a\u80fd\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u6b65\u9aa4\uff1aID=" + stepID);
        }
        WorkflowStep wfs = new WorkflowStep();
        for (int i = 0; i < wfs.getColumnCount(); ++i) {
            wfs.setV(i, step.getV(i));
        }
        return wfs;
    }

    public static SCMS_StepSchema findCurrentStep(long instanceID) throws WorkflowException {
        SCMS_StepSchema step;
        int i;
        QueryBuilder qb = new QueryBuilder("where InstanceID=? and (State=? or State=?)", instanceID, (Object)"Underway");
        qb.add((Object)"Unread");
        SCMS_StepSet set = new WorkflowStep().query(qb);
        for (i = 0; i < set.size(); ++i) {
            step = set.get(i);
            if (!step.getState().equals("Underway") || !step.getOwner().equals(User.getUserName())) continue;
            return step;
        }
        for (i = 0; i < set.size(); ++i) {
            step = set.get(i);
            if (!step.getState().equals("Unread") || !WorkflowUtil.hasPriv((String)step.getAllowOrgan(), (String)step.getAllowRole(), (String)step.getAllowUser()) || !"1".equals(WorkflowUtil.findWorkflow((long)step.getWorkflowID()).getData().get((Object)"NotNeedApply"))) continue;
            return step;
        }
        throw new WorkflowException("\u672a\u80fd\u627e\u5230\u5f53\u524d\u6b65\u9aa4,\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
    }

    public static WorkflowAction[] findInitActions(long workflowID) throws Exception {
        Workflow wf = WorkflowUtil.findWorkflow((long)workflowID);
        Node[] nodes = wf.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].getType().equals("StartNode")) continue;
            ArrayList<WorkflowAction> list = new ArrayList<WorkflowAction>(4);
            list.add(WorkflowAction.getTemporarySaveAction());
            Context ctx = new Context(workflowID);
            WorkflowTransition[] tss = nodes[i].getTransitions();
            for (int j = 0; j < tss.length; ++j) {
                if (!tss[j].validate(ctx)) continue;
                list.add(new WorkflowAction(tss[j].getTargetNode()));
            }
            WorkflowAction[] actions = new WorkflowAction[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                actions[j] = (WorkflowAction)list.get(j);
            }
            return actions;
        }
        return null;
    }

    public static WorkflowAction[] findAvaiableActions(long instanceID) throws Exception {
        WorkflowInstance instance = WorkflowUtil.findInstance((long)instanceID);
        return WorkflowUtil.findAvaiableActions((WorkflowInstance)instance);
    }

    public static WorkflowAction[] findAvaiableActions(WorkflowInstance instance) throws Exception {
        int j;
        WorkflowTransition[] tss;
        Node node;
        Context ctx;
        Transaction tran;
        int i;
        if (instance.getState().equals("Completed")) {
            return new WorkflowAction[0];
        }
        SCMS_StepSchema step = new SCMS_StepSchema();
        QueryBuilder qb = new QueryBuilder("where InstanceID=? and (State=? or State=?)");
        qb.add(instance.getID());
        qb.add((Object)"Underway");
        qb.add((Object)"Unread");
        SCMS_StepSet set = step.query(qb);
        ArrayList<WorkflowAction> list = new ArrayList<WorkflowAction>(4);
        Workflow flow = WorkflowUtil.findWorkflow((long)instance.getWorkflowID());
        boolean underwayFlag = false;
        for (i = 0; i < set.size(); ++i) {
            step = set.get(i);
            tran = new Transaction();
            ctx = new Context(tran, step);
            if (step.getOwner() == null || !step.getOwner().equals(User.getUserName())) continue;
            node = flow.findNode(step.getNodeID());
            list.add(WorkflowAction.getTemporarySaveAction());
            tss = node.getTransitions();
            for (j = 0; j < tss.length; ++j) {
                if (!tss[j].validate(ctx)) continue;
                list.add(new WorkflowAction(tss[j].getTargetNode()));
            }
            underwayFlag = true;
            break;
        }
        if (!underwayFlag) {
            for (i = 0; i < set.size(); ++i) {
                step = set.get(i);
                if (!step.getState().equals("Unread") || !WorkflowUtil.hasPriv((String)step.getAllowOrgan(), (String)step.getAllowRole(), (String)step.getAllowUser())) continue;
                if (!"1".equals(flow.getData().get((Object)"NotNeedApply"))) {
                    list.add(WorkflowAction.getApplyAction((int)step.getNodeID()));
                    continue;
                }
                tran = new Transaction();
                ctx = new Context(tran, step);
                node = flow.findNode(step.getNodeID());
                list.add(WorkflowAction.getTemporarySaveAction());
                tss = node.getTransitions();
                for (j = 0; j < tss.length; ++j) {
                    if (!tss[j].validate(ctx)) continue;
                    list.add(new WorkflowAction(tss[j].getTargetNode()));
                }
                underwayFlag = true;
            }
        }
        for (i = list.size() - 1; i >= 0; --i) {
            WorkflowAction a1 = (WorkflowAction)list.get(i);
            for (int j2 = i - 1; j2 >= 0; --j2) {
                WorkflowAction a2 = (WorkflowAction)list.get(j2);
                if (a1.getID() != a2.getID()) continue;
                list.remove(i);
            }
        }
        WorkflowAction[] actions = new WorkflowAction[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            actions[i2] = (WorkflowAction)list.get(i2);
        }
        return actions;
    }

    public static SCMS_StepSchema findUnreadStep(long instanceID, int nodeID) throws WorkflowException {
        SCMS_StepSchema step = new SCMS_StepSchema();
        step.setInstanceID(instanceID);
        step.setNodeID(nodeID);
        step.setState("Unread");
        SCMS_StepSet set = step.query();
        if (set.size() > 0) {
            step = set.get(0);
            return step;
        }
        throw new WorkflowException("\u627e\u4e0d\u5230\u53ef\u4ee5\u7533\u8bf7\u7684\u6b65\u9aa4!");
    }

    public static void applyStep(long instanceID, int nodeID) throws Exception {
        SCMS_StepSchema step = WorkflowUtil.findUnreadStep((long)instanceID, (int)nodeID);
        if (!WorkflowUtil.hasPriv((String)step.getAllowOrgan(), (String)step.getAllowRole(), (String)step.getAllowUser())) {
            throw new WorkflowException("\u7528\u6237\u6ca1\u6709\u7533\u8bf7\u6d41\u7a0b\u6b65\u9aa4");
        }
        QueryBuilder qb = new QueryBuilder("update SCMS_Step set State=?,Owner=? where State=? and InstanceID=? and NodeID=? and ID=?");
        qb.add((Object)"Underway");
        qb.add((Object)User.getUserName());
        qb.add((Object)"Unread");
        qb.add(instanceID);
        qb.add(nodeID);
        qb.add(step.getID());
        if (qb.executeNoQuery() == 0) {
            throw new WorkflowException("\u7533\u8bf7\u5931\u8d25\uff0c\u53ef\u80fd\u5df1\u88ab\u522b\u7684\u7528\u6237\u7533\u8bf7!");
        }
    }

    public static void forceEnd(long instanceID, int nodeID) throws Exception {
        Transaction tran = new Transaction();
        WorkflowUtil.forceEnd((Transaction)tran, (long)instanceID, (int)nodeID);
        if (!tran.commit()) {
            throw new WorkflowException(tran.getExceptionMessage());
        }
    }

    public static void forceEnd(Transaction tran, long instanceID, int nodeID) throws Exception {
        if (!"admin".equals(User.getUserName())) {
            throw new WorkflowException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5f3a\u5236\u7ed3\u675f\u6d41\u7a0b\u7684\u6743\u9650!");
        }
        WorkflowInstance instance = WorkflowUtil.findInstance((long)instanceID);
        Workflow flow = WorkflowUtil.findWorkflow((long)instance.getWorkflowID());
        if (flow == null) {
            LogUtil.warn((Object)("\u5f3a\u5236\u7ed3\u675f\u6d41\u7a0b\u65f6\u53d1\u73b0ID\u4e3a" + instance.getWorkflowID() + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728!"));
        } else {
            SCMS_StepSchema newStep = new SCMS_StepSchema();
            newStep.setID(NoUtil.getMaxID((String)"WorkflowStepID"));
            newStep.setWorkflowID(instance.getWorkflowID());
            newStep.setNodeID(flow.getEndNode().getID());
            newStep.setActionID(-6);
            newStep.setPreviousStepID(0L);
            newStep.setInstanceID(instance.getID());
            newStep.setDataVersionID("0");
            newStep.setOwner(User.getUserName());
            newStep.setStartTime(new Date());
            newStep.setMemo("\u5f3a\u5236\u7ed3\u675f\u6d41\u7a0b");
            newStep.setOperators(User.getUserName());
            newStep.setState("Finish");
            newStep.setAddTime(new Date());
            newStep.setAddUser(User.getUserName());
            tran.add((Schema)newStep, 1);
            Context context = new Context(tran, instance, newStep);
            WorkflowUtil.findAdapter().onStepCreate(context);
            WorkflowAction.executeMethod((Context)context, (Node)WorkflowUtil.findWorkflow((long)instance.getWorkflowID()).getEndNode(), (String)"Pre");
        }
        instance.setState("Completed");
        tran.add((Schema)instance, 2);
        tran.add(new QueryBuilder("update SCMS_Step set State=? where InstanceID=?", (Object)"Finish", instanceID));
    }

    public static boolean hasPriv(String[] branchInnerCodes, String[] roleCodes, String[] userNames) {
        int i;
        if (userNames != null) {
            for (int i2 = 0; i2 < userNames.length; ++i2) {
                if (!userNames[i2].equals(User.getUserName())) continue;
                return true;
            }
        }
        boolean flag = false;
        if (branchInnerCodes != null) {
            String innerCode = User.getBranchInnerCode();
            if (StringUtil.isNotEmpty((String)innerCode)) {
                for (i = 0; i < branchInnerCodes.length; ++i) {
                    if (!innerCode.equals(branchInnerCodes[i])) continue;
                    flag = true;
                    break;
                }
            }
        } else {
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (roleCodes != null) {
            List list = PubFun.getRoleCodesByUserName((String)User.getUserName());
            for (i = 0; i < roleCodes.length; ++i) {
                if (!list.contains(roleCodes[i])) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean hasPriv(String branchInnerCodes, String roleCodes, String userNames) {
        String[] p1 = null;
        String[] p2 = null;
        String[] p3 = null;
        if (StringUtil.isNotEmpty((String)branchInnerCodes)) {
            p1 = StringUtil.splitEx((String)branchInnerCodes, (String)",");
        }
        if (StringUtil.isNotEmpty((String)roleCodes)) {
            p2 = StringUtil.splitEx((String)roleCodes, (String)",");
        }
        if (StringUtil.isNotEmpty((String)userNames)) {
            p3 = StringUtil.splitEx((String)userNames, (String)",");
        }
        return WorkflowUtil.hasPriv((String[])p1, (String[])p2, (String[])p3);
    }

    public static WorkflowAction findAction(long workflowID, int actionID) {
        Workflow wf = WorkflowUtil.findWorkflow((long)workflowID);
        if (actionID == -1) {
            return WorkflowAction.getTemporarySaveAction();
        }
        if (actionID == -5) {
            return WorkflowAction.getRestartAction();
        }
        if (actionID == -2) {
            return new WorkflowAction(actionID, "\u5f00\u59cb\u6d41\u8f6c", new Mapx());
        }
        if (actionID == -4) {
            return new WorkflowAction(actionID, "\u811a\u672c\u8df3\u8f6c", new Mapx());
        }
        if (actionID == -6) {
            return new WorkflowAction(actionID, "\u5f3a\u5236\u7ed3\u675f", new Mapx());
        }
        Node node = wf.findNode(actionID);
        if (node.getType().equals("ActionNode")) {
            return new WorkflowAction(node);
        }
        return null;
    }

    public static WorkflowAdapter findAdapter() {
        String className = "com.sobey.bsp.vms.business.workflow.VMSWorkflowAdapter";
        if (workflowtype == 2) {
            className = "com.sobey.bsp.vms.business.workflow.AudioWorkflowAdapter";
        }
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("\u672a\u5b9a\u4e49\u5de5\u4f5c\u6d41\u9002\u914d\u5668!");
        }
        try {
            Class<?> c = Class.forName(className);
            if (!WorkflowAdapter.class.isAssignableFrom(c)) {
                throw new RuntimeException("\u7c7b" + className + "\u672a\u7ee7\u627fWorkflowAdapter!");
            }
            adapter = (WorkflowAdapter)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return adapter;
    }

    public static Mapx getDataVariables(String dataID, String dataVersionID) {
        return WorkflowUtil.findAdapter().getVariables(dataID, dataVersionID);
    }

    public static boolean saveDataVariables(Context context) {
        return WorkflowUtil.findAdapter().saveVariables(context);
    }

    public static String getStepName(long workflowID, int nodeID) {
        Workflow flow = WorkflowUtil.findWorkflow((long)workflowID);
        if (flow == null) {
            return "\u672a\u627e\u5230\u5de5\u4f5c\u6d41";
        }
        Node node = flow.findNode(nodeID);
        if (node == null) {
            return "\u672a\u627e\u5230\u6b65\u9aa4";
        }
        return node.getName();
    }

    public static String getActionNodeName(long workflowID, int actionID) {
        return WorkflowUtil.findAction((long)workflowID, (int)actionID).getName();
    }

    public static void deleteInstance(Transaction tran, long instanceID) {
        SCMS_InstanceSet iset = new SCMS_InstanceSchema().query(new QueryBuilder("where ID=?", instanceID));
        SCMS_StepSet sset = new SCMS_StepSchema().query(new QueryBuilder("where InstanceID=?", instanceID));
        tran.add((SchemaSet)iset, 5);
        tran.add((SchemaSet)sset, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCache(SCMS_WorkflowSchema schema) {
        Object object = mutex;
        synchronized (object) {
            WorkflowMap.put((Object)new Long(schema.getID()), (Object)Workflow.convert((SCMS_WorkflowSchema)schema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCache(SCMS_WorkflowSchema schema) {
        Object object = mutex;
        synchronized (object) {
            WorkflowMap.remove((Object)new Long(schema.getID()));
        }
    }

    private static boolean checkPrivString(String str) {
        if (str.indexOf(39) > 0 || str.indexOf(34) > 0) {
            return false;
        }
        return str.indexOf(40) <= 0 && str.indexOf(41) <= 0;
    }

    public static boolean hasPrivUser(SCMS_StepSchema step) throws WorkflowException {
        if (StringUtil.isNotEmpty((String)step.getAllowUser())) {
            return true;
        }
        QueryBuilder qb = new QueryBuilder("select count(1) from SCMS_User where 1=1");
        if (StringUtil.isNotEmpty((String)step.getAllowOrgan())) {
            if (!WorkflowUtil.checkPrivString((String)step.getAllowOrgan())) {
                throw new WorkflowException("AllowOrgan\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26,StepID=" + step.getID());
            }
            qb.appendSQLPart(" and BranchInnerCode in ('" + step.getAllowOrgan().replaceAll(",", "','") + "')");
        }
        if (StringUtil.isNotEmpty((String)step.getAllowRole())) {
            if (!WorkflowUtil.checkPrivString((String)step.getAllowRole())) {
                throw new WorkflowException("AllowRole\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26,StepID=" + step.getID());
            }
            qb.appendSQLPart(" and exists (select 1 from SCMS_UserRole where UserName=SCMS_User.UserName and RoleCode in ('" + step.getAllowRole().replaceAll(",", "','") + "'))");
        }
        if (StringUtil.isNotEmpty((String)step.getAllowOrgan()) || StringUtil.isNotEmpty((String)step.getAllowRole())) {
            return qb.executeInt() > 0;
        }
        return false;
    }

    public static String[] getPrivUsers(SCMS_StepSchema step) throws WorkflowException {
        QueryBuilder qb = WorkflowUtil.getPrivUserQueryBuilder((SCMS_StepSchema)step);
        DataTable dt = qb.executeDataTable();
        String[] arr = new String[dt.getRowCount()];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            arr[i] = dt.getString(i, "UserName");
        }
        return arr;
    }

    public static QueryBuilder getPrivUserQueryBuilder(SCMS_StepSchema step) throws WorkflowException {
        QueryBuilder qb = new QueryBuilder("select * from SCMS_User where ");
        if (StringUtil.isNotEmpty((String)step.getAllowOrgan())) {
            if (!WorkflowUtil.checkPrivString((String)step.getAllowOrgan())) {
                throw new WorkflowException("AllowOrgan\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26,StepID=" + step.getID());
            }
            qb.appendSQLPart(" (BranchInnerCode in ('" + step.getAllowOrgan().replaceAll(",", "','") + "')");
        }
        if (StringUtil.isNotEmpty((String)step.getAllowRole())) {
            if (!WorkflowUtil.checkPrivString((String)step.getAllowRole())) {
                throw new WorkflowException("AllowRole\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26,StepID=" + step.getID());
            }
            if (StringUtil.isEmpty((String)step.getAllowOrgan())) {
                qb.appendSQLPart("(");
            } else {
                qb.appendSQLPart(" and ");
            }
            qb.appendSQLPart(" exists (select 1 from SCMS_UserRole where UserName=SCMS_User.UserName and RoleCode in ('" + step.getAllowRole().replaceAll(",", "','") + "'))");
        }
        if (StringUtil.isNotEmpty((String)step.getAllowRole()) || StringUtil.isNotEmpty((String)step.getAllowOrgan())) {
            qb.appendSQLPart(")");
        } else {
            qb.appendSQLPart(" 1=2 ");
        }
        if (StringUtil.isNotEmpty((String)step.getAllowUser())) {
            qb.appendSQLPart(" or UserName in (");
            if (WorkflowUtil.checkPrivString((String)step.getAllowUser())) {
                String[] p1 = step.getAllowUser().split(",");
                for (int i = 0; i < p1.length; i += 2) {
                    if (i != 0) {
                        qb.appendSQLPart(",");
                    }
                    qb.appendSQLPart("'" + p1[i] + "'");
                }
            }
            qb.appendSQLPart(")");
        }
        return qb;
    }

    public static boolean isStartStep(long instanceID) {
        QueryBuilder qb = new QueryBuilder("where InstanceID=? and (State=? or State=?)", instanceID);
        qb.add((Object)"Underway");
        qb.add((Object)"Unread");
        SCMS_StepSet set = new SCMS_StepSchema().query(qb);
        for (int i = 0; i < set.size(); ++i) {
            Workflow wf = WorkflowUtil.findWorkflow((long)set.get(i).getWorkflowID());
            if (wf.getStartNode().getID() != set.get(i).getNodeID()) continue;
            return true;
        }
        return false;
    }

    static {
        workflowtype = 0;
    }
}

