/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.vms.business.workflow.mvc;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataCollection;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_StepSchema;
import com.sobey.bsp.schema.SCMS_WorkflowSchema;
import com.sobey.bsp.schema.SCMS_WorkflowSet;
import com.sobey.bsp.vms.business.workflow.core.Context;
import com.sobey.bsp.vms.business.workflow.core.Node;
import com.sobey.bsp.vms.business.workflow.core.WorkflowException;
import com.sobey.bsp.vms.business.workflow.core.WorkflowInstance;
import com.sobey.bsp.vms.business.workflow.core.WorkflowTransition;
import com.sobey.bsp.vms.business.workflow.core.WorkflowUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class WorkflowPage
extends Page {
    public static Mapx init(Mapx params) {
        String id = params.getString((Object)"ID");
        if (StringUtil.isNotEmpty((String)id)) {
            SCMS_WorkflowSchema fc = new SCMS_WorkflowSchema();
            fc.setID(id);
            fc.fill();
            params.put((Object)"Name", (Object)fc.getName());
            params.put((Object)"ID", fc.getID());
            params.put((Object)"Memo", (Object)fc.getMemo());
            params.put((Object)"XML", (Object)StringUtil.javaEncode((String)fc.getConfigXML()));
        }
        return params;
    }

    public static void roleDataBind(DataGridAction dga) {
        long siteid = Application.getCurrentSiteID();
        DataTable dt = new QueryBuilder("select RoleCode,RoleName from SCMS_Role where siteid='" + siteid + "'").executeDataTable();
        dga.dataTable2JSON(dt);
    }

    public static void userDataBind(DataGridAction dga) {
        long workflowID = dga.getParams().getLong((Object)"WorkflowID");
        int actionID = dga.getParams().getInt((Object)"ActionID");
        long instanceID = dga.getParams().getLong((Object)"InstanceID");
        Transaction tran = new Transaction();
        SCMS_StepSchema step = new SCMS_StepSchema();
        WorkflowInstance instance = new WorkflowInstance();
        if (instanceID != 0L) {
            try {
                instance = WorkflowUtil.findInstance((long)instanceID);
            }
            catch (WorkflowException e) {
                e.printStackTrace();
            }
            try {
                step = WorkflowUtil.findCurrentStep((long)instanceID);
            }
            catch (WorkflowException e) {
                e.printStackTrace();
            }
        } else {
            step.setOwner(User.getUserName());
            step.setAllowUser(User.getUserName());
            instance.setDataID("0");
            step.setDataVersionID("0");
        }
        Context context = new Context(tran, instance, step);
        WorkflowTransition[] wts = WorkflowUtil.findWorkflow((long)workflowID).findNode(actionID).getTransitions();
        QueryBuilder qb = null;
        int i = 0;
        while (i < wts.length) {
            try {
                if (!wts[i].validate(context)) continue;
                Node node = wts[i].getTargetNode();
                Mapx map = node.getData();
                step.setAllowUser(map.getString((Object)"User"));
                step.setAllowOrgan(map.getString((Object)"Organ"));
                step.setAllowRole(map.getString((Object)"Role"));
                try {
                    qb = WorkflowUtil.getPrivUserQueryBuilder((SCMS_StepSchema)step);
                }
                catch (WorkflowException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ++i;
            }
        }
        if (StringUtil.isNotEmpty((String)dga.getParam("SearchUserName"))) {
            qb.appendSQLPart(" and UserName like %" + dga.getParam("SearchUserName") + "%");
        }
        qb.appendSQLPart(" order by AddTime desc,UserName");
        dga.setTotal(qb);
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        dt.decodeColumn("BranchInnerCode", (Map)new QueryBuilder("select BranchInnerCode,Name from ZDBranch").executeDataTable().toMapx(0, 1));
        dt.insertColumn("RoleNames");
        for (int i2 = 0; i2 < dt.getRowCount(); ++i2) {
            dt.set(i2, "RoleNames", (Object)PubFun.getRoleNames((List)PubFun.getRoleCodesByUserName((String)dt.getString(i2, "UserName"))));
        }
        dga.bindData(dt);
    }

    public void save() {
        SCMS_WorkflowSchema wd = new SCMS_WorkflowSchema();
        if (StringUtil.isNotEmpty((String)this.$V("ID"))) {
            wd.setID(this.$V("ID"));
            wd.fill();
        } else {
            wd.setID(NoUtil.getMaxID((String)"WorkflowID"));
            wd.setAddTime(new Date());
            wd.setAddUser(User.getUserName());
        }
        wd.setModifyTime(new Date());
        wd.setModifyUser(User.getUserName());
        wd.setName(this.$V("Name"));
        wd.setConfigXML(StringUtil.htmlDecode((String)this.$V("XML")));
        wd.setMemo(this.$V("Memo"));
        this.Response.put("ID", wd.getID());
        boolean flag = true;
        if (StringUtil.isNotEmpty((String)this.$V("ID"))) {
            flag = wd.update();
        } else {
            int count = new QueryBuilder("SELECT COUNT(*) FROM SCMS_WORKFLOW WHERE NAME='" + this.$V("Name") + "'").executeInt();
            if (count > 0) {
                this.Response.setMessage("\u4fdd\u5b58\u5931\u8d25\uff0c\u5de5\u4f5c\u6d41\u5df2\u7ecf\u5b58\u5728!");
                this.Response.setStatus(0);
                return;
            }
            flag = wd.insert();
        }
        if (flag) {
            WorkflowUtil.updateCache((SCMS_WorkflowSchema)wd);
            this.Response.setMessage("\u4fdd\u5b58\u6210\u529f!");
            this.Response.setStatus(1);
        } else {
            this.Response.setError("\u4fdd\u5b58\u6570\u636e\u5230\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }

    public static void dg1DataBind(DataGridAction dga) {
        String name = dga.getParam("SearchName");
        String searchDate = dga.getParam("SearchDate");
        StringBuffer conditions = new StringBuffer();
        if (StringUtil.isNotEmpty((String)name)) {
            conditions.append(" AND NAME LIKE '%" + name.trim() + "%' ");
        }
        if (StringUtil.isNotEmpty((String)searchDate)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDate);
            if (day == 0) {
                conditions.append(" AND ADDTIME like '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                conditions.append(" AND ADDTIME like '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                conditions.append(" AND ADDTIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                conditions.append(" AND ADDTIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                conditions.append(" AND ADDTIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                conditions.append(" AND ADDTIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        String sql = " select ID,Name,Prop1,Prop2,Prop3,Prop4,Memo,AddTime,AddUser,ModifyTime,ModifyUser,'' as status,'' as statusName from SCMS_Workflow where 1=1 " + conditions.toString();
        String countsql = " select count(*) from SCMS_Workflow where 1=1 " + conditions.toString();
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        dga.setTotal(new QueryBuilder(countsql));
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String status = dt.getString(i, "Prop1");
            if ("1".equals(status)) {
                dt.set(i, "status", (Object)"1");
                dt.set(i, "statusName", (Object)"\u505c\u7528");
                continue;
            }
            dt.set(i, "status", (Object)"0");
            dt.set(i, "statusName", (Object)"\u5f00\u542f");
        }
        dga.dataTable2JSON(dt);
    }

    public void startWorkflow() {
        String id = this.$V("id");
        String status = this.$V("status");
        String sql = "update scms_workflow set prop1='" + status + "' where id='" + id + "'";
        int count = new QueryBuilder(sql).executeNoQuery();
        if ("1".equals(status)) {
            new QueryBuilder("update scms_site set workflowid=" + id).executeNoQuery();
            Application.setCurrentWorkflowID((String)id);
            new QueryBuilder("update scms_workflow set prop1='0' where id<>'" + id + "'").executeNoQuery();
        } else {
            new QueryBuilder("update scms_site set workflowid=0").executeNoQuery();
            Application.setCurrentWorkflowID((String)"0");
        }
        SiteUtil.update((long)Application.getCurrentSiteID());
        if (count > 0) {
            this.Response.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        } else {
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }

    public void del() {
        int i;
        String IDs = this.$V("IDs");
        if (!StringUtil.checkID((String)IDs)) {
            this.Response.setLogInfo(0, "\u4f20\u5165\u5de5\u4f5c\u6d41\u53d1\u751f\u9519\u8bef!");
            return;
        }
        SCMS_WorkflowSchema wf = new SCMS_WorkflowSchema();
        SCMS_WorkflowSet set = wf.query(new QueryBuilder("where ID in (" + IDs + ")"));
        Transaction tran = new Transaction();
        for (i = 0; i < set.size(); ++i) {
            WorkflowUtil.findAdapter().onWorkflowDelete(tran, set.get(i).getID());
        }
        tran.add(new QueryBuilder("delete from scms_instance where WorkflowID in (" + IDs + ")"));
        tran.add(new QueryBuilder("delete from SCMS_Step where WorkflowID in (" + IDs + ")"));
        tran.add((SchemaSet)set, 3);
        if (tran.commit()) {
            for (i = 0; i < set.size(); ++i) {
                WorkflowUtil.deleteCache((SCMS_WorkflowSchema)set.get(i));
            }
            this.Response.setLogInfo(1, "\u5220\u9664\u6210\u529f\uff01");
        } else {
            this.Response.setLogInfo(0, "\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    public void addSimilar() {
        String IDs = this.$V("IDs");
        if (!StringUtil.checkID((String)IDs)) {
            this.Response.setLogInfo(0, "\u4f20\u5165\u5de5\u4f5c\u6d41\u53d1\u751f\u9519\u8bef!");
            return;
        }
        SCMS_WorkflowSchema wf = new SCMS_WorkflowSchema();
        wf.setID(IDs);
        wf.fill();
        wf.setValue((DataCollection)this.Request);
        wf.setID(NoUtil.getMaxID((String)"WorkflowID"));
        Transaction trans = new Transaction();
        trans.add((Schema)wf, 1);
        if (trans.commit()) {
            this.Response.setLogInfo(1, "\u65b0\u5efa\u6210\u529f\uff01");
        } else {
            this.Response.setLogInfo(0, "\u65b0\u5efa\u5931\u8d25\uff01");
        }
    }
}

