/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.zas.client;

import com.sobey.bsp.zas.ClientConfig;
import com.sobey.bsp.zas.UserData;
import com.sobey.bsp.zas.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.servlet.ServletException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceTicketValidator {
    protected String ticket;
    protected String response;
    protected UserData user;
    protected String pgt;
    protected static String cn;
    protected static PublicKey pk;
    protected static Cipher encryptCipher;
    protected static Cipher decryptCipher;

    public UserData getUser() {
        return this.user;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public void validate() throws ServletException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(ClientConfig.getServerURL() + "ServiceValidate.jsp");
        sb.append("?");
        sb.append("ServiceID=" + ClientConfig.getServiceID() + "&ST=" + this.ticket);
        if (ClientConfig.isNeedNewLogin()) {
            sb.append("&NeedNewLogin=true");
        }
        this.response = Util.getURLContent((String)sb.toString());
        this.parseResponse();
    }

    protected static void initCert() {
        try {
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            String password = ClientConfig.getPassword();
            byte[] bs = Util.base64Decode((String)password.replaceAll("\\s*", ""));
            ByteArrayInputStream fin = new ByteArrayInputStream(bs);
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(fin);
            fin.close();
            String dn = cert.getIssuerDN().getName();
            int index1 = dn.indexOf("CN=") + 3;
            int index2 = dn.indexOf(",", index1);
            if (index2 < 0) {
                index2 = dn.length();
            }
            cn = dn.substring(index1, index2);
            pk = cert.getPublicKey();
            encryptCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            encryptCipher.init(1, pk);
            decryptCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            decryptCipher.init(2, pk);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316Proxy\u8bc1\u4e66\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }

    public static String encrypt(String str) throws ServletException {
        if (cn == null) {
            ServiceTicketValidator.initCert();
        }
        try {
            byte[] code = null;
            try {
                byte[] bs = str.getBytes("UTF-8");
                code = new byte[((bs.length - 1) / 117 + 1) * 128];
                int indexBS = 0;
                int indexCode = 0;
                while (bs.length - indexBS > 117) {
                    indexCode += encryptCipher.doFinal(bs, indexBS, 117, code, indexCode);
                    indexBS += 117;
                }
                encryptCipher.doFinal(bs, indexBS, bs.length - indexBS, code, indexCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Util.base64Encode((byte[])code);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("\u52a0\u5bc6\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }

    public static String decrypt(String str) throws ServletException {
        if (cn == null) {
            ServiceTicketValidator.initCert();
        }
        try {
            byte[] code = Util.base64Decode((String)str);
            byte[] bs = new byte[code.length];
            int indexBS = 0;
            int indexCode = 0;
            while (code.length - indexCode > 128) {
                indexBS += decryptCipher.doFinal(code, indexCode, 128, bs, indexBS);
                indexCode += 128;
            }
            indexBS += decryptCipher.doFinal(code, indexCode, code.length - indexCode, bs, indexBS);
            return new String(bs, 0, indexBS, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("\u89e3\u5bc6\u65f6\u53d1\u751f\u9519\u8bef");
        }
    }

    protected void parseResponse() {
        HashMap map = Util.parseXML((String)this.response);
        this.user = new UserData();
        Object[] ks = map.keySet().toArray();
        try {
            for (int i = 0; i < map.size(); ++i) {
                String name = ks[i].toString();
                String value = (String)map.get(ks[i]);
                if (name.equals("UserName")) {
                    if (ClientConfig.getMode() == 4 && value.length() > 50) {
                        value = ServiceTicketValidator.decrypt((String)value);
                    }
                    this.user.setUserName(value);
                    continue;
                }
                if (name.equals("Status")) {
                    if (value.equals("OK")) continue;
                    throw new ServletException("\u68c0\u9a8cTicket\u5931\u8d25!");
                }
                if (name.equals("PGT") && ClientConfig.isProxyEnable()) {
                    if (ClientConfig.getMode() == 4) {
                        value = ServiceTicketValidator.decrypt((String)value);
                    }
                    this.pgt = value;
                    continue;
                }
                this.user.setValue(name, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProxyGrantingTicket() {
        return this.pgt;
    }
}

