/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.contentinfo.service.impl;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_AudioInfoLogSchema;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_SiteSchema;
import com.sobey.bsp.vms.interfaces.media.FileItem;
import com.sobey.bsp.vms.interfaces.media.SrcFileItem;
import com.sobey.cms.core.contentinfo.service.AudioInfoService;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class AudioInfoServiceImpl
implements AudioInfoService {
    public Map saveAudioinfo(Transaction trans, Map params, boolean autoPublish) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String title = (String)params.get("title");
        String contentId = (String)params.get("contentId");
        String addUser = (String)params.get("addUser");
        Date createTime = (Date)params.get("createTime");
        String description = (String)params.get("description");
        String keywords = (String)params.get("keywords");
        String contentSourceId = (String)params.get("contentSourceId");
        List fileitemList = (List)params.get("fileitem");
        List catalogInfo = (List)params.get("catalogInfo");
        List srcFileitemList = (List)params.get("srcFileItem");
        int fromStyle = (Integer)params.get("mediaFromType");
        String customParam = (String)params.get("customParam");
        Date firstPlayTime = (Date)params.get("firstPlayTime");
        String subTitle = (String)params.get("subTitle");
        Map map = (Map)catalogInfo.get(0);
        String siteId = (String)map.get("siteId");
        String prefix = "/vod/";
        String sourceContentPath = this.getSourceContentPath(srcFileitemList);
        long audioLength = 0L;
        String playUrl = "";
        List mp3FileitemList = this.getMp3FileItemList(fileitemList);
        SCMS_SiteSchema scms_siteSchema = new SCMS_SiteSchema();
        scms_siteSchema.setId(siteId);
        if (scms_siteSchema.fill()) {
            String prop2 = scms_siteSchema.getProp2();
            JSONObject prop2JSONObject = JSONObject.fromObject((Object)prop2);
            JSONArray audioJSONArray = prop2JSONObject.getJSONArray("audio");
            if (CollectionUtils.isNotEmpty((Collection)mp3FileitemList)) {
                String[] formats = this.getFomatArray(mp3FileitemList);
                FileItem[] mp3FileItem = this.getMp3FileItemArray(mp3FileitemList);
                audioLength = this.getAudioLength(audioLength, mp3FileitemList, mp3FileItem);
                this.getOrderFormatsAndFileItem(formats, mp3FileItem);
                List formatNames = this.getValueByKey(audioJSONArray, formats, "name");
                List fileUrlList = this.getFileUrlList(formats, mp3FileItem);
                JSONArray urlsJSONArray = this.builderUrlJsonArray(fileUrlList);
                playUrl = this.builderPlayUrl(title, prefix, audioLength, formatNames, urlsJSONArray);
            }
            for (Map maps : catalogInfo) {
                String catalogId = (String)maps.get("catalogId");
                String innercode = (String)maps.get("catalogInnerCode");
                String statusFlag = this.getStatusFlag(autoPublish, siteId);
                SCMS_AudioInfoSchema scms_audioInfoSchema = this.builderScms_audioInfoSchema(autoPublish, title, contentId, addUser, createTime, description, keywords, contentSourceId, fromStyle, customParam, firstPlayTime, subTitle, sourceContentPath, audioLength, playUrl, catalogId, siteId, innercode);
                trans.add((Schema)scms_audioInfoSchema, 1);
                SCMS_AudioInfoLogSchema scms_audioInfoLogSchema = this.builderScms_audioInfoLogSchema(contentId, addUser, createTime);
                trans.add((Schema)scms_audioInfoLogSchema, 1);
                returnMap.put("statusFlag", statusFlag);
                returnMap.put("mp3Json", playUrl);
                returnMap.put("status", "1");
            }
        }
        return returnMap;
    }

    private SCMS_AudioInfoSchema builderScms_audioInfoSchema(boolean autoPublish, String title, String contentId, String addUser, Date createTime, String description, String keywords, String contentSourceId, int fromStyle, String customParam, Date firstPlayTime, String subTitle, String sourceContentPath, long audioLength, String playUrl, String catalogId, String siteId, String innercode) {
        SCMS_AudioInfoSchema scms_audioInfoSchema = new SCMS_AudioInfoSchema();
        scms_audioInfoSchema.setCatalogInnerCode(innercode);
        scms_audioInfoSchema.setId(Long.valueOf(Long.parseLong(contentId)));
        scms_audioInfoSchema.setContentSourceId(contentSourceId);
        scms_audioInfoSchema.setTitle(title);
        scms_audioInfoSchema.setModifyTime(createTime);
        scms_audioInfoSchema.setPath(sourceContentPath);
        scms_audioInfoSchema.setStatus(Long.valueOf(1L));
        scms_audioInfoSchema.setFromStyle(Integer.valueOf(fromStyle));
        if (StringUtil.isNotEmpty((String)addUser)) {
            scms_audioInfoSchema.setModifyUser(addUser);
            scms_audioInfoSchema.setCreatorName(addUser);
        } else {
            scms_audioInfoSchema.setCreatorName(ContentUtil.getSourceNameByMediaFrom((int)fromStyle));
            scms_audioInfoSchema.setModifyUser(ContentUtil.getSourceNameByMediaFrom((int)fromStyle));
        }
        scms_audioInfoSchema.setCreateTime(createTime);
        scms_audioInfoSchema.setPlayUrl(playUrl);
        scms_audioInfoSchema.setSiteid(Long.valueOf(Long.parseLong(siteId)));
        scms_audioInfoSchema.setCustom(customParam);
        scms_audioInfoSchema.setSubTitle(subTitle);
        scms_audioInfoSchema.setPlayTime(firstPlayTime);
        scms_audioInfoSchema.setStatus(Long.valueOf(this.getStatus(autoPublish, siteId)));
        scms_audioInfoSchema.setPublishDate(autoPublish ? createTime : null);
        scms_audioInfoSchema.setDescription(description);
        scms_audioInfoSchema.setTag(keywords);
        scms_audioInfoSchema.setDuration(Long.valueOf(audioLength));
        scms_audioInfoSchema.setKeyFrame("");
        scms_audioInfoSchema.setCatalogId(Long.valueOf(Long.parseLong(catalogId)));
        return scms_audioInfoSchema;
    }

    private long getStatus(boolean autoPublish, String siteid) {
        if (autoPublish) {
            return 1L;
        }
        String workflowid = SiteUtil.getWorkFlowID((String)siteid);
        if (StringUtil.isEmpty((String)workflowid) || "0".equals(workflowid) || "-1".equals(workflowid)) {
            return 0L;
        }
        return -1L;
    }

    private String getStatusFlag(boolean autoPublish, String siteid) {
        String workflowid;
        String statusFlag = "";
        statusFlag = autoPublish ? "1" : (StringUtil.isEmpty((String)(workflowid = SiteUtil.getWorkFlowID((String)siteid))) || "0".equals(workflowid) || "-1".equals(workflowid) ? "0" : "-1");
        return statusFlag;
    }

    private JSONArray builderUrlJsonArray(List<String> fileUrlList) {
        JSONArray urlsJSONArray = new JSONArray();
        for (String url : fileUrlList) {
            if (StringUtil.isNotEmpty((String)url)) {
                if (url.indexOf("/vod/") >= 0) {
                    url = url.substring(url.indexOf("/vod/") + "/vod/".length());
                } else if (url.indexOf("/") == 0) {
                    url = url.substring(1);
                }
            }
            urlsJSONArray.add((Object)url);
        }
        return urlsJSONArray;
    }

    private String builderPlayUrl(String title, String prefix, long audioLength, List<String> formatNames, JSONArray urlsAry) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"duration", (Object)(audioLength / 1000L));
        jsonObj.put((Object)"title", (Object)title);
        jsonObj.put((Object)"host", (Object)prefix);
        JSONArray clipsAry = this.builderClipJsonArray(title, audioLength, urlsAry);
        jsonObj.put((Object)"clips", (Object)clipsAry);
        jsonObj.put((Object)"formats", formatNames);
        String playUrl = jsonObj.toString();
        return playUrl;
    }

    private JSONArray builderClipJsonArray(String title, long audioLength, JSONArray urlsAry) {
        JSONArray clipsAry = new JSONArray();
        JSONObject clipsObj = new JSONObject();
        clipsObj.put((Object)"duration", (Object)(audioLength / 1000L));
        clipsObj.put((Object)"urls", (Object)urlsAry);
        clipsObj.put((Object)"title", (Object)title);
        clipsAry.add((Object)clipsObj);
        return clipsAry;
    }

    private List<String> getFileUrlList(String[] formats, FileItem[] mp3FileItem) {
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < formats.length; ++i) {
            String fileUrl = mp3FileItem[i].getFileURL();
            if (StringUtil.isNotEmpty((String)fileUrl)) {
                fileUrl = StringUtil.replaceAllToSlant((String)fileUrl);
            }
            urls.add(fileUrl);
        }
        return urls;
    }

    private List<String> getValueByKey(JSONArray audioJSONArray, String[] formats, String name) {
        ArrayList<String> keyList = new ArrayList<String>();
        if (audioJSONArray == null) {
            return keyList;
        }
        for (int k = 0; k < formats.length; ++k) {
            String format = formats[k];
            for (int i = 0; i < audioJSONArray.size(); ++i) {
                JSONObject bitItem = audioJSONArray.getJSONObject(i);
                String setFormat = bitItem.getString("format");
                if (!format.equalsIgnoreCase(setFormat)) continue;
                keyList.add(bitItem.getString(name));
            }
        }
        return keyList;
    }

    private long getAudioLength(long audioLength, List<FileItem> mp3FileitemList, FileItem[] mp3FileItem) {
        for (int i = 0; i < mp3FileitemList.size(); ++i) {
            if (i != 0 || StringUtils.isEmpty((String)mp3FileItem[i].getFileLength())) continue;
            audioLength = Long.parseLong(mp3FileItem[i].getFileLength());
        }
        return audioLength;
    }

    private FileItem[] getMp3FileItemArray(List<FileItem> mp3FileitemList) {
        FileItem[] mp3FileItem = new FileItem[mp3FileitemList.size()];
        for (int i = 0; i < mp3FileitemList.size(); ++i) {
            mp3FileItem[i] = mp3FileitemList.get(i);
        }
        return mp3FileItem;
    }

    private String[] getFomatArray(List<FileItem> mp3FileitemList) {
        String[] formats = new String[mp3FileitemList.size()];
        for (int i = 0; i < mp3FileitemList.size(); ++i) {
            formats[i] = mp3FileitemList.get(i).getFileTypeID();
        }
        return formats;
    }

    private SCMS_AudioInfoLogSchema builderScms_audioInfoLogSchema(String contentId, String addUser, Date createTime) {
        SCMS_AudioInfoLogSchema scms_audioInfoLogSchema = new SCMS_AudioInfoLogSchema();
        scms_audioInfoLogSchema.setID(NoUtil.getMaxID((String)"AudioInfoLogId"));
        scms_audioInfoLogSchema.setAction("INSERT");
        scms_audioInfoLogSchema.setContentId(contentId);
        scms_audioInfoLogSchema.setActionDetail("\u7efc\u5408\u5165\u5e93");
        scms_audioInfoLogSchema.setAddTime(createTime);
        scms_audioInfoLogSchema.setAddUser(addUser);
        return scms_audioInfoLogSchema;
    }

    private List<FileItem> getMp3FileItemList(List<FileItem> fileitemList) {
        ArrayList<FileItem> mp3FileitemList = new ArrayList<FileItem>();
        for (int i = 0; i < fileitemList.size(); ++i) {
            String fileTypeId = fileitemList.get(i).getFileTypeID();
            if (!StringUtil.isNotEmpty((String)fileTypeId) || !"mp3".equalsIgnoreCase(fileTypeId.split("_")[2])) continue;
            mp3FileitemList.add(fileitemList.get(i));
        }
        return mp3FileitemList;
    }

    private String getSourceContentPath(List<SrcFileItem> srcFileitemList) {
        String sourceContentPath = "";
        if (CollectionUtils.isNotEmpty(srcFileitemList) && StringUtil.isNotEmpty((String)srcFileitemList.get(0).getFileName())) {
            String srcFileUrl = srcFileitemList.get(0).getFileName();
            int index = StringUtil.replaceAllToSlant((String)srcFileUrl).indexOf("/source/storage");
            sourceContentPath = index > -1 ? srcFileUrl.substring(srcFileUrl.indexOf("/source/storage")) : StringUtil.replaceAllToSlant((String)("/source/storage/" + srcFileUrl));
        }
        return sourceContentPath;
    }

    private void getOrderFormatsAndFileItem(String[] formats, FileItem[] oldFileItem) {
        for (int i = 0; i < formats.length; ++i) {
            for (int j = 0; j < formats.length; ++j) {
                String[] formatOf_j;
                int formatOf_j_num;
                String[] formatOf_i = formats[i].split("_");
                int formatOf_i_num = Integer.parseInt(formatOf_i[1].substring(0, formatOf_i[1].length() - 1));
                if (formatOf_i_num <= (formatOf_j_num = Integer.parseInt((formatOf_j = formats[j].split("_"))[1].substring(0, formatOf_j[1].length() - 1)))) continue;
                String temp = formats[j];
                formats[j] = formats[i];
                formats[i] = temp;
                FileItem fileItem = oldFileItem[j];
                oldFileItem[j] = oldFileItem[i];
                oldFileItem[i] = fileItem;
            }
        }
    }
}

